/*
 * machine.h - Ultrix definitions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: machine.h,v 1.11 98/02/16 19:55:37 abe Exp $
 */


#if	!defined(MACHINE_H)
#define	MACHINE_H	1


#include <sys/types.h>
#include <sys/param.h>


/*
 * GET_MAX_FD is defined for those dialects that provide a function other than
 * getdtablesize() to obtain the maximum file descriptor number plus one.
 */

/* #define	GET_MAX_FD	?	*/


/*
 * HASAOPT is defined for those dialects that have AFS support; it specifies
 * that the default path to an alternate AFS kernel name list file may be
 * supplied with the -A <path> option.
 */

/* #define	HASAOPT		1 */


/*
 * HASBLKDEV is defined for those dialects that want block device information
 * recorded in BDevtp[].
 */

#define	HASBLKDEV	1


/*
 * HASDCACHE is defined for those dialects that support a device cache
 * file.
 *
 * HASENVDC defined the name of an environment variable that contains the
 * device cache file path.  The HASENVDC environment variable is ignored when
 * the lsof process is setuid(root) or its real UID is 0.
 *
 * HASPERSDC defines the format for the last component of a personal device
 * cache file path.  The first will be the home directory of the real UID that
 * executes lsof.
 *
 * HASPERSDCPATH defines the environment variable whose value is the middle
 * component of the personal device cache file path.  The middle component
 * follows the home directory and precedes the results of applying HASPERSDC.
 * The HASPERSDCPATH environment variable is ignored when the lsof process is
 * setuid(root) or its real UID is 0.
 *
 * HASSYSDC defines a public device cache file path.  When it's defined, it's
 * used as the path from which to read the device cache.
 *
 * Consult the 00DCACHE and 00FAQ files of the lsof distribution for more
 * information on device cache file path construction.
 */

#define	HASDCACHE	1
#define	HASENVDC	"LSOFDEVCACHE"
#define	HASPERSDC	"%h/%p.lsof_%L"
#define	HASPERSDCPATH	"LSOFPERSDCPATH"
/* #define	HASSYSDC	"/var/adm/lsof.dc" */


/*
 * HASCDRNODE is defined for those dialects that have CD-ROM nodes.
 */

/* #define	HASCDRNODE	1 */


/*
 * HASFIFONODE is defined for those dialects that have FIFO nodes.
 */

/* #define	HASFIFONODE	1 */


/*
 * HASFSINO is defined for those dialects that have the file system
 * inode element, fs_ino, in the lfile structure definition in lsof.h.
 */

/* #define	HASFSINO	1 */


/*
 * HASGNODE is defined for those dialects that have gnodes.
 */

#define	HASGNODE	1


/*
 * HASHSNODE is defined for those dialects that have High Sierra nodes.
 */

/* #define	HASHSNODE	1 */


/*
 * HASINODE is defined for those dialects that have inodes and wish to
 * use readinode() from node.c.
 */

/* #define	HASINODE	1 */


/*
 * HASINTSIGNAL is defined for those dialects whose signal function returns
 * an int.
 */

/* #define	HASINTSIGNAL	1 */


/*
 * HASKOPT is defined for those dialects that support the -k option of
 * reading the kernel's name list from an optional file.
 */

#define	HASKOPT	1


/*
 * HASLFILEADD is defined for those dialects that need additional elements
 * in struct lfile.  The HASLFILEADD definition is a macro that defines
 * them.  If any of the additional elements need to be preset in the
 * alloc_lfile() function of proc.c, the SETLFILEADD macro may be defined
 * to do that.  The HASXOPT definition may be used to select the conditions
 * under which private lfile elements are used.
 *
 * Field identifiers 1 through 9 are reserved for dialect-specific field
 * output.  Define the string HASFIELDAP<x> as the help (-F?) name of the
 * private field and LISTLFIELAP<x> as a macro to list the field output.
 * (<x> is the field identifier character.)  HASFIELDAP<x> is used in proc.c
 * and store.c; LISTFIELDAP<x>, in proc.c.
 *
 * See ../dialectx/ptx for an example of the use of HASLFILEADD, SETLFILEADD,
 * and HASXOPT.
 */

/* #define HASLFILEADD <macro of new element definitions>; */
/* #define SETLFILEADD <macro of code to preset new elements>; */
/* #define HASFIELDAP1 <string name of field for -F? output> */
/* #define LISTLFILEAP1 <macro to list field output>; */


/*
 * HASMOPT is defined for those dialects that support the reading of
 * kernel memory from an alternate file.
 */

#define	HASMOPT	1


/*
 * HASNCACHE is defined for those dialects that have a kernel name cache
 * that lsof can search.
 *
 * HASNCAPID is defined for those dialects with a searchable kernel name
 * cache whose cache and vnodes are linked by a capability ID.
 */

#define	HASNCACHE	1
#define	HASNCAPID	1


/*
 * HASNLIST is defined for those dialects that use nlist() to acccess
 * kernel symbols.
 */

#define	HASNLIST	1


/*
 * HASPIPEFN is defined for those dialects that have a special function to
 * process DTYPE_PIPE file structure entries.  Its value is the name of the
 * function.
 *
 * NOTE: don't forget to define a prototype for this function in dproto.h.
 */

/* #define	HASPIPEFN	process_pipe */


/*
 * HASPIPENODE is defined for those dialects that have pipe nodes.
 */

/* #define	HASPIPENODE	1 */


/*
 * HASPMAPENABLED is defined when the reporting of portmapper registration
 * info is enabled by default.
 */

/* #define	HASPMAPENABLED	1 */


/*
 * HASPPID is defined for those dialects that support identification of
 * the parent process IDentifier (PPID) of a process.
 */

#define	HASPPID		1


/*
 * HASPRINTDEV, HASPRINTINO, HASPRINTNM, HASPRINTOFF, and HASPRINTSZ
 * define private dialect-specific functions for printing DEVice numbers,
 * INOde numbers, NaMes, file OFFsets, and file SiZes.  The functions are
 * called from print_file().
 */

/* #define	HASPRINTDEV	print_dev	*/
/* #define	HASPRINTINO	print_ino	*/
/* #define	HASPRINTNM	print_nm	*/
/* #define	HASPRINTOFF	print_off	*/
/* #define	HASPRINTSZ	print_sz	*/


/*
 * HASPRIVFILETYPE and PRIVFILETYPE are defined for dialects that have a
 * file structure type that isn't defined by a DTYPE_* symbol.  They are
 * used in lib/prfp.c to select the type's processing.
 *
 * PRIVFILETYPE is the definition of the f_type value in the file struct.
 *
 * HASPRIVFILETYPE is the name of the processing function.
 */

/* #define	HASPRIVFILETYPE	process_shmf	*/
/* #define	PRIVFILETYPE	??	*/


/*
 * HASPRIVNMCACHE is defined for dialects that have a private method for
 * printing cached NAME column values for some files.  HASPRIVNAMECACHE
 * is defined to be the name of the function.
 *
 * The function takes one argument, a struct lfile pointer to the file, and
 * returns non-zero if it prints a name to stdout.
 */

/* #define	HASPRIVNMCACHE	<function name>	*/


/*
 * HASPROCFS is defined for those dialects that have a proc file system --
 * usually /proc and usually in SYSV4 derivatives.
 *
 * HASFSTYPE is defined for those systems that have a file system type
 * string, st_fstype, in the stat() buffer.
 *
 * The defined value is the string that names the file system type.
 *
 * The HASPROCFS definition usually must be accompanied by the HASFSTYPE
 * definition and the providing of an fstype element in the local mounts
 * structure (defined in dlsof.h).
 *
 * The HASPROCFS definition may be accompanied by the HASPINODEN definition.
 * HASPINODEN specifies that searching for files in HASPROCFS is to be done
 * by inode number.
 */

/* #define	HASPROCFS	"proc" */
/* #define	HASFSTYPE	1 */
/* #define	HASPINODEN	1 */


/*
 * HASRNODE is defined for those dialects that have rnodes.
 */

/* #define	HASRNODE	1 */


/*
 * Define HASSECURITY to restrict the listing of all open files to the
 * root user.  When HASSECURITY is defined, the non-root user may list
 * only files whose processes have the same user ID as the real user ID
 * (the one that its user logged on with) of the lsof process.
 */

/* #define	HASSECURITY	1 */


/*
 * HASSNODE is defined for those dialects that have snodes.
 */

/* #define	HASSNODE	1 */


/*
 * HASSTREAMS is defined for those dialects that support streams.
 */

/* #define	HASSTREAMS	1 */


/*
 * HASTCPTPIQ is defined for dialects where it is possible to report the
 * TCP/TPI Recv-Q and Send-Q values produced by netstat.
 */

#define	HASTCPTPIQ	1


/*
 * HASTCPTPIW is defined for dialects where it is possible to report the
 * TCP/TPI send and receive window sizes produced by netstat.
 */

/* #define	HASTCPTPIW	1 */


/*
 * HASTMPNODE is defined for those dialects that have tmpnodes.
 */

/* #define	HASTMPNODE	1 */


/*
 * HASVNODE is defined for those dialects that use the Sun virtual file system
 * node, the vnode.  BSD derivatives usually do; System V derivatives prior to
 * R4 usually don't.  Ultrix has an equivalent, called a gnode.
 */

/* #define	HASVNODE	1 */


/*
 * HASXOPT is defined for those dialects that have an X option.  It
 * defines the text for the usage display.  HASXOPT_VALUE defines the
 * option's default binary value -- 0 or 1.
 */

/* #define	HASXOPT		"help text for X option" */
/* #define	HASXOPT_VALUE	1 */


/*
 * UID_ARG defines the size of a User ID number when it is passed
 * as a function argument.
 */

#define	UID_ARG	uid_t


/*
 * Each USE_LIB_<function_name> is defined for dialects that use the
 * <function_name> in the lsof library.
 *
 * Note: other definitions and operations may be required to condition the
 * library function source code.  They may be found in the dialect dlsof.h
 * header files.
 */

/* #define	USE_LIB_COMPLETEVFS		1	   cvfs.c */
#define	USE_LIB_FIND_CH_INO			1	/* fino.c */
#define	USE_LIB_IS_FILE_NAMED			1	/* isfn.c */
#define	USE_LIB_LKUPDEV				1	/* lkud.c */
#define	USE_LIB_PRINTCHDEVNAME			1	/* pdvn.c */
#define	USE_LIB_PROCESS_FILE			1	/* prfp.c */
#define	USE_LIB_PRINT_TCPTPI			1	/* ptti.c */
#define	USE_LIB_READDEV				1	/* rdev.c */
/* #define	USE_LIB_READMNT			1	   rmnt.c */
/* #define	USE_LIB_READVFS			1	   rvfs.c */
#define	USE_LIB_RNAM				1	/* rnam.c */
/* #define	USE_LIB_RNCH			1	   rnch.c */
/* #define	USE_LIB_RNMH			1	   rnmh.c */


/*
 * WARNDEVACCESS is defined for those dialects that should issue a warning
 * when lsof can't access /dev (or /device) or one of its sub-directories.
 * The warning can be inhibited by the lsof caller with the -w option.
 */

#define	WARNDEVACCESS	1


/*
 * WARNINGSTATE is defined for those dialects that want to suppress all lsof
 * warning messages.
 */

/* #define	WARNINGSTATE	1	warnings are enabled by default */


/*
 * WILLDROPGID is defined for those dialects whose lsof executable runs
 * setgid(not_real_GID) and whose setgid power can be relinquished after
 * the dialect's initialize() function has been executed.
 */

#define	WILLDROPGID	1


/*
 * zeromem is a macro that uses bzero or memset.
 */

#define	zeromem(a, l)	memset(a, 0, l)

#endif	/* !defined(MACHINE_H) */
