/*
 * store.c - common global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: store.c,v 1.6 97/10/10 08:24:29 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

#if	defined(HASBLKDEV)
struct l_dev *BDevtp = NULL;	/* block device table pointer */
int BNdev = 0;			/* number of entries in BDevtp[] */
struct l_dev **BSdev = NULL;	/* pointer to BDevtp[] pointers, sorted
				 * by device */
#endif	/* defined(HASBLKDEV) */

int CkPasswd = 0;		/* time to check /etc/passwd for change */
struct str_lst *Cmdl = NULL;	/* command names selected with -c */

#if	defined(HASDCACHE)
unsigned DCcksum;		/* device cache file checksum */
int DCfd = -1;			/* device cache file descriptor */
FILE *DCfs = NULL;		/* stream pointer for DCfd */
char *DCpathArg = NULL;		/* device cache path from -D[b|r|u]<path> */
char *DCpath[] = {		/* device cache paths, indexed by DCpathX
				 *when it's >= 0 */
	NULL, NULL, NULL, NULL
};
int DCpathX = -1;		/* device cache path index:
				 *	-1 = path not defined
				 *	 0 = defined via -D
				 *	 1 = defined via HASENVDC
				 *	 2 = defined via HASSYSDC
				 *	 3 = defined via HASPERSDC and
				 *	     HASPERSDCPATH */
int DCrebuilt = 0;		/* an unsafe device cache file has been
				 * rebuilt */
int DCstate = 3;		/* device cache state:
				 *	0 = ignore (-Di)
				 *	1 = build (-Db[path])
				 *	2 = read; don't rebuild (-Dr[path])
				 *	3 = update; read and rebuild if
				 *	    necessary (-Du[path])
				 */
int DCunsafe = 0;		/* device cache file is potentially unsafe,
				 * (The [cm]time check failed.) */
#endif	/* defined(HASDCACHE) */

int DChelp = 0;			/* -D? status */

struct l_dev *Devtp = NULL;	/* device table pointer */
int Fand = 0;			/* -a option status */
int Fblock = 0;			/* -b option status */

#if	defined(HASNCACHE)
int Fncache = 1;		/* -C option status */
#endif	/* defined(HASNCACHE) */

int Ffield = 0;			/* -f and -F status */
int Fhelp = 0;			/* -h option status */
int Fhost = 1;			/* -H option status */
int Fnet = 0;			/* -i option status: 0==none, 1==find all,
				 * 2==some found*/
int Fnfs = 0;			/* -N option status: 0==none, 1==find all,
				 * 2==some found*/
int Foffset = 0;		/* -o option status */
int Fovhd = 0;			/* -O option status */
int Fport = 1;			/* -P option status */
int Fpgrp = 0;			/* -g option status */

#if	defined(HASPPID)
int Fppid = 0;			/* -R option status */
#endif	/* defined(HASPPID) */

int Fsize = 0;			/* -s option status */
int Ftcptpi = TCPTPI_STATE;	/* -T option status */
int Fterse = 0;			/* -t option status */
int Funix = 0;			/* -U option status */
int Futol = 1;			/* -l option status */
int Fverbose = 0;		/* -V option status */

#if	defined(WARNINGSTATE)
int Fwarn = 1;			/* -w option status */
#else	/* !defined(WARNINGSTATE) */
int Fwarn = 0;			/* -w option status */
#endif	/* defined(WARNINGSTATE) */

#if	defined(HASXOPT_VALUE)
int Fxopt = HASXOPT_VALUE;	/* -X option status */
#endif	/* defined(HASXOPT_VALUE) */

struct str_lst *Fdl = NULL;	/* file descriptors selected with -d */

struct fieldsel FieldSel[] = {
	{ LSOF_FID_ACCESS,	0,	LSOF_FNM_ACCESS	},	/*  0 */
	{ LSOF_FID_CMD,		0,	LSOF_FNM_CMD	},	/*  1 */
	{ LSOF_FID_DEVCH,	0,	LSOF_FNM_DEVCH	},	/*  2 */
	{ LSOF_FID_DEVN,	0,	LSOF_FNM_DEVN	},	/*  3 */
	{ LSOF_FID_FD,		0,	LSOF_FNM_FD	},	/*  4 */
	{ LSOF_FID_INODE,	0,	LSOF_FNM_INODE	},	/*  5 */
	{ LSOF_FID_LOCK,	0,	LSOF_FNM_LOCK	},	/*  6 */
	{ LSOF_FID_LOGIN,	0,	LSOF_FNM_LOGIN	},	/*  7 */
	{ LSOF_FID_MARK,	1,	LSOF_FNM_MARK	},	/*  8 */
	{ LSOF_FID_NAME,	0,	LSOF_FNM_NAME	},	/*  9 */
	{ LSOF_FID_OFFSET,	0,	LSOF_FNM_OFFSET	},	/* 10 */
	{ LSOF_FID_PID,		1,	LSOF_FNM_PID	},	/* 11 */
	{ LSOF_FID_PGRP,	0,	LSOF_FNM_PGRP	},	/* 12 */
	{ LSOF_FID_PROTO,	0,	LSOF_FNM_PROTO	},	/* 13 */
	{ LSOF_FID_PPID,	0,	LSOF_FNM_PPID	},	/* 14 */
	{ LSOF_FID_SIZE,	0,	LSOF_FNM_SIZE	},	/* 15 */
	{ LSOF_FID_STREAM,	0,	LSOF_FNM_STREAM	},	/* 16 */
	{ LSOF_FID_TYPE,	0,	LSOF_FNM_TYPE	},	/* 17 */
	{ LSOF_FID_TCPTPI,	0,	LSOF_FNM_TCPTPI	},	/* 18 */
	{ LSOF_FID_UID,		0,	LSOF_FNM_UID	},	/* 19 */
	{ LSOF_FID_TERM,	0,	LSOF_FNM_TERM	},	/* 20 */

#if	defined(HASFIELDAP1)
	{ '1',			0,	HASFIELDAP1},		/* TERM + 1 */
#endif	/* defined(HASFIELDAP1) */

#if	defined(HASFIELDAP2)
	{ '2',			0,	HASFIELDAP2},		/* TERM + 2 */
#endif	/* defined(HASFIELDAP2) */

#if	defined(HASFIELDAP3)
	{ '3',			0,	HASFIELDAP3},		/* TERM + 3 */
#endif	/* defined(HASFIELDAP3) */

#if	defined(HASFIELDAP4)
	{ '4',			0,	HASFIELDAP4},		/* TERM + 4 */
#endif	/* defined(HASFIELDAP4) */

#if	defined(HASFIELDAP5)
	{ '5',			0,	HASFIELDAP5},		/* TERM + 5 */
#endif	/* defined(HASFIELDAP5) */

#if	defined(HASFIELDAP6)
	{ '6',			0,	HASFIELDAP6},		/* TERM + 6 */
#endif	/* defined(HASFIELDAP6) */

#if	defined(HASFIELDAP7)
	{ '7',			0,	HASFIELDAP7},		/* TERM + 7 */
#endif	/* defined(HASFIELDAP7) */

#if	defined(HASFIELDAP8)
	{ '8',			0,	HASFIELDAP8},		/* TERM + 8 */
#endif	/* defined(HASFIELDAP8) */

#if	defined(HASFIELDAP9)
	{ '9',			0,	HASFIELDAP9},		/* TERM + 9 */
#endif	/* defined(HASFIELDAP9) */

	{ ' ',			0,	NULL		}
};

int Hdr = 0;			/* header print status */
struct lfile *Lf = NULL;	/* current local file structure */
struct lproc *Lp = NULL;	/* current local process table entry */
struct lproc *Lproc = NULL;	/* local process table */
char *Memory = NULL;		/* core file path */
struct mounts *Mtab = NULL;	/* mounted devices */

#if	defined(HASPROCFS)
struct mounts *Mtprocfs = NULL;	/* /proc mount entry */
#endif	/* defined(HASPROCFS) */

int Mxpgrp = 0;			/* maximum process groip ID table entries */
int Mxpid = 0;			/* maximum PID table entries */
int Mxuid = 0;			/* maximum UID table entries */
gid_t Mygid;			/* real GID of this lsof process */
int Mypid;			/* lsof's process ID */
uid_t Myuid;			/* real UID of this lsof process */
char *Namech = NULL;		/* name characters for printing */
int Ndev = 0;			/* number of entries in Devtp[] */

#if	defined(HASNLIST)
struct NLIST_TYPE *Nl = NULL;	/* kernel name list */
int Nll = 0;			/* Nl calloc'd length */
#endif	/* defined(HASNLIST) */

int Nlproc = 0;			/* number of entries in Lproc[] */
char *Nmlst = NULL;		/* namelist file path */
int Npgrp = 0;			/* -g option count */
int Npid = 0;			/* -p option count */
int Npuns;			/* number of unselected PIDs (starts at Npid) */
int Ntype;			/* node type (see N_* symbols) */
int Nuid = 0;			/* -u option count */
int Nuidexcl = 0;		/* -u option count of UIDs excluded */
int Nuidincl = 0;		/* -u option count of UIDs included */
struct nwad *Nwad = NULL;	/* list of network addresses */
struct lfile *Plf = NULL;	/* previous local file structure */
char *Pn;			/* program name */

#if	defined(HASPROCFS)
struct procfsid *Procfsid = NULL;
				/* proc file system PID search table */
int Procsrch = 0;		/* 1 if searching for any proc file system
				 * file */
#endif

int RptTm = 0;			/* repeat time -- set by -r */
struct l_dev **Sdev = NULL;	/* pointer to Devtp[] pointers, sorted
				 * by device */
int Selall = 1;			/* all processes are selected (default) */
int Selflags = 0;		/* selection flags -- see SEL* in lsof.h */
int Setgid = 0;			/* setgid state */
int Selinet = 0;		/* select only Internet socket files */
int Setuidroot = 0;		/* setuid-root state */
struct sfile *Sfile = NULL;	/* chain of files to search for */
struct int_lst *Spgrp = NULL;	/* process group IDs to search for */
struct int_lst *Spid = NULL;	/* Process IDs to search for */
struct seluid *Suid = NULL;	/* User IDs to include or exclude */
char Terminator = '\n';		/* output field terminator */
int TmLimit = TMLIMIT;		/* Readlink() and stat() timeout (seconds) */
