/*
 * lsof.h - common header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: lsof.h,v 1.7 97/10/10 08:26:54 abe Exp $
 */


#if	!defined(LSOF_H)
#define	LSOF_H	1

#include "machine.h"
#include "lsof_fields.h"

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <pwd.h>
#include <stdio.h>

#include <sys/stat.h>


/*
 * Definitions of structures that may be needed by dlsof.h
 */

struct l_dev {
	dev_t rdev;			/* device */
	ino_t inode;			/* inode number */
	char *name;			/* name */
	int v;				/* has been verified
					 * (when DCUnsafe == 1) */
};

#include "dlsof.h"

extern int errno;
extern char *optarg;
extern int optind;

#define	ACCESSERRFMT	"%s: WARNING: access %s: %s\n"
#define	CMDL		9		/* command character length */

# if	defined(HASDCACHE)
#define	CRC_POLY	0120001 	/* CRC-16 polynomial */
#define	CRC_TBLL	256		/* crc table length for software */
#define	CRC_BITS	8		/* number of bits contributing */
# endif	/* defined(HASDCACHE) */

#define	CWD		" cwd"		/* current working directory fd name */
#define	FDLEN		8		/* fd printing array length */
#define	IDINCR		10		/* PID/PGRP table malloc() increment */
#define	IPROTOL		6		/* Internet protocol length */
#define	LOGINML		9		/* login name length */
#define	LPROCINCR	128		/* Lproc[] allocation increment */
#define	LSOF_URL	"ftp://vic.cc.purdue.edu/pub/tools/unix/lsof"
#define	MAXDCPATH	4		/* paths in DCpath[] */
#define	MAXNWAD		100		/* maximum network addresses */
#define	N_REGLR		0		/* regular file system node */
#define	N_AFS		1		/* AFS node */
#define	N_AUTO		2		/* automount node */
#define	N_BLK		3		/* block device node */
#define	N_CACHE		4		/* cached file system node */
#define	N_CDFS		5		/* CD-ROM node */
#define	N_CHR		6		/* character device node */
#define	N_COM		7		/* streams common device node */
#define	N_DOOR		8		/* DOOR node */
#define	N_FIFO		9		/* FIFO node */
#define	N_HSFS		10		/* High Sierra node */
#define	N_KERN		11		/* BSD /kern node */
#define	N_LOFS		12		/* loopback node */
#define	N_MPC		13		/* multiplexed device node */
#define	N_MVFS		14		/* multi-volume file system node (?) */
#define	N_NFS		15		/* NFS node */
#define	N_NM		16		/* named file system node */
#define	N_OBJF		17		/* objfs file system node */
#define	N_PCFS		18		/* PC file system node */
#define	N_PIPE		19		/* pipe device node */
#define	N_PROC		20		/* /proc node */
#define	N_SOCK		21		/* sock_vnodeops node */
#define	N_SPEC		22		/* spec_vnodeops node */
#define	N_STREAM	23		/* stream node */
#define	N_TMP		24		/* tmpfs node */
#define	N_UFS		25		/* Unix file system node */
#define	N_VXFS		26		/* Veritas file system node */
#define	N_XFS		27		/* XFS node */
#define	RPTTM		15		/* default repeat seconds */
#define	RTD		" rtd"		/* root directory fd name */
#define	TCPTPI_QUEUES	1		/* report TCP/TPI queue lengths */
#define	TCPTPI_STATE	2		/* report TCP/TPI state */
#define TCPTPI_WINDOWS	4		/* report TCP/TPI window sizes */
#define	TCPTPI_ALL	(TCPTPI_QUEUES | TCPTPI_STATE | TCPTPI_WINDOWS)
					/* report all TCP/TPI info */
#define	TMLIMIT		15		/* readlink() & stat() timeout sec */
#define	TMLIMMIN	2		/* minimum timeout */
#define	TYPEL		8		/* type character length */
#define	UIDCACHEL	1024		/* UID cache length */
#define	UIDINCR		10		/* UID table malloc() increment */
#define	USERPRTL	8		/* login/UID print length */


/*
 * Selection flags
 */

#define	PS_PRI		1		/* primary process selection -- e.g.,
					 * by PID or UID */
#define	PS_SEC		2		/* secondary process selection -- e.g.,
					 * by directory or file */
#define	SELCMD		0x001		/* select process by command name */
#define	SELFD		0x002		/* select file by descriptor name */
#define	SELNA		0x004		/* select socket by address (-i@...) */
#define	SELNET		0x008		/* select Internet socket files (-i) */
#define	SELNFS		0x010		/* select NFS files (-N) */
#define	SELNM		0x020		/* select by name */
#define	SELPGRP		0x040		/* select process group IDs (-g) */
#define	SELPID		0x080		/* select PIDs (-p) */
#define	SELUID		0x100		/* select UIDs (-u) */
#define	SELUNX		0x200		/* select Unix socket (-U) */
#define	SELALL		(SELCMD|SELFD|SELNA|SELNET|SELNM|SELNFS|SELPID|SELUID|SELUNX)

/*
 * Structure definitions
 */

#if	defined(HAS_AFS)
struct afsnode {			/* AFS pseudo-node structure */
	dev_t dev;
	unsigned char ino_st;		/* 1 if inode has a value */
	unsigned long inode;
	unsigned long size;
};
#endif	/* defined(HAS_AFS) */

#if	defined(HASNLIST)
struct drive_Nl {			/* data to drive build_Nl() */
	char *nn;			/* nickname for lookups */
	char *knm;			/* kernel variable for name list */
};
extern struct drive_Nl Drive_Nl[];	/* defined in dstore.c */
#endif	/* defined(HASNLIST) */


/*
 * Global storage definitions (including their structure definitions)
 */

struct int_lst {
	int i;				/* integer argument */
	int f;				/* find state */
};

struct seluid {
	uid_t uid;			/* User ID */
	char *lnm;			/* specified login name (NULL = none) */
	unsigned char excl;		/* excluded state */
	unsigned char f;		/* selected User ID find state
					 * (meaningful only if excl == 0) */
};

extern int CkPasswd;

struct str_lst {
	char *str;			/* string */
	int len;			/* string length */
	int f;				/* selected string find state */
	struct str_lst *next;		/* next list entry */
};
extern struct str_lst *Cmdl;

# if	defined(HASDCACHE)
extern unsigned DCcksum;
extern int DCfd;
extern FILE *DCfs;
extern char *DCpathArg;
extern char *DCpath[];
extern int DCpathX;
extern int DCrebuilt;
extern int DCstate;
extern int DCunsafe;
# endif	/* defined(HASDCACHE) */

extern int DChelp;
extern struct l_dev *Devtp;

# if	defined(HASBLKDEV)
extern struct l_dev *BDevtp, **BSdev;
extern int BNdev;
# endif	/* defined(HASBLKDEV) */

extern int Fand;
extern int Fblock;
extern int Ffield;
extern int Fhelp;
extern int Fhost;

# if	defined(HASNCACHE)
extern int Fncache;
# endif	/* defined(HASNCACHE) */

extern int Fnet;
extern int Fnfs;
extern int Foffset;
extern int Fovhd;
extern int Fport;
extern int Fpgrp;

# if	defined(HASPPID)
extern int Fppid;
# endif	/* defined(HASPPID) */

extern int Fsize;
extern int Ftcptpi;
extern int Fterse;
extern int Funix;
extern int Futol;
extern int Fverbose;
extern int Fwarn;

# if	defined(HASXOPT_VALUE)
extern int Fxopt;
# endif	/* defined(HASXOPT_VALUE) */

extern struct str_lst *Fdl;

struct fieldsel {
	char id;			/* field ID character */
	unsigned char st;		/* field status */
	char *nm;			/* field name */
};
extern struct fieldsel FieldSel[];

extern int Hdr;

enum IDType {PGRP, PID};

struct lfile {
	char access;
	char lock;
	unsigned char dev_def;		/* device number definition status */
	unsigned char inp_ty;		/* inode/iproto type
					 *	0: neither inode nor iproto
					 *	1: inode contains number
					 *	2: iproto contains string */
	unsigned char is_com;		/* common stream status */
	unsigned char is_nfs;		/* NFS file status */
	unsigned char is_stream;	/* stream device status */

# if	defined(HASVXFS) && defined(HASVXFSDNLC)
	unsigned char is_vxfs;		/* VxFS file status */
# endif	/* defined(HASVXFS) && defined(HASVXFSDNLC) */

	unsigned char off_def;		/* offset definition status */
	unsigned char sz_def;		/* size definition status */
	char fd[FDLEN];
	char iproto[IPROTOL];
	char type[TYPEL];
	short sf;			/* select flags -- SEL* symbols */
	int ch;				/* VMPC channel: -1 = none */
	int ntype;			/* node type -- N_* value */
	unsigned long off;
	unsigned long sz;
	dev_t dev;
	unsigned long inode;
	char *dev_ch;
	char *fsdir;			/* file system directory */
	char *fsdev;			/* file system device */

# if	defined(HASFSINO)
	unsigned long fs_ino;		/* file system inode number */
# endif	/* defined HASFSINO) */

	struct linaddr {		/* local Internet address information */
		int as;			/* address status: 0 == none */
		int p;			/* port */
		struct in_addr ia;	/* Internet address */
	} li[2];			/* li[0]: local
					 * li[1]: foreign */
	struct ltstate {		/* local TCP/TPI state */
		int type;		/* state type: -1 == none
					 *		0 == TCP
					 *		1 == TPI */
		union {
			int i;		/* integer state */
			unsigned int u;	/* unsigned integer state */
		} state;

#if	defined(HASTCPTPIQ)
		unsigned long rq;	/* receive queue length */
		unsigned long sq;	/* send queue length */
		unsigned char rqs;	/* rq status: 0 = none */
		unsigned char sqs;	/* sq status: 0 = none */
#endif	/* defined(HASTCPTPIQ) */

#if	defined(HASTCPTPIW)
		unsigned char rws;	/* rw status: 0 = none */
		unsigned char wws;	/* ww status: 0 = none */
		unsigned long rw;	/* read window size */
		unsigned long ww;	/* write window size */
#endif	/* defined(HASTCPTPIW) */

	} lts;
	char *nm;
	char *nma;			/* NAME column addition */

# if	defined(HASNCACHE)
	unsigned long na;		/* name cache lookup node address */
#  if	defined(HASNCAPID)
	unsigned long id;		/* capability ID */
#  endif	/* defined(HASNCAPID) */
# endif	/* defined(HASNCACHE) */

# if	defined(HASLFILEADD)
	HASLFILEADD
# endif	/* defined(HASLFILEADD) */

	struct lfile *next;
};
extern struct lfile *Lf, *Plf;


struct lproc {
	char *cmd;			/* command name */
	short sf;			/* select flags -- SEL* symbols */
	short pss;			/* state: 0 = not selected
				 	 *	  1 = wholly selected
				 	 *	  2 = partially selected */
	int pid;			/* process ID */
	int pgrp;			/* process group ID */
	int ppid;			/* parent process ID */
	uid_t uid;			/* user ID */
	struct lfile *file;		/* open files of process */
};
extern struct lproc *Lp, *Lproc;

extern char *Memory;
extern struct mounts *Mtab;

# if	defined(HASPROCFS)
extern struct mounts *Mtprocfs;
# endif

extern int Mxpgrp;
extern int Mxpid;
extern int Mxuid;
extern gid_t Mygid;
extern int Mypid;
extern uid_t Myuid;
extern char *Namech;
extern int Ndev;

# if	defined(HASNLIST)
#  if	!defined(NLIST_TYPE)
#define	NLIST_TYPE	nlist
#  endif	/* !defined(NLIST_TYPE) */
extern struct NLIST_TYPE *Nl;
extern int Nll;
# endif	/* defined(HASNLIST) */

extern int Nlproc;
extern char *Nmlst;
extern int Npgrp;
extern int Npid;
extern int Npuns;
extern int Ntype;
extern int Nuid;
extern int Nuidexcl;
extern int Nuidincl;

struct nwad {
	char *arg;				/* argument */
	char *proto;				/* protocol */
	unsigned char a[4];			/* address */
	int sport;				/* starting port */
	int eport;				/* ending port */
	int f;					/* find state */
	struct nwad *next;			/* forward link */
};
extern struct nwad *Nwad;

extern char *Pn;

# if	defined(HASPROCFS)
struct procfsid {
	pid_t pid;			/* search PID */

#  if	defined(HASPINFO)
	unsigned char type;		/* type: 0 if one PID file in HASPROCFS
					 *       1 if one PID file in HASPINFO
					 *	 2 if all files in HASPINFO */
#  endif	/* defined(HASPINFO) */

#  if	defined(HASPINODEN)
	unsigned long inode;		/* search inode number */
#  endif	/* defined(HASPINODEN) */

	struct procfsid *next;		/* forward link */
};

extern struct procfsid *Procfsid;
extern int Procsrch;
# endif	/* defined(HASPROCFS) */

extern int RptTm;
extern struct l_dev **Sdev;
extern int Selall;
extern int Selflags;
extern int Setgid;
extern int Selinet;
extern int Setuidroot;
extern struct sfile *Sfile;
extern struct int_lst *Spgrp;
extern struct int_lst *Spid;
extern struct seluid *Suid;
extern char Terminator;
extern int TmLimit;

#include "proto.h"
#include "dproto.h"

#endif	/* LSOF_H */
