/*
 * prfp.c -- process_file() function for lsof library
 */


/*
 * Copyright 1997 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#include "../machine.h"

#if	defined(USE_LIB_PROCESS_FILE)

# if	!defined(lint)
static char copyright[] =
"@(#) Copyright 1997 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: prfp.c,v 1.1 97/02/24 07:29:40 abe Exp $";
# endif	/* !defined(lint) */

#include "../lsof.h"


/*
 * process_file() - process file
 */

/*
 * The caller may define:
 *
 *	FILEPTR	as the name of the location to store a pointer
 *			to the current file struct -- e.g.,
 *
 *			struct file *foobar;
 *			#define FILEPTR	foobar
 */

void
process_file(fp)
	struct file *fp;		/* kernel file structure address */
{
	struct file f;
	int flag;

#if	defined(FILEPTR)
	FILEPTR = &f;
#endif	/* defined(FILEPTR) */

	if (kread((KA_T)fp, (char *)&f, sizeof(f))) {
		(void) sprintf(Namech, "can't read file struct from %#x", fp);
		enter_nm(Namech);
		return;
	}
	Lf->off = (unsigned long)f.f_offset;

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
		if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
			Lf->access = 'r';
		else if (flag == FWRITE)
			Lf->access = 'w';
		else if (flag == (FREAD | FWRITE))
			Lf->access = 'u';
	/*
	 * Process structure by its type.
	 */
		switch (f.f_type) {


#if	defined(DTYPE_PIPE)
		case DTYPE_PIPE:
# if	defined(HASPIPEFN)
			if (!Selinet)
				HASPIPEFN((caddr_t)f.f_data);
			return;
# endif	/* defined(HASPIPEFN) */
#endif	/* defined(DTYPE_PIPE) */

#if	defined(DTYPE_GNODE)
		case DTYPE_GNODE:
#endif	/* defined(DTYPE_GNODE) */

#if	defined(DTYPE_INODE)
		case DTYPE_INODE:
#endif	/* defined(DTYPE_INODE) */

#if	defined(DTYPE_PORT)
		case DTYPE_PORT:
#endif	/* defined(DTYPE_PORT) */

#if	defined(DTYPE_VNODE)
		case DTYPE_VNODE:
#endif	/* defined(DTYPE_VNODE) */

			if (!Selinet)
				process_node((caddr_t)f.f_data);
			return;
		case DTYPE_SOCKET:
			process_socket((caddr_t)f.f_data);
			return;

#if	defined(HASPRIVFILETYPE)
		case PRIVFILETYPE:
			HASPRIVFILETYPE((caddr_t)f.f_data);
			return;
#endif	/* defined(HASPRIVFILETYPE) */

		default:
			if (f.f_type != 0 || f.f_ops != NULL) {
				(void) sprintf(Namech,
					"%#x file struct, ty=%#x, op=%#x",
					fp, f.f_type, f.f_ops);
				enter_nm(Namech);
				return;
			}
		}
	}
	enter_nm("no more information");
}
#else	/* !defined(USE_LIB_PROCESS_FILE) */
static char d1[] = "d"; static char *d2 = d1;
#endif	/* defined(USE_LIB_PROCESS_FILE) */
