/*
 * dlsof.h - RISCos header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.2 97/08/15 08:26:16 abe Exp $
 */


#if	!defined(EPIX_LSOF_H)
#define	RISCOS_LSOF_H	1

#include <dirent.h>
#include <nlist.h>
#include <string.h>
#include <bsd/sys/time.h>
#include <sun/mntent.h>
#include <rpc/types.h>
#include <sys/fs/nfs.h>
#include <sys/vnode.h>
#include <sys/fs/snode.h>

# if	!defined(KERNEL)
#define	KERNEL	1
# endif

#include <bsd/sys/un.h>
#include <sys/file.h>
#include <sys/flock.h>
#undef	KERNEL

#include <sys/immu.h>
#include <sys/mbuf.h>
#include <bsd/sys/domain.h>
#include <bsd/sys/protosw.h>
#include <bsd/sys/unpcb.h>
#include <bsd/netinet/in.h>
#include <sys/fs/ufs_inode.h>
#include <sys/region.h>
#include <sys/sbd.h>
#include <sys/proc.h>
#include <sys/socket.h>
#include <bsd/sys/socketvar.h>
#include <bsd/net/route.h>
#include <bsd/net/raw_cb.h>
#include <bsd/netinet/in_pcb.h>
#include <bsd/netinet/tcp.h>
#include <bsd/netinet/tcp_fsm.h>
#include <bsd/netinet/tcp_timer.h>
#include <bsd/netinet/tcp_var.h>
#include <sys/stream.h>
#include <sys/user.h>
#include <sys/var.h>
#include <sys/fs/nfs_clnt.h>
#include <sys/fs/nfs_rnode.h>
#include <sys/vfs.h>
#include <sys/fs/ufs_mount.h>
#include <sys/fs/com_inode.h>

/*
 * The following structure definition comes from <sys/fs/fifonode.h>
 * which is missing from the RISCos 4.52 distribution.
 */

struct fifonode {
	struct snode	fn_snode;	/* must be first */
	struct fifo_bufhdr *fn_buf;	/* ptr to first buffer */
	struct proc	*fn_rsel;	/* ptr to read selector */
	struct proc	*fn_wsel;	/* ptr to write selector */
	struct proc	*fn_xsel;	/* ptr to exception selector */
	int		fn_unused1;
	short		fn_wcnt;	/* number of waiting readers */
	short		fn_rcnt;	/* number of waiting writers */
	short		fn_wptr;	/* write offset */
	short		fn_rptr;	/* read offset */
	short		fn_flag;	/* (see below) */
};

typedef	int	pid_t;

extern char *getenv();
extern char *sys_errlist[];
#define	strerror(errno)	sys_errlist[errno]

#define	COMP_P		void
#define DEVINCR		4096	/* device table malloc() increment */
#define	KA_T		long
#define	KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned
#define N_UNIX		"/unix"
#define	PROCDFLT	256	/* default size of local proc table */
#define PROCMIN		5	/* processes that make a "good" scan */
#define PROCTRYLM	5	/* times to try to read proc table */
#define QSORT_P		char
#define	READLEN_T	unsigned
#define STRNCPY_L	size_t
#define	STRNML		32	/* stream name length (maximum) */
#define U_SIZE		sizeof(struct user)


/*
 * Global storage definitions (including their structure definitions)
 */

extern struct file *Fileptr;
#define	FILEPTR	Fileptr			/* for process_file() in dfile.c */
extern int Kd;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

extern int Mem;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	ushort mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};

#define	X_NCACHE	"ncache"
#define	X_NCSIZE	"ncsize"
#define	NL_NAME		n_name

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};


/*
 * This #include and accompanying #undef's is placed last, lest the
 * #undef's disturb something else.  The #undef's prevent symbol
 * conflicts between <setjmp.h> and <sys/pcb.h>.
 */

#undef	JB_S0
#undef	JB_S1
#undef	JB_S2
#undef	JB_S3
#undef	JB_S4
#undef	JB_S5
#undef	JB_S6
#undef	JB_S7
#undef	JB_SP
#undef	JB_FP
#undef	JB_PC
#undef	NJBREGS

#include <setjmp.h>


/*
 * Definition for rdev.c
 */

#define	DIRTYPE	dirent


/*
 * Definition for rvfs.c
 */

#define	RVFS_DEVSAVE	1


/*
 * Definitions for rnch.c
 */

# if     defined(HASNCACHE)
#include <sys/dnlc.h>
# endif  /* defined(HASNCACHE) */

#endif	/* RISCOS_LSOF_H */
