/*
 * dsock.c - AIX socket processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dsock.c,v 1.3 97/09/23 08:20:25 abe Exp $";
#endif


#include "lsof.h"


/*
 * We include <sys/domain.h> here instead of "dlsof.h" for gcc's benefit.
 * It's loader can't handle the multiple CONST u_char arrays declared in
 * <net/net_globals.h> -- e.g., etherbroadcastaddr[].  (<sys/domain.h>
 * #include's <net/net_globals.h>.)
 */

#include <sys/domain.h>


/*
 * process_socket() - process socket file
 */

void
process_socket(sa)
	caddr_t sa;			/* socket address in kernel */
{
	struct domain d;
	char dev_ch[32];
	struct in_addr *fa = (struct in_addr *)NULL;
	int fam;
	int fp, lp;
	struct gnode g;
	struct inode i;
	struct inpcb inp;
	int is = 0;
	struct in_addr *la = (struct in_addr *)NULL;
	struct mbuf mb;
	struct protosw p;
	struct rawcb raw;
	struct socket s;
	struct sockaddr sad;
	struct tcpcb t;
	struct unpcb uc, unp;
	struct sockaddr_un *ua = NULL;
	struct sockaddr_un un;
	struct vnode v;

/*
 * Set socket file variables.
 */
        (void) strcpy(Lf->type, "sock");
	Lf->inp_ty = 2;
/*
 * Read socket and protocol switch structures.
 */
	if (sa == NULL) {
		enter_nm("no socket address");
		return;
	}
        if (kread((KA_T) sa, (char *) &s, sizeof(s))) {
                (void) sprintf(Namech, "can't read socket struct from %#x",
			sa);
                enter_nm(Namech);
                return;
        }
	if ( ! s.so_type) {
                enter_nm("no socket type");
                return;
	}
        if (s.so_proto == NULL
	||  kread((KA_T) s.so_proto, (char *) &p, sizeof(p))) {
                enter_nm("no protocol switch");
                return;
        }
/*
 * Save size information.
 */
	if (Fsize) {
		if (Lf->access == 'r')
			Lf->sz = (unsigned long)s.so_rcv.sb_cc;
		else if (Lf->access == 'w')
			Lf->sz = (unsigned long)s.so_snd.sb_cc;
		else
			Lf->sz = (unsigned long)s.so_rcv.sb_cc + s.so_snd.sb_cc;
		Lf->sz_def = 1;
	} else
		Lf->off_def = 1;

#if	defined(HASTCPTPIQ)
	Lf->lts.rq = s.so_rcv.sb_cc;
	Lf->lts.sq = s.so_snd.sb_cc;
	Lf->lts.rqs = Lf->lts.sqs = 1;
#endif	/* defined(HASTCPTPIQ) */

/*
 * Process socket by the associated domain family.
 */
        if (kread((KA_T) p.pr_domain, (char *) &d, sizeof(d))) {
                (void) sprintf(Namech, "can't read domain struct from %#x",
                        p.pr_domain);
                enter_nm(Namech);
                return;
        }

	switch ((fam = d.dom_family)) {

/*
 * Process an Internet domain socket.
 */
	case AF_INET:
		if (Fnet)
			Lf->sf |= SELNET;
		(void) strcpy(Lf->type, "inet");
		printiproto(p.pr_protocol);
	/*
	 * Read protocol control block.
	 */
		if (s.so_pcb == NULL) {
			enter_nm("no protocol control block");
			return;
		}
		if (s.so_type == SOCK_RAW) {

		/*
		 * Print raw socket information.
		 */
		    if (kread((KA_T) s.so_pcb, (char *)&raw, sizeof(raw))
		    ||  (struct socket *)sa != raw.rcb_socket) {
			(void) sprintf(Namech, "can't read rawcb at %#x",
				s.so_pcb);
			enter_nm(Namech);
			return;
		    }
		    (void) sprintf(dev_ch, "0x%08x", s.so_pcb);
		    enter_dev_ch(dev_ch);
		    if (raw.rcb_laddr
		    && !kread((KA_T)raw.rcb_laddr, (char *)&sad, sizeof(sad))) {
			if (sad.sa_family == AF_INET)
			    la = (struct in_addr *)&sad.sa_data[2];
			else if (sad.sa_family)
			    printrawaddr(&sad);
		    }
		    if (raw.rcb_laddr
		    && !kread((KA_T)raw.rcb_faddr, (char *)&sad, sizeof(sad))) {
			if (sad.sa_family == AF_INET)
			    fa = (struct in_addr *)&sad.sa_data[2];
			else if (sad.sa_family) {
			    (void) strcat(endnm(), "->");
			    printrawaddr(&sad);
			}
		    }
		    if (fa || la)
			(void) ent_inaddr(la, -1, fa, -1);
		} else {

		/*
		 * Save Internet socket information.
		 */
		    if (kread((KA_T) s.so_pcb, (char *) &inp, sizeof(inp))
		    ||  (struct socket *)sa != inp.inp_socket) {
			(void) sprintf(Namech, "can't read inpcb at %#x",
			    s.so_pcb);
			enter_nm(Namech);
			return;
		    }
		    (void) sprintf(dev_ch, "0x%08x",
			(inp.inp_ppcb == NULL) ? s.so_pcb : inp.inp_ppcb);
		    enter_dev_ch(dev_ch);
		    la = &inp.inp_laddr;
		    lp = (int)ntohs(inp.inp_lport);
		    if (inp.inp_faddr.s_addr != INADDR_ANY || inp.inp_fport
		    != 0) {
			fa =  &inp.inp_faddr;
			fp = (int)ntohs(inp.inp_fport);
		    }
		    if (fa || la)
			(void) ent_inaddr(la, lp, fa, fp);
		    if (p.pr_protocol == IPPROTO_TCP && inp.inp_ppcb
		    &&  kread((KA_T)inp.inp_ppcb, (char *)&t, sizeof(t)) == 0) {
			Lf->lts.type = 0;
			Lf->lts.state.i = (int)t.t_state;
		    }
		}
		break;
/*
 * Process a Unix domain socket.
 */
	case AF_UNIX:
		if (Funix)
			Lf->sf |= SELUNX;
		(void) strcpy(Lf->type, "unix");
	/*
	 * Read Unix protocol control block and the Unix address structure.
	 */
		(void) sprintf(dev_ch, "0x%08x", sa);
		enter_dev_ch(dev_ch);
		if (kread((KA_T) s.so_pcb, (char *) &unp, sizeof(unp))) {
			(void) sprintf(Namech, "can't read unpcb at %#x",
				s.so_pcb);
			break;
		}
		if ((struct socket *)sa != unp.unp_socket) {
			(void) sprintf(Namech, "unp_socket (%#x) mismatch",
				unp.unp_socket);
			break;
		}
		if (unp.unp_addr) {
		    if (kread((KA_T) unp.unp_addr, (char *) &mb, sizeof(mb))) {
			(void) sprintf(Namech,
				"can't read unp_addr at %#x",
				unp.unp_addr);
			break;
		    }

#if	AIXV>=3200
		    ua = (struct sockaddr_un *) ((char *) &mb +
			(mb.m_hdr.mh_data - (caddr_t) unp.unp_addr));
#else	/* AIXV<3200 */
		    ua = (struct sockaddr_un *)(((char *)&mb) + mb.m_off);
#endif	/* AIXV>=3200 */

		}
		if (ua == NULL) {
			ua = &un;
			(void) bzero((char *)ua, sizeof(un));
			ua->sun_family = AF_UNSPEC;
		}
	/*
	 * Print information on Unix socket that has no address bound
	 * to it, although it may be connected to another Unix domain
	 * socket as a pipe.
	 */
		if (ua->sun_family != AF_UNIX) {
			if (ua->sun_family == AF_UNSPEC) {
				if (unp.unp_conn) {
					if (kread((KA_T) unp.unp_conn,
						(char *) &uc, sizeof(uc))) {
					    (void) sprintf(Namech,
						"can't read unp_conn at %#x",
						unp.unp_conn);
					} else {
					    (void) sprintf(Namech,
						"->0x%08x", uc.unp_socket);
					}
				} else
				    (void) strcpy(Namech, "->(none)");
			} else
				(void) sprintf(Namech,
					"unknown sun_family (%d)",
					ua->sun_family);
			break;
		}
	/*
	 * Read any associated vnode and then read its gnode and inode.
	 */
		g.gn_type = VSOCK;
		if (unp.unp_vnode
		&&  readvnode((caddr_t)unp.unp_vnode, &v) == 0) {
			if (v.v_gnode
			&&  readgnode((caddr_t)v.v_gnode, &g) == 0) {
				Lf->lock = isglocked(&g);
				if (g.gn_type == VSOCK && g.gn_data
				&& readinode((struct inode *)g.gn_data, &i)
				== 0)
					is = 1;
			}
		}
	/*
	 * Print Unix socket information.
	 */
		if (is) {
			Lf->dev = i.i_dev;
			Lf->dev_def = 1;
			if (Lf->dev_ch) {
				(void) free((FREE_P *)Lf->dev_ch);
				Lf->dev_ch = NULL;
			}
			Lf->inode = (unsigned long)i.i_number;
			Lf->inp_ty = 1;
		}
		if (ua->sun_path[0]) {
			if (mb.m_len >= sizeof(struct sockaddr_un))
				mb.m_len = sizeof(struct sockaddr_un) - 1;
			*((char *)ua + mb.m_len) = '\0';
			if (Sfile && is_file_named(ua->sun_path, VSOCK, 0, 0))
				Lf->sf |= SELNM;
			else
				(void) strcpy(Namech, ua->sun_path);
		} else
			(void) strcpy(Namech, "no address");
		break;

	default:
		printunkaf(fam);
	}
	if (Namech[0])
		enter_nm(Namech);
}
