/*
 * dlsof.h - AIX header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.4 97/08/15 08:16:36 abe Exp $
 */


#if	!defined(AIX_LSOF_H)
#define	AIX_LSOF_H	1

#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <setjmp.h>
#include <unistd.h>

# if	!defined(_KERNEL)
#define _KERNEL	1
# endif

#include <sys/vnode.h>
#include <sys/file.h>
#include <procinfo.h>
#define p_pid	pi_pid
#define	p_pgrp	pi_pgrp
#define	p_ppid	pi_ppid
#define p_stat	pi_stat
#define p_uid	pi_uid
#undef	sleep
#undef	_KERNEL

#include <sys/mbuf.h>
#include <sys/mntctl.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/sysmacros.h>
#include <sys/un.h>
#include <sys/unpcb.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>

# if	AIXV>=4100
#include <netinet/ip.h>
# endif	/* AIXV>=4100 */

#include <netinet/in_pcb.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <sys/vattr.h>
#include <sys/statfs.h>
#include <sys/vfs.h>
#include <sys/vmount.h>

# if	AIXV>=4100
#  if	AIXV>=4110
#undef	u
#undef	u_comm
#undef	u_cdir
#undef	u_rdir
#undef	u_maxofile
#undef	u_ufd
#undef	u_loader
#  endif	/* AIXV>=4110 */

#define	u_comm		U_comm
#define	u_cdir		U_cdir
#define	u_rdir		U_rdir
#define	u_maxofile	U_maxofile
#define	u_ufd		U_ufd
#define	u_loader	U_loader
# endif	/* AIXV>=4100 */

# if	defined(HAS_NFS)
#include <nfs/rnode.h>
# endif	/* defined(HAS_NFS) */

#  if	AIXV>=3200
#include <sys/specnode.h>
#  endif	/* AIXV>=3200 */

/*
 * AIX doesn't supply cdrnode.h.
 */

struct cdrnode {
	caddr_t		f1[4];
	struct gnode	f2;
	dev_t		f3;
	ino_t		cn_inumber;	/* inode number */
	caddr_t		f4;
	cnt_t		f5[2];
	u_short		f6;
	uint		f7[2];
	uchar		f8[3];
	off_t		cn_size;	/* size of file in bytes */
};

/*
 * AIX doesn't supply ld_data.h.
 */

struct le {
	struct le *next;		/* next entry pointer */
	ushort dummy1;
	ushort dummy2;
	uint dummy3;
	struct file *fp;		/* file table entry pointer */

# if	AIXV>=4110
	int ft;				/* file type indicator */
	unsigned dummy4;
	char *dummy5;
	unsigned dummy6;
	char *dummy7[3];
	char *nm;			/* name */
# endif	/* AIXV>=4110 */

};

# if	defined(HAS_AFS)
#include <afs/stds.h>
#include <afs/param.h>
#include <afs/afsint.h>
#include <afs/vldbint.h>


/*
 * This is an emulation of the afs_rwlock_t definition that appears in
 * the AFS sources in afs/lock.h.
 */

struct afs_lock {

#  if	HAS_AFS<304
    unsigned long d1[4];
#  else	/* HAS_AFS>=304 */
    unsigned long d1[6];
#  endif	/* HAS_AFS<304 */

};
typedef struct afs_lock afs_lock_t;
typedef struct afs_lock afs_rwlock_t;

#define	KERNEL
#include <afs/afs.h>
#undef	KERNEL
# endif	/* defined(HAS_AFS) */


/*
 * Miscellaneous definitions.
 */

# if	defined(HAS_AFS)
#define	AFSAPATHDEF	"/usr/vice/etc/dkload/???"
#define	AFSDEV		1	/* AFS "fake" device number */

#  if	!defined(MNT_AFS)
#define	MNT_AFS		AFS_MOUNT_AFS
#  endif	/* !defined(MNT_AFS) */
# endif	/* defined(HAS_AFS) */

#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned
#define	N_UNIX		"/unix"
#define PROCSIZE	sizeof(struct procinfo)
#define QSORT_P		void
#define	READLEN_T	unsigned
#define STRNCPY_L	size_t
#define U_SIZE		sizeof(struct user)


# if	AIXV>=4110
/*
 * readx() definitions for AIX 4.1.1 and above.
 */

#define	LIBMASK		0xf0000000		/* library table mask */
#define	LIBNMCOMP	0xd0000000		/* library table name has
						 * multiple components */
#define	LIBNMLN		40			/* maximum library table name
						 * length */
#define	RDXMASK		0x0fffffff		/* kreadx() address mask */
# endif	/* AIXV>=4110 */


/*
 * Name list (Nl[]) indexes
 */

#define	X_UADDR		0
#define	X_NL_NUM	1


/*
 * Define for ckfa.c
 */

#define	CKFA_MPXCHAN	1


/*
 * Definitions for dvch.c
 */

#if	AIXV>=4140
#define	DCACHE_CLONE	rw_clone_sect	/* clone function for read_dcache */
#define	DCACHE_CLR	clr_sect	/* function to clear clone and
					 * pseudo caches when reading the
					 * device cache file fails */
#endif	/* AIXV>=4140 */


# if	defined(HAS_AFS)
/*
 * AFS name list (AFSnl[]) indexes
 */

#define	X_AFS_FID	0
#define	X_AFS_VOL	1
#define	X_AFSNL_NUM	2
# endif	/* defined(HAS_AFS) */


# if	AIXV>=4140
/*
 * Local clone information
 */

struct clone {
	struct l_dev cd;		/* device, inode, name, verify status */
	struct clone *next;		/* next entry */
};
extern struct clone *Clone;
extern int CloneMaj;
extern int ClonePtc;
#endif	/* AIXV>=4140 */


/*
 * Local vfs information
 */

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	int vmt_flags;			/* vmount flags */
	int vmt_gfstype;		/* vmount gfs type */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;


/*
 * Local mount information
 */

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	u_short mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};
extern struct mounts *Mtab;


/*
 * Search file information
 */

struct sfile {
	char *aname;			/* file name argument */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	chan_t ch;			/* channel (last path component,
					 * (if numeric) */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};


/*
 * Miscellaneous external definitions
 */

# if	defined(HAS_AFS)
extern struct nlist AFSnl[];	/* AFS kernel symbol name list table */

#  if	defined(HASAOPT)
extern char *AFSApath;		/* alternate AFS name list path (from -a) */
#  endif	/* defined(HASAOPT) */

extern struct vfs *AFSVfsp;	/* AFS struct vfs kernel pointer */
# endif	/* defined(HAS_AFS) */

extern int Kd;
extern int Km;
extern struct nlist Nl[];

#endif	/* AIX_LSOF_H */
