
LSOF(8)             UNIX Programmer's Manual              LSOF(8)

NAME
     lsof - list open files

SYNOPSIS
     lsof [ -?abChHlnNoOPstUwX ] [ -c c ] [ -d d ] [ -D D ] [ -F
     [f] ] [ -g [s] ] [ -i i ] [ -k k ] [ -m m ] [ -p s ] [ -r
     [t] ] [ -S [t] ] [ -u s ] [ -- ] [ names ]

DESCRIPTION
     Lsof revision 3.43 lists information about files opened by
     processes for the following Unix dialects:

          AIX 3.2.4, 3.2.5, 4.1, 4.1.1, and 4.1.2 for the IBM
               RISC/System 6000
          DC/OSx 1.1 for Pyramid ES, Nile, and S series
          DYNIX 3.0.12 (Purdue version) for the Sequent Symmetry
          EP/IX 2.1.1 for the CDC 4680
          FreeBSD 1.1.5.1, 2.0, and 2.0.5 for Intel-based systems
          HP-UX 8.x, 9.x, and 10 for HP systems
          IRIX 4.0.5H, 5.2, 5.3, 6.0, and 6.1 for SGI systems
          Linux through 1.3.0 for Intel-based systems
          Motorola V/88 for R32V3, R40V4.2, and R40V4.3 M88K systems
          NetBSD 1.0 and 1.0A for Intel and SPARC-based systems
          NEXTSTEP 2.1 and 3.[0123], all architectures
          Novell UnixWare 1.1, 1.1.1, and 1.1.2 for Intel-based
               systems
          OSF/1 1.3, 2.0, 3.0, and 3.2 for DEC Alpha
          PTX 2.1.[156] and 4.0.[23] for Sequent systems
          RISC/os 4.52 for MIPS R2000-based systems
          SCO OpenDesktop or OpenServer 1.1, 3.0, and 5.0 for
               Intel-based systems
          Solaris 2.[1234] and 2.5 BETA
          SunOS 4.1.[1234]
          Ultrix 2.2, 4.2, 4.3, and 4.4 for DEC RISC and VAX

     An open file may be a regular file, a directory, a block
     special file, a character special file, an executing text
     reference, a library, a stream or a network file (Internet
     socket, NFS file or Unix domain socket.) A specific file or
     all the files in a file system may be selected by path.

     Instead of a formatted display, lsof will produce output
     that can be parsed by other programs.  See the -F, option
     description, and the OUTPUT FOR OTHER PROGRAMS section for
     more information.

     In addition to producing a single output list, lsof will run
     in repeat mode.  In repeat mode it will produce output,
     delay, then repeat the output operation until stopped with
     an interrupt or quit signal.  See the -r [t] option descrip-
     tion for more information.

     Lsof may work on other Unix dialects - e.g., AIX 3.2.3,
     EP/IX 1.4.3, FreeBSD 1.0e, HP-UX 7.x, IRIX 5.1.1, NEXTSTEP
     2.[01], and SunOS 4.1 - but has not been tested on any of
     them recently.

OPTIONS
     In the absence of any options, lsof lists all open files
     belonging to all active processes.

     If any list request option is specified, other list requests
     must be specifically requested - e.g., if -n is specified
     for the listing of Internet and x.25 (HP-UX) network files,
     NFS files won't be listed unless -N is also specified; or if
     a user list is specified with the -u option, Internet and
     x.25 (HP-UX) network files and Unix domain socket files,
     belonging to users not in the list, won't be listed unless
     the -n and -U options are also specified.

     Normally list options that are specifically stated are ORed
     - i.e., specifying the -n and -ufoo options produces a list-
     ing of all network files OR files belonging to processes
     owned by user ``foo''.  The -a option may be used to AND the
     selections.  For example, specifying -a, -n, and -ufoo pro-
     duces a listing of only network files that belong to
     processes owned by user ``foo''.

     Caution: the -a option causes all list selection options to
     be ANDed; it can't be used to cause ANDing of selected pairs
     of selection options by placing it between them, even though
     its placement there is acceptable.  Wherever -a is placed,
     it causes the ANDing of all selection options.

     Items of the same selection set - command names, file
     descriptors, network addresses, process identifiers, user
     identifiers - are joined in a single ORed set and applied
     before the result participates in ANDing.  Thus, for exam-
     ple, specifying -i@aaa.bbb, -i@ccc.ddd, -a, and -ufff,ggg
     will select the listing of files that belong to either login
     ``fff'' OR ``ggg'' AND have network connections to either
     host aaa.bbb OR ccc.ddd.

     Values are optional following several options: -F, -g, -r,
     and -S.  When you have no values for these options, be care-
     ful that the following character isn't ambiguous.  For exam-
     ple, -Fn might represent the -F and -n options, or it might
     represent the n field identifier character following the -F
     option.  When ambiguity is possible, start a new option with
     a `-' character - e.g., ``-F -n''.  If the next option is a
     file name, follow the possibly ambiguous option with ``--''
     - e.g., ``-F -- name''.

     -? -h    These two options select a usage (help) output
              list.  Lsof displays a shortened form of this out-
              put when it detects an error in the options sup-
              plied to it, after it has displayed messages
              explaining each error.

     -a       This option causes list selection options to be
              ANDed, as described above.

     -b       This option causes lsof to avoid kernel functions
              that might block - lstat(2), readlink(2), and
              stat(2).

              See the BLOCKS AND TIMEOUTS and AVOIDING KERNEL
              BLOCKS sections for information on using this
              option.

     -c c     This option selects the listing of files for
              processes executing the command named c.  Multiple
              commands may be specified, using multiple -c
              options.  They are joined in a single ORed set
              before participating in AND option selection.

              Caution: since lsof truncates command names to nine
              characters, when you specify a name longer than
              that with -c, lsof won't find it.

     -C       This option disables the reporting of partial path
              name components from the kernel's name cache.  See
              the KERNEL NAME CACHE section for more information.

     -d d     This option selects the listing of files whose file
              descriptor number or name is d.  Multiple file
              descriptors my be specified, using multiple -d
              options.  They are joined in a single ORed set
              before participating in AND option selection.  See
              the description of File Descriptor (FD) output
              values in the OUTPUT section for more information
              on file descriptor names.

     -D D     This option directs lsof's use of the device cache
              file.  (See the DEVICE CACHE FILE sections for more
              information on it.)

              -D must be followed by a function letter; the func-
              tion letter may optionally be followed by a path
              name.  Lsof recognizes these function letters:

                   b - build the device cache file
                   i - ignore the device cache file
                   r - read the device cache file
                   u - read and update the device cache file

              The b, r, and u functions are not available in
              Motorola V/88 R40V42 and above, all versions of
              Novell UnixWare, and all versions of Pyramid DC/OSx
              for security reasons.  When these functions are
              unavailable, they will not appear in the descrip-
              tion of the -D option that accompanies -h or -?
              option ouput.

              When available, the b, r, and u functions may be
              followed by the device cache file's path.  The
              standard default is .lsof hostname in the home
              directory of the real user ID that executes lsof,
              but this could have been changed when lsof was con-
              figured and compiled.  (The output of the -? and -h
              options show the current default prefix - e.g.,
              ``.lsof''.) The suffix, hostname, is the first com-
              ponent of the host's name returned by gethost-
              name(2).

              When available, the b function directs lsof to
              build a new device cache file at the default or
              specified path.

              The i function directs lsof to ignore the default
              device cache file and obtain its information about
              devices via direct calls to the kernel.

              When available, the r function directs lsof to read
              the device cache at the default or specified path,
              but prevents it from creating a new device cache
              file when none exists or the existing one is
              improperly structured.

              When available, the u function directs lsof to read
              the device cache file at the default or specified
              path, if possible, and to rebuild it, if necessary.
              This is the default device cache file function when
              no -D option has been specified.

     -F f     This option specifies a character list, f, that
              selects the fields to be output for processing by
              another program, and the character that terminates
              each output field.  Each field to be output is
              specified with a single character in f.  The field
              terminator defaults to NL, but may be changed to
              NUL (000).  See the OUTPUT FOR OTHER PROGRAMS sec-
              tion for a description of the field identification
              characters and the field output process.

              When the field selection character list is empty,
              all fields are selected and the NL field terminator
              is used.

              When the field selection character list contains
              only a zero (`0'), all fields are selected and the
              NUL terminator character is used.

              Other combinations of fields and their associated
              field terminator character must be set with expli-
              cit entries in f, as described in the OUTPUT FOR
              OTHER PROGRAMS section.

              When the field selection character list contains
              the single character `?', lsof will display a help
              list of the field identification characters.
              (Escape the `?' character as your shell requires.)

     -g [s]   This option selects the listing of files for the
              processes whose optional process group IDentifica-
              tion (PGRP) numbers are in the comma-separated set
              s - e.g., ``123'' or ``123,456''.  (There should be
              no spaces in the set.)

              Multiple PGRP numbers are joined in a single ORed
              set before participating in AND option selection.

              The -g option also enables the output display of
              PGRP numbers.  When specified without a PGRP set
              that's all it does.

     -H       This option inhibits the conversion of network
              numbers to host names for network files.  Inhibit-
              ing conversion may make lsof run a little faster.
              It is also useful when host name lookup is not
              working properly.

     -i i     This option selects the listing of files any of
              whose Internet address matches the address speci-
              fied in i.  Multiple addresses may be specified
              with multiple -i options.  They are joined in a
              single ORed set before participating in AND option
              selection.

              An Internet address is specified in the form:

              [protocol][@hostname|hostaddr][:service|port]

              where:
                   protocol is a protocol name - e.g., TCP.
                   hostname is an Internet host name.
                   hostaddr is an Internet host address in dot form.
                   service is an /etc/services name - e.g., smtp.
                   port is a port number.

              At least one address component - protocol, host
              specification, or port specification - must be sup-
              plied.  The `@' character, leading the host specif-
              ication, is always required; as is the `:', leading
              the port specification.  Specify either hostname or
              hostaddr.  Specify either service name or port
              number.  If service is specified, protocol must
              also be specified.  Use any case - lower or upper -
              for protocol.

              Here are some sample addresses:
                   TCP:25 - TCP and port 25
                   @1.2.3.4 - Internet host address 1.2.3.4
                   UDP:who - UDP who service port
                   TCP@vic.cc:513 - TCP, port 513 and host name vic.cc

     -k k     This option specifies a kernel name list file, k,
              in place of /vmunix, /mach, /dynix, etc.  This
              option is not available under AIX on the IBM
              RISC/System 6000.

     -l       This option inhibits the conversion of user ID
              numbers to login names.  It is also useful when
              login name lookup is working improperly or slowly.

     -m m     This option specifies a kernel memory file, c, in
              place of /dev/kmem or /dev/mem - e.g., a crash dump
              file.

     -n       This option selects the listing of Internet and
              x.25 (HP-UX) network files.

     -N       This option selects the listing of NFS files.

     -o       This option directs lsof to display file offset at
              all times.  It causes the SIZE/OFF output column
              title to be changed to OFFSET.

              The -o and -s options are mutually exclusive; they
              can't both be specified.  When neither is speci-
              fied, lsof displays whatever value - size or offset
              - is appropriate for the type of the file.

     -O       This option directs lsof to bypass the strategy it
              uses to avoid being blocked by some kernel opera-
              tions - i.e., doing them in forked child processes.
              See the BLOCKS AND TIMEOUTS and AVOIDING KERNEL
              BLOCKS sections for more information on kernel
              operations that may block lsof.

              While use of this option will reduce lsof startup
              overhead, it may also cause lsof to hang when the
              kernel doesn't respond to a function.  Use this
              option cautiously.

     -p s     This option selects the listing of files for the
              processes whose ID numbers are in the
              comma-separated set s - e.g., ``123'' or
              ``123,456''.  (There should be no spaces in the
              set.)

              Multiple process ID numbers are joined in a single
              ORed set before participating in AND option selec-
              tion.

     -P       This option inhibits the conversion of port numbers
              to port names for network files.  Inhibiting the
              conversion may make lsof run a little faster.  It
              is also useful when host name lookup is not working
              properly.

     -r [t]   This option puts lsof in repeat mode.  There lsof
              displays output on open files as selected by other
              options, delays t seconds (the default is fifteen),
              then repeats its output display, delaying and pro-
              ducing output repetitively until stopped with an
              interrupt or quit signal.  When no delay time, t,
              is specified, lsof uses a default of fifteen.

              Lsof marks the end of each set of output: if field
              output is in progress (the -F, option has been
              specified), the marker is `m'; otherwise the marker
              is ``========''.  The marker is followed by a NL
              character.

              Repeat mode reduces lsof startup overhead, so it is
              more efficient to use this mode than to call lsof
              repetitively from a shell script, for example.

              To use repeat mode most efficiently, accompany -r
              with specification of other lsof selection options,
              so the amount of kernel memory access lsof does
              will be kept to a minimum.  Options that filter at
              the process level - e.g., -c, -g, -p, -u - are the
              most efficient selectors.

              Repeat mode is useful when coupled with field out-
              put (see the -F, option description) and a
              supervising awk or perl script.

     -s       This option directs lsof to display file size at
              all times.  It causes the SIZE/OFF output column
              title to be changed to SIZE.  If the file does not
              have a size, nothing is displayed.

              The -o and -s options are mutually exclusive; they
              can't both be specified.  When neither is speci-
              fied, lsof displays whatever value - size or offset
              - is appropriate for the type of file.

     -S [t]   This option specifies an optional time-out seconds
              value for kernel functions - lstat(2), readlink(2),
              and stat(2) - that might otherwise deadlock.  The
              minimum for t is two; the default, fifteen; when no
              value is specified, the default is used.

              See the BLOCKS AND TIMEOUTS section for more infor-
              mation.

     -t       This option specifies that lsof should produce
              terse output with process identifiers only and no
              header - e.g., so that the output may be piped to
              kill(1).  This option selects the -w option.

     -u s     This option selects the listing of files for the
              user whose login names or user ID numbers are in
              the comma-separated set s - e.g., ``abe'', or
              ``548,root''.  (There should be no spaces in the
              set.)

              Multiple login names or user ID numbers are joined
              in a single ORed set before participating in AND
              option selection.

     -U       This option selects the listing of Unix domain
              socket files.

     -w       This option causes lsof to suppress all warning
              messages.  The -t option selects this option.

     -X       This is a dialect-specific option.

         AIX:
              WARNING: use of this option on a busy AIX system
              might cause an application process to hang so com-
              pletely that it can neither be killed nor stopped.
              I have never seen this happen or had a report of
              it, but I think the possibility exists.

              This IBM AIX RISC/System 6000 -X option directs
              lsof to use the kernel readx() function.  By
              default use of readx() is disabled.

              When AIX readx() use is disabled, lsof may not be
              able to report information for all text and loader
              file references, but it may also avoid exacerbating
              an AIX 3.2.x and 4.1[.x] kernel directory search
              kernel error, known as the Stale Segment ID bug.

              When readx() is enabled, lsof will attempt to
              report information on the text file being executed
              by each process and the shared libraries it uses.

              The readx() function, used by lsof or any other
              program, to access some sections of kernel virtual
              memory, can trigger the Stale Segment ID bug.  It
              can cause the kernel's dir search() function
              erroneously to believe that part of an in-memory
              copy of a file system directory has been zeroed.
              Another application process, distinct from lsof,
              asking the kernel to search the directory - e.g.,
              by using open(2) - can cause dir search() to loop
              forever, thus hanging the application process.

              Consult the 00FAQ and 00README files of the lsof
              distribution for a more complete description of the
              Stale Segment ID bug, its APAR, and methods for
              defining readx() use when compiling lsof.

         PTX:
              This Sequent PTX -X option directs to list file
              link count (``ct=<n>') and inode address
              (``ina=0x<a>'') at the end of the NAME column.  The
              file link count (decimal) indicates the number of
              concurrent users of the file.  The kernel inode
              address (hexadecimal) is a value that is sometimes
              useful when working with a malfunctioning system.
              (Also see the manual page for the crash(1) applica-
              tion.)

              Link count data, when output as a field, has a
              field identifier character of `1'; inode address,
              `2'.

     --       The double minus sign option is a marker that sig-
              nals the end of the keyed options.  It may be used,
              for example, when the first file name begins with a
              minus sign.  It may also be used when the absence
              of a value for the last keyed option must be signi-
              fied by the presence of a minus sign in the follow-
              ing option and before the start of the file names.

     names    These are path names of specific files to list.
              Symbolic links are resolved before use.  The first
              name may be separated from the preceding options
              with the ``--'' option.

              If a name is the mount point of a file system or
              the device of the mount point of a file system,
              lsof will list all the files open on the file sys-
              tem.  If a name is the base name of a family of
              multiplexed files - e. g, AIX's /dev/pts - lsof
              will list all the associated multipled files on the
              device that are open - e.g., /dev/pts/1,
              /dev/pts/2, etc.

              If a name is a Unix domain socket name, lsof will
              search for it by the characters of the name alone -
              both as specified and as resolved from symbolic
              links.  When the socket uses a name that is a sym-
              bolic link to another, you must specify the name
              the socket uses.  However, if the socket uses the
              symbolic link's resolution, you may specify it or
              the symbolic link origination.  When asking lsof to
              search for a Unix domain socket name, be careful to
              specify its absolute path, just as it appears in
              kernel structures.  Specifying a relative path -
              e.g.  ./file - in place of the file's absolute path
              - e.g., /tmp/file - won't work because lsof must
              match the characters you specify with what it finds
              in the kernel structures associated with Unix
              domain sockets.

              If a name is none of the above, lsof will list any
              open files whose device and inode match that of the
              specified path name.

              If you have also specified the -b option, the only
              names you may safely specify are file systems for
              which your mount table supplies alternate device
              numbers.  See the AVOIDING KERNEL BLOCKS and ALTER-
              NATE DEVICE NUMBERS sections for more information.

              Multiple file names are joined in a single ORed set
              before participating in AND option selection.

SECURITY
     Lsof has three features that may cause security concerns.
     First, its default compilation mode allows anyone to list
     all open files with it.  Second, by default it creates a
     user-readable and user-writable device cache file in the
     home directory of the real user ID that executes lsof.  (The
     list-all-open-files and device cache features may be
     disabled when lsof is compiled.) Third, its -k and -m
     options name alternate alternate kernel name list or memory
     files.

     Restricting the listing of all open files is controlled by
     the compile-time HASSECURITY option.  When HASSECURITY is
     defined, lsof will allow only the root user to list all open
     files.  The non-root user may list only open files of
     processes with the same user IDentification number as the
     real user ID number of the lsof process (the one that its
     user logged on with).  When HASSECURITY is not defined, any-
     one may list all open files.

     Help output, presented in response to the -? or -h option,
     gives the HASSECURITY definition status.

     See the Security section of the 0README file of the lsof
     distribution for information on building lsof with the
     HASSECURITY option enabled.

     Creation and use of a user-readable and user-writable device
     cache file is controlled by the compile-time HASDCACHE
     option.  See the DEVICE CACHE FILE section for details on
     how its path is formed.  For security considerations it is
     important to note that if the real user ID under which lsof
     is executed is root, the device cache file will be written
     in root's home directory - e.g., / or /root.  When HASDCACHE
     is not defined, lsof does not write or attempt to read a
     device cache file.

     When HASDCACHE is defined, the lsof help output, presented
     in response to the -? or -h option, will describe the -D
     option.  When HASDCACHE is not defined, the help output will
     have no -D option description.

     Before you decide to disable the device cache file feature -
     enabling it improves the performance of lsof by reducing the
     startup overhead of examining all the nodes in /dev (or
     /devices) - read the discussion of it in sections 4.2 and
     4.2.1 of the 00FAQ file that accompanies the lsof distribu-
     tion.

     WHEN IN DOUBT, YOU CAN TEMPORARILY DISABLE THE USE OF THE
     DEVICE CACHE FILE WITH THE -Di OPTION.

     When lsof user declares alternate kernel name list or memory
     files with the -k and -m options, lsof checks the user's
     authority to read them with access(2).  This is intended to
     prevent whatever special power lsof's modes might confer on
     it from letting it read files not normally accessible via
     the authority of the real user ID.

OUTPUT
     This section describes the information lsof lists for each
     open file.  See the OUTPUT FOR OTHER PROGRAMS section for
     additional information on output that can be processed by
     another program.

     COMMAND    contains the first nine characters of the name of
                the Unix command associated with the process.

     PID        is the Process IDentification number of the pro-
                cess.

     PGRP       is the process group IDentification number asso-
                ciated with the process.  It is only displayed
                when the -g option has been specified.

     USER       is the user ID number or login name of the user
                to whom the process belongs.  (See the -l option
                description.)

     FD         is the File Descriptor number of the file or:

                     cwd  current working directory;
                     Lnn  library references;
                     ltx  shared library text (code and data);
                     Mxx  hex memory-mapped type number xx.
                     m86  DOS Merge mapped file;
                     mem  memory-mapped file;
                     pd   parent directory;
                     rtd  root directory;
                     txt  program text (code and data);
                     v86  VP/ix mapped file;

                FD is followed by one of these characters,
                describing the mode under which the file is open:

                     r for read access;
                     w for write access;
                     u for read and write access;
                     space if unknown (e.g., cwd or txt).

                The mode character is followed by one of these
                characters, describing the type of lock applied
                to the file:

                     r for read lock on part of the file;
                     R for a read lock on the entire file;
                     w for a write lock on part of the file;
                     W for a write lock on the entire file;
                     space if there is no lock.

     TYPE       is the type of the node associated with the file
                - e.g., GDIR, GREG, VDIR, VREG, etc.

                or ``dnet'' for a DECnet socket;

                or ``inet'' for an Internet domain socket;

                or ``lla'' for a HP-UX link level access file;

                or ``rte'' for an AF ROUTE socket;

                or ``sock'' for a socket of unknown domain;

                or ``unix'' for a Unix domain socket;

                or ``x.25'' for an HP-UX x.25 socket;

                or ``BLK'' for a block special file;

                or ``CHR'' for a character special file;

                or ``DIR'' for a directory;

                or ``DOOR'' for a VDOOR file;

                or ``FIFO'' for a FIFO special file;

                or ``LINK'' for a symbolic link file;

                or ``MPB'' for a multiplexed block file;

                or ``MPC'' for a multiplexed character file;

                or ``PCTL'' for a /proc control file;

                or ``PCUR'' for the current /proc process;

                or ``PDIR'' for a /proc directory;

                or ``PFIL'' for an executable /proc file;

                or ``PFPR'' for a /proc FP register set;

                or ``PGRP'' for a /proc group notifier file;

                or ``PIPE'' for an Ultrix 4.2 pipe;

                or ``PMEM'' for a /proc memory image file;

                or ``PNTF'' for a /proc process notifier file;

                or ``PORT'' for an Ultrix SYSV named pipe;

                or ``PREG'' for a /proc register file;

                or ``PSTA'' for a /proc status file;

                or ``REG'' for a regular file.

     DEVICE     contains the major and minor device numbers for a
                character special, block special, regular, direc-
                tory or NFS file (an HP-UX minor device number is
                listed in hexadecimal, as is a DEC OSF/1 minor
                device number larger than 99,999);

                or the protocol control block address of a DECnet
                (Ultrix 4.[23]), Internet, Unix, or x.25 (HP-UX)
                network file - the address that appears in the -A
                output from some netstat(1) programs;

                or ``memory'' for a memory file system node under
                OSF/1 on the DEC Alpha;

                or the address of the private data area of a
                Solaris socket stream;

                or a kernel reference address that identifies the
                file.  The kernel reference address may be used
                for FIFO's, for example.

                Usually only the lower thirty two bits of OSF/1
                DEC Alpha kernel addresses are displayed.

     SIZE/OFF or OFFSET
                is the size of the file or the file offset in
                bytes.  Lsof displays whatever value - size or
                offset - is appropriate for the type of the file.
                The file size is displayed in decimal; the offset
                is displayed in decimal with a leading ``0t'' if
                it is less than 100,000,000; in hexadecimal with
                a leading ``0x'' if it is larger than 99,999,999.
                Thus the leading ``0t'' and ``0x'' identify an
                offset when the column may contain both a size
                and an offset (i.e., its title is SIZE/OFF).

                If the -o option is specified, lsof always
                displays the file offset (or nothing if no offset
                is available) and labels the column OFFSET.  The
                offset always begins with ``0t'' or ``0x'' as
                described above.  If the -s option is specified,
                lsof always displays the file size (or nothing if
                no size is available) and labels the column SIZE.
                The -o and -s options are mutually exclusive;
                they can't both be specified.

                If size is being displayed and the mode of a Unix
                domain socket is read-only, the receive buffer
                size is displayed; write-only, the write buffer
                size; read and write, the sum of the two buffer
                sizes.

                If size is being displayed and the mode of a
                Solaris TCP socket is read-only, the undelivered
                receive window size is displayed; write-only, the
                unacknowledged transmit window size; read and
                write, the sum of the two window sizes.

                The offset displayed for Linux and Sequent PTX
                TCP sockets is the TCP send-next sequence number.

     INODE      is the inode number of a local file, truncated
                and prefixed with an asterisk (`*') if it is too
                large for the output field;

                or the inode number of an NFS file in the server
                host, truncated and prefixed with an asterisk
                (`*') if the number is too large for the output
                field; ;

                or the Internet protocol type - e. g, ``TCP'';

                or ``STR'' for a stream;

                or ``CCITT'' for an HP-UX x.25 socket.

     NAME       is the name of the mount point and file system on
                which the file resides (Under IRIX 5.2 the
                appearance of ``(PIPE)'' identifies a pipe
                file.);

                or the name of a file specified in the names
                option (after any symbolic links have been
                resolved);

                or the name of a character special or block spe-
                cial device;

                or the local and remote Internet addresses of a
                network file (as numbers or names, depending on
                the -H and -P options); a UDP destination Inter-
                net address may be followed by the amount of time
                that's elapsed since the last packet was sent to
                the destination;

                or the local and remote node and object addresses
                of a DECnet file (The node address appears as an
                area.node number pair if the -H option is speci-
                fied.);

                or the address or name of a Unix domain socket;

                or the local and remote mount point names of an
                NFS file;

                or ``STR'', followed by the stream name;

                or a stream character device name, followed by
                ``->'' and the stream name;

                or ``STR:'' followed by the SCO Unix stream dev-
                ice and module names, separated by ``->'';

                or the SunOS current working or root directory
                path name;

                system directory name, `` -- '', and as many com-
                ponents of the path name as lsof can find in the
                kernel's name cache for selected dialects (See
                the KERNEL NAME CACHE section for more informa-
                tion.);

                or ``PIPE->'', followed by a Solaris kernel pipe
                destination address;

                or ``COMMON:'' for an IRIX (versions below 5.2)
                common file system entry;

                or ``COMMON:'', followed by the vnode device
                information structure's device name, for a
                Solaris common vnode;

                or the address family, followed by a slash (`/'),
                followed by fourteen comma-separated bytes of a
                non-Internet raw socket address;

                or the HP-UX x.25 local address, followed by the
                virtual connection number (if any), followed by
                the remote address (if any);

                or ``(dead)'' for disassociated OSF/1 DEC Alpha
                files - typically terminal files that have been
                flagged with the TIOCNOTTY ioctl and closed by
                daemons;

                or ``r=count/bytes w=count/bytes'' for incomplete
                EP/IX 2.1.1 file structures (ones with no vnode
                or socket pointer), with
                     r signifying read statistics,
                     count giving the operation count,
                     bytes giving bytes transferred,
                     w signifying write statistics;

                or ``rd=<offset>'' and ``wr=<offset>'' for the
                values of the read and write offsets of a FIFO.

     For dialects that support a ``namefs'' file system, allowing
     one file to be attached to another with fattach(3C), lsof
     will add ``(FA:<address1><direction><address2>)'' to the
     NAME column.  <address1> and <address2> are hexadecimal
     vnode addresses.  <direction> will be ``<-'' if <address2>
     has been fattach'ed to this vnode whose address is
     <address1>; and ``->'' if <address1>, the vnode address of
     this vnode, has been fattach'ed to <address2>.  <address1>
     may be omitted if it already appears in the DEVICE column.

OUTPUT FOR OTHER PROGRAMS
     When the -F option is specified, lsof produces output that
     is suitable for processing by another program - e.g, an awk
     or perl script.

     Each unit of information is output in a field that is iden-
     tified with a leading character and terminated by a NL (012)
     (or a NUL (000) if the 0 (zero) field identifier character
     is specified.) The data of the field follows immediately
     after the field identification character and extends to the
     field terminator.

     It is possible to think of field output as process and file
     sets.  A process set begins with a field whose identifier is
     `p' (for process IDentifier (PID)).  It extends to the
     beginning of the next PID field or the beginning of the
     first file set of the process, whichever comes first.
     Included in the process set are fields that identify the
     command, the process group IDentification (PGRP) number, and
     the user ID (UID) number or login name.

     A file set begins with a field whose identifier is `f' (for
     file descriptor).  It is followed by lines that describe the
     file's access mode, lock state, type, device, size, offset,
     inode, protocol, name and stream module names.  It extends
     to the beginning of the next file or process set, whichever
     comes first.

     When the NUL (000) field terminator has been selected with
     the 0 (zero) field identifier character, lsof ends each pro-
     cess and file set with a NL (012) character.

     Lsof always produces one field, the PID (`p') field.  All
     other fields may be declared optionally in the field iden-
     tifier character list that follows the -F option.

     It is entirely possible to select a set of fields that can-
     not easily be parsed - e.g., if the field descriptor field
     is not selected, it may be difficult to identify file sets.
     To help you avoid this difficulty, lsof supports the -F
     option; it selects the output of all fields with NL termina-
     tors (the -F0 option pair selects the output of all fields
     with NUL terminators).

     These are the fields that lsof will produce.  The single
     character listed first is the field identifier.

          a    file access mode
          c    process command name
          d    file's device character code
          D    file's major/minor device number (0x<hexadecimal>)
          f    file descriptor
          i    file's inode number
          l    file's lock status
          L    process login name
          m    marker between repeated output
          n    file name, comment, Internet address
          o    file's offset (0t<decimal> or 0x<hexadecimal>)
          p    process ID (always selected)
          g    process group ID
          P    protocol name
          s    file's size
          S    file's stream identification
          t    file's type
          u    process user ID
          0    use NUL field terminator character in place of NL
          1-9  dialect-specific field identifiers (The output
               of -F? identifies the information to be found
               in dialect-specific fields.)

     You can get on-line help information on these characters and
     their descriptions by specifying the -F? option pair.
     (Escape the `?' character as your shell requires.)
     Additional information on field content can be found in the
     OUTPUT section.

     As an example, ``-F pcfn'' will select the process ID (`p'),
     command name (`c'), file descriptor (`f') and file name
     (`n') fields with an NL field terminator character; ``-F
     pcfn0'' selects the same output with a NUL (000) field ter-
     minator character.

     Lsof doesn't produce all fields for every process or file
     set, only those that are available.  Some fields are mutu-
     ally exclusive: file device characters and file major/minor
     device numbers; file inode number and protocol name; file
     name and stream identification; file size and offset.  One
     or the other member of these mutually exclusive sets will
     appear in field output, but not both.

     Normally lsof ends each field with a NL (012) character.
     The 0 (zero) field identifier character may be specified to
     change the field terminator character to a NUL (000).  A NUL
     terminator may be easier to process with xargs (1), for
     example, or with programs whose quoting mechanisms may not
     easily cope with the range of characters in the field out-
     put.  When the NUL field terminator is in use, lsof ends
     each process and file set with a NL (012).

     Two aids to producing programs that can process lsof field
     output are included in the lsof distribution.  The first is
     a C header file, lsof fields.h, that contains symbols for
     the field identification characters, indexes for storing
     them in a table, and explanation strings that may be com-
     piled into programs.  Lsof uses this header file.

     The second aid is a set of sample scripts that process field
     output, written in awk, perl 4, and perl 5.  They're located
     in the scripts subdirectory of the lsof distribution.

BLOCKS AND TIMEOUTS
     Lsof can be blocked by some kernel functions that it uses -
     lstat(2), readlink(2), and stat(2).  These functions are
     stalled in the kernel, for example, when the hosts where
     mounted NFS file systems reside become inaccessible.

     Lsof attempts to break these blocks with timers and child
     processes, but the techniques are not wholly reliable.  When
     lsof does manage to break a block, it will report the break
     with an error message.  The messages may be suppressed with
     the -t and -w options.

     The default timeout value may be displayed with the -? or -h
     option, and it may be changed with the -S [t] option.  The
     minimum for t is two seconds, but you should avoid small
     values, since slow system responsiveness can cause short
     timeouts to expire unexpectedly and perhaps stop lsof before
     it can produce any output.

     When lsof has to break a block during its access of mounted
     file system information, it normally continues, although
     with less information available to display about open files.

     Lsof can also be directed to avoid the protection of timers
     and child processes when using the kernel functions that
     might block by specifying the -O option.  While this will
     allow lsof to start up with less overhead, it exposes lsof
     completely to the kernel situations that might block it.
     Use this option cautiously.

AVOIDING KERNEL BLOCKS
     You can use the -b option to tell lsof to avoid using kernel
     functions that would block.  Some cautions apply.

     First, using this option usually requires that your system
     supply alternate device numbers in place of the device
     numbers that lsof would normally obtain with the lstat(2)
     and stat(2) kernel functions.  See the ALTERNATE DEVICE
     NUMBERS section for more information on alternate device
     numbers.

     Second, you can't specify names for lsof to locate unless
     they're file system names.  This is because lsof needs to
     know the device and inode numbers of files listed with names
     in the lsof options, and the -b option prevents lsof from
     obtaining them.  Moreover, since lsof only has device
     numbers for the file systems that have alternates, its abil-
     ity to locate files on file systems depends completely on
     the availability and accuracy of the alternates.  If no
     alternates are available, or if they're incorrect, lsof
     won't be able to locate files on the named file systems.

     Third, if the names of your file system directories that
     lsof obtains from your system's mount table are symbolic
     links, lsof won't be able to resolve the links.  This is
     because the -b option causes lsof to avoid the kernel
     readlink(2) function it uses to resolve symbolic links.

     Finally, using the -b option causes lsof to issue warning
     messages when it needs to use the kernel functions that the
     -b option directs it to avoid.  You can suppress these mes-
     sages by specifying the -w option, but if you do, you won't
     see the alternate device numbers reported in the warning
     messages.

ALTERNATE DEVICE NUMBERS
     On some dialects, when lsof has to break a block because it
     can't get information about a mounted file system via the
     lstat(2) and stat(2) kernel functions, or because you speci-
     fied the -b option, lsof can obtain some of the information
     it needs - the device number and possibly the file system
     type - from the system mount table.  When that is possible,
     lsof will report the device number it obtained.  (You can
     suppress the report by specifying the -w option.)

     You can assist this process if your mount table is supported
     with an /etc/mtab or /etc/mnttab file that contains an
     options field by adding a ``dev=xxxx'' field for mount
     points that do not have one in their options strings.

     The ``xxxx'' portion of the field is the hexadecimal value
     of the file system's device number.  (Consult the st dev
     field of the output of the lstat(2) and stat(2) functions
     for the appropriate values for your file systems.) Here's an
     example from an SGI IRIX 5.2 /etc/mtab for a file system
     remotely mounted via NFS:

          ... nfs rw,grpid,intr,nodevs,retry=6,dev=00100007 ...

     There's an advantage to having ``dev=xxxx'' entries in your
     mount table file, especially for file systems that are
     mounted from remote NFS servers.  When a remote server
     crashes and you want to identify its users by running lsof
     on one of its clients, lsof probably won't be able to get
     output from the lstat(2) and stat(2) functions for the file
     system.  If it can obtain the file system's device number
     from the mount table, it will be able to display the files
     open on the crashed NFS server.

     Some dialects that do not use an ASCII /etc/mtab or
     /etc/mnttab file for the mount table may still provide an
     alternative device number in their internal mount tables.
     This includes AIX, DEC OSF/1, FreeBSD, NetBSD, and Ultrix.
     Lsof knows how to obtain the alternative device number for
     these dialects and uses it when its attempt to lstat(2) or
     stat(2) the file system is blocked.

     If you're not sure your dialect supplies alternate device
     numbers for file systems from its mount table, use this lsof
     incantation to see if it reports any alternate device
     numbers:

          lsof -b

     Look for standard error file warning messages that begin
     ``assuming "dev=xxxx" from ...''.

KERNEL NAME CACHE
     Lsof is able to examine the kernel's name cache on some
     dialects and extract recently used path name components from
     it.  Lsof reports the ones it finds in the NAME column,
     starting with the file system name, followed by a space, two
     `-' characters, another space, and the name components it
     has located, separated by the `/' character.

     Lsof can report path name components for these dialects:

          DYNIX 3.0.12 (Purdue version)
          EP/IX 2.1.1
          FreeBSD 1.1.5.1, 2.0, and 2.0.5
          HP-UX 9.x and 10
          Motorola V/88 R40V4.2 and R40V4.3
          NetBSD 1.0 and 1.0A
          NEXTSTEP 3.[0123]
          OSF/1 2.0, 3.0, and 3.2
          PTX 2.1.[156] and 4.0.[23]
          SGI IRIX 5.3
          Solaris 2.[34] and 2.5 BETA
          SunOS 4.1.[23]
          Ultrix 2.2, 4.2, and 4.3

     Lsof can't report path name components for these dialects:

          AIX 3.2.4, 3.2.5, 4.1, 4.1.1, and 4.1.2
          DC/OSx 1.1
          Linux
          Motorola V/88 R32V3
          Novell UnixWare 1.1, 1.1.1, and 1.1.2
          SCO OpenDesktop or OpenServer 1.1 and 3.0
          SGI IRIX 4.0.5H, 5.2, 6.0, and 6.1

     Lsof may be able to report path name components for these
     dialects, but the code hasn't been tested on them:

          HP-UX 8.x
          NEXTSTEP 2.1
          OSF/1 1.3
          Solaris 2.[12]
          SunOS 4.1.[14]
          Ultrix 4.3 and 4.4

     If you want to know why lsof can't report path name com-
     ponents for some dialects, consult section 3.1 of the 00FAQ
     file of the lsof distribution.

DEVICE CACHE FILE
     Examining all members of the /dev (or /devices) node tree
     with stat(2) functions can be time consuming.  What's more,
     the information that lsof needs - device number, inode
     number, and path - rarely changes.

     Consequently, lsof maintains an ASCII text file of cached
     /dev (or /devices) information.

     The standard name of the device cache file is
     .lsof hostname, and it is written in the home directory of
     the real user ID that executes lsof.  The device cache file
     belongs to the user ID and is readable and writable by the
     user ID alone - i.e., its modes are 0600.  Each distinct
     real user ID on a given host that executes lsof has a dis-
     tinct device cache file.

     The suffix, hostname, is the first component of the host's
     name returned by gethostname(2).  If a user ID's home direc-
     tory is NFS-mounted from several hosts and lsof is executed
     from more than one of them, then the user ID's home direc-
     tory may contain more than one device cache file.

     The local system administrator may disable the device cache
     file feature or change the default device cache file prefix
     (``.lsof'') when lsof is compiled.  (Consult the output of
     the -? or -h option for the current state of device cache
     support and the default prefix - e.g., ``.lsof''.)

     The -D option provides some control over the cache.  When
     its b, r, and u functions are available, you can use them to
     request that the cache file be built in a specific location
     (b[path]); read but not rebuilt (r[path]); or read and
     rebuilt (u[path]).  (These functions are not available
     available in Motorola V/88 R40V42 and above, all versions of
     Novell UnixWare, and all versions of Pyramid DC/OSx for
     security reasons.) The ignore function (i) is always avail-
     able; it directs lsof to ignore any existing device cache
     file.

     When available, u function is the default when no -D option
     has been specified, using the default device cache file
     name, .lsof hostname, in the home directory of the real user
     ID that executes lsof.  This function tells lsof to attempt
     to read and use the device cache file.  If it can't read the
     file, it will read information from the kernel with stat(2)
     function calls, then write an updated version of the file.

     Lsof can detect that the file has been accidentally or mali-
     ciously modified by several sanity checks, including a six-
     teen bit Cyclic Redundancy Check (CRC) sum of the file's
     contents.  When lsof senses something wrong with the file,
     it will attempt to remove the current one and create a new
     copy.

     When a new device is added to the system, the device cache
     file may need to be recreated.  Since lsof compares the
     mtime of the device cache file with the mtime and ctime of
     the /dev (or /devices) directory, it usually detects that a
     new device has been added; in that case lsof issues a warn-
     ing message and rebuilds the device cache file, depending on
     the function specified in the -D option.

     If lsof doesn't update the cache file when you believe it
     should, use the b function of -D, if it's available, to tell
     lsof to recreate the file.

DIAGNOSTICS
     Errors are identified with messages on the standard error
     file.

     Lsof returns a one (1) if any error was detected, including
     the failure to locate any names.  It returns a zero (0) if
     no errors were detected and if it was able to list informa-
     tion about all the specified names.

     When lsof cannot open access to /dev (or /devices) or one of
     its subdirectories, it issues a warning message and contin-
     ues.  The warning message may be suppressed with the -w
     option.  It may also have been suppressed by the system
     administrator when lsof was compiled by the setting of the
     WARNDEVACCESS definition.  In the latter case, the output
     from lsof's -? or -h option will contain the message:

          Warnings are disabled for inaccessible device directories.

EXAMPLES
     To list all open files, use:

          lsof

     To list all open Internet, x.25 (HP-UX), and Unix domain
     files, use:

          lsof -n -U

     To list all files using any protocol on port 513 of host
     wonderland.cc.purdue.edu, use:

          lsof -i @wonderland.cc.purdue.edu:513

     To list all files using any protocol on any port of
     mace.cc.purdue.edu (cc.purdue.edu is the default domain),
     use:

          lsof -i @mace

     To list all open files for login name ``abe'', or user ID
     1234, or process 456, or process 123, or process 789, use:

          lsof -p 456,123,789 -u 1234,abe

     To list all open files on device /dev/hd4, use:

          lsof /dev/hd4

     To find the process that has /u/abe/foo open, use:

          lsof /u/abe/foo

     To send a SIGHUP to the processes that have /u/abe/bar open,
     use:

          kill -HUP `lsof -t /u/abe/bar`

     To find any open file, including an open Unix domain socket
     file, with the name /dev/log, use:

          lsof /dev/log

     To find processes with open files on the NFS file system
     named /nfs/mount/point whose server is inaccessible, and
     presuming your mount table supplies the device number for
     /nfs/mount/point, use:

          lsof -b /nfs/mount/point

     To do the preceding search with warning messages suppressed,
     use:

          lsof -bw /nfs/mount/point

     To ignore the device cache file, use:

          lsof -Di

     To obtain PID and command name field output for each pro-
     cess, file descriptor, file device number, and file inode
     number for each file of each process, use:

          lsof -FpcfDi

     To list the files at descriptors 1 and 3 of every process
     running the lsof command for login ID ``abe'' every 10
     seconds, use:

          lsof -c lsof -a -d 1 -d 3 -u abe -r10

BUGS
     Since lsof reads kernel memory in its search for open files,
     rapid changes in kernel memory may produce unpredictable
     results.

     The lock status character (following the file descriptor) is
     derived under AIX from a test of the first filock structure
     of the gnode (see <sys/flock.h> and <sys/gnode.h>).

     Lsof can't search for files with restrictive access permis-
     sions by name unless it is installed with root set-UID per-
     mission.  Otherwise it is limited to searching for files to
     which its user or its set-GID group (if any) has access per-
     mission.

     Lsof startup time is long on dialects where scanning the
     /dev (or /devices) directory and the mount table are slow
     operations.  Where possible - e.g., when the listing of only
     network files is requested - the scans are avoided or
     deferred.  When the device cache file is in use, scanning
     /dev (or /devices) is avoided once the cache file has been
     written.

     The display of the destination address of a raw socket
     (e.g., for ping) depends on the Unix operating system.  Some
     dialects store the destination address in the raw socket's
     protocol control block, some do not.

     Lsof can't always represent Solaris and SunOS device numbers
     in the same way that ls(1) does.  For example, the major and
     minor device numbers that the lstat(2) and stat(2) functions
     report for the directory on which CD-ROM files are mounted
     (typically /cdrom) are not the same as the ones that it
     reports for the device on which CD-ROM files are mounted
     (typically /dev/sr0).  (Lsof reports the directory numbers.)

     The system to which the Ultrix 2.2 port was directed is a
     local one that has been extensively updated with network
     features from the 4.3BSD Tahoe and Reno releases, so it may
     not match a standard Ultrix 2.2 system, if there is any such
     system still in use.

     The support for /proc file systems is available only for BSD
     and OSF dialects, Linux, and dialects derived from SYSV R4 -
     e.g., FreeBSD, IRIX 5.[23], NetBSD, Solaris, V/88
     R40V4.[23], UnixWare.  One SYSV R4 exception is EP/IX 2.1.1,
     where I have been unable to overcome conflicts between its
     svr3 and svr4 environments to build an lsof with /proc file
     system support.  Some /proc file items - device number,
     inode number, and file size - are unavailable in some
     dialects.

     No text (txt) file descriptors are displayed for Linux
     processes.  All entries for files other than the current
     working directory, the root directory, and numerical file
     descriptors are labeled mem descriptors.

     Door file system support under Solaris 2.5 BETA is minimal,
     since the file system type is new and experimental.  Sun
     advises that the door file system and its interface are sub-
     ject to change in future releases.

FILES
     /dev/kmem         kernel virtual memory device

     /dev/mem          physical memory device

     /dev/swap         system paging device

     .lsof hostname    lsof's device cache file (The suffix,
                       hostname, is the first component of the
                       host's name returned by gethostname(2).)

AUTHORS
     Lsof was written by Victor A. Abell <abe@cc.purdue.edu> of
     the Purdue University Computing Center (PUCC), starting from
     the fstat and ofiles programs.  Anthony Shortland
     <Anthony.Shortland@FMR.com> produced the Pyramid DC/OSx 1.1
     support.

     Vic acknowledges his debt to the work of Dan Bernstein,
     Michael ``Ford'' Ditto, Tom Dunigan, Alexander Dupuy, Vik
     Lall, Ray Moody, C. Spencer, Michael Spitzer and those who
     wrote Berkeley's fstat program, all contributors to lsof's
     predecessors.  Vic thanks Doug McKenzie for his HP-UX proc-
     tor program and Rich Kulawiec for pointing it out.

     Finally, Vic is grateful to David Addison, Richard Allen,
     Marc Auslander, Ade Barkah, Anthony Baxter, John Beacom,
     Bruce Beare, Dave Bianchi, Achim Bohnet, Mark Bonsack, Bill
     Bormann, Michael Bryan, Bernt Christandl, Hans Petter Chris-
     tiansen, Albert Chin-A-Young, Axel Clauberg, John Colgrave,
     Jim Cooper, Dave Curry, Ian Darwin, Hugh Dickins, David
     DiGiacomo, Casper Dik, Greg Earle, Robert Ehrlich, Doug
     Eldred, Scott Ellentuch, Tom Endo, Mike Feldman, Bob
     Foertsch, Mike Fraser, Terry Friedrichsen, Roman Gollent,
     Garner Halloran, Adam Hammer, Charles Hannum, Steinar Haug,
     Paul Hite, J. Nelson Howell, Gerrit Huizenga, John Jackson,
     Kurt Jaeger, Carl Johnson, Dion Johnson, Peter Jordan, Pasi
     Kaara, Frank Kaefer, Claus Kalle, Henry Katz, Shane Kenney,
     Steve Kirsch, Przemek Klosowski, Joseph Kowalski, Paul
     Kranenburg, Alex Kreis, Markus Lautenbacher, Steve Lacey,
     Marty Leisner, Stuart Levy, Wendy Lin, Friedel Loinger,
     Michael Long, Pete Lord, Bela Lubkin, Horst Luehrsen,
     Andreas Luik, Michael Mackenzie, Lawrence MacIntyre, Benson
     Margulies, Claude Marinier, Fletcher Mattox, Dale McCluskey,
     Sean McDermott, Dwight McKay, William McVey, Jeffrey Mogul,
     Dave Morrison, Pat Myrto, Allan Nathanson, Chance Neale,
     Joseph J. Nuspl Jr., Craig B. Olofson, Dave Olson, Keith
     Parks, Mark Peek, Ezra Peisach, Nathan Peterson, Dominique
     Petitpierre, Francois Pinard, Alex Podlecki, Philippe-Andre
     Prindeville, David Putz, Tim Ramsey, Stephan Rossi, Kevin
     Ruderman, Chris Schanzle, Hendrik G. Seliger, Igor V. Semen-
     yuk, Michael Shields, Anthony Shortland, Dave Sill, John
     Silva, Gerry Singleton, Leonard Sitongia, Kevin Smallwood,
     Douglas R. Smith, Dave Stevens, Jeff Stewart, Andreas
     Stolcke, Dale Talcott, Andy Thomas, Chris Timmons, Zdenko
     Tomasic, Linus Torvalds, Mike Tracy, Lenny Turetsky, Jules
     van Weerden, Mark Vasoll, Robert Vernon, Jos Vos, Joel
     White, Patrick Wolfe, James Woodward, and Ron Young for
     their help in developing and improving lsof.

SEE ALSO
     access(2), awk(1), crash(1), fattach(3C), ff(1), fstat(8),
     fuser(1), gethostname(2), kill(1), lstat(2), netstat(1),
     ofiles(8L), perl(1), ps(1), readlink(2), stat(2).

