/*      @(#)route.h	1.3 STREAMWare TCP/IP SVR4.2  source        */
/*      SCCS IDENTIFICATION        */
/*	Copyright (c) 1990, 1991, 1992 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1985, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _NET_TCPIP_ROUTE_H	/* wrapper symbol for kernel use */
#define _NET_TCPIP_ROUTE_H	/* subject to change without notice */

#ident	"@(#)uts-x86:net/tcpip/route.h	1.4"
#ident	"$Header: $"

/*
 *  		PROPRIETARY NOTICE (Combined)
 *  
 *  This source code is unpublished proprietary information
 *  constituting, or derived under license from AT&T's Unix(r) System V.
 *  In addition, portions of such source code were derived from Berkeley
 *  4.3 BSD under license from the Regents of the University of
 *  California.
 *  
 *  
 *  
 *  		Copyright Notice 
 *  
 *  Notice of copyright on this source code product does not indicate 
 *  publication.
 *  
 *  	(c) 1986,1987,1988,1989  Sun Microsystems, Inc.
 *  	(c) 1983,1984,1985,1986,1987,1988,1989,1990  AT&T.
 *	(c) 1990,1991 UNIX System Laboratories, Inc.
 *  	          All rights reserved.
 */

/*
 * System V STREAMS TCP - Release 3.0 
 *
 * Copyright 1987, 1988, 1989 Lachman Associates, Incorporated (LAI) 
 * All Rights Reserved. 
 *
 * The copyright above and this notice must be preserved in all copies of this
 * source code.  The copyright above does not evidence any actual or intended
 * publication of this source code. 
 *
 * This is unpublished proprietary trade secret source code of Lachman
 * Associates.  This source code may not be copied, disclosed, distributed,
 * demonstrated or licensed except as expressly authorized by Lachman
 * Associates. 
 *
 * System V STREAMS TCP was jointly developed by Lachman Associates and
 * Convergent Technologies. 
 */

#ifdef _KERNEL_HEADERS

#ifndef _UTIL_TYPES_H
#include <util/types.h>			/* REQUIRED */
#endif

#ifndef _IO_STREAM_H
#include <io/stream.h>			/* REQUIRED */
#endif

#ifndef _NET_TRANSPORT_SOCKET_H
#include <net/transport/socket.h>	/* REQUIRED */
#endif

#elif defined(_KERNEL)

#include <sys/types.h>			/* REQUIRED */
#include <sys/stream.h>			/* REQUIRED */
#include <sys/socket.h>			/* REQUIRED */

#endif /* _KERNEL_HEADERS */

/*
 * Kernel resident routing tables.
 * 
 * The routing tables are initialized when interface addresses
 * are set by making entries for all directly connected interfaces.
 */

/*
 * A route consists of a destination address and a reference
 * to a routing entry.  These are often held by protocols
 * in their control blocks, e.g. inpcb.
 */
struct route {
#ifdef STRNET
	mblk_t	*ro_rt;
#else
	struct	rtentry *ro_rt;
#endif /* STRNET */
	struct	sockaddr ro_dst;
};

/*
 * We distinguish between routes to hosts and routes to networks,
 * preferring the former if available.  For each route we infer
 * the interface to use from the gateway address supplied when
 * the route was entered.  Routes that forward packets through
 * gateways are marked so that the output routines know to address the
 * gateway rather than the ultimate destination.
 */
struct rtentry {
	u_long	rt_hash;		/* to speed lookups */
	struct	sockaddr rt_dst;	/* key */
	struct	sockaddr rt_gateway;	/* value */
	short	rt_flags;		/* up/down?, host/net */
	short	rt_refcnt;		/* # held references */
	u_long	rt_use;			/* raw # packets forwarded */
#ifdef STRNET
	struct	ip_provider *rt_prov;	/* the answer: provider to use */
#else
	struct	ifnet *rt_ifp;		/* the answer: interface to use */
#endif /* STRNET */
	int		rt_metric;	/* metric for route provider */
	int		rt_proto;	/* protocol route was learned */
	time_t		rt_age;		/* time of last update */
};

#define	RTF_UP		0x1		/* route useable */
#define	RTF_GATEWAY	0x2		/* destination is a gateway */
#define	RTF_HOST	0x4		/* host entry (net otherwise) */
#define RTF_REINSTATE	0x8		/* re-instate route after timeout */
#define	RTF_DYNAMIC	0x10		/* created dynamically (by redirect) */
#define	RTF_MODIFIED	0x20		/* modified dynamically (by redirect) */
#define RTF_REMOTE	0x40	/* route used for forwarded packets */

#define RTF_USERMASK	(RTF_GATEWAY|RTF_HOST)

/*
 * Protocols for learning routes.  These values are from RFC 1158.
 */
#define	RTP_OTHER	1
#define	RTP_LOCAL	2
#define	RTP_NETMGMT	3
#define	RTP_ICMP	4
#define	RTP_EGP		5
#define	RTP_GGP		6
#define	RTP_HELLO	7
#define	RTP_RIP		8
#define	RTP_IS_IS	9
#define	RTP_ES_IS	10
#define	RTP_CISCOIGRP	11
#define	RTP_BBNSPFIGP	12
#define	RTP_OSPF	13
#define	RTP_BGP		14

/*
 * Routing statistics.
 */
struct	rtstat {
	short	rts_badredirect;	/* bogus redirect calls */
	short	rts_dynamic;		/* routes created by redirects */
	short	rts_newgateway;		/* routes modified by redirects */
	short	rts_unreach;		/* lookups which failed */
	short	rts_wildcard;		/* lookups satisfied by a wildcard */
};

#ifdef _KERNEL

#ifdef STRNET
#define RT(x) ((struct rtentry *) (x)->b_rptr)
#define	RTFREE(rt) \
	if (RT(rt)->rt_refcnt == 1) \
		rtfree(rt); \
	else \
		RT(rt)->rt_refcnt--;
#else
#define	RTFREE(rt) \
	if ((rt)->rt_refcnt == 1) \
		rtfree(rt); \
	else \
		(rt)->rt_refcnt--;
#endif /* STRNET */


#ifdef	GATEWAY
#define	RTHASHSIZ	64
#else
#define	RTHASHSIZ	8
#endif	/* GATEWAY */
#if	(RTHASHSIZ & (RTHASHSIZ - 1)) == 0
#define RTHASHMOD(h)	((h) & (RTHASHSIZ - 1))
#else
#define RTHASHMOD(h)	((h) % RTHASHSIZ)
#endif

#ifdef	STRNET
mblk_t	*rthost[RTHASHSIZ];
mblk_t	*rtnet[RTHASHSIZ];
#else
struct	mbuf *rthost[RTHASHSIZ];
struct	mbuf *rtnet[RTHASHSIZ];
#endif	/* STRNET */

struct	rtstat	rtstat;
#endif	/* _KERNEL */
#endif	/* _NET_TCPIP_ROUTE_H */
