/*
 * dstore.c - Motorola V/88 global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.6 95/09/01 15:02:44 abe Exp $";
#endif


#include "lsof.h"


#if	V88>=40403
struct clone *Clone = NULL;	/* clone device list */
int CloneMajor;			/* clone major device number */
int HaveCloneMajor = 0;		/* CloneMajor is defined */
#endif	/* V88>=40403 */

#if	V88<40402
struct fsinfo *Fsinfo = NULL;	/* kernel's fsinfo[], indexed by fstyp */
#else	/* V88>=40402 */
char **Fsinfo = NULL;		/* file system information */
int Fsinfomax = 0;		/* maximum file system type */
#endif	/* V88<40402 */

int Kmem = -1;			/* /dev/kmem file descriptor */

struct l_vfs *Lvfs = NULL;	/* local vfs structure table */

short Nfstyp = 0;		/* number of fstypsw[] entries */

struct nlist Nl[] = {

#if	V88<40402
	{ "_fsinfo",		0, 0, 0, 0, 0 },
	{ "_nfstyp",		0, 0, 0, 0, 0 },
	{ "_pregpp",		0, 0, 0, 0, 0 },
	{ "_proc",		0, 0, 0, 0, 0 },
	{ "_v",			0, 0, 0, 0, 0 },
#else	/* V88>=40402 */
	{ "ncache",		0, 0, 0, 0, 0 },
	{ "ncsize",		0, 0, 0, 0, 0 },
	{ "segvn_ops",		0, 0, 0, 0, 0 },
	{ "v",			0, 0, 0, 0, 0 },

# if	V88>=40403
	{ "clone_major",	0, 0, 0, 0, 0 },
# endif	/* V88>=40403 */
#endif	/* V88<40402 */

	{ NULL,			0, 0, 0, 0, 0 }
};
