/*
 * dstore.c - HP-UX global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.3 95/06/23 15:46:03 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */


int Kmem = -1;				/* /dev/kmem file descriptor */

struct l_vfs *Lvfs = NULL;		/* local vfs structure table */

#if	_HPUXV<800
int Mem = -1;			/* /dev/mem file descriptor */
#endif	/* _HPUXV<800 */

struct nlist Nl[] = {

# if	defined(hp9000s300)
        { "_ncache"		},
        { "_ncsize"		},
        { "_proc"		},
        { "_nfs_vnodeops"	},
        { "_nproc"		},
        { "_vnodefops"		},

#  if	_HPUXV<800
	{ "_Usrptmap"		},
	{ "_usrpt"		},
#  endif	/* _HPUXV<800 */
# endif	/* defined(hp9000s300) */

# if	defined(hp9000s800)
        { "ncache"		},
        { "ncsize"		},
	{ "proc"		},
        { "nfs_vnodeops"	},
	{ "nproc"		},
        { "vnodefops"		},

#  if	_HPUXV<800
	{ "ubase"		},
	{ "npids"		},
#  else	/* _HPUXV>=800 */
#   if	_HPUXV>=1000
	{ "cdfs_vnodeops"	},
	{ "fifo_vnodeops"	},
	{ "pipe_vnodeops"	},
	{ "spec_vnodeops"	},
#   endif	/* _HPUXV>=1000 */
#  endif	/* _HPUXV<800 */
# endif	/* defined(hp9000s800) */

	{ "" }
};

#if	_HPUXV<800 && defined(hp9000s800)
int npids;			/* number of PIDs (for uvadd()) */
struct proc *proc;		/* process table address (for uvadd()) */
#endif	/* _HPUXV<800 && defined(hp9000s300) */

#if	_HPUXV<800
int Swap = -1;			/* swap device file descriptor */
#endif	/* _HPUXV<800 */

#if	!defined(HPUX7) && defined(hp9000s800)
struct user *ubase;		/* user area base (for uvadd()) */
#endif

#if	!defined(HPUX7) && defined(hp9000s300)
struct user *ubase;		/* user area base (for uvadd()) */
struct pte *Usrptmap;		/* user page table map pointer */
struct pte *usrpt;		/* user page table pointer
				 * (for bktomx from vmmac.h) */
#endif

struct fileops *Vnfops;		/* vnodefops switch address */
