/*
 * dlsof.h - DYNIX header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


#if	!defined(DYNIX_LSOF_H)
#define	DYNIX_LSOF_H	1

#include <mntent.h>
#include <setjmp.h>
#include <strings.h>
#include <nlist.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <sys/dir.h>
#include <sys/domain.h>
#include <sys/mbuf.h>
#include <sys/proc.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/un.h>
#include <sys/unpcb.h>
#include <sys/vfs.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>
#include <netinet/in_pcb.h>
#include <nfs/nfs.h>
#include <nfs/nfs_clnt.h>
#include <nfs/rnode.h>
#define KERNEL
#include <sys/file.h>
#include <sys/inode.h>
#include <ufs/mount.h>
#undef KERNEL
#include <sys/user.h>

# if	!defined(DYNIX31)
/*
 * This is from sys/user.h.  It's ifdef KERNEL, though, and defining
 * KERNEL for user.h breaks other things.
 *
 * Open-file table extension object structure.
 */

struct  ofile_ext {
	struct  ofile_ext *oe_next;             /* list of unused entries */
	short           oe_nofile;              /* # ofile entries */
	short           oe_refcnt;              /* # proc's sharing this ext */
	short           oe_ccount;              /* # sharing proc's in memory */
	swblk_t         oe_swaddr;              /* disk address when swapped */
	sema_t          oe_mutex;               /* misc mutex */
	struct  ofile   *oe_ofile;              /* array of open files */
};
# endif	/* ! DYNIX31 */

# if	defined(DYNIX)
extern int nlist();
# endif

typedef	int	pid_t;

# if	defined(HASPWSTAYOPEN)
extern int _pw_stayopen;
#define	pw_stay_open()	_pw_stayopen=1
# endif

extern char *sys_errlist[];
#define	strerror(errno) sys_errlist[errno]

#define	COMP_P		void
#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	char
#define FREE_P		MALLOC_P
#define MALLOC_S	unsigned

# if	defined(HASNCACHE)
#define	NC_SIZE		128	/* should come from a header file */
# endif	/* defined(HASNCACHE) */

#define N_UNIX		"/dynix"

# if	defined(i386)
#define	PTBITS		0xfff	/* 4096 byte pages */
# else
#define	PTBITS		0x1ff	/* 512 byte pages */
# endif

#define QSORT_P		char
#define	READLEN_T	int
#define STRNCPY_L	int
#define SWAP		"/dev/drum"
#define	U_SIZE		sizeof(struct user)

# if	defined(DYNIX31)
#define strchr		index
#define strrchr		rindex
# endif

#  if	defined(SEQUENT)
#define strchr		index
#define strrchr		rindex
#define	uid_t		int
#define	unp_addr	unp_remaddr
# endif


/*
 * Global storage definitions (including their structure definitions)
 */

extern int Kmem;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	u_short mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};


/*
 * Name list (Nl[]) indexes
 */

#define	X_NCACHE	0
#define X_PROC          1
#define X_NPROC         2
#define X_NFS_OPS	3
#define	X_SYSMAP	4

extern int Notkmem;

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

extern int Swap;
extern struct pte *Sysmap;

#endif	/* DYNIX_LSOF_H */
