#! /bin/zsh -f

# Written by SL Baur <steve@xemacs.org>
# December, 1998
# This file is part of XEmacs and is used by the maintainers
#  for creating distributions

# LinkPackages:  Fetch a brand new distribution tree
# Usage:  LinkPackages BUILDDIR

setopt extendedglob
set -e # Exit at the first sign of trouble

if [ $# != 1 ]; then
	echo "Usage: $0: BUILDDIR"
	exit 1
fi

export BUILDDIR=$1

if [ ! -d bootstrap-mule-packages ]; then
	echo "$0: Warning: Bootstrap Mule packages directory doesn't exist."
fi
if [ ! -d bootstrap-xemacs-packages ]; then
	echo "$0: Warning: Bootstrap XEmacs packages directory doesn't exist."
fi

if [ -d ${BUILDDIR} ]; then
	[ -e ${BUILDDIR}/mule-packages ] && rm -f ${BUILDDIR}/mule-packages
	ln -s ../bootstrap-mule-packages ${BUILDDIR}/mule-packages
	[ -e ${BUILDDIR}/xemacs-packages ] && rm -f ${BUILDDIR}/xemacs-packages
	ln -s ../bootstrap-xemacs-packages ${BUILDDIR}/xemacs-packages
fi

exit 0
