/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ClassPathException;
import bsh.EvalError;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;

public abstract class BshClassManager {
    private static BshClassManager manager;
    private static boolean checkedForManager;
    private static Object NOVALUE;
    private static ClassLoader externalClassLoader;
    protected static transient Hashtable absoluteClassCache;
    protected static transient Hashtable absoluteNonClasses;

    public static BshClassManager getClassManager() {
        if (!checkedForManager && manager == null) {
            try {
                if (BshClassManager.plainClassForName("java.lang.ref.WeakReference") != null && BshClassManager.plainClassForName("java.util.HashMap") != null) {
                    Class clazz = BshClassManager.plainClassForName("bsh.classpath.ClassManagerImpl");
                    manager = (BshClassManager)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                System.err.println("Error loading classmanager: " + exception);
            }
        }
        checkedForManager = true;
        return manager;
    }

    public static boolean classExists(String string) {
        return BshClassManager.classForName(string) != null;
    }

    public static Class classForName(String string) {
        BshClassManager bshClassManager = BshClassManager.getClassManager();
        if (bshClassManager != null) {
            return bshClassManager.getClassForName(string);
        }
        try {
            return BshClassManager.plainClassForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class plainClassForName(String string) throws ClassNotFoundException {
        try {
            BshClassManager bshClassManager;
            Class<Object> clazz = externalClassLoader != null ? externalClassLoader.loadClass(string) : ((bshClassManager = manager) != null ? bshClassManager.getPlainClassForName(string) : Class.forName(string));
            BshClassManager.cacheClassInfo(string, clazz);
            return clazz;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            BshClassManager.cacheClassInfo(string, null);
            throw new ClassNotFoundException(noClassDefFoundError.toString());
        }
    }

    public static void cacheClassInfo(String string, Class clazz) {
        if (clazz != null) {
            absoluteClassCache.put(string, clazz);
        } else {
            absoluteNonClasses.put(string, NOVALUE);
        }
    }

    protected void clearCaches() {
        absoluteNonClasses = new Hashtable();
        absoluteClassCache = new Hashtable();
    }

    public static void addCMListener(Listener listener) {
        BshClassManager.getClassManager();
        if (manager != null) {
            manager.addListener(listener);
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        externalClassLoader = classLoader;
        BshClassManager bshClassManager = BshClassManager.getClassManager();
        if (bshClassManager != null) {
            bshClassManager.classLoaderChanged();
        }
    }

    public abstract Class getClassForName(String var1);

    public abstract Class getPlainClassForName(String var1) throws ClassNotFoundException;

    public abstract ClassLoader getBaseLoader();

    public abstract ClassLoader getLoaderForClass(String var1);

    public abstract void addClassPath(URL var1) throws IOException;

    public abstract void reset();

    public abstract void setClassPath(URL[] var1);

    public abstract void reloadAllClasses() throws ClassPathException;

    public abstract void reloadClasses(String[] var1) throws ClassPathException;

    public abstract void reloadPackage(String var1) throws ClassPathException;

    public abstract void doSuperImport() throws EvalError;

    public abstract String getClassNameByUnqName(String var1) throws ClassPathException;

    public abstract void addListener(Listener var1);

    public abstract void removeListener(Listener var1);

    public abstract void dump(PrintWriter var1);

    protected abstract void classLoaderChanged();

    static {
        NOVALUE = new Object();
        absoluteClassCache = new Hashtable();
        absoluteNonClasses = new Hashtable();
    }

    public static interface Listener {
        public void classLoaderChanged();
    }
}

