/* ,file-id archive://[lord]/391/vu/./hashtab.h/1998-05-18
*/
#ifndef VUHASHTABH
#define VUHASHTABH

/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



struct hashtab
{
  struct hashtab * parent;
  int refs;
  subset nested_p;
  void ** children[16];
};

struct hashtab_item
{
  struct hashtab_item * next_same_hash;
  struct hashtab * table;

  unsigned long hash;
  void * data;
  void * binding;
};

struct hashtab_rules;

typedef int (*hashtab_eq) (void *, void *);

typedef int (*hashtab_alloc) (int * errn,
			      struct hashtab ** retv,
			      struct hashtab_rules *);

typedef void (*free_hashtab) (struct hashtab *,
			      struct hashtab_rules *);

typedef int (*hashtab_alloc_item) (int * errn,
				   struct hashtab_item ** retv,
				   struct hashtab_rules *, void *);

typedef void (*free_hashtab_item) (struct hashtab_item *,
				   struct hashtab_rules *);

struct hashtab_rules
{
  hashtab_eq eq;
  hashtab_alloc hash_alloc;
  free_hashtab free_hash;
  hashtab_alloc_item hash_item_alloc;
  free_hashtab_item free_hash_item;
};



typedef void (*hashtab_freefn) (struct hashtab_item * it);


/* automatically generated __STDC__ prototypes */
extern int hashtab_new (int * errn, struct hashtab ** retv, struct hashtab_rules * rules);
extern void hashtab_free (struct hashtab * it,
			  hashtab_freefn freefn,
			  struct hashtab_rules * rules);
extern void hashtab_free_static (struct hashtab * tab,
				 hashtab_freefn freefn,
				 struct hashtab_rules * rules);
extern struct hashtab_item * hashtab_find (struct hashtab * table,
					   unsigned long hash,
					   void * key,
					   struct hashtab_rules * rules);
extern struct hashtab_item * hashtab_store (struct hashtab * table,
					    unsigned long hash,
					    void * key,
					    struct hashtab_rules * rules);
extern void hashtab_delete (struct hashtab_item * it, struct hashtab_rules * rules);
#endif  /* VUHASHTABH */
