/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import type { FormMetadata, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { v1 as simplest } from "./simplest.js";

const languages = (i18n: InternationalizationAPI) => [
  {
    label: i18n.str`Mandarin Chinese`,
    value: "cmn",
  },
  {
    label: i18n.str`Spanish`,
    value: "spa",
  },
  {
    label: i18n.str`English`,
    value: "eng",
  },
  {
    label: i18n.str`Hindi`,
    value: "hin",
  },
  {
    label: i18n.str`Portuguese`,
    value: "por",
  },
  {
    label: i18n.str`Bengali`,
    value: "ben",
  },
  {
    label: i18n.str`Russian`,
    value: "rus",
  },
  {
    label: i18n.str`Japanese`,
    value: "jpn",
  },
  {
    label: i18n.str`Yue`,
    value: "yue",
  },
  {
    label: i18n.str`Vietnamese`,
    value: "vie",
  },
  {
    label: i18n.str`Turkish`,
    value: "tur",
  },
  {
    label: i18n.str`Wu`,
    value: "wuu",
  },
  {
    label: i18n.str`Marathi`,
    value: "mar",
  },
  {
    label: i18n.str`Telugu`,
    value: "ten",
  },
  {
    label: i18n.str`Korean`,
    value: "kor",
  },
  {
    label: i18n.str`French`,
    value: "fra",
  },
  {
    label: i18n.str`Tamil`,
    value: "tam",
  },
  {
    label: i18n.str`Egyptian Arabic`,
    value: "arz",
  },
  {
    label: i18n.str`Standard German`,
    value: "deu",
  },
  {
    label: i18n.str`Urdu`,
    value: "urd",
  },
  {
    label: i18n.str`Javanese`,
    value: "jav",
  },
  {
    label: i18n.str`Punjabi`,
    value: "pan",
  },
  {
    label: i18n.str`Italian`,
    value: "ita",
  },
  {
    label: i18n.str`Gujarati`,
    value: "guj",
  },
  {
    label: i18n.str`Iranian Persian`,
    value: "pes",
  },
  {
    label: i18n.str`Bhojpuri`,
    value: "bho",
  },
  {
    label: i18n.str`Hausa`,
    value: "hau",
  },
];


export const preloadedForms: (i18n: InternationalizationAPI) => Array<FormMetadata> = (i18n) => [
  {
    label: i18n.str`Simple comment`,
    id: "__simple_comment",
    version: 1,
    config: simplest(i18n),
  // }, {
  //   label: i18n.str`Identification form`,
  //   id: "902.1e",
  //   version: 1,
  //   config: form_902_1e_v1(i18n),
  // }, {
  //   label: i18n.str`Operational legal entity or partnership`,
  //   id: "902.11e",
  //   version: 1,
  //   config: form_902_11e_v1(i18n),
  // }, {
  //   label: i18n.str`Foundations`,
  //   id: "902.12e",
  //   version: 1,
  //   config: form_902_12e_v1(i18n),
  // }, {
  //   label: i18n.str`Declaration for trusts`,
  //   id: "902.13e",
  //   version: 1,
  //   config: form_902_13e_v1(i18n),
  // }, {
  //   label: i18n.str`Information on life insurance policies`,
  //   id: "902.15e",
  //   version: 1,
  //   config: form_902_15e_v1(i18n),
  // }, {
  //   label: i18n.str`Declaration of beneficial owner`,
  //   id: "902.9e",
  //   version: 1,
  //   config: form_902_9e_v1(i18n),
  // }, {
  //   label: i18n.str`Customer profile`,
  //   id: "902.5e",
  //   version: 1,
  //   config: form_902_5e_v1(i18n),
  // }, {
  //   label: i18n.str`Risk profile`,
  //   id: "902.4e",
  //   version: 1,
  //   config: form_902_4e_v1(i18n),
  },
];


const currencies = (i18n: InternationalizationAPI) => [
  {
    label: i18n.str`United States dollar`,
    value: "usd",
  },
  {
    label: i18n.str`Euro`,
    value: "eur",
  },
  {
    label: i18n.str`Swiss franc`,
    value: "chf",
  },
  {
    label: i18n.str`Argentine peso`,
    value: "ars",
  },
  {
    label: i18n.str`Mexican peso`,
    value: "mxn",
  },
  {
    label: i18n.str`Brazilian real`,
    value: "brl",
  },
];

