#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018, 2019, 2020 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; Tests of Unicode word segmentation

(declare (usual-integrations))

(include "test-ucd-data/segmentation-support.scm")

(define-test 'word-breaks
  (map (lambda (test-case)
	 (let ((string (test-case->string test-case))
	       (breaks (test-case->breaks test-case)))
	   (lambda ()
	     (with-test-properties
	      (lambda ()
		(assert-equal (string-word-breaks string) breaks))
	      'expression string))))
       '((#t #\x0001 #t #\x0001 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0001 #t #\x000D #t)
	 (#t #\x0001 #f #\x0308 #t #\x000D #t)
	 (#t #\x0001 #t #\x000A #t)
	 (#t #\x0001 #f #\x0308 #t #\x000A #t)
	 (#t #\x0001 #t #\x000B #t)
	 (#t #\x0001 #f #\x0308 #t #\x000B #t)
	 (#t #\x0001 #t #\x3031 #t)
	 (#t #\x0001 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0001 #t #\x0041 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0041 #t)
	 (#t #\x0001 #t #\x003A #t)
	 (#t #\x0001 #f #\x0308 #t #\x003A #t)
	 (#t #\x0001 #t #\x002C #t)
	 (#t #\x0001 #f #\x0308 #t #\x002C #t)
	 (#t #\x0001 #t #\x002E #t)
	 (#t #\x0001 #f #\x0308 #t #\x002E #t)
	 (#t #\x0001 #t #\x0030 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0030 #t)
	 (#t #\x0001 #t #\x005F #t)
	 (#t #\x0001 #f #\x0308 #t #\x005F #t)
	 (#t #\x0001 #t #\x1F1E6 #t)
	 (#t #\x0001 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0001 #t #\x05D0 #t)
	 (#t #\x0001 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0001 #t #\x0022 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0001 #t #\x0027 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0001 #t #\x261D #t)
	 (#t #\x0001 #f #\x0308 #t #\x261D #t)
	 (#t #\x0001 #t #\x1F3FB #t)
	 (#t #\x0001 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0001 #t #\x2764 #t)
	 (#t #\x0001 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0001 #t #\x1F466 #t)
	 (#t #\x0001 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0001 #f #\x00AD #t)
	 (#t #\x0001 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0001 #f #\x0300 #t)
	 (#t #\x0001 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0001 #f #\x200D #t)
	 (#t #\x0001 #f #\x0308 #f #\x200D #t)
	 (#t #\x0001 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0001 #t #\x0061 #t #\x003A #t)
	 (#t #\x0001 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0001 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0001 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0001 #t #\x0061 #t #\x002C #t)
	 (#t #\x0001 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0001 #t #\x0031 #t #\x003A #t)
	 (#t #\x0001 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0001 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0001 #t #\x0031 #t #\x002C #t)
	 (#t #\x0001 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0001 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0001 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000D #t #\x0001 #t)
	 (#t #\x000D #t #\x0308 #t #\x0001 #t)
	 (#t #\x000D #t #\x000D #t)
	 (#t #\x000D #t #\x0308 #t #\x000D #t)
	 (#t #\x000D #f #\x000A #t)
	 (#t #\x000D #t #\x0308 #t #\x000A #t)
	 (#t #\x000D #t #\x000B #t)
	 (#t #\x000D #t #\x0308 #t #\x000B #t)
	 (#t #\x000D #t #\x3031 #t)
	 (#t #\x000D #t #\x0308 #t #\x3031 #t)
	 (#t #\x000D #t #\x0041 #t)
	 (#t #\x000D #t #\x0308 #t #\x0041 #t)
	 (#t #\x000D #t #\x003A #t)
	 (#t #\x000D #t #\x0308 #t #\x003A #t)
	 (#t #\x000D #t #\x002C #t)
	 (#t #\x000D #t #\x0308 #t #\x002C #t)
	 (#t #\x000D #t #\x002E #t)
	 (#t #\x000D #t #\x0308 #t #\x002E #t)
	 (#t #\x000D #t #\x0030 #t)
	 (#t #\x000D #t #\x0308 #t #\x0030 #t)
	 (#t #\x000D #t #\x005F #t)
	 (#t #\x000D #t #\x0308 #t #\x005F #t)
	 (#t #\x000D #t #\x1F1E6 #t)
	 (#t #\x000D #t #\x0308 #t #\x1F1E6 #t)
	 (#t #\x000D #t #\x05D0 #t)
	 (#t #\x000D #t #\x0308 #t #\x05D0 #t)
	 (#t #\x000D #t #\x0022 #t)
	 (#t #\x000D #t #\x0308 #t #\x0022 #t)
	 (#t #\x000D #t #\x0027 #t)
	 (#t #\x000D #t #\x0308 #t #\x0027 #t)
	 (#t #\x000D #t #\x261D #t)
	 (#t #\x000D #t #\x0308 #t #\x261D #t)
	 (#t #\x000D #t #\x1F3FB #t)
	 (#t #\x000D #t #\x0308 #t #\x1F3FB #t)
	 (#t #\x000D #t #\x2764 #t)
	 (#t #\x000D #t #\x0308 #t #\x2764 #t)
	 (#t #\x000D #t #\x1F466 #t)
	 (#t #\x000D #t #\x0308 #t #\x1F466 #t)
	 (#t #\x000D #t #\x00AD #t)
	 (#t #\x000D #t #\x0308 #f #\x00AD #t)
	 (#t #\x000D #t #\x0300 #t)
	 (#t #\x000D #t #\x0308 #f #\x0300 #t)
	 (#t #\x000D #t #\x200D #t)
	 (#t #\x000D #t #\x0308 #f #\x200D #t)
	 (#t #\x000D #t #\x0061 #f #\x2060 #t)
	 (#t #\x000D #t #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x000D #t #\x0061 #t #\x003A #t)
	 (#t #\x000D #t #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x000D #t #\x0061 #t #\x0027 #t)
	 (#t #\x000D #t #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x000D #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x000D #t #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x000D #t #\x0061 #t #\x002C #t)
	 (#t #\x000D #t #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x000D #t #\x0031 #t #\x003A #t)
	 (#t #\x000D #t #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x000D #t #\x0031 #t #\x0027 #t)
	 (#t #\x000D #t #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x000D #t #\x0031 #t #\x002C #t)
	 (#t #\x000D #t #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x000D #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000D #t #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000A #t #\x0001 #t)
	 (#t #\x000A #t #\x0308 #t #\x0001 #t)
	 (#t #\x000A #t #\x000D #t)
	 (#t #\x000A #t #\x0308 #t #\x000D #t)
	 (#t #\x000A #t #\x000A #t)
	 (#t #\x000A #t #\x0308 #t #\x000A #t)
	 (#t #\x000A #t #\x000B #t)
	 (#t #\x000A #t #\x0308 #t #\x000B #t)
	 (#t #\x000A #t #\x3031 #t)
	 (#t #\x000A #t #\x0308 #t #\x3031 #t)
	 (#t #\x000A #t #\x0041 #t)
	 (#t #\x000A #t #\x0308 #t #\x0041 #t)
	 (#t #\x000A #t #\x003A #t)
	 (#t #\x000A #t #\x0308 #t #\x003A #t)
	 (#t #\x000A #t #\x002C #t)
	 (#t #\x000A #t #\x0308 #t #\x002C #t)
	 (#t #\x000A #t #\x002E #t)
	 (#t #\x000A #t #\x0308 #t #\x002E #t)
	 (#t #\x000A #t #\x0030 #t)
	 (#t #\x000A #t #\x0308 #t #\x0030 #t)
	 (#t #\x000A #t #\x005F #t)
	 (#t #\x000A #t #\x0308 #t #\x005F #t)
	 (#t #\x000A #t #\x1F1E6 #t)
	 (#t #\x000A #t #\x0308 #t #\x1F1E6 #t)
	 (#t #\x000A #t #\x05D0 #t)
	 (#t #\x000A #t #\x0308 #t #\x05D0 #t)
	 (#t #\x000A #t #\x0022 #t)
	 (#t #\x000A #t #\x0308 #t #\x0022 #t)
	 (#t #\x000A #t #\x0027 #t)
	 (#t #\x000A #t #\x0308 #t #\x0027 #t)
	 (#t #\x000A #t #\x261D #t)
	 (#t #\x000A #t #\x0308 #t #\x261D #t)
	 (#t #\x000A #t #\x1F3FB #t)
	 (#t #\x000A #t #\x0308 #t #\x1F3FB #t)
	 (#t #\x000A #t #\x2764 #t)
	 (#t #\x000A #t #\x0308 #t #\x2764 #t)
	 (#t #\x000A #t #\x1F466 #t)
	 (#t #\x000A #t #\x0308 #t #\x1F466 #t)
	 (#t #\x000A #t #\x00AD #t)
	 (#t #\x000A #t #\x0308 #f #\x00AD #t)
	 (#t #\x000A #t #\x0300 #t)
	 (#t #\x000A #t #\x0308 #f #\x0300 #t)
	 (#t #\x000A #t #\x200D #t)
	 (#t #\x000A #t #\x0308 #f #\x200D #t)
	 (#t #\x000A #t #\x0061 #f #\x2060 #t)
	 (#t #\x000A #t #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x000A #t #\x0061 #t #\x003A #t)
	 (#t #\x000A #t #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x000A #t #\x0061 #t #\x0027 #t)
	 (#t #\x000A #t #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x000A #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x000A #t #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x000A #t #\x0061 #t #\x002C #t)
	 (#t #\x000A #t #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x000A #t #\x0031 #t #\x003A #t)
	 (#t #\x000A #t #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x000A #t #\x0031 #t #\x0027 #t)
	 (#t #\x000A #t #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x000A #t #\x0031 #t #\x002C #t)
	 (#t #\x000A #t #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x000A #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000A #t #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000B #t #\x0001 #t)
	 (#t #\x000B #t #\x0308 #t #\x0001 #t)
	 (#t #\x000B #t #\x000D #t)
	 (#t #\x000B #t #\x0308 #t #\x000D #t)
	 (#t #\x000B #t #\x000A #t)
	 (#t #\x000B #t #\x0308 #t #\x000A #t)
	 (#t #\x000B #t #\x000B #t)
	 (#t #\x000B #t #\x0308 #t #\x000B #t)
	 (#t #\x000B #t #\x3031 #t)
	 (#t #\x000B #t #\x0308 #t #\x3031 #t)
	 (#t #\x000B #t #\x0041 #t)
	 (#t #\x000B #t #\x0308 #t #\x0041 #t)
	 (#t #\x000B #t #\x003A #t)
	 (#t #\x000B #t #\x0308 #t #\x003A #t)
	 (#t #\x000B #t #\x002C #t)
	 (#t #\x000B #t #\x0308 #t #\x002C #t)
	 (#t #\x000B #t #\x002E #t)
	 (#t #\x000B #t #\x0308 #t #\x002E #t)
	 (#t #\x000B #t #\x0030 #t)
	 (#t #\x000B #t #\x0308 #t #\x0030 #t)
	 (#t #\x000B #t #\x005F #t)
	 (#t #\x000B #t #\x0308 #t #\x005F #t)
	 (#t #\x000B #t #\x1F1E6 #t)
	 (#t #\x000B #t #\x0308 #t #\x1F1E6 #t)
	 (#t #\x000B #t #\x05D0 #t)
	 (#t #\x000B #t #\x0308 #t #\x05D0 #t)
	 (#t #\x000B #t #\x0022 #t)
	 (#t #\x000B #t #\x0308 #t #\x0022 #t)
	 (#t #\x000B #t #\x0027 #t)
	 (#t #\x000B #t #\x0308 #t #\x0027 #t)
	 (#t #\x000B #t #\x261D #t)
	 (#t #\x000B #t #\x0308 #t #\x261D #t)
	 (#t #\x000B #t #\x1F3FB #t)
	 (#t #\x000B #t #\x0308 #t #\x1F3FB #t)
	 (#t #\x000B #t #\x2764 #t)
	 (#t #\x000B #t #\x0308 #t #\x2764 #t)
	 (#t #\x000B #t #\x1F466 #t)
	 (#t #\x000B #t #\x0308 #t #\x1F466 #t)
	 (#t #\x000B #t #\x00AD #t)
	 (#t #\x000B #t #\x0308 #f #\x00AD #t)
	 (#t #\x000B #t #\x0300 #t)
	 (#t #\x000B #t #\x0308 #f #\x0300 #t)
	 (#t #\x000B #t #\x200D #t)
	 (#t #\x000B #t #\x0308 #f #\x200D #t)
	 (#t #\x000B #t #\x0061 #f #\x2060 #t)
	 (#t #\x000B #t #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x000B #t #\x0061 #t #\x003A #t)
	 (#t #\x000B #t #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x000B #t #\x0061 #t #\x0027 #t)
	 (#t #\x000B #t #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x000B #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x000B #t #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x000B #t #\x0061 #t #\x002C #t)
	 (#t #\x000B #t #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x000B #t #\x0031 #t #\x003A #t)
	 (#t #\x000B #t #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x000B #t #\x0031 #t #\x0027 #t)
	 (#t #\x000B #t #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x000B #t #\x0031 #t #\x002C #t)
	 (#t #\x000B #t #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x000B #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000B #t #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x3031 #t #\x0001 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0001 #t)
	 (#t #\x3031 #t #\x000D #t)
	 (#t #\x3031 #f #\x0308 #t #\x000D #t)
	 (#t #\x3031 #t #\x000A #t)
	 (#t #\x3031 #f #\x0308 #t #\x000A #t)
	 (#t #\x3031 #t #\x000B #t)
	 (#t #\x3031 #f #\x0308 #t #\x000B #t)
	 (#t #\x3031 #f #\x3031 #t)
	 (#t #\x3031 #f #\x0308 #f #\x3031 #t)
	 (#t #\x3031 #t #\x0041 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0041 #t)
	 (#t #\x3031 #t #\x003A #t)
	 (#t #\x3031 #f #\x0308 #t #\x003A #t)
	 (#t #\x3031 #t #\x002C #t)
	 (#t #\x3031 #f #\x0308 #t #\x002C #t)
	 (#t #\x3031 #t #\x002E #t)
	 (#t #\x3031 #f #\x0308 #t #\x002E #t)
	 (#t #\x3031 #t #\x0030 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0030 #t)
	 (#t #\x3031 #f #\x005F #t)
	 (#t #\x3031 #f #\x0308 #f #\x005F #t)
	 (#t #\x3031 #t #\x1F1E6 #t)
	 (#t #\x3031 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x3031 #t #\x05D0 #t)
	 (#t #\x3031 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x3031 #t #\x0022 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0022 #t)
	 (#t #\x3031 #t #\x0027 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0027 #t)
	 (#t #\x3031 #t #\x261D #t)
	 (#t #\x3031 #f #\x0308 #t #\x261D #t)
	 (#t #\x3031 #t #\x1F3FB #t)
	 (#t #\x3031 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x3031 #t #\x2764 #t)
	 (#t #\x3031 #f #\x0308 #t #\x2764 #t)
	 (#t #\x3031 #t #\x1F466 #t)
	 (#t #\x3031 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x3031 #f #\x00AD #t)
	 (#t #\x3031 #f #\x0308 #f #\x00AD #t)
	 (#t #\x3031 #f #\x0300 #t)
	 (#t #\x3031 #f #\x0308 #f #\x0300 #t)
	 (#t #\x3031 #f #\x200D #t)
	 (#t #\x3031 #f #\x0308 #f #\x200D #t)
	 (#t #\x3031 #t #\x0061 #f #\x2060 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x3031 #t #\x0061 #t #\x003A #t)
	 (#t #\x3031 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x3031 #t #\x0061 #t #\x0027 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x3031 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x3031 #t #\x0061 #t #\x002C #t)
	 (#t #\x3031 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x3031 #t #\x0031 #t #\x003A #t)
	 (#t #\x3031 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x3031 #t #\x0031 #t #\x0027 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x3031 #t #\x0031 #t #\x002C #t)
	 (#t #\x3031 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x3031 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x3031 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0041 #t #\x0001 #t)
	 (#t #\x0041 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0041 #t #\x000D #t)
	 (#t #\x0041 #f #\x0308 #t #\x000D #t)
	 (#t #\x0041 #t #\x000A #t)
	 (#t #\x0041 #f #\x0308 #t #\x000A #t)
	 (#t #\x0041 #t #\x000B #t)
	 (#t #\x0041 #f #\x0308 #t #\x000B #t)
	 (#t #\x0041 #t #\x3031 #t)
	 (#t #\x0041 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0041 #f #\x0041 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0041 #t)
	 (#t #\x0041 #t #\x003A #t)
	 (#t #\x0041 #f #\x0308 #t #\x003A #t)
	 (#t #\x0041 #t #\x002C #t)
	 (#t #\x0041 #f #\x0308 #t #\x002C #t)
	 (#t #\x0041 #t #\x002E #t)
	 (#t #\x0041 #f #\x0308 #t #\x002E #t)
	 (#t #\x0041 #f #\x0030 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0030 #t)
	 (#t #\x0041 #f #\x005F #t)
	 (#t #\x0041 #f #\x0308 #f #\x005F #t)
	 (#t #\x0041 #t #\x1F1E6 #t)
	 (#t #\x0041 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0041 #f #\x05D0 #t)
	 (#t #\x0041 #f #\x0308 #f #\x05D0 #t)
	 (#t #\x0041 #t #\x0022 #t)
	 (#t #\x0041 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0041 #t #\x0027 #t)
	 (#t #\x0041 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0041 #t #\x261D #t)
	 (#t #\x0041 #f #\x0308 #t #\x261D #t)
	 (#t #\x0041 #t #\x1F3FB #t)
	 (#t #\x0041 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0041 #t #\x2764 #t)
	 (#t #\x0041 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0041 #t #\x1F466 #t)
	 (#t #\x0041 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0041 #f #\x00AD #t)
	 (#t #\x0041 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0041 #f #\x0300 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0041 #f #\x200D #t)
	 (#t #\x0041 #f #\x0308 #f #\x200D #t)
	 (#t #\x0041 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0041 #f #\x0061 #t #\x003A #t)
	 (#t #\x0041 #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x0041 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0041 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0041 #f #\x0061 #t #\x002C #t)
	 (#t #\x0041 #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x0041 #f #\x0031 #t #\x003A #t)
	 (#t #\x0041 #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x0041 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0041 #f #\x0031 #t #\x002C #t)
	 (#t #\x0041 #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x0041 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0041 #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x003A #t #\x0001 #t)
	 (#t #\x003A #f #\x0308 #t #\x0001 #t)
	 (#t #\x003A #t #\x000D #t)
	 (#t #\x003A #f #\x0308 #t #\x000D #t)
	 (#t #\x003A #t #\x000A #t)
	 (#t #\x003A #f #\x0308 #t #\x000A #t)
	 (#t #\x003A #t #\x000B #t)
	 (#t #\x003A #f #\x0308 #t #\x000B #t)
	 (#t #\x003A #t #\x3031 #t)
	 (#t #\x003A #f #\x0308 #t #\x3031 #t)
	 (#t #\x003A #t #\x0041 #t)
	 (#t #\x003A #f #\x0308 #t #\x0041 #t)
	 (#t #\x003A #t #\x003A #t)
	 (#t #\x003A #f #\x0308 #t #\x003A #t)
	 (#t #\x003A #t #\x002C #t)
	 (#t #\x003A #f #\x0308 #t #\x002C #t)
	 (#t #\x003A #t #\x002E #t)
	 (#t #\x003A #f #\x0308 #t #\x002E #t)
	 (#t #\x003A #t #\x0030 #t)
	 (#t #\x003A #f #\x0308 #t #\x0030 #t)
	 (#t #\x003A #t #\x005F #t)
	 (#t #\x003A #f #\x0308 #t #\x005F #t)
	 (#t #\x003A #t #\x1F1E6 #t)
	 (#t #\x003A #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x003A #t #\x05D0 #t)
	 (#t #\x003A #f #\x0308 #t #\x05D0 #t)
	 (#t #\x003A #t #\x0022 #t)
	 (#t #\x003A #f #\x0308 #t #\x0022 #t)
	 (#t #\x003A #t #\x0027 #t)
	 (#t #\x003A #f #\x0308 #t #\x0027 #t)
	 (#t #\x003A #t #\x261D #t)
	 (#t #\x003A #f #\x0308 #t #\x261D #t)
	 (#t #\x003A #t #\x1F3FB #t)
	 (#t #\x003A #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x003A #t #\x2764 #t)
	 (#t #\x003A #f #\x0308 #t #\x2764 #t)
	 (#t #\x003A #t #\x1F466 #t)
	 (#t #\x003A #f #\x0308 #t #\x1F466 #t)
	 (#t #\x003A #f #\x00AD #t)
	 (#t #\x003A #f #\x0308 #f #\x00AD #t)
	 (#t #\x003A #f #\x0300 #t)
	 (#t #\x003A #f #\x0308 #f #\x0300 #t)
	 (#t #\x003A #f #\x200D #t)
	 (#t #\x003A #f #\x0308 #f #\x200D #t)
	 (#t #\x003A #t #\x0061 #f #\x2060 #t)
	 (#t #\x003A #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x003A #t #\x0061 #t #\x003A #t)
	 (#t #\x003A #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x003A #t #\x0061 #t #\x0027 #t)
	 (#t #\x003A #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x003A #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x003A #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x003A #t #\x0061 #t #\x002C #t)
	 (#t #\x003A #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x003A #t #\x0031 #t #\x003A #t)
	 (#t #\x003A #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x003A #t #\x0031 #t #\x0027 #t)
	 (#t #\x003A #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x003A #t #\x0031 #t #\x002C #t)
	 (#t #\x003A #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x003A #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x003A #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x002C #t #\x0001 #t)
	 (#t #\x002C #f #\x0308 #t #\x0001 #t)
	 (#t #\x002C #t #\x000D #t)
	 (#t #\x002C #f #\x0308 #t #\x000D #t)
	 (#t #\x002C #t #\x000A #t)
	 (#t #\x002C #f #\x0308 #t #\x000A #t)
	 (#t #\x002C #t #\x000B #t)
	 (#t #\x002C #f #\x0308 #t #\x000B #t)
	 (#t #\x002C #t #\x3031 #t)
	 (#t #\x002C #f #\x0308 #t #\x3031 #t)
	 (#t #\x002C #t #\x0041 #t)
	 (#t #\x002C #f #\x0308 #t #\x0041 #t)
	 (#t #\x002C #t #\x003A #t)
	 (#t #\x002C #f #\x0308 #t #\x003A #t)
	 (#t #\x002C #t #\x002C #t)
	 (#t #\x002C #f #\x0308 #t #\x002C #t)
	 (#t #\x002C #t #\x002E #t)
	 (#t #\x002C #f #\x0308 #t #\x002E #t)
	 (#t #\x002C #t #\x0030 #t)
	 (#t #\x002C #f #\x0308 #t #\x0030 #t)
	 (#t #\x002C #t #\x005F #t)
	 (#t #\x002C #f #\x0308 #t #\x005F #t)
	 (#t #\x002C #t #\x1F1E6 #t)
	 (#t #\x002C #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x002C #t #\x05D0 #t)
	 (#t #\x002C #f #\x0308 #t #\x05D0 #t)
	 (#t #\x002C #t #\x0022 #t)
	 (#t #\x002C #f #\x0308 #t #\x0022 #t)
	 (#t #\x002C #t #\x0027 #t)
	 (#t #\x002C #f #\x0308 #t #\x0027 #t)
	 (#t #\x002C #t #\x261D #t)
	 (#t #\x002C #f #\x0308 #t #\x261D #t)
	 (#t #\x002C #t #\x1F3FB #t)
	 (#t #\x002C #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x002C #t #\x2764 #t)
	 (#t #\x002C #f #\x0308 #t #\x2764 #t)
	 (#t #\x002C #t #\x1F466 #t)
	 (#t #\x002C #f #\x0308 #t #\x1F466 #t)
	 (#t #\x002C #f #\x00AD #t)
	 (#t #\x002C #f #\x0308 #f #\x00AD #t)
	 (#t #\x002C #f #\x0300 #t)
	 (#t #\x002C #f #\x0308 #f #\x0300 #t)
	 (#t #\x002C #f #\x200D #t)
	 (#t #\x002C #f #\x0308 #f #\x200D #t)
	 (#t #\x002C #t #\x0061 #f #\x2060 #t)
	 (#t #\x002C #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x002C #t #\x0061 #t #\x003A #t)
	 (#t #\x002C #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x002C #t #\x0061 #t #\x0027 #t)
	 (#t #\x002C #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x002C #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x002C #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x002C #t #\x0061 #t #\x002C #t)
	 (#t #\x002C #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x002C #t #\x0031 #t #\x003A #t)
	 (#t #\x002C #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x002C #t #\x0031 #t #\x0027 #t)
	 (#t #\x002C #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x002C #t #\x0031 #t #\x002C #t)
	 (#t #\x002C #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x002C #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x002C #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x002E #t #\x0001 #t)
	 (#t #\x002E #f #\x0308 #t #\x0001 #t)
	 (#t #\x002E #t #\x000D #t)
	 (#t #\x002E #f #\x0308 #t #\x000D #t)
	 (#t #\x002E #t #\x000A #t)
	 (#t #\x002E #f #\x0308 #t #\x000A #t)
	 (#t #\x002E #t #\x000B #t)
	 (#t #\x002E #f #\x0308 #t #\x000B #t)
	 (#t #\x002E #t #\x3031 #t)
	 (#t #\x002E #f #\x0308 #t #\x3031 #t)
	 (#t #\x002E #t #\x0041 #t)
	 (#t #\x002E #f #\x0308 #t #\x0041 #t)
	 (#t #\x002E #t #\x003A #t)
	 (#t #\x002E #f #\x0308 #t #\x003A #t)
	 (#t #\x002E #t #\x002C #t)
	 (#t #\x002E #f #\x0308 #t #\x002C #t)
	 (#t #\x002E #t #\x002E #t)
	 (#t #\x002E #f #\x0308 #t #\x002E #t)
	 (#t #\x002E #t #\x0030 #t)
	 (#t #\x002E #f #\x0308 #t #\x0030 #t)
	 (#t #\x002E #t #\x005F #t)
	 (#t #\x002E #f #\x0308 #t #\x005F #t)
	 (#t #\x002E #t #\x1F1E6 #t)
	 (#t #\x002E #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x002E #t #\x05D0 #t)
	 (#t #\x002E #f #\x0308 #t #\x05D0 #t)
	 (#t #\x002E #t #\x0022 #t)
	 (#t #\x002E #f #\x0308 #t #\x0022 #t)
	 (#t #\x002E #t #\x0027 #t)
	 (#t #\x002E #f #\x0308 #t #\x0027 #t)
	 (#t #\x002E #t #\x261D #t)
	 (#t #\x002E #f #\x0308 #t #\x261D #t)
	 (#t #\x002E #t #\x1F3FB #t)
	 (#t #\x002E #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x002E #t #\x2764 #t)
	 (#t #\x002E #f #\x0308 #t #\x2764 #t)
	 (#t #\x002E #t #\x1F466 #t)
	 (#t #\x002E #f #\x0308 #t #\x1F466 #t)
	 (#t #\x002E #f #\x00AD #t)
	 (#t #\x002E #f #\x0308 #f #\x00AD #t)
	 (#t #\x002E #f #\x0300 #t)
	 (#t #\x002E #f #\x0308 #f #\x0300 #t)
	 (#t #\x002E #f #\x200D #t)
	 (#t #\x002E #f #\x0308 #f #\x200D #t)
	 (#t #\x002E #t #\x0061 #f #\x2060 #t)
	 (#t #\x002E #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x002E #t #\x0061 #t #\x003A #t)
	 (#t #\x002E #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x002E #t #\x0061 #t #\x0027 #t)
	 (#t #\x002E #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x002E #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x002E #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x002E #t #\x0061 #t #\x002C #t)
	 (#t #\x002E #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x002E #t #\x0031 #t #\x003A #t)
	 (#t #\x002E #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x002E #t #\x0031 #t #\x0027 #t)
	 (#t #\x002E #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x002E #t #\x0031 #t #\x002C #t)
	 (#t #\x002E #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x002E #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x002E #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0030 #t #\x0001 #t)
	 (#t #\x0030 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0030 #t #\x000D #t)
	 (#t #\x0030 #f #\x0308 #t #\x000D #t)
	 (#t #\x0030 #t #\x000A #t)
	 (#t #\x0030 #f #\x0308 #t #\x000A #t)
	 (#t #\x0030 #t #\x000B #t)
	 (#t #\x0030 #f #\x0308 #t #\x000B #t)
	 (#t #\x0030 #t #\x3031 #t)
	 (#t #\x0030 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0030 #f #\x0041 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0041 #t)
	 (#t #\x0030 #t #\x003A #t)
	 (#t #\x0030 #f #\x0308 #t #\x003A #t)
	 (#t #\x0030 #t #\x002C #t)
	 (#t #\x0030 #f #\x0308 #t #\x002C #t)
	 (#t #\x0030 #t #\x002E #t)
	 (#t #\x0030 #f #\x0308 #t #\x002E #t)
	 (#t #\x0030 #f #\x0030 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0030 #t)
	 (#t #\x0030 #f #\x005F #t)
	 (#t #\x0030 #f #\x0308 #f #\x005F #t)
	 (#t #\x0030 #t #\x1F1E6 #t)
	 (#t #\x0030 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0030 #f #\x05D0 #t)
	 (#t #\x0030 #f #\x0308 #f #\x05D0 #t)
	 (#t #\x0030 #t #\x0022 #t)
	 (#t #\x0030 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0030 #t #\x0027 #t)
	 (#t #\x0030 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0030 #t #\x261D #t)
	 (#t #\x0030 #f #\x0308 #t #\x261D #t)
	 (#t #\x0030 #t #\x1F3FB #t)
	 (#t #\x0030 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0030 #t #\x2764 #t)
	 (#t #\x0030 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0030 #t #\x1F466 #t)
	 (#t #\x0030 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0030 #f #\x00AD #t)
	 (#t #\x0030 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0030 #f #\x0300 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0030 #f #\x200D #t)
	 (#t #\x0030 #f #\x0308 #f #\x200D #t)
	 (#t #\x0030 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0030 #f #\x0061 #t #\x003A #t)
	 (#t #\x0030 #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x0030 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0030 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0030 #f #\x0061 #t #\x002C #t)
	 (#t #\x0030 #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x0030 #f #\x0031 #t #\x003A #t)
	 (#t #\x0030 #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x0030 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0030 #f #\x0031 #t #\x002C #t)
	 (#t #\x0030 #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x0030 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0030 #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x005F #t #\x0001 #t)
	 (#t #\x005F #f #\x0308 #t #\x0001 #t)
	 (#t #\x005F #t #\x000D #t)
	 (#t #\x005F #f #\x0308 #t #\x000D #t)
	 (#t #\x005F #t #\x000A #t)
	 (#t #\x005F #f #\x0308 #t #\x000A #t)
	 (#t #\x005F #t #\x000B #t)
	 (#t #\x005F #f #\x0308 #t #\x000B #t)
	 (#t #\x005F #f #\x3031 #t)
	 (#t #\x005F #f #\x0308 #f #\x3031 #t)
	 (#t #\x005F #f #\x0041 #t)
	 (#t #\x005F #f #\x0308 #f #\x0041 #t)
	 (#t #\x005F #t #\x003A #t)
	 (#t #\x005F #f #\x0308 #t #\x003A #t)
	 (#t #\x005F #t #\x002C #t)
	 (#t #\x005F #f #\x0308 #t #\x002C #t)
	 (#t #\x005F #t #\x002E #t)
	 (#t #\x005F #f #\x0308 #t #\x002E #t)
	 (#t #\x005F #f #\x0030 #t)
	 (#t #\x005F #f #\x0308 #f #\x0030 #t)
	 (#t #\x005F #f #\x005F #t)
	 (#t #\x005F #f #\x0308 #f #\x005F #t)
	 (#t #\x005F #t #\x1F1E6 #t)
	 (#t #\x005F #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x005F #f #\x05D0 #t)
	 (#t #\x005F #f #\x0308 #f #\x05D0 #t)
	 (#t #\x005F #t #\x0022 #t)
	 (#t #\x005F #f #\x0308 #t #\x0022 #t)
	 (#t #\x005F #t #\x0027 #t)
	 (#t #\x005F #f #\x0308 #t #\x0027 #t)
	 (#t #\x005F #t #\x261D #t)
	 (#t #\x005F #f #\x0308 #t #\x261D #t)
	 (#t #\x005F #t #\x1F3FB #t)
	 (#t #\x005F #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x005F #t #\x2764 #t)
	 (#t #\x005F #f #\x0308 #t #\x2764 #t)
	 (#t #\x005F #t #\x1F466 #t)
	 (#t #\x005F #f #\x0308 #t #\x1F466 #t)
	 (#t #\x005F #f #\x00AD #t)
	 (#t #\x005F #f #\x0308 #f #\x00AD #t)
	 (#t #\x005F #f #\x0300 #t)
	 (#t #\x005F #f #\x0308 #f #\x0300 #t)
	 (#t #\x005F #f #\x200D #t)
	 (#t #\x005F #f #\x0308 #f #\x200D #t)
	 (#t #\x005F #f #\x0061 #f #\x2060 #t)
	 (#t #\x005F #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x005F #f #\x0061 #t #\x003A #t)
	 (#t #\x005F #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x005F #f #\x0061 #t #\x0027 #t)
	 (#t #\x005F #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x005F #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x005F #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x005F #f #\x0061 #t #\x002C #t)
	 (#t #\x005F #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x005F #f #\x0031 #t #\x003A #t)
	 (#t #\x005F #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x005F #f #\x0031 #t #\x0027 #t)
	 (#t #\x005F #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x005F #f #\x0031 #t #\x002C #t)
	 (#t #\x005F #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x005F #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x005F #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x1F1E6 #t #\x0001 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0001 #t)
	 (#t #\x1F1E6 #t #\x000D #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x000D #t)
	 (#t #\x1F1E6 #t #\x000A #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x000A #t)
	 (#t #\x1F1E6 #t #\x000B #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x000B #t)
	 (#t #\x1F1E6 #t #\x3031 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x3031 #t)
	 (#t #\x1F1E6 #t #\x0041 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0041 #t)
	 (#t #\x1F1E6 #t #\x003A #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x003A #t)
	 (#t #\x1F1E6 #t #\x002C #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x002C #t)
	 (#t #\x1F1E6 #t #\x002E #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x002E #t)
	 (#t #\x1F1E6 #t #\x0030 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0030 #t)
	 (#t #\x1F1E6 #t #\x005F #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x005F #t)
	 (#t #\x1F1E6 #f #\x1F1E6 #t)
	 (#t #\x1F1E6 #f #\x0308 #f #\x1F1E6 #t)
	 (#t #\x1F1E6 #t #\x05D0 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x1F1E6 #t #\x0022 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0022 #t)
	 (#t #\x1F1E6 #t #\x0027 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0027 #t)
	 (#t #\x1F1E6 #t #\x261D #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x261D #t)
	 (#t #\x1F1E6 #t #\x1F3FB #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x1F1E6 #t #\x2764 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x2764 #t)
	 (#t #\x1F1E6 #t #\x1F466 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x1F1E6 #f #\x00AD #t)
	 (#t #\x1F1E6 #f #\x0308 #f #\x00AD #t)
	 (#t #\x1F1E6 #f #\x0300 #t)
	 (#t #\x1F1E6 #f #\x0308 #f #\x0300 #t)
	 (#t #\x1F1E6 #f #\x200D #t)
	 (#t #\x1F1E6 #f #\x0308 #f #\x200D #t)
	 (#t #\x1F1E6 #t #\x0061 #f #\x2060 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x1F1E6 #t #\x0061 #t #\x003A #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x1F1E6 #t #\x0061 #t #\x0027 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x1F1E6 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x1F1E6 #t #\x0061 #t #\x002C #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x1F1E6 #t #\x0031 #t #\x003A #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x1F1E6 #t #\x0031 #t #\x0027 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x1F1E6 #t #\x0031 #t #\x002C #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x1F1E6 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x1F1E6 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x05D0 #t #\x0001 #t)
	 (#t #\x05D0 #f #\x0308 #t #\x0001 #t)
	 (#t #\x05D0 #t #\x000D #t)
	 (#t #\x05D0 #f #\x0308 #t #\x000D #t)
	 (#t #\x05D0 #t #\x000A #t)
	 (#t #\x05D0 #f #\x0308 #t #\x000A #t)
	 (#t #\x05D0 #t #\x000B #t)
	 (#t #\x05D0 #f #\x0308 #t #\x000B #t)
	 (#t #\x05D0 #t #\x3031 #t)
	 (#t #\x05D0 #f #\x0308 #t #\x3031 #t)
	 (#t #\x05D0 #f #\x0041 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0041 #t)
	 (#t #\x05D0 #t #\x003A #t)
	 (#t #\x05D0 #f #\x0308 #t #\x003A #t)
	 (#t #\x05D0 #t #\x002C #t)
	 (#t #\x05D0 #f #\x0308 #t #\x002C #t)
	 (#t #\x05D0 #t #\x002E #t)
	 (#t #\x05D0 #f #\x0308 #t #\x002E #t)
	 (#t #\x05D0 #f #\x0030 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0030 #t)
	 (#t #\x05D0 #f #\x005F #t)
	 (#t #\x05D0 #f #\x0308 #f #\x005F #t)
	 (#t #\x05D0 #t #\x1F1E6 #t)
	 (#t #\x05D0 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x05D0 #f #\x05D0 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x05D0 #t)
	 (#t #\x05D0 #t #\x0022 #t)
	 (#t #\x05D0 #f #\x0308 #t #\x0022 #t)
	 (#t #\x05D0 #f #\x0027 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0027 #t)
	 (#t #\x05D0 #t #\x261D #t)
	 (#t #\x05D0 #f #\x0308 #t #\x261D #t)
	 (#t #\x05D0 #t #\x1F3FB #t)
	 (#t #\x05D0 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x05D0 #t #\x2764 #t)
	 (#t #\x05D0 #f #\x0308 #t #\x2764 #t)
	 (#t #\x05D0 #t #\x1F466 #t)
	 (#t #\x05D0 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x05D0 #f #\x00AD #t)
	 (#t #\x05D0 #f #\x0308 #f #\x00AD #t)
	 (#t #\x05D0 #f #\x0300 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0300 #t)
	 (#t #\x05D0 #f #\x200D #t)
	 (#t #\x05D0 #f #\x0308 #f #\x200D #t)
	 (#t #\x05D0 #f #\x0061 #f #\x2060 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x05D0 #f #\x0061 #t #\x003A #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x05D0 #f #\x0061 #t #\x0027 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x05D0 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x05D0 #f #\x0061 #t #\x002C #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x05D0 #f #\x0031 #t #\x003A #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x05D0 #f #\x0031 #t #\x0027 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x05D0 #f #\x0031 #t #\x002C #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x05D0 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x05D0 #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0022 #t #\x0001 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0022 #t #\x000D #t)
	 (#t #\x0022 #f #\x0308 #t #\x000D #t)
	 (#t #\x0022 #t #\x000A #t)
	 (#t #\x0022 #f #\x0308 #t #\x000A #t)
	 (#t #\x0022 #t #\x000B #t)
	 (#t #\x0022 #f #\x0308 #t #\x000B #t)
	 (#t #\x0022 #t #\x3031 #t)
	 (#t #\x0022 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0022 #t #\x0041 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0041 #t)
	 (#t #\x0022 #t #\x003A #t)
	 (#t #\x0022 #f #\x0308 #t #\x003A #t)
	 (#t #\x0022 #t #\x002C #t)
	 (#t #\x0022 #f #\x0308 #t #\x002C #t)
	 (#t #\x0022 #t #\x002E #t)
	 (#t #\x0022 #f #\x0308 #t #\x002E #t)
	 (#t #\x0022 #t #\x0030 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0030 #t)
	 (#t #\x0022 #t #\x005F #t)
	 (#t #\x0022 #f #\x0308 #t #\x005F #t)
	 (#t #\x0022 #t #\x1F1E6 #t)
	 (#t #\x0022 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0022 #t #\x05D0 #t)
	 (#t #\x0022 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0022 #t #\x0022 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0022 #t #\x0027 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0022 #t #\x261D #t)
	 (#t #\x0022 #f #\x0308 #t #\x261D #t)
	 (#t #\x0022 #t #\x1F3FB #t)
	 (#t #\x0022 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0022 #t #\x2764 #t)
	 (#t #\x0022 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0022 #t #\x1F466 #t)
	 (#t #\x0022 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0022 #f #\x00AD #t)
	 (#t #\x0022 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0022 #f #\x0300 #t)
	 (#t #\x0022 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0022 #f #\x200D #t)
	 (#t #\x0022 #f #\x0308 #f #\x200D #t)
	 (#t #\x0022 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0022 #t #\x0061 #t #\x003A #t)
	 (#t #\x0022 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0022 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0022 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0022 #t #\x0061 #t #\x002C #t)
	 (#t #\x0022 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0022 #t #\x0031 #t #\x003A #t)
	 (#t #\x0022 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0022 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0022 #t #\x0031 #t #\x002C #t)
	 (#t #\x0022 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0022 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0022 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0027 #t #\x0001 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0027 #t #\x000D #t)
	 (#t #\x0027 #f #\x0308 #t #\x000D #t)
	 (#t #\x0027 #t #\x000A #t)
	 (#t #\x0027 #f #\x0308 #t #\x000A #t)
	 (#t #\x0027 #t #\x000B #t)
	 (#t #\x0027 #f #\x0308 #t #\x000B #t)
	 (#t #\x0027 #t #\x3031 #t)
	 (#t #\x0027 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0027 #t #\x0041 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0041 #t)
	 (#t #\x0027 #t #\x003A #t)
	 (#t #\x0027 #f #\x0308 #t #\x003A #t)
	 (#t #\x0027 #t #\x002C #t)
	 (#t #\x0027 #f #\x0308 #t #\x002C #t)
	 (#t #\x0027 #t #\x002E #t)
	 (#t #\x0027 #f #\x0308 #t #\x002E #t)
	 (#t #\x0027 #t #\x0030 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0030 #t)
	 (#t #\x0027 #t #\x005F #t)
	 (#t #\x0027 #f #\x0308 #t #\x005F #t)
	 (#t #\x0027 #t #\x1F1E6 #t)
	 (#t #\x0027 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0027 #t #\x05D0 #t)
	 (#t #\x0027 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0027 #t #\x0022 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0027 #t #\x0027 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0027 #t #\x261D #t)
	 (#t #\x0027 #f #\x0308 #t #\x261D #t)
	 (#t #\x0027 #t #\x1F3FB #t)
	 (#t #\x0027 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0027 #t #\x2764 #t)
	 (#t #\x0027 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0027 #t #\x1F466 #t)
	 (#t #\x0027 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0027 #f #\x00AD #t)
	 (#t #\x0027 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0027 #f #\x0300 #t)
	 (#t #\x0027 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0027 #f #\x200D #t)
	 (#t #\x0027 #f #\x0308 #f #\x200D #t)
	 (#t #\x0027 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0027 #t #\x0061 #t #\x003A #t)
	 (#t #\x0027 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0027 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0027 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0027 #t #\x0061 #t #\x002C #t)
	 (#t #\x0027 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0027 #t #\x0031 #t #\x003A #t)
	 (#t #\x0027 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0027 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0027 #t #\x0031 #t #\x002C #t)
	 (#t #\x0027 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0027 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0027 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x261D #t #\x0001 #t)
	 (#t #\x261D #f #\x0308 #t #\x0001 #t)
	 (#t #\x261D #t #\x000D #t)
	 (#t #\x261D #f #\x0308 #t #\x000D #t)
	 (#t #\x261D #t #\x000A #t)
	 (#t #\x261D #f #\x0308 #t #\x000A #t)
	 (#t #\x261D #t #\x000B #t)
	 (#t #\x261D #f #\x0308 #t #\x000B #t)
	 (#t #\x261D #t #\x3031 #t)
	 (#t #\x261D #f #\x0308 #t #\x3031 #t)
	 (#t #\x261D #t #\x0041 #t)
	 (#t #\x261D #f #\x0308 #t #\x0041 #t)
	 (#t #\x261D #t #\x003A #t)
	 (#t #\x261D #f #\x0308 #t #\x003A #t)
	 (#t #\x261D #t #\x002C #t)
	 (#t #\x261D #f #\x0308 #t #\x002C #t)
	 (#t #\x261D #t #\x002E #t)
	 (#t #\x261D #f #\x0308 #t #\x002E #t)
	 (#t #\x261D #t #\x0030 #t)
	 (#t #\x261D #f #\x0308 #t #\x0030 #t)
	 (#t #\x261D #t #\x005F #t)
	 (#t #\x261D #f #\x0308 #t #\x005F #t)
	 (#t #\x261D #t #\x1F1E6 #t)
	 (#t #\x261D #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x261D #t #\x05D0 #t)
	 (#t #\x261D #f #\x0308 #t #\x05D0 #t)
	 (#t #\x261D #t #\x0022 #t)
	 (#t #\x261D #f #\x0308 #t #\x0022 #t)
	 (#t #\x261D #t #\x0027 #t)
	 (#t #\x261D #f #\x0308 #t #\x0027 #t)
	 (#t #\x261D #t #\x261D #t)
	 (#t #\x261D #f #\x0308 #t #\x261D #t)
	 (#t #\x261D #f #\x1F3FB #t)
	 (#t #\x261D #f #\x0308 #f #\x1F3FB #t)
	 (#t #\x261D #t #\x2764 #t)
	 (#t #\x261D #f #\x0308 #t #\x2764 #t)
	 (#t #\x261D #t #\x1F466 #t)
	 (#t #\x261D #f #\x0308 #t #\x1F466 #t)
	 (#t #\x261D #f #\x00AD #t)
	 (#t #\x261D #f #\x0308 #f #\x00AD #t)
	 (#t #\x261D #f #\x0300 #t)
	 (#t #\x261D #f #\x0308 #f #\x0300 #t)
	 (#t #\x261D #f #\x200D #t)
	 (#t #\x261D #f #\x0308 #f #\x200D #t)
	 (#t #\x261D #t #\x0061 #f #\x2060 #t)
	 (#t #\x261D #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x261D #t #\x0061 #t #\x003A #t)
	 (#t #\x261D #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x261D #t #\x0061 #t #\x0027 #t)
	 (#t #\x261D #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x261D #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x261D #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x261D #t #\x0061 #t #\x002C #t)
	 (#t #\x261D #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x261D #t #\x0031 #t #\x003A #t)
	 (#t #\x261D #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x261D #t #\x0031 #t #\x0027 #t)
	 (#t #\x261D #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x261D #t #\x0031 #t #\x002C #t)
	 (#t #\x261D #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x261D #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x261D #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x1F3FB #t #\x0001 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0001 #t)
	 (#t #\x1F3FB #t #\x000D #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x000D #t)
	 (#t #\x1F3FB #t #\x000A #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x000A #t)
	 (#t #\x1F3FB #t #\x000B #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x000B #t)
	 (#t #\x1F3FB #t #\x3031 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x3031 #t)
	 (#t #\x1F3FB #t #\x0041 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0041 #t)
	 (#t #\x1F3FB #t #\x003A #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x003A #t)
	 (#t #\x1F3FB #t #\x002C #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x002C #t)
	 (#t #\x1F3FB #t #\x002E #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x002E #t)
	 (#t #\x1F3FB #t #\x0030 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0030 #t)
	 (#t #\x1F3FB #t #\x005F #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x005F #t)
	 (#t #\x1F3FB #t #\x1F1E6 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x1F3FB #t #\x05D0 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x05D0 #t)
	 (#t #\x1F3FB #t #\x0022 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0022 #t)
	 (#t #\x1F3FB #t #\x0027 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0027 #t)
	 (#t #\x1F3FB #t #\x261D #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x261D #t)
	 (#t #\x1F3FB #t #\x1F3FB #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x1F3FB #t #\x2764 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x2764 #t)
	 (#t #\x1F3FB #t #\x1F466 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x1F466 #t)
	 (#t #\x1F3FB #f #\x00AD #t)
	 (#t #\x1F3FB #f #\x0308 #f #\x00AD #t)
	 (#t #\x1F3FB #f #\x0300 #t)
	 (#t #\x1F3FB #f #\x0308 #f #\x0300 #t)
	 (#t #\x1F3FB #f #\x200D #t)
	 (#t #\x1F3FB #f #\x0308 #f #\x200D #t)
	 (#t #\x1F3FB #t #\x0061 #f #\x2060 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x1F3FB #t #\x0061 #t #\x003A #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x1F3FB #t #\x0061 #t #\x0027 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x1F3FB #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x1F3FB #t #\x0061 #t #\x002C #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x1F3FB #t #\x0031 #t #\x003A #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x1F3FB #t #\x0031 #t #\x0027 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x1F3FB #t #\x0031 #t #\x002C #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x1F3FB #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x1F3FB #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x2764 #t #\x0001 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0001 #t)
	 (#t #\x2764 #t #\x000D #t)
	 (#t #\x2764 #f #\x0308 #t #\x000D #t)
	 (#t #\x2764 #t #\x000A #t)
	 (#t #\x2764 #f #\x0308 #t #\x000A #t)
	 (#t #\x2764 #t #\x000B #t)
	 (#t #\x2764 #f #\x0308 #t #\x000B #t)
	 (#t #\x2764 #t #\x3031 #t)
	 (#t #\x2764 #f #\x0308 #t #\x3031 #t)
	 (#t #\x2764 #t #\x0041 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0041 #t)
	 (#t #\x2764 #t #\x003A #t)
	 (#t #\x2764 #f #\x0308 #t #\x003A #t)
	 (#t #\x2764 #t #\x002C #t)
	 (#t #\x2764 #f #\x0308 #t #\x002C #t)
	 (#t #\x2764 #t #\x002E #t)
	 (#t #\x2764 #f #\x0308 #t #\x002E #t)
	 (#t #\x2764 #t #\x0030 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0030 #t)
	 (#t #\x2764 #t #\x005F #t)
	 (#t #\x2764 #f #\x0308 #t #\x005F #t)
	 (#t #\x2764 #t #\x1F1E6 #t)
	 (#t #\x2764 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x2764 #t #\x05D0 #t)
	 (#t #\x2764 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x2764 #t #\x0022 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0022 #t)
	 (#t #\x2764 #t #\x0027 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0027 #t)
	 (#t #\x2764 #t #\x261D #t)
	 (#t #\x2764 #f #\x0308 #t #\x261D #t)
	 (#t #\x2764 #t #\x1F3FB #t)
	 (#t #\x2764 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x2764 #t #\x2764 #t)
	 (#t #\x2764 #f #\x0308 #t #\x2764 #t)
	 (#t #\x2764 #t #\x1F466 #t)
	 (#t #\x2764 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x2764 #f #\x00AD #t)
	 (#t #\x2764 #f #\x0308 #f #\x00AD #t)
	 (#t #\x2764 #f #\x0300 #t)
	 (#t #\x2764 #f #\x0308 #f #\x0300 #t)
	 (#t #\x2764 #f #\x200D #t)
	 (#t #\x2764 #f #\x0308 #f #\x200D #t)
	 (#t #\x2764 #t #\x0061 #f #\x2060 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x2764 #t #\x0061 #t #\x003A #t)
	 (#t #\x2764 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x2764 #t #\x0061 #t #\x0027 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x2764 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x2764 #t #\x0061 #t #\x002C #t)
	 (#t #\x2764 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x2764 #t #\x0031 #t #\x003A #t)
	 (#t #\x2764 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x2764 #t #\x0031 #t #\x0027 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x2764 #t #\x0031 #t #\x002C #t)
	 (#t #\x2764 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x2764 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x2764 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x1F466 #t #\x0001 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0001 #t)
	 (#t #\x1F466 #t #\x000D #t)
	 (#t #\x1F466 #f #\x0308 #t #\x000D #t)
	 (#t #\x1F466 #t #\x000A #t)
	 (#t #\x1F466 #f #\x0308 #t #\x000A #t)
	 (#t #\x1F466 #t #\x000B #t)
	 (#t #\x1F466 #f #\x0308 #t #\x000B #t)
	 (#t #\x1F466 #t #\x3031 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x3031 #t)
	 (#t #\x1F466 #t #\x0041 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0041 #t)
	 (#t #\x1F466 #t #\x003A #t)
	 (#t #\x1F466 #f #\x0308 #t #\x003A #t)
	 (#t #\x1F466 #t #\x002C #t)
	 (#t #\x1F466 #f #\x0308 #t #\x002C #t)
	 (#t #\x1F466 #t #\x002E #t)
	 (#t #\x1F466 #f #\x0308 #t #\x002E #t)
	 (#t #\x1F466 #t #\x0030 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0030 #t)
	 (#t #\x1F466 #t #\x005F #t)
	 (#t #\x1F466 #f #\x0308 #t #\x005F #t)
	 (#t #\x1F466 #t #\x1F1E6 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x1F466 #t #\x05D0 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x1F466 #t #\x0022 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0022 #t)
	 (#t #\x1F466 #t #\x0027 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0027 #t)
	 (#t #\x1F466 #t #\x261D #t)
	 (#t #\x1F466 #f #\x0308 #t #\x261D #t)
	 (#t #\x1F466 #f #\x1F3FB #t)
	 (#t #\x1F466 #f #\x0308 #f #\x1F3FB #t)
	 (#t #\x1F466 #t #\x2764 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x2764 #t)
	 (#t #\x1F466 #t #\x1F466 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x1F466 #f #\x00AD #t)
	 (#t #\x1F466 #f #\x0308 #f #\x00AD #t)
	 (#t #\x1F466 #f #\x0300 #t)
	 (#t #\x1F466 #f #\x0308 #f #\x0300 #t)
	 (#t #\x1F466 #f #\x200D #t)
	 (#t #\x1F466 #f #\x0308 #f #\x200D #t)
	 (#t #\x1F466 #t #\x0061 #f #\x2060 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x1F466 #t #\x0061 #t #\x003A #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x1F466 #t #\x0061 #t #\x0027 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x1F466 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x1F466 #t #\x0061 #t #\x002C #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x1F466 #t #\x0031 #t #\x003A #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x1F466 #t #\x0031 #t #\x0027 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x1F466 #t #\x0031 #t #\x002C #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x1F466 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x1F466 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x00AD #t #\x0001 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0001 #t)
	 (#t #\x00AD #t #\x000D #t)
	 (#t #\x00AD #f #\x0308 #t #\x000D #t)
	 (#t #\x00AD #t #\x000A #t)
	 (#t #\x00AD #f #\x0308 #t #\x000A #t)
	 (#t #\x00AD #t #\x000B #t)
	 (#t #\x00AD #f #\x0308 #t #\x000B #t)
	 (#t #\x00AD #t #\x3031 #t)
	 (#t #\x00AD #f #\x0308 #t #\x3031 #t)
	 (#t #\x00AD #t #\x0041 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0041 #t)
	 (#t #\x00AD #t #\x003A #t)
	 (#t #\x00AD #f #\x0308 #t #\x003A #t)
	 (#t #\x00AD #t #\x002C #t)
	 (#t #\x00AD #f #\x0308 #t #\x002C #t)
	 (#t #\x00AD #t #\x002E #t)
	 (#t #\x00AD #f #\x0308 #t #\x002E #t)
	 (#t #\x00AD #t #\x0030 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0030 #t)
	 (#t #\x00AD #t #\x005F #t)
	 (#t #\x00AD #f #\x0308 #t #\x005F #t)
	 (#t #\x00AD #t #\x1F1E6 #t)
	 (#t #\x00AD #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x00AD #t #\x05D0 #t)
	 (#t #\x00AD #f #\x0308 #t #\x05D0 #t)
	 (#t #\x00AD #t #\x0022 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0022 #t)
	 (#t #\x00AD #t #\x0027 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0027 #t)
	 (#t #\x00AD #t #\x261D #t)
	 (#t #\x00AD #f #\x0308 #t #\x261D #t)
	 (#t #\x00AD #t #\x1F3FB #t)
	 (#t #\x00AD #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x00AD #t #\x2764 #t)
	 (#t #\x00AD #f #\x0308 #t #\x2764 #t)
	 (#t #\x00AD #t #\x1F466 #t)
	 (#t #\x00AD #f #\x0308 #t #\x1F466 #t)
	 (#t #\x00AD #f #\x00AD #t)
	 (#t #\x00AD #f #\x0308 #f #\x00AD #t)
	 (#t #\x00AD #f #\x0300 #t)
	 (#t #\x00AD #f #\x0308 #f #\x0300 #t)
	 (#t #\x00AD #f #\x200D #t)
	 (#t #\x00AD #f #\x0308 #f #\x200D #t)
	 (#t #\x00AD #t #\x0061 #f #\x2060 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x00AD #t #\x0061 #t #\x003A #t)
	 (#t #\x00AD #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x00AD #t #\x0061 #t #\x0027 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x00AD #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x00AD #t #\x0061 #t #\x002C #t)
	 (#t #\x00AD #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x00AD #t #\x0031 #t #\x003A #t)
	 (#t #\x00AD #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x00AD #t #\x0031 #t #\x0027 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x00AD #t #\x0031 #t #\x002C #t)
	 (#t #\x00AD #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x00AD #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x00AD #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0300 #t #\x0001 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0300 #t #\x000D #t)
	 (#t #\x0300 #f #\x0308 #t #\x000D #t)
	 (#t #\x0300 #t #\x000A #t)
	 (#t #\x0300 #f #\x0308 #t #\x000A #t)
	 (#t #\x0300 #t #\x000B #t)
	 (#t #\x0300 #f #\x0308 #t #\x000B #t)
	 (#t #\x0300 #t #\x3031 #t)
	 (#t #\x0300 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0300 #t #\x0041 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0041 #t)
	 (#t #\x0300 #t #\x003A #t)
	 (#t #\x0300 #f #\x0308 #t #\x003A #t)
	 (#t #\x0300 #t #\x002C #t)
	 (#t #\x0300 #f #\x0308 #t #\x002C #t)
	 (#t #\x0300 #t #\x002E #t)
	 (#t #\x0300 #f #\x0308 #t #\x002E #t)
	 (#t #\x0300 #t #\x0030 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0030 #t)
	 (#t #\x0300 #t #\x005F #t)
	 (#t #\x0300 #f #\x0308 #t #\x005F #t)
	 (#t #\x0300 #t #\x1F1E6 #t)
	 (#t #\x0300 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0300 #t #\x05D0 #t)
	 (#t #\x0300 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0300 #t #\x0022 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0300 #t #\x0027 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0300 #t #\x261D #t)
	 (#t #\x0300 #f #\x0308 #t #\x261D #t)
	 (#t #\x0300 #t #\x1F3FB #t)
	 (#t #\x0300 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0300 #t #\x2764 #t)
	 (#t #\x0300 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0300 #t #\x1F466 #t)
	 (#t #\x0300 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0300 #f #\x00AD #t)
	 (#t #\x0300 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0300 #f #\x0300 #t)
	 (#t #\x0300 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0300 #f #\x200D #t)
	 (#t #\x0300 #f #\x0308 #f #\x200D #t)
	 (#t #\x0300 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0300 #t #\x0061 #t #\x003A #t)
	 (#t #\x0300 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0300 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0300 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0300 #t #\x0061 #t #\x002C #t)
	 (#t #\x0300 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0300 #t #\x0031 #t #\x003A #t)
	 (#t #\x0300 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0300 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0300 #t #\x0031 #t #\x002C #t)
	 (#t #\x0300 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0300 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0300 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x200D #t #\x0001 #t)
	 (#t #\x200D #f #\x0308 #t #\x0001 #t)
	 (#t #\x200D #t #\x000D #t)
	 (#t #\x200D #f #\x0308 #t #\x000D #t)
	 (#t #\x200D #t #\x000A #t)
	 (#t #\x200D #f #\x0308 #t #\x000A #t)
	 (#t #\x200D #t #\x000B #t)
	 (#t #\x200D #f #\x0308 #t #\x000B #t)
	 (#t #\x200D #t #\x3031 #t)
	 (#t #\x200D #f #\x0308 #t #\x3031 #t)
	 (#t #\x200D #t #\x0041 #t)
	 (#t #\x200D #f #\x0308 #t #\x0041 #t)
	 (#t #\x200D #t #\x003A #t)
	 (#t #\x200D #f #\x0308 #t #\x003A #t)
	 (#t #\x200D #t #\x002C #t)
	 (#t #\x200D #f #\x0308 #t #\x002C #t)
	 (#t #\x200D #t #\x002E #t)
	 (#t #\x200D #f #\x0308 #t #\x002E #t)
	 (#t #\x200D #t #\x0030 #t)
	 (#t #\x200D #f #\x0308 #t #\x0030 #t)
	 (#t #\x200D #t #\x005F #t)
	 (#t #\x200D #f #\x0308 #t #\x005F #t)
	 (#t #\x200D #t #\x1F1E6 #t)
	 (#t #\x200D #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x200D #t #\x05D0 #t)
	 (#t #\x200D #f #\x0308 #t #\x05D0 #t)
	 (#t #\x200D #t #\x0022 #t)
	 (#t #\x200D #f #\x0308 #t #\x0022 #t)
	 (#t #\x200D #t #\x0027 #t)
	 (#t #\x200D #f #\x0308 #t #\x0027 #t)
	 (#t #\x200D #t #\x261D #t)
	 (#t #\x200D #f #\x0308 #t #\x261D #t)
	 (#t #\x200D #t #\x1F3FB #t)
	 (#t #\x200D #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x200D #f #\x2764 #t)
	 (#t #\x200D #f #\x0308 #t #\x2764 #t)
	 (#t #\x200D #f #\x1F466 #t)
	 (#t #\x200D #f #\x0308 #t #\x1F466 #t)
	 (#t #\x200D #f #\x00AD #t)
	 (#t #\x200D #f #\x0308 #f #\x00AD #t)
	 (#t #\x200D #f #\x0300 #t)
	 (#t #\x200D #f #\x0308 #f #\x0300 #t)
	 (#t #\x200D #f #\x200D #t)
	 (#t #\x200D #f #\x0308 #f #\x200D #t)
	 (#t #\x200D #t #\x0061 #f #\x2060 #t)
	 (#t #\x200D #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x200D #t #\x0061 #t #\x003A #t)
	 (#t #\x200D #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x200D #t #\x0061 #t #\x0027 #t)
	 (#t #\x200D #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x200D #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x200D #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x200D #t #\x0061 #t #\x002C #t)
	 (#t #\x200D #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x200D #t #\x0031 #t #\x003A #t)
	 (#t #\x200D #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x200D #t #\x0031 #t #\x0027 #t)
	 (#t #\x200D #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x200D #t #\x0031 #t #\x002C #t)
	 (#t #\x200D #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x200D #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x200D #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #f #\x2060 #t #\x0001 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0061 #f #\x2060 #t #\x000D #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x000D #t)
	 (#t #\x0061 #f #\x2060 #t #\x000A #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x000A #t)
	 (#t #\x0061 #f #\x2060 #t #\x000B #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x000B #t)
	 (#t #\x0061 #f #\x2060 #t #\x3031 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0041 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0041 #t)
	 (#t #\x0061 #f #\x2060 #t #\x003A #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x003A #t)
	 (#t #\x0061 #f #\x2060 #t #\x002C #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x002C #t)
	 (#t #\x0061 #f #\x2060 #t #\x002E #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x002E #t)
	 (#t #\x0061 #f #\x2060 #f #\x0030 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0030 #t)
	 (#t #\x0061 #f #\x2060 #f #\x005F #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x005F #t)
	 (#t #\x0061 #f #\x2060 #t #\x1F1E6 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0061 #f #\x2060 #f #\x05D0 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x05D0 #t)
	 (#t #\x0061 #f #\x2060 #t #\x0022 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0061 #f #\x2060 #t #\x0027 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0061 #f #\x2060 #t #\x261D #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x261D #t)
	 (#t #\x0061 #f #\x2060 #t #\x1F3FB #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0061 #f #\x2060 #t #\x2764 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0061 #f #\x2060 #t #\x1F466 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0061 #f #\x2060 #f #\x00AD #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0061 #f #\x2060 #f #\x0300 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0061 #f #\x2060 #f #\x200D #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x200D #t)
	 (#t #\x0061 #f #\x2060 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x2060 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #f #\x2060 #f #\x0031 #t #\x003A #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x0061 #f #\x2060 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0031 #t #\x002C #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x0061 #f #\x2060 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #f #\x2060 #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x003A #t #\x0001 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0001 #t)
	 (#t #\x0061 #t #\x003A #t #\x000D #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x000D #t)
	 (#t #\x0061 #t #\x003A #t #\x000A #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x000A #t)
	 (#t #\x0061 #t #\x003A #t #\x000B #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x000B #t)
	 (#t #\x0061 #t #\x003A #t #\x3031 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x3031 #t)
	 (#t #\x0061 #f #\x003A #f #\x0041 #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x0041 #t)
	 (#t #\x0061 #t #\x003A #t #\x003A #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x003A #t)
	 (#t #\x0061 #t #\x003A #t #\x002C #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x002C #t)
	 (#t #\x0061 #t #\x003A #t #\x002E #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x002E #t)
	 (#t #\x0061 #t #\x003A #t #\x0030 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0030 #t)
	 (#t #\x0061 #t #\x003A #t #\x005F #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x005F #t)
	 (#t #\x0061 #t #\x003A #t #\x1F1E6 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0061 #f #\x003A #f #\x05D0 #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x05D0 #t)
	 (#t #\x0061 #t #\x003A #t #\x0022 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0022 #t)
	 (#t #\x0061 #t #\x003A #t #\x0027 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0027 #t)
	 (#t #\x0061 #t #\x003A #t #\x261D #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x261D #t)
	 (#t #\x0061 #t #\x003A #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x003A #t #\x2764 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x2764 #t)
	 (#t #\x0061 #t #\x003A #t #\x1F466 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0061 #t #\x003A #f #\x00AD #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #f #\x00AD #t)
	 (#t #\x0061 #t #\x003A #f #\x0300 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #f #\x0300 #t)
	 (#t #\x0061 #t #\x003A #f #\x200D #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #f #\x200D #t)
	 (#t #\x0061 #f #\x003A #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x003A #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x003A #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x003A #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x003A #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #f #\x003A #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #t #\x003A #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x003A #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x003A #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x003A #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x003A #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x0027 #t #\x0001 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0061 #t #\x0027 #t #\x000D #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x000D #t)
	 (#t #\x0061 #t #\x0027 #t #\x000A #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x000A #t)
	 (#t #\x0061 #t #\x0027 #t #\x000B #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x000B #t)
	 (#t #\x0061 #t #\x0027 #t #\x3031 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0041 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x0041 #t)
	 (#t #\x0061 #t #\x0027 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #t #\x002E #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x002E #t)
	 (#t #\x0061 #t #\x0027 #t #\x0030 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0030 #t)
	 (#t #\x0061 #t #\x0027 #t #\x005F #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x005F #t)
	 (#t #\x0061 #t #\x0027 #t #\x1F1E6 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0061 #f #\x0027 #f #\x05D0 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x05D0 #t)
	 (#t #\x0061 #t #\x0027 #t #\x0022 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0061 #t #\x0027 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #t #\x261D #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x261D #t)
	 (#t #\x0061 #t #\x0027 #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x0027 #t #\x2764 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0061 #t #\x0027 #t #\x1F466 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0061 #t #\x0027 #f #\x00AD #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0061 #t #\x0027 #f #\x0300 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0061 #t #\x0027 #f #\x200D #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #f #\x200D #t)
	 (#t #\x0061 #f #\x0027 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x0027 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #f #\x0027 #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x0027 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0001 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x000D #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x000D #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x000A #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x000A #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x000B #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x000B #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x3031 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0041 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x0041 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x002E #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x002E #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0030 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0030 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x005F #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x005F #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x1F1E6 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x05D0 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x05D0 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0022 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x261D #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x261D #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x2764 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x1F466 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x00AD #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0300 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x200D #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #f #\x200D #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x003A #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #f #\x0027 #f #\x2060 #f #\x0308 #f #\x0061 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x0027 #f #\x2060 #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x002C #t #\x0001 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0001 #t)
	 (#t #\x0061 #t #\x002C #t #\x000D #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x000D #t)
	 (#t #\x0061 #t #\x002C #t #\x000A #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x000A #t)
	 (#t #\x0061 #t #\x002C #t #\x000B #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x000B #t)
	 (#t #\x0061 #t #\x002C #t #\x3031 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x3031 #t)
	 (#t #\x0061 #t #\x002C #t #\x0041 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0041 #t)
	 (#t #\x0061 #t #\x002C #t #\x003A #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x003A #t)
	 (#t #\x0061 #t #\x002C #t #\x002C #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x002C #t)
	 (#t #\x0061 #t #\x002C #t #\x002E #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x002E #t)
	 (#t #\x0061 #t #\x002C #t #\x0030 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0030 #t)
	 (#t #\x0061 #t #\x002C #t #\x005F #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x005F #t)
	 (#t #\x0061 #t #\x002C #t #\x1F1E6 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0061 #t #\x002C #t #\x05D0 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0061 #t #\x002C #t #\x0022 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0022 #t)
	 (#t #\x0061 #t #\x002C #t #\x0027 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0027 #t)
	 (#t #\x0061 #t #\x002C #t #\x261D #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x261D #t)
	 (#t #\x0061 #t #\x002C #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0061 #t #\x002C #t #\x2764 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x2764 #t)
	 (#t #\x0061 #t #\x002C #t #\x1F466 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0061 #t #\x002C #f #\x00AD #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #f #\x00AD #t)
	 (#t #\x0061 #t #\x002C #f #\x0300 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #f #\x0300 #t)
	 (#t #\x0061 #t #\x002C #f #\x200D #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #f #\x200D #t)
	 (#t #\x0061 #t #\x002C #t #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0061 #t #\x002C #t #\x0061 #t #\x003A #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0061 #t #\x002C #t #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0061 #t #\x002C #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0061 #t #\x002C #t #\x0061 #t #\x002C #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0061 #t #\x002C #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0061 #t #\x002C #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0061 #t #\x002C #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0061 #t #\x002C #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0061 #t #\x002C #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #t #\x003A #t #\x0001 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0001 #t)
	 (#t #\x0031 #t #\x003A #t #\x000D #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x000D #t)
	 (#t #\x0031 #t #\x003A #t #\x000A #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x000A #t)
	 (#t #\x0031 #t #\x003A #t #\x000B #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x000B #t)
	 (#t #\x0031 #t #\x003A #t #\x3031 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x3031 #t)
	 (#t #\x0031 #t #\x003A #t #\x0041 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0041 #t)
	 (#t #\x0031 #t #\x003A #t #\x003A #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x003A #t)
	 (#t #\x0031 #t #\x003A #t #\x002C #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x002C #t)
	 (#t #\x0031 #t #\x003A #t #\x002E #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x002E #t)
	 (#t #\x0031 #t #\x003A #t #\x0030 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0030 #t)
	 (#t #\x0031 #t #\x003A #t #\x005F #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x005F #t)
	 (#t #\x0031 #t #\x003A #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x003A #t #\x05D0 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0031 #t #\x003A #t #\x0022 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0022 #t)
	 (#t #\x0031 #t #\x003A #t #\x0027 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0027 #t)
	 (#t #\x0031 #t #\x003A #t #\x261D #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x261D #t)
	 (#t #\x0031 #t #\x003A #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x003A #t #\x2764 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x2764 #t)
	 (#t #\x0031 #t #\x003A #t #\x1F466 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0031 #t #\x003A #f #\x00AD #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #f #\x00AD #t)
	 (#t #\x0031 #t #\x003A #f #\x0300 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #f #\x0300 #t)
	 (#t #\x0031 #t #\x003A #f #\x200D #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #f #\x200D #t)
	 (#t #\x0031 #t #\x003A #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x003A #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x003A #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x003A #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x003A #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #t #\x003A #t #\x0031 #t #\x003A #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0031 #t #\x003A #t)
	 (#t #\x0031 #t #\x003A #t #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #t #\x003A #t #\x0031 #t #\x002C #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0031 #t #\x002C #t)
	 (#t #\x0031 #t #\x003A #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #t #\x003A #f #\x0308 #t #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0001 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0031 #t #\x0027 #t #\x000D #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x000D #t)
	 (#t #\x0031 #t #\x0027 #t #\x000A #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x000A #t)
	 (#t #\x0031 #t #\x0027 #t #\x000B #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x000B #t)
	 (#t #\x0031 #t #\x0027 #t #\x3031 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0041 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0041 #t)
	 (#t #\x0031 #t #\x0027 #t #\x003A #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x003A #t)
	 (#t #\x0031 #t #\x0027 #t #\x002C #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x002C #t)
	 (#t #\x0031 #t #\x0027 #t #\x002E #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x002E #t)
	 (#t #\x0031 #f #\x0027 #f #\x0030 #t)
	 (#t #\x0031 #f #\x0027 #f #\x0308 #f #\x0030 #t)
	 (#t #\x0031 #t #\x0027 #t #\x005F #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x005F #t)
	 (#t #\x0031 #t #\x0027 #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x0027 #t #\x05D0 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0022 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0027 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0031 #t #\x0027 #t #\x261D #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x261D #t)
	 (#t #\x0031 #t #\x0027 #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x0027 #t #\x2764 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0031 #t #\x0027 #t #\x1F466 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0031 #t #\x0027 #f #\x00AD #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0031 #t #\x0027 #f #\x0300 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0031 #t #\x0027 #f #\x200D #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #f #\x200D #t)
	 (#t #\x0031 #t #\x0027 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x0027 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x0027 #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #t #\x0027 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #f #\x0027 #f #\x0031 #t #\x003A #t)
	 (#t #\x0031 #f #\x0027 #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x0031 #f #\x0027 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #f #\x0027 #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #f #\x0027 #f #\x0031 #t #\x002C #t)
	 (#t #\x0031 #f #\x0027 #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x0031 #f #\x0027 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #f #\x0027 #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #t #\x002C #t #\x0001 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0001 #t)
	 (#t #\x0031 #t #\x002C #t #\x000D #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x000D #t)
	 (#t #\x0031 #t #\x002C #t #\x000A #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x000A #t)
	 (#t #\x0031 #t #\x002C #t #\x000B #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x000B #t)
	 (#t #\x0031 #t #\x002C #t #\x3031 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x3031 #t)
	 (#t #\x0031 #t #\x002C #t #\x0041 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0041 #t)
	 (#t #\x0031 #t #\x002C #t #\x003A #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x003A #t)
	 (#t #\x0031 #t #\x002C #t #\x002C #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x002C #t)
	 (#t #\x0031 #t #\x002C #t #\x002E #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x002E #t)
	 (#t #\x0031 #f #\x002C #f #\x0030 #t)
	 (#t #\x0031 #f #\x002C #f #\x0308 #f #\x0030 #t)
	 (#t #\x0031 #t #\x002C #t #\x005F #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x005F #t)
	 (#t #\x0031 #t #\x002C #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x002C #t #\x05D0 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0031 #t #\x002C #t #\x0022 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0022 #t)
	 (#t #\x0031 #t #\x002C #t #\x0027 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002C #t #\x261D #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x261D #t)
	 (#t #\x0031 #t #\x002C #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x002C #t #\x2764 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x2764 #t)
	 (#t #\x0031 #t #\x002C #t #\x1F466 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0031 #t #\x002C #f #\x00AD #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #f #\x00AD #t)
	 (#t #\x0031 #t #\x002C #f #\x0300 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #f #\x0300 #t)
	 (#t #\x0031 #t #\x002C #f #\x200D #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #f #\x200D #t)
	 (#t #\x0031 #t #\x002C #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002C #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x002C #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002C #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002C #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #t #\x002C #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #f #\x002C #f #\x0031 #t #\x003A #t)
	 (#t #\x0031 #f #\x002C #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x0031 #f #\x002C #f #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #f #\x002C #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #f #\x002C #f #\x0031 #t #\x002C #t)
	 (#t #\x0031 #f #\x002C #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x0031 #f #\x002C #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #f #\x002C #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0001 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0001 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x000D #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x000D #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x000A #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x000A #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x000B #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x000B #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x3031 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x3031 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0041 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0041 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x003A #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x003A #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x002C #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x002C #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x002E #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x002E #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0030 #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0308 #f #\x0030 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x005F #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x005F #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x1F1E6 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x05D0 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x05D0 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0022 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0022 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x261D #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x261D #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x1F3FB #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x2764 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x2764 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x1F466 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x1F466 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x00AD #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #f #\x00AD #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0300 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #f #\x0300 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x200D #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #f #\x200D #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0061 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0061 #t #\x003A #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0061 #t #\x0027 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0061 #t #\x0027 #f #\x2060 #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #t #\x002E #f #\x2060 #f #\x0308 #t #\x0061 #t #\x002C #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0031 #t #\x003A #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0308 #f #\x0031 #t #\x003A #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0308 #f #\x0031 #t #\x0027 #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0031 #t #\x002C #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0308 #f #\x0031 #t #\x002C #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x0031 #f #\x002E #f #\x2060 #f #\x0308 #f #\x0031 #t #\x002E #f #\x2060 #t)
	 (#t #\x000D #f #\x000A #t #\x0061 #t #\x000A #t #\x0308 #t)
	 (#t #\x0061 #f #\x0308 #t)
	 (#t #\x0020 #f #\x200D #t #\x0646 #t)
	 (#t #\x0646 #f #\x200D #t #\x0020 #t)
	 (#t #\x0041 #f #\x0041 #f #\x0041 #t)
	 (#t #\x0041 #f #\x003A #f #\x0041 #t)
	 (#t #\x0041 #t #\x003A #t #\x003A #t #\x0041 #t)
	 (#t #\x05D0 #f #\x0027 #t)
	 (#t #\x05D0 #f #\x0022 #f #\x05D0 #t)
	 (#t #\x0041 #f #\x0030 #f #\x0030 #f #\x0041 #t)
	 (#t #\x0030 #f #\x002C #f #\x0030 #t)
	 (#t #\x0030 #t #\x002C #t #\x002C #t #\x0030 #t)
	 (#t #\x3031 #f #\x3031 #t)
	 (#t #\x0041 #f #\x005F #f #\x0030 #f #\x005F #f #\x3031 #f #\x005F #t)
	 (#t #\x0041 #f #\x005F #f #\x005F #f #\x0041 #t)
	 (#t #\x1F1E6 #f #\x1F1E7 #t #\x1F1E8 #t #\x0062 #t)
	 (#t #\x0061 #t #\x1F1E6 #f #\x1F1E7 #t #\x1F1E8 #t #\x0062 #t)
	 (#t #\x0061 #t #\x1F1E6 #f #\x1F1E7 #f #\x200D #t #\x1F1E8 #t #\x0062 #t)
	 (#t #\x0061 #t #\x1F1E6 #f #\x200D #f #\x1F1E7 #t #\x1F1E8 #t #\x0062 #t)
	 (#t #\x0061 #t #\x1F1E6 #f #\x1F1E7 #t #\x1F1E8 #f #\x1F1E9 #t #\x0062 #t)
	 (#t #\x261D #f #\x1F3FB #t #\x261D #t)
	 (#t #\x1F466 #f #\x1F3FB #t)
	 (#t #\x200D #f #\x1F466 #f #\x1F3FB #t)
	 (#t #\x200D #f #\x2764 #t)
	 (#t #\x200D #f #\x1F466 #t)
	 (#t #\x1F466 #t #\x1F466 #t)
	 (#t #\x0061 #f #\x0308 #f #\x200D #f #\x0308 #f #\x0062 #t)
	 (#t #\x0031 #t #\x003A #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x003A #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x003A #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #t #\x003A #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x003A #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x003A #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #t #\x003A #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x003A #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x003A #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #t #\x003A #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x003A #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x003A #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #t #\x003A #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x003A #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x003A #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #t #\x003A #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x003A #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x003A #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #t #\x002E #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002E #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002E #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #t #\x002E #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002E #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002E #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #t #\x002E #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002E #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002E #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #t #\x002E #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002E #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002E #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #t #\x002E #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002E #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002E #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #t #\x002E #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002E #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002E #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #t #\x002C #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002C #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002C #t #\x003A #t #\x0031 #t)
	 (#t #\x0031 #t #\x002C #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002C #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002C #t #\x003A #t #\x0061 #t)
	 (#t #\x0031 #t #\x002C #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002C #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002C #t #\x002E #t #\x0031 #t)
	 (#t #\x0031 #t #\x002C #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002C #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002C #t #\x002E #t #\x0061 #t)
	 (#t #\x0031 #t #\x002C #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002C #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002C #t #\x002C #t #\x0031 #t)
	 (#t #\x0031 #t #\x002C #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0031 #t #\x002C #t #\x002C #t #\x0061 #t)
	 (#t #\x0031 #f #\x005F #f #\x0061 #t #\x002C #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #t #\x003A #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x003A #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x003A #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #t #\x003A #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x003A #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x003A #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #t #\x003A #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x003A #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x003A #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #t #\x003A #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x003A #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x003A #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #t #\x003A #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x003A #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x003A #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #t #\x003A #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x003A #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x003A #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #t #\x002E #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002E #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002E #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #t #\x002E #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002E #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002E #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #t #\x002E #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002E #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002E #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #t #\x002E #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002E #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002E #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #t #\x002E #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002E #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002E #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #t #\x002E #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002E #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002E #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #t #\x002C #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002C #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002C #t #\x003A #t #\x0031 #t)
	 (#t #\x0061 #t #\x002C #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002C #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002C #t #\x003A #t #\x0061 #t)
	 (#t #\x0061 #t #\x002C #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002C #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002C #t #\x002E #t #\x0031 #t)
	 (#t #\x0061 #t #\x002C #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002C #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002C #t #\x002E #t #\x0061 #t)
	 (#t #\x0061 #t #\x002C #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002C #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002C #t #\x002C #t #\x0031 #t)
	 (#t #\x0061 #t #\x002C #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0031 #t #\x002C #t #\x002C #t #\x0061 #t)
	 (#t #\x0061 #f #\x005F #f #\x0061 #t #\x002C #t #\x002C #t #\x0061 #t))))