/*
 This file is part of GNUnet.
 (C) 2014 Christian Grothoff (and other contributing authors)

 GNUnet is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published
 by the Free Software Foundation; either version 3, or (at your
 option) any later version.

 GNUnet is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GNUnet; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 */


package org.gnunet.requests;

import org.gnunet.mq.Envelope;
import org.gnunet.util.GnunetMessage;

/**
 * Very simple getRequestIdentifier that sends a pre-determined message
 * to the server and has a context.  When this getRequestIdentifier is restarted,
 * the message is simply sent again.
 */
public class FixedMessageRequest<Ctx> extends Request {
    private final GnunetMessage.Body message;
    private final Ctx ctx;

    public FixedMessageRequest(GnunetMessage.Body message, Ctx ctx) {
        this.message = message;
        this.ctx = ctx;
    }

    @Override
    public Envelope assembleRequest() {
        return new Envelope(message);
    }

    public Ctx getContext() {
        return ctx;
    }
}
