/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.key.rsa;

import gnu.crypto.Registry;
import gnu.crypto.key.rsa.GnuRSAKey;
import gnu.crypto.key.rsa.RSAKeyPairRawCodec;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class GnuRSAPublicKey
extends GnuRSAKey
implements PublicKey,
RSAPublicKey {
    public GnuRSAPublicKey(BigInteger n, BigInteger e) {
        super(n, e);
    }

    public static GnuRSAPublicKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_RSA_PUBLIC_KEY[0]) {
            RSAKeyPairRawCodec codec = new RSAKeyPairRawCodec();
            return (GnuRSAPublicKey)codec.decodePublicKey(k);
        }
        throw new IllegalArgumentException("magic");
    }

    public byte[] getEncoded(int format) {
        if (format != 1) {
            throw new IllegalArgumentException("format");
        }
        byte[] result = new RSAKeyPairRawCodec().encodePublicKey(this);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey that = (RSAPublicKey)obj;
        return super.equals(that) && this.getPublicExponent().equals(that.getPublicExponent());
    }
}

