/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

const responseModule = require('http_observer/process_response.js');

var stubListener = {
    originalListener: {
	dataAvailableTriggered: false,
	stopRequestTriggered: false,
	onDataAvailable: function () { this.dataAvailableTriggered = true; },
	onStopRequest: function () { this.stopRequestTriggered = true; }
    },
    receivedData: ['<!doctype><html>',
	   '<body><h1>Hello World!</h1></body>',
	   '</html>']
};

var stubResInfo = {
    request: {
	contentType: 'text/html',
	URI: {spec: 'http://www.example.org'},
	referrer: {spec: ''},
	contentCharset: 'UTF-8',
	cancel: function () { }
    },
    statusCode: 200
};

var init = function () {
    return responseModule.ProcessResponse(stubListener, stubResInfo);
}

exports.testProcessResponseConstructor = function (test) {
    var obj = init();
    test.assert(obj);
};

exports.testListener = function (test) {
    var obj = init();
    test.assertEqual(obj.listener, stubListener);
};

exports.testProperties = function (test) {
    var obj = init();
    test.assertEqual(obj.resInfo, stubResInfo);
    test.assertEqual(obj.req, stubResInfo.request);
};

exports.testSetData = function (test) {
    var obj = init();
    obj.setData();
    test.assertEqual(obj.data, stubListener.receivedData.join(''));
};

exports.testSetContentType = function (test) {
    var obj = init();
    obj.req.contentType = 'TEXT/HTML';
    obj.setContentType();
    test.assertEqual(obj.contentType, 'text/html');
};

exports.testSetUrls = function (test) {
    var obj = init();
    obj.req.URI.spec = 'http://www.example.org/blah.html#a-Fragment';
    obj.req.referrer.spec = 'http://www.example.org/blob.html#some-fragment-who-knows-if-its-possible';
    obj.setUrls();
    test.assertEqual(obj.url, 'http://www.example.org/blah.html');
    test.assertEqual(obj.referrer, 'http://www.example.org/blob.html');
};

exports.testGenBinaryOutput = function (test) {
    var obj = init();
    obj.genBinaryOutput();
    test.assert(obj.storageStream);
    test.assert(obj.binaryOutputStream);
}