:userdoc.

:title.FIGlet v2.2 (23 January 1997)

.*
.*  FIGlet
.*  Copyright (C) 1991, 1993, 1994 Glenn Chappell and Ian Chai
.*  Internet: <ggc@uiuc.edu> and <chai@uiuc.edu>
.*  Portions Copyright 1996, 1997 by John Cowan <cowan@ccil.org>
.*  FIGlet, along with the various FIGlet fonts and documentation, may
.*  be freely copied and distributed.
.*  If you use FIGlet, please send an e-mail message to
.*  <figlet-l@postoffice.cso.uiuc.edu>.
.*
.*  Formatted into OS/2 IPF format by Jim Northrup <northrup@bright.net>
.*  If you find formating (not content) errors in this document, please
.*  contact Jim at the above address.
.*

:h1 name=overview.Overview

:font facename='Tms Rmn' size=30x24.
.ce Overview of FIGlet
:font facename=default size=0x0.

:hp1.(Important Ed. Note: The FTP and HTTP links in this document assume you are
using IBM's WebExplorer and that you have a connection to the Internet.  If this
is not the case, attempting to follow these links will result in an error.):ehp1.

:p.
:hp2.FIGlet:ehp2. prints its input using large characters
(called "FIGcharacters") made up of ordinary
screen characters (called "sub-characters").
:hp2.FIGlet:ehp2. output is generally reminiscent of the
sort of "signatures" many people like to put at
the end of e-mail and UseNet messages.  It is also
reminiscent of the output of some banner programs,
although it is oriented normally, not sideways.

:p.
:hp2.FIGlet:ehp2. can print in a variety of fonts, both left-to-right
and right-to-left, with adjacent characters kerned and
"smushed" together in various ways.  :hp2.FIGlet:ehp2. fonts are
stored in separate files, which can be identified by the
suffix ".flf".  Most :hp2.FIGlet:ehp2. font files will be stored in
:hp2.FIGlet:ehp2.'s default font directory.

:p.
:hp2.FIGlet:ehp2. can also use "control files", which tell it to map
certain input characters to certain other characters,
similar to the Unix tr command.  Control files can be
identified by the suffix ".flc".  Most :hp2.FIGlet:ehp2. control
files will be stored in :hp2.FIGlet:ehp2.'s default font directory.

:p.
You can store :hp2.FIGlet:ehp2. fonts and control files
in compressed form. See :link reftype=hd refid=compressed."COMPRESSED FONTS":elink.

:h1 name=usage.Usage
:font facename='Tms Rmn' size=30x24.
.ce Usage of FIGlet
:font facename=default size=0x0.
:cgraphic.

figlet 
         :link reftype=fn refid=f_option.-f fontfile:elink.   :link reftype=fn refid=d_option.-d fontdirectory:elink.   :link reftype=fn refid=c_option.-c:elink. Ĵ
                                                  :link reftype=fn refid=l_option.-l:elink. Ĵ
                                                  :link reftype=fn refid=r_option.-r:elink. Ĵ
                                                  :link reftype=fn refid=x_option.-x:elink. 

      
         :link reftype=fn refid=t_option.-t:elink. Ĵ  :link reftype=fn refid=n_option.-n:elink. Ĵ  :link reftype=fn refid=capD_option.-D:elink. Ĵ
         :link reftype=fn refid=w_option.-w outputwidth:elink.   :link reftype=fn refid=p_option.-p:elink.   :link reftype=fn refid=capE_option.-E:elink. 

      
         :link reftype=fn refid=capN_option.-N:elink. Ĵ  :link reftype=fn refid=smushmode_options.-s:elink. Ĵ
         :link reftype=fn refid=capC_option.-C controlfile:elink.   :link reftype=fn refid=smushmode_options.-S:elink. Ĵ
                              :link reftype=fn refid=smushmode_options.-k:elink. Ĵ
                              :link reftype=fn refid=smushmode_options.-W:elink. Ĵ
                              :link reftype=fn refid=smushmode_options.-o:elink. Ĵ
                              :link reftype=fn refid=smushmode_options.-m smushmode:elink. 

      
         :link reftype=fn refid=info_options.-v:elink. Ĵ  :link reftype=fn refid=capL_option.-L:elink. Ĵ
         :link reftype=fn refid=info_options.-I infocode:elink.   :link reftype=fn refid=capR_option.-R:elink. Ĵ
                           :link reftype=fn refid=capX_option.-X:elink. 

:ecgraphic.

:p.
Just start up :hp2.FIGlet:ehp2. (type "figlet") and then type
whatever you want.  Alternatively, pipe a file or the output of
another command through :hp2.FIGlet:ehp2.,  or put input on the command
line after the options.  See :link reftype=hd refid=examples.examples:elink.
for other things to do.

:p.
:hp2.FIGlet:ehp2. reads command line options from left to right, and
only the last option that affects a parameter has any
effect.  Every option has an inverse, so that, for example,
if :hp2.FIGlet:ehp2. is customized with an alias, all the
options are still available.

:p.
Commonly-used options are -f, -c, -k, -t, -p and -v.

:p.
Once the options are read, if there are any remaining words on the command line,
they are used instead of standard input as the source of text. This feature
allows shell scripts to generate large letters without having to dummy
up standard input files. An empty argument, obtained by two sequential quotes,
results in a line break.

:fn id=f_option.
:hp2.
.ce FIGlet&colon. -f fontfile Option
:ehp2.
:p.
Select the font.  The .flf suffix may be left off of
fontfile, in which case :hp2.FIGlet:ehp2. automatically appends
it.  :hp2.FIGlet:ehp2. looks for the file first in the default
font directory and then in the current directory, or,
if fontfile was given as a full pathname, in the given
directory.  If the -f option is not specified, :hp2.FIGlet:ehp2.
uses the font that was specified when it was compiled.
To find out which font this is, use the -I3 option.
:efn.

:fn id=d_option.
:hp2.
.ce FIGlet&colon. -d fontdirectory Option
:ehp2.
:p.
Change the default font directory.  :hp2.FIGlet:ehp2. looks for
fonts first in the default directory and then in the
current directory.  If the -d option is not specified,
:hp2.FIGlet:ehp2. uses the directory that was specified when it
was compiled.  To find out which directory this is, use
the -I2 option.
:efn.


:fn id=c_option.
:hp2.
.ce FIGlet&colon. -c Option
:ehp2.
:p.
Centers :hp2.FIGlet:ehp2. output horizontally.
:efn.

:fn id=l_option.
:hp2.
.ce FIGlet&colon. -l Option
:ehp2.
:p.
Makes :hp2.FIGlet:ehp2. output flush-left.
:efn.

:fn id=r_option.
:hp2.
.ce FIGlet&colon. -r Option
:ehp2.
:p.
Makes :hp2.FIGlet:ehp2. output flush-right.
:efn.

:fn id=x_option.
:hp2.
.ce FIGlet&colon. -x Option
:ehp2.
:p.
(Default) Sets :hp2.FIGlet:ehp2. output justification according
to whether left-to-right or right-to-left text is selected.
Left-to-right text will be flush-left, while right-to-left
text will be flush-right.  (Left-to-right versus
right-to-left text is controlled by -L, -R and -X.)
:efn.


:fn id=t_option.
:hp2.
.ce FIGlet&colon. -t Option
:ehp2.
:p.
Sets outputwidth to terminal width. :hp2.FIGlet:ehp2. uses the
outputwidth to determine when to break
lines and how to center the output. If the
terminal width cannot be determined, the previous
outputwidth is retained.  By defualt, the outputwidth
is 80 columns so that people with wide terminals
won't annoy the people they e-mail :hp2.FIGlet:ehp2. output to.
:efn.

:fn id=w_option.
:hp2.
.ce FIGlet&colon. -w outputwidth Option
:ehp2.
:p.
Sets the outputwidth to the given integer.
:hp2.FIGlet:ehp2. uses the outputwidth to determine when
to break lines and how to center the output.
An outputwidth of 1 is a special value that
tells :hp2.FIGlet:ehp2. to print each non-space character,
in its entirety, on a separate line, no
matter how wide it is. By defualt, the outputwidth
is 80 columns so that people with wide terminals
won't annoy the people they e-mail :hp2.FIGlet:ehp2. output to.
:efn.


:fn id=n_option.
:hp2.
.ce FIGlet&colon. -n Option
:ehp2.
:p.
Puts :hp2.FIGlet:ehp2. back to normal line break mode (default), in
which every newline :hp2.FIGlet:ehp2. reads causes it to produce a
line break.
:efn.

:fn id=p_option.
:hp2.
.ce FIGlet&colon. -p Option
:ehp2.
:p.
Puts :hp2.FIGlet:ehp2. into "paragraph mode", which eliminates
some unnecessary line breaks when piping a multi-line
file through :hp2.FIGlet:ehp2..  In paragraph mode, :hp2.FIGlet:ehp2. treats
line breaks within a paragraph as if they were merely
blanks between words.  (Specifically, -p causes :hp2.FIGlet:ehp2.
to convert any newline which is not preceded by a
newline and not followed by a space character into a
blank.)
:efn.

:fn id=capD_option.
:hp2.
.ce FIGlet&colon. -D Option
:ehp2.
:p.
Switches to the German (ISO 646-DE) character set.
Turns `[', `\' and `]' into umlauted A, O and U,
respectively.  `{', `|' and `}' turn into the
respective lower case versions of these.  `~' turns
into s-z.  (Of course, all this assumes the font author
has placed German characters in these positions in the
font file.  Many font authors do not.)
:p.
This option, and its inverse, :hp2.-E:ehp2., are
deprecated, which means they probably will not appear
in the next version of :hp2.FIGlet:ehp2.&per.
:efn.


:fn id=capE_option.
:hp2.
.ce FIGlet&colon. -E Option
:ehp2.
:p.
Switches to English (default), i.e., the standard ASCII
character set.  This option, and its inverse,
:hp2.-D:ehp2., are deprecated, which means they probably
will not appear in the next version of :hp2.FIGlet:ehp2.&per.
:efn.

:fn id=capN_option.
:hp2.
.ce FIGlet&colon. -N Option
:ehp2.
:p.
This option deals with :hp2.FIGlet:ehp2. controlfiles.  A
controlfile is a file containing a list of commands
that :hp2.FIGlet:ehp2. executes each time it reads a character.
These commands can map certain input characters to
other characters, similar to the Unix tr command or the
:hp2.FIGlet:ehp2. -D option.  :hp2.FIGlet:ehp2. maintains a list of
controlfiles, which is empty when :hp2.FIGlet:ehp2. starts up.
This option clears the controlfile list, cancelling
the effect of any previous -C.  :hp2.FIGlet:ehp2. executes the
commands in all controlfiles in the list.  See FIGFONT.INF
for details on how to write a controlfile.
:efn.

:fn id=capC_option.
:hp2.
.ce FIGlet&colon. -C controlfile Option
:ehp2.
:p.
This option deals with :hp2.FIGlet:ehp2. controlfiles.  A
controlfile is a file containing a list of commands
that :hp2.FIGlet:ehp2. executes each time it reads a character.
These commands can map certain input characters to
other characters, similar to the Unix tr command or the
:hp2.FIGlet:ehp2. -D option.  :hp2.FIGlet:ehp2. maintains a list of
controlfiles, which is empty when :hp2.FIGlet:ehp2. starts up. This
option adds the given controlfile to the list.
:hp2.FIGlet:ehp2. executes the commands in all controlfiles
in the list.  See FIGFONT.INF for details on how to write a controlfile.
:efn.

:fn id=smushmode_options.
:hp2.
FIGlet&colon. -s, -S, -k, -W, -o, and -m Options
:ehp2.
:p.
These options control how :hp2.FIGlet:ehp2. spaces the
FIGcharacters that it outputs. :hp2.-s:ehp2. (default)
and :hp2.-S:ehp2. cause "smushing". The FIGcharacters
are displayed as close together as possible, and overlapping
sub-characters are removed. Exactly which sub-characters count
as "overlapping" depends on the font's layoutmode, which is
defined by the font's author.

:p.
:hp2.-k:ehp2. causes "kerning".  As many blanks as possible
are removed between FIGcharacters, so that they touch, but
the FIGcharacters are not smushed.

:p.
:hp2.-W:ehp2. makes :hp2.FIGlet:ehp2. display all FIGcharacters
at their full width, which may be fixed or variable, depending
on the font.

:p.
The difference between :hp2.-s:ehp2. and :hp2.-S:ehp2. is that
:hp2.-s:ehp2. will not smush a font whose author specified
kerning or full width as the default layoutmode, whereas
:hp2.-S:ehp2. will attempt to do so.

:p.
If there is no information in the font about how to smush,
or if the :hp2.-o:ehp2. option is specified, then the
FIGcharacters are "overlapped". This means that after kerning,
the first subcharacter of each FIGcharacter is removed.
(This is not done if a FIGcharacter contains only one subcharacter.)

:p.
:hp2.-m layoutmode:ehp2.
Specifies an explicit layoutmode between :hp2.1:ehp2. and :hp2.63:ehp2.
Layoutmodes are explained in FIGFONT.INF which also provides complete
information on the format of a
:hp2.FIGlet:ehp2. font.

:p.
For the sake of backward compatibility
with versions of :hp2.FIGlet:ehp2. before 2.2,
:hp2.-m 0:ehp2. is equivalent to :hp2.-k:ehp2.,
:hp2.-m -1:ehp2. is equivalent to :hp2.-W:ehp2.,
and :hp2.-m -2:ehp2. is equivalent to :hp2.-s:ehp2.&per.
The :hp2.-m:ehp2. switch is normally used only by font
designers testing the various layoutmodes with a new font.

:efn.

:fn id=info_options.
:hp2.
FIGlet&colon. -v and -I infocode Options
:ehp2.
:p.

These options print various information about :hp2.FIGlet:ehp2.,
then exits.  If several of these options are given on
the command line, only the last is executed, and only
after all other command-line options have been dealt
with.

:p.
Prints the information corresponding to the given infocode
in a consistent, reliable (i.e., guaranteed to be the same
in future releases) format.  -I is primarily intended to be
used by programs that use :hp2.FIGlet:ehp2..  infocode can be any of
the following.

:ul.
:li.:hp2.-1:ehp2. Normal operation (default).
.br
This infocode indicates that :hp2.FIGlet:ehp2. should operate
normally, not giving any informational printout,
printing its input in the selected font.

:li.:hp2.0:ehp2. Version and copyright.
.br
This is identical to -v.

:li.:hp2.1:ehp2. Version (integer).
.br
This will print the version of your copy of :hp2.FIGlet:ehp2.
as a decimal integer.  The main version number is
multiplied by 10000, the sub-version number is
multiplied by 100, and the sub-sub-version number
is multiplied by 1.  These are added together, and
the result is printed out.  For example, :hp2.FIGlet:ehp2.
2.2 will print "20200".  If there is ever a
version 2.2.1, it will print "20201".
Similarly, version 3.7.2 would print "30702".
These numbers are guaranteed to be ascending, with
later versions having higher numbers.  Note that
the first major release of :hp2.FIGlet:ehp2., version 2.0,
did not have the -I option.

:li.:hp2.2:ehp2. Default font directory.
.br
This will print the default font directory.  It is
affected by the -d option.

:li.:hp2.3:ehp2. Font.
.br
This will print the name of the font :hp2.FIGlet:ehp2. would
use.  It is affected by the -f option.  This is
not a filename; the ".flf" suffix is not
printed.

:li.:hp2.4:ehp2. Output width.
.br
This will print the value :hp2.FIGlet:ehp2. would use for
outputwidth, the number of columns wide :hp2.FIGlet:ehp2.
assumes the screen is.  It is affected by the -w
and -t options.
:eul.

:p.
If infocode is any other positive value, :hp2.FIGlet:ehp2. will
simply exit without printing anything.
:efn.


:fn id=capL_option.
:hp2.
.ce FIGlet&colon. -L option
:ehp2.
:p.
-L selects left-to-right printing of :hp2.FIGlet:ehp2. output.
:efn.


:fn id=capR_option.
:hp2.
.ce FIGlet&colon. -R option
:ehp2.
:p.
-R selects right-to-left printing of :hp2.FIGlet:ehp2. output.
:efn.

:fn id=capX_option.
:hp2.
.ce FIGlet&colon. -X option
:ehp2.
:p.
(Default) makes :hp2.FIGlet:ehp2. use right-to-left or left-to-right
printing of output as specified in the font file.
:efn.

:h1 name=examples.Examples
:font facename='Tms Rmn' size=30x24.
.ce Examples of FIGlet Usage
:font facename=default size=0x0.

:p.
:ul.
:li.
To use :hp2.FIGlet:ehp2. with its default settings, simply type
.br
:xmp.
    figlet
:exmp.
and then type whatever you like.

:li.
To change the font, use the -f option, for example,
.br
:xmp.
    figlet -f script
:exmp.

:li.
Use the -c option if you would prefer centered output:
.br
:xmp.
    figlet -c
:exmp.

:li.
We have found that the most common use of :hp2.FIGlet:ehp2. is making
up large text to be placed in e-mail messages.  For this
reason, :hp2.FIGlet:ehp2. defaults to 80 column output.  If you are
using a wider terminal, and would like :hp2.FIGlet:ehp2. to use the
full width of your terminal, use the -t option:
.br
:xmp.
     figlet -t
:exmp.

:li.
If you don't want :hp2.FIGlet:ehp2. to smush font characters into each
other, use the -k option:
.br
:xmp.
    figlet -k
:exmp.

:li.
If :hp2.FIGlet:ehp2. gets its input from a file, it is often a good
idea to use -p:
.br
:xmp.
    figlet -p < myfile.txt
:exmp.

:li.
Of course, the above can be combined:
.br
:xmp.
 figlet -ptk -f shadow < anotherfile.txt
 figlet -cf slant
:exmp.

:li.
Finally, if you want to have :hp2.FIGlet:ehp2. take
the input from the command line instead of a file:

:xmp.
 figlet Hello world
:exmp.
:eul.

:p.
:hp2.
.ce Other Things to Try
:ehp2.
:p.
Nice effects can be obtained from the lean font by piping
it through the Unix tr command.  Some you might want to try
are the following:
.br
:xmp.
    figlet -f lean | tr ' _/' ' ()'
    figlet -f lean | tr ' _/' './\\'
    figlet -f lean | tr ' _/' ' //'
    figlet -f lean | tr ' _/' '/  '
:exmp.

:p.
Similar things can be done with the block font and many of
the other :hp2.FIGlet:ehp2. fonts.

:h1 id=compressed.Compressed Fonts

:font facename='Tms Rmn' size=30x24.
.ce Compressed Fonts
:font facename=default size=0x0.

:p.
You can compress the fonts and controlfiles
using the :hp2.zip:ehp2. archiving program from InfoZip
(:link reftype=launch object='explore.exe' data='http://www.cdrom.com/pub/infozip/Info-Zip.html'.http&colon.//www.cdrom.com/pub/infozip/Info-Zip.html:elink.).
Place only one font or controlfile in each archive,
and rename the archive file (which will have a name
ending in :hp1.&per.zip:ehp1. )
back to :hp1.&per.flf:ehp1. or :hp1.&per.flc:ehp1.
as the case may be. If you don't rename the file appropriately,
:hp2.FIGlet:ehp2. won't be able to find it.
:hp2.FIGlet:ehp2. does not care what the filename within the
:hp1.&per.zip:ehp1. archive is, and will process only the first file.

:p.
The :hp1.&per.zip:ehp1. format was chosen because tools to
create and manipulate it are widely available for free
on many platforms.


:h1 id=standard.Standard Fonts

:font facename='Tms Rmn' size=30x24.
.ce Standard Fonts
:font facename=default size=0x0.

:p.
Here are a few notes about some of the fonts provided with
:hp2.FIGlet:ehp2.&per.

:p.
You can get many other fonts by anonymous FTP from
:link reftype=launch object='explore.exe' data='ftp://ftp.nicoh.com/pub/figlet'.ftp&colon.//ftp&per.nicoh&per.com/pub/figlet:elink.
or the Web site
:link reftype=launch object='explore.exe' data='http://st-www.cs.uiuc.edu/~chai/figlet.html'.http&colon.//st-www&per.cs&per.uiuc&per.edu/~chai/figlet.html:elink.&per.
These locations should also contain the latest version of
:hp2.FIGlet:ehp2. and other related utilities.

:p.
The font :hp1.standard:ehp1. is the basic :hp2.FIGlet:ehp2.
font, used when no other font is specified. (This default can
be changed when :hp2.FIGlet:ehp2. is compiled on your system.)
The :hp2.controlfiles:ehp2. :hp1.8859-2:ehp1., :hp1.8859-3:ehp1.,
:hp1.8859-4:ehp1., and :hp1.8859-9:ehp1. are provided for
interpreting those character sets, also known as ISO Latin-2
through Latin-5 respectively. The character set 8859-1
(ISO Latin-1) is :hp2.FIGlet:ehp2.'s default and requires
no special :hp2.controlfile:ehp2.

:p.
Closely related are the fonts :hp1.slant:ehp1., :hp1.shadow:ehp1.,
:hp1.small:ehp1., :hp1.smslant:ehp1. (both small and slanted),
:hp1.smshadow:ehp1. (both small and shadowed),
and :hp1.big:ehp1.&per. These fonts support only Latin-1, except that
:hp1.big:ehp1. supports Greek FIGcharacters as well;
the :hp2.controlfiles:ehp2. :hp1.frango:ehp1.
(for Greek text written in Latin characters, so-called
:hp1."frangovlakhika":ehp1.),
and :hp1.8859-7:ehp1. (for mixed Latin/Greek text) are provided.

:p.
The :hp1.ivrit:ehp1. font is a right-to-left font including both
Latin and Hebrew FIGcharacters; the Latin characters are those of the
:hp1.standard:ehp1. font. The available :hp2.controlfiles:ehp2.
are :hp1.ilhebrew:ehp1., which maps the letters you get by typing
on a U.S. keyboard as if it were a Hebrew keyboard; :hp1.ushebrew:ehp1.,
which makes a reasonable mapping from Latin letters to Hebrew ones;
and :hp1.8859-8:ehp1., which supports mixed Latin/Hebrew text.

:warning.
:hp2.FIGlet:ehp2. doesn't support bidirectional text,
so everything will come out right-to-left, even Latin letters.
:ewarning.

:p.
The fonts :hp1.terminal:ehp1., :hp1.digital:ehp1.,
and :hp1.bubble:ehp1. output the input character with
some decoration around it (or no decoration, in the case of
:hp1.terminal:ehp1.). The characters coded 128 to 159,
which have varying interpretations, are output as-is.
You can use the appropriate :hp2.controlfiles:ehp2.
to process Latin-2, Latin-3, or Latin-4 (but not Latin-5) text,
provided your output device has screen or printer fonts that
are appropriate for these character sets.

:p.
Two script fonts are available&colon. :hp1.script:ehp1., which
is larger than :hp1.standard:ehp1., and :hp1.smscript:ehp1.,
which is smaller.

:p.
The font :hp1.lean:ehp1. is made up solely of `/' and `_'
sub-characters; :hp1.block:ehp1. is a straight (non-leaning)
version of it.

:p.
The font :hp1.mini:ehp1. is very small, and especially suitable
for e-mail signatures.

:p.
The font :hp1.banner:ehp1. looks like the output of the Unix
:hp2.banner:ehp2. program; it is a capitals and small capitals
font that doesn't support the ISO Latin-1 extensions to plain ASCII.
It does, however, support the Japanese :hp1.katakana:ehp1. syllabary;
the :hp2.controlfile:ehp2. :hp1.uskata:ehp1. maps the upper-case and
lower-case Latin letters into the 48 basic :hp1.katakana:ehp1.
characters, and the :hp2.controlfile:ehp2. :hp1.jis0201:ehp1. handles
JIS 0201X (JIS-Roman) mixed Latin and :hp1.katakana:ehp1. text.
Furthermore, the :hp1.banner:ehp1. font also supports Cyrillic (Russian)
FIGcharacters; the :hp2.controlfile:ehp2. :hp1.8859-5:ehp1. supports
mixed Latin and Cyrillic text, the :hp2.controlfile:ehp2. :hp1.koi8r:ehp1.
supports the popular KOI8-R mapping of mixed text, and the
:hp2.controlfile:ehp2. :hp1.moscow:ehp1. supports a sensible mapping from
Latin to Cyrillic, compatible with the :hp1.moscow:ehp1. font (not supplied).

:p.
The fonts  :hp1.mnemonic:ehp1. and :hp1.safemnem:ehp1. support the
mnemonic character set documented in RFC 1345. They implement a large
subset of Unicode (over 1800 characters) very crudely, using ASCII-based
mnemonic sequences, and are good for getting a quick look at UTF-8 unicode
files, using the controlfile :hp1.utf8:ehp1.&per.


:h1 id=diagnostics.Diagnostics

:font facename='Tms Rmn' size=30x24.
.ce Diagnostics
:font facename=default size=0x0.

:p.
:hp2.FIGlet:ehp2.'s diagnostics are intended to be self-explanatory.
Possible messages are
:xmp.

     Usage: ...
     Out of memory
     Unable to open font file
     Not a FIGlet 2 font file
     Unable to open control file
     Not a FIGlet 2 control file
     "-t" is disabled, since ioctl is not fully implemented.

:exmp.
This last message is printed when the -t option is given,
but the operating system in use does not include the system
call :hp2.FIGlet:ehp2. uses to determine the terminal width.

:p.
:hp2.FIGlet:ehp2. also prints an explanatory message if the -F option
is given on the command line.  The earlier version of
:hp2.FIGlet:ehp2., version 2.0, listed the available fonts when the -F
option was given.  This option has been removed from :hp2.FIGlet:ehp2.
2.1.  It has been replaced by the figlist script, which is
part of the standard :hp2.FIGlet:ehp2. package.

:h1 id=origin.Origin

:font facename='Tms Rmn' size=30x24.
.ce Origin
:font facename=default size=0x0.

:p.
":hp2.FIGlet:ehp2." stands for "Frank, Ian and Glenn's LETters".
Inspired by Frank's .sig, Glenn wrote (most of) it, and Ian
helped.

:p.
Most of the standard :hp2.FIGlet:ehp2. fonts were inspired by
signatures on various UseNet articles.  Since typically
hundreds of people use the same style of letters in their
signatures, it was often not deemed necessary to give credit
to any one font designer.

:h1 id=bugs.Bugs

:font facename='Tms Rmn' size=30x24.
.ce Bugs
:font facename=default size=0x0.

:p.
Very little error checking is done on font and control
files.  While :hp2.FIGlet:ehp2. tries to be forgiving of errors, and
should (hopefully) never actually crash, using an
improperly-formatted file with :hp2.FIGlet:ehp2. will produce
unpredictable output.

:p.
:hp2.FIGlet:ehp2. does not handle formatting characters in a very
intelligent way.  A tab character is converted to a blank,
and vertical-tab, form-feed and carriage-return are each
converted to a newline.  On many systems, tabs can be
handled better by piping files through expand before piping
through :hp2.FIGlet:ehp2..

:p.
:hp2.FIGlet:ehp2. output is quite ugly if it is displayed in a
proportionally-spaced font.  I suppose this is to be
expected.

:p.
Please report any errors you find in this manual or the program to
<figlet-l@postoffice.cso.uiuc.edu>


:h1 name=other.Other Fonts &amp. Mailing List

:font facename='Tms Rmn' size=30x24.
.ce Other Fonts and Mailing List
:font facename=default size=0x0.

:p.
You can get many fonts which are not in the basic :hp2.FIGlet:ehp2.
package by anonymous FTP from
:link reftype=launch object='explore.exe' data='ftp://ftp.nicoh.com/pub/figlet'.ftp&colon.//ftp&per.nicoh&per.com/pub/figlet:elink.
or the Web site
:link reftype=launch object='explore.exe' data='http://st-www.cs.uiuc.edu/~chai/figlet.html'.http&colon.//st-www&per.cs&per.uiuc&per.edu/~chai/figlet.html:elink.&per.
They should also contain the latest version of :hp2.FIGlet:ehp2. and other
utilities related to :hp2.FIGlet:ehp2.&per.

:p.
We run an e-mail list dedicated to :hp2.FIGlet:ehp2. software and font
announcements, as well as general discussion about :hp2.FIGlet:ehp2.&per.
If you would like to be on this list, send e-mail to
listserv@vmd.cso.uiuc.edu with the message body
:xmp.
      subscribe figlet-l YOUR NAME
:exmp.
:p.
where YOUR NAME should be replaced with your name.  For
those who don't want to be bothered with the discussions,
the list can be configured so that you only see software
update notices, or only software and font announcements.


:h1 id=authors.Authors

:font facename='Tms Rmn' size=30x24.
.ce Authors
:font facename=default size=0x0.

:p.
Glenn Chappell <ggc@uiuc.edu> did most of the work. You can
e-mail him but he is not an e-mail fanatic; people who e-
mail Glenn will probably get answers, but if you e-mail his
best friend:

:p.
Ian Chai <chai@uiuc.edu>, who is an e-mail fanatic, you'll
get answers, endless conversation about the mysteries of
life, invitations to join some 473 mailing lists and a free
toaster.  (Well, ok, maybe not the free toaster.)

:p.
Frank inspired this whole project with his .sig, but don't
e-mail him; he's decidedly an un-e-mail-fanatic.

:p.
Gilbert "The Mad Programmer" Healton <ghealton@nmia.com> added the
:hp2.-A:ehp2. option for version 2.1.1.  This option specified input from
the command line; it is still allowed, but has no effect.

:p.
John Cowan <cowan@ccil.org> added the -o, -s, -k, -S, and -W
options, and the support for Unicode mapping tables,
ISO 2022/HZ/Shift-JIS/UTF-8 input, and compressed fonts
and control files. He also revised this documentation,
with a lot of input from Paul Burton <solution@earthlink.net>.

:euserdoc.
