/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (sntp-opts.c)
 *  
 *  It has been AutoGen-ed  Wednesday June 28, 2006 at 07:29:32 AM EDT
 *  From the definitions    sntp-opts.def
 *  and the template file   options
 */

#define OPTION_CODE_COMPILE 1
#include "sntp-opts.h"

#ifdef  __cplusplus
extern "C" {
#endif
tSCC zCopyright[] =
       "sntp copyright (c) 1970-2006 ntp.org, all rights reserved";
tSCC zCopyrightNotice[] =
       
/* extracted from sntp-opts.def near line 10 */
"See the sntp/Copyright file";
extern tUsageProc optionUsage;

#ifndef NULL
#  define NULL 0
#endif
#ifndef EXIT_SUCCESS
#  define  EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#  define  EXIT_FAILURE 1
#endif
/*
 *  Ipv4 option description:
 */
tSCC    zIpv4Text[] =
        "Force IPv4 DNS name resolution";
tSCC    zIpv4_NAME[]               = "IPV4";
tSCC    zIpv4_Name[]               = "ipv4";
#define IPV4_FLAGS       (OPTST_DISABLED)

/*
 *  Ipv6 option description:
 */
tSCC    zIpv6Text[] =
        "Force IPv6 DNS name resolution";
tSCC    zIpv6_NAME[]               = "IPV6";
tSCC    zIpv6_Name[]               = "ipv6";
#define IPV6_FLAGS       (OPTST_DISABLED)

/*
 *  Normalverbose option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zNormalverboseText[] =
        "Slightly verbose";
tSCC    zNormalverbose_NAME[]      = "NORMALVERBOSE";
tSCC    zNormalverbose_Name[]      = "normalverbose";
static const int
    aNormalverboseCantList[] = {
    INDEX_OPT_EXTRAVERBOSE,
    INDEX_OPT_MEGAVERBOSE, NO_EQUIVALENT };
#define NORMALVERBOSE_FLAGS       (OPTST_DISABLED)

/*
 *  Extraverbose option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zExtraverboseText[] =
        "Extra verbose";
tSCC    zExtraverbose_NAME[]       = "EXTRAVERBOSE";
tSCC    zExtraverbose_Name[]       = "extraverbose";
static const int
    aExtraverboseCantList[] = {
    INDEX_OPT_NORMALVERBOSE,
    INDEX_OPT_MEGAVERBOSE, NO_EQUIVALENT };
#define EXTRAVERBOSE_FLAGS       (OPTST_DISABLED)

/*
 *  Megaverbose option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zMegaverboseText[] =
        "Mega verbose";
tSCC    zMegaverbose_NAME[]        = "MEGAVERBOSE";
tSCC    zMegaverbose_Name[]        = "megaverbose";
static const int
    aMegaverboseCantList[] = {
    INDEX_OPT_NORMALVERBOSE,
    INDEX_OPT_EXTRAVERBOSE, NO_EQUIVALENT };
#define MEGAVERBOSE_FLAGS       (OPTST_DISABLED)

/*
 *  Settimeofday option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zSettimeofdayText[] =
        "Set (step) the time with settimeofday()";
tSCC    zSettimeofday_NAME[]       = "SETTIMEOFDAY";
tSCC    zSettimeofday_Name[]       = "settimeofday";
static const int
    aSettimeofdayCantList[] = {
    INDEX_OPT_ADJTIME, NO_EQUIVALENT };
#define SETTIMEOFDAY_FLAGS       (OPTST_DISABLED)

/*
 *  Adjtime option description with
 *  "Must also have options" and "Incompatible options":
 */
tSCC    zAdjtimeText[] =
        "Set (slew) the time with adjtime()";
tSCC    zAdjtime_NAME[]            = "ADJTIME";
tSCC    zAdjtime_Name[]            = "adjtime";
static const int
    aAdjtimeCantList[] = {
    INDEX_OPT_SETTIMEOFDAY, NO_EQUIVALENT };
#define ADJTIME_FLAGS       (OPTST_DISABLED)

/*
 *  Help/More_Help/Version option descriptions:
 */
tSCC zHelpText[]       = "Display usage information and exit";
tSCC zHelp_Name[]      = "help";

tSCC zMore_HelpText[]  = "Extended usage information passed thru pager";
tSCC zMore_Help_Name[] = "more-help";

tSCC zVersionText[]    = "Output version information and exit";
tSCC zVersion_Name[]   = "version";

/*
 *  Save/Load_Opts option description:
 */
tSCC zSave_OptsText[]     = "Save the option state to a config file";
tSCC zSave_Opts_Name[]    = "save-opts";

tSCC zLoad_OptsText[]     = "Load options from a config file";
tSCC zLoad_Opts_NAME[]    = "LOAD_OPTS";

tSCC zNotLoad_Opts_Name[] = "no-load-opts";
tSCC zNotLoad_Opts_Pfx[]  = "no";
#define zLoad_Opts_Name   (zNotLoad_Opts_Name + 3)
/*
 *  Declare option callback procedures
 */
/* extracted from optmain.tpl near line 586 */

#if defined(TEST_SNTP_OPTS)
/*
 *  Under test, omit argument processing, or call optionStackArg,
 *  if multiple copies are allowed.
 */
extern tOptProc
    optionPagedUsage, optionVersionStderr;
static tOptProc
    doUsageOpt;

#else /* NOT defined TEST_SNTP_OPTS */
/*
 *  When not under test, there are different procs to use
 */
extern tOptProc
    optionPagedUsage, optionPrintVersion;
static tOptProc
    doUsageOpt;
#endif /* defined(TEST_SNTP_OPTS) */
#ifdef TEST_SNTP_OPTS
# define DOVERPROC optionVersionStderr
#else
# define DOVERPROC optionPrintVersion
#endif /* TEST_SNTP_OPTS */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Sntp Option Descriptions.
 */
static tOptDesc optDesc[ OPTION_CT ] = {
  {  /* entry idx, value */ 0, VALUE_OPT_IPV4,
     /* equiv idx, value */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ IPV4_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zIpv4Text, zIpv4_NAME, zIpv4_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_IPV6,
     /* equiv idx, value */ NOLIMIT, NOLIMIT,
     /* equivalenced to  */ INDEX_OPT_IPV4,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ IPV6_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zIpv6Text, zIpv6_NAME, zIpv6_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_NORMALVERBOSE,
     /* equiv idx, value */ 2, VALUE_OPT_NORMALVERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NORMALVERBOSE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aNormalverboseCantList,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zNormalverboseText, zNormalverbose_NAME, zNormalverbose_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_EXTRAVERBOSE,
     /* equiv idx, value */ 3, VALUE_OPT_EXTRAVERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ EXTRAVERBOSE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aExtraverboseCantList,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zExtraverboseText, zExtraverbose_NAME, zExtraverbose_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_MEGAVERBOSE,
     /* equiv idx, value */ 4, VALUE_OPT_MEGAVERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MEGAVERBOSE_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aMegaverboseCantList,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zMegaverboseText, zMegaverbose_NAME, zMegaverbose_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_SETTIMEOFDAY,
     /* equiv idx, value */ 5, VALUE_OPT_SETTIMEOFDAY,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SETTIMEOFDAY_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aSettimeofdayCantList,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zSettimeofdayText, zSettimeofday_NAME, zSettimeofday_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 6, VALUE_OPT_ADJTIME,
     /* equiv idx, value */ 6, VALUE_OPT_ADJTIME,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ ADJTIME_FLAGS, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aAdjtimeCantList,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zAdjtimeText, zAdjtime_NAME, zAdjtime_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                          | OPTST_ARG_OPTIONAL, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ DOVERPROC,
     /* desc, NAME, name */ zVersionText, NULL, zVersion_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ zHelpText, NULL, zHelp_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ zMore_HelpText, NULL, zMore_Help_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                          | OPTST_ARG_OPTIONAL, 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ zSave_OptsText, NULL, zSave_Opts_Name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, 0,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_DISABLE_IMM | \
			OPTST_SET_ARGTYPE(OPARG_TYPE_STRING), 0,
     /* last opt argumnt */ NULL,
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ zLoad_OptsText, zLoad_Opts_NAME, zLoad_Opts_Name,
     /* disablement strs */ zNotLoad_Opts_Name, zNotLoad_Opts_Pfx }
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the Sntp Option Environment
 */
tSCC   zPROGNAME[]   = "SNTP";
tSCC   zUsageTitle[] =
"sntp - standard SNTP program - Ver. 4.2.3p13\n\
USAGE:  %s [ -<flag> | --<name> ]...\n";
tSCC   zRcName[]     = ".ntprc";
tSCC*  apzHomeList[] = {
       "$HOME",
       ".",
       NULL };

tSCC   zBugsAddr[]    = "http://bugs.ntp.isc.org, bugs@ntp.org";
#define zExplain NULL
tSCC    zDetail[]     = "\n\
.I sntp\n\
can be used as a SNTP client to query a NTP or SNTP server and either display\n\
the time or set the local system's time (given suitable privilege).  It can be\n\
run as an interactive command, in a\n\
.I cron\n\
job or as a daemon.  It can be run as a daemon to provide a SNTP server for\n\
other clients.  NTP is the Network Time Protocol (RFC 1305) and SNTP is the\n\
Simple Network Time Protocol (RFC 2030, which supersedes RFC 1769).\n\
.SS Options\n\
.PP\n\
.I sntp\n\
recognizes the following options:\n\
.TP\n\
.B \\-v\n\
indicates that diagnostic messages for non-fatal errors and a limited amount of\n\
tracing should be written to standard error.  Fatal ones always produce a\n\
diagnostic.  This option should be set when there is a suspected problem with\n\
the server, network or the source.\n\
.TP\n\
.B \\-V\n\
requests more and less comprehensible output, mainly for investigating problems\n\
with apparently inconsistent timestamps.  This option should be set when the\n\
program fails with a message indicating that is the trouble.\n\
.TP\n\
.B \\-W\n\
requests very verbose debugging output, and will interfere with the timing\n\
when writing to the terminal (because of line buffered output from C).  Note\n\
that the times produced by this are the corrections needed, and not the error\n\
in the local clock.  This option should be set only when debugging the source.\n\
.TP\n\
.B \\-q\n\
indicates that it should query a daemon save file being maintained by it.\n\
This needs no privilege and will change neither the save file nor the clock.\n\
.PP\n\
The default is that it should behave as a client, and the following options\n\
are then relevant:\n\
.TP\n\
.B \\-r\n\
indicates that the system clock should be reset by\n\
.IR settimeofday .\n\
Naturally, this will work only if the user has enough privilege.\n\
.TP\n\
.B \\-a\n\
indicates that the system clock should be reset by\n\
.IR adjtime .\n\
Naturally, this will work only if the user has enough privilege.\n\
.PP\n\
The default is to write the estimated correct local date and time (i.e. not\n\
UTC) to the standard output in a format like\n\
.BR \"'1996 Oct 15 20:17:25.123 + 4.567 +/- 0.089 secs'\" ,\n\
where the\n\
.B \"'+ 4.567 +/- 0.089 secs'\"\n\
indicates the estimated error in the time on the local system.  In daemon mode,\n\
it will add drift information in a format like\n\
.BR \"' + 1.3 +/- 0.1 ppm'\" ,\n\
and display this at roughly\n\
.I separation\n\
intervals (see under the\n\
.B \\-x\n\
option for details).\n\
.TP\n\
.BI \\-l \" lockfile\"\n\
sets the name of the lock file to ensure that there is only\n\
one copy of\n\
.I sntp\n\
running at once.  The default is installation-dependent, but will usually be\n\
.IR /etc/sntp.pid .\n\
.TP\n\
.BI \\-e \" minerr\"\n\
sets the maximum ignorable variation between the clocks to\n\
.IR minerr .\n\
Acceptable values are from 0.001 to 1, and the default is 0.1 if a NTP host is\n\
is specified and 0.5 otherwise.\n\
.TP\n\
.BI \\-E \" maxerr\"\n\
sets the maximum value of various delays that are deemed acceptable to\n\
.IR maxerr .\n\
Acceptable values are from 1 to 60, and the default is 5.  It should sometimes\n\
be increased if there are problems with the network, NTP server or system\n\
clock, but take care.\n\
.TP\n\
.BI \\-P  \" prompt\"\n\
sets the maximum clock change that will be made automatically to\n\
.IR maxerr .\n\
Acceptable values are from 1 to 3600 or\n\
.IR no ,\n\
and the default is 30.  If the program is being run interactively in ordinary\n\
client mode, and the system clock is to be changed, larger corrections will\n\
prompt the user for confirmation.  Specifying\n\
.I no\n\
will disable this and the correction will be made regardless.\n\
.TP\n\
.BI \\-c \" count\"\n\
sets the maximum number of NTP packets required to\n\
.IR count .\n\
Acceptable values are from 1 to 25 if a NTP host is specified and from 5 to 25\n\
otherwise, and the default is 5.  If the maximum isn't enough, the system needs\n\
a better consistency algorithm than this program uses.\n\
.TP\n\
.BI \\-d \" delay\"\n\
sets a rough limit on the total running time to\n\
.I delay\n\
seconds.  Acceptable values are from 1 to 3600, and the default is 15 if a NTP\n\
host is specified and 300 otherwise.\n\
.TP\n\
.BI \\-x \" separation\"\n\
causes the program to run as a daemon (i.e. forever), and to estimate and \n\
correct for the clock drift.\n\
.I separation\n\
sets the minimum time between calls to the server in minutes if a NTP host is\n\
specified, and between broadcast packets if not.  Acceptable values are from 1\n\
to 1440 (a day), and the default (if\n\
.B \\-x\n\
is specified but\n\
.I separation\n\
is omitted) is 300.\n\
.TP\n\
.BI \\-f \" savefile\"\n\
may be used with the\n\
.B \\-x\n\
option to store a record of previous packets, which speeds up recalculating\n\
the drift after\n\
.I sntp\n\
has to be restarted (e.g. because of network or server outages).  In order to\n\
restart the data,\n\
.I sntp\n\
must be restarted reasonably soon after it died (within a few times the value of\n\
.IR separation ),\n\
with the same value of the\n\
.B \\-c\n\
option, the same value of\n\
.IR separation ,\n\
in the same mode (i.e. broadcast or client), though the NTP servers need not\n\
be the same for client mode, and with compatible values of other settings.\n\
Note that the file will be created with the default ownerships and permissions,\n\
using standard C facilities.  The default is installation-dependent, but will\n\
usually be\n\
.IR /etc/sntp.state .\n\
.TP\n\
.B -4\n\
force IPv4 DNS resolution.\n\
.TP\n\
.B -6\n\
force IPv6 DNS resolution.\n\
.PP\n\
.B address(es)\n\
are the DNS names or IP numbers of hosts to use for the challenge and response\n\
protocol; if no names are given, the program waits for broadcasts.  Polling a\n\
server is vastly more reliable than listening to broadcasts.  Note that a\n\
single component numeric address is not allowed, to avoid ambiguities.  If\n\
more than one name is give, they will be used in a round-robin fashion.\n\
.PP\n\
Constraints:\n\
.IP\n\
.B minerr\n\
must be less than\n\
.B maxerr\n\
which must be less than\n\
.B delay\n\
(or, if a NTP host is not specified\n\
.BR delay / count \"),\"\n\
and\n\
.B count\n\
must be less than half of\n\
.BR delay .\n\
.IP\n\
In update mode,\n\
.B maxerr\n\
must be less than\n\
.BR prompt.\n\
.IP\n\
In daemon mode (i.e. when\n\
.B \\-x\n\
is specified),\n\
.B minerr\n\
must be less than\n\
.B maxerr\n\
which must be less than\n\
.B separation\n\
(note that this is in minutes, not seconds, but the numeric value is compared).\n\
.PP\n\
Note that none of the above values are closely linked to the limits described\n\
in the NTP protocol (RFC 1305).\n\
.SH USAGE\n\
The simplest use of this program is as an unprivileged command to check the\n\
current time and error in the local clock.  For example:\n\
.IP\n\
.B sntp ntpserver.somewhere\n\
.PP\n\
It can be run as a unprivileged background process to check on the clock drift\n\
as well as the current error; this will probably fail if the local clock is\n\
reset while it is running.  For example:\n\
.IP\n\
.B sntp -x ntpserver.somewhere > output 2>\\&1 \\&\n\
.PP\n\
With suitable privilege, it can be run as a command or in a\n\
.I cron\n\
job to reset the local clock from a reliable server, like the\n\
.I ntpdate\n\
and\n\
.I rdate\n\
commands.  For example:\n\
.IP\n\
.B sntp -a ntpserver.somewhere\n\
.PP\n\
It can also be run as a daemon to keep the local clock in step.  For example:\n\
.IP\n\
.B sntp -a -x ntpserver.somewhere > output 2>\\&1 \\&\n\
.PP\n\
More information on how to use this utility is given in the\n\
.I README\n\
file in the distribution.  In particular, this\n\
.I man\n\
page does not describe how to set it up as a server, which needs special care\n\
to avoid propagating misinformation.\n\
.SH RETURN VALUE\n\
When used as a client in non-daemon mode, the program returns a zero exit\n\
status for success, and a non-zero one otherwise. When used as a daemon\n\
(either client or server), it does not return except after a serious error.\n\
.SH BUGS\n\
The program implements the SNTP protocol, and does not provide all NTP \n\
facilities.  In particular, it contains no checks against any form of spoofing.\n\
If this is a serious concern, some network security mechanism (like a firewall\n\
or even just\n\
.IR tcpwrappers )\n\
should be installed.\n\
.PP\n\
There are some errors, ambiguities and inconsistencies in the RFCs, and this\n\
code may not interwork with all other NTP implementations.  Any unreasonable\n\
restrictions should be reported as bugs to whoever is responsible.  It may\n\
be difficult to find out who that is.\n\
.PP\n\
The program will stop as soon as it feels that things have got out of control.\n\
In client daemon mode, it will usually fail during an extended period of\n\
network or server inaccessibility or excessively slow performance, or when the\n\
local clock is reset by another process.  It will then need restarting\n\
manually.  Experienced system administrators can write a shell script, a\n\
.I cron\n\
job or put it in\n\
.IR inittab ,\n\
to do this automatically.\n\
.PP\n\
The error cannot be estimated reliably with broadcast packets or for the drift\n\
in daemon mode (even with client-server packets), and the guess made by the\n\
program may be wrong (possibly even very wrong).  If this is a problem, then\n\
setting the\n\
.B \\-c\n\
option to a larger value may help.  Or it may not.\n\
.SH AUTHOR\n\
.I sntp\n\
was developed by N.M. Maclaren of the University of Cambridge Computing\n\
Service.\n";
tSCC    zFullVersion[] = SNTP_FULL_VERSION;
/* extracted from optcode near line 321 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

tOptions sntpOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_ENVIRON
    + OPTPROC_NO_ARGS
    + OPTPROC_HAS_IMMED ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zCopyrightNotice,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage,       /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP,
      INDEX_OPT_SAVE_OPTS,
      NO_EQUIVALENT /* index of '-#' option */,
      NO_EQUIVALENT /* index of default opt */
    },
    OPTION_CT, 7 /* user option count */
};

/*
 *  Create the static procedure(s) declared above.
 */
static void
doUsageOpt(
    tOptions*   pOptions,
    tOptDesc*   pOptDesc )
{
    USAGE( EXIT_SUCCESS );
}
/* extracted from optmain.tpl near line 92 */

#if defined(TEST_SNTP_OPTS) /* TEST MAIN PROCEDURE: */

int
main( int argc, char** argv )
{
    int res = EXIT_SUCCESS;
    (void)optionProcess( &sntpOptions, argc, argv );
    {
        void optionPutShell( tOptions* );
        optionPutShell( &sntpOptions );
    }
    return res;
}
#endif  /* defined TEST_SNTP_OPTS */
/* extracted from optcode near line 418 */

#if ENABLE_NLS
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <autoopts/usage-txt.h>

static char*
AO_gettext( const char* pz )
{
    char* pzRes;
    if (pz == NULL)
        return NULL;
    pzRes = _(pz);
    if (pzRes == pz)
        return pzRes;
    pzRes = strdup( pzRes );
    if (pzRes == NULL) {
        fputs( _("No memory for duping translated strings\n"), stderr );
        exit( EXIT_FAILURE );
    }
    return pzRes;
}

/*
 *  This invokes the translation code (e.g. gettext(3)).
 */
static void
translate_option_strings( void )
{
    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_usage_text.field_ct == 0)
        return;
    /*
     *  Do the translations.  The first pointer follows the field count field.
     *  The field count field is the size of a pointer.
     */
    {
        char** ppz = (char**)(void*)&(option_usage_text);
        int    ix  = option_usage_text.field_ct;

        do {
            ppz++;
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
    }
    option_usage_text.field_ct = 0;

    {
        tOptDesc* pOD = sntpOptions.pOptDesc;
        int       ix  = sntpOptions.optCt;

        for (;;) {
            pOD->pzText           = AO_gettext(pOD->pzText);
            pOD->pz_NAME          = AO_gettext(pOD->pz_NAME);
            pOD->pz_Name          = AO_gettext(pOD->pz_Name);
            pOD->pz_DisableName   = AO_gettext(pOD->pz_DisableName);
            pOD->pz_DisablePfx    = AO_gettext(pOD->pz_DisablePfx);
            if (--ix <= 0)
                break;
            pOD++;
        }
    }
    sntpOptions.pzCopyright   = AO_gettext(sntpOptions.pzCopyright);
    sntpOptions.pzCopyNotice  = AO_gettext(sntpOptions.pzCopyNotice);
    sntpOptions.pzFullVersion = AO_gettext(sntpOptions.pzFullVersion);
    sntpOptions.pzUsageTitle  = AO_gettext(sntpOptions.pzUsageTitle);
    sntpOptions.pzExplain     = AO_gettext(sntpOptions.pzExplain);
    sntpOptions.pzDetail      = AO_gettext(sntpOptions.pzDetail);
}

#endif /* ENABLE_NLS */

#ifdef  __cplusplus
}
#endif
