#!/bin/sh
#
# mkmodindex.sh: search for *.mdd files, and index the modules
#
# $@ = directories to search from
#

echo "# module index generated by mkmodindex.sh"
echo

module_list=' '
while test $# -ne 0; do
    dir=$1
    shift
    ( set $dir/*.mdd; test -f $1 ) || continue
    dosubs=false
    for mod in `echo '' $dir/*.mdd '' | sed 's, [^ ]*/, ,g;s,\.mdd , ,g'`; do
	case `echo "$mod@ $module_list " | sed 's,^.*[^_0-9A-Za-z].*@,@@,'` in
	    @@*)
		echo >&2 "WARNING: illegally named module \`$mod' in $dir"
		echo >&2 "         (ignoring it)"
		;;
	    *@*" $mod "*)
		eval "loc=\$loc_$mod"
		echo >&2 "WARNING: module \`$mod' (in $loc) duplicated in $dir"
		echo >&2 "         (ignoring duplicate)"
		dosubs=true
		;;
	    *)
		module_list="$module_list$mod "
		echo "loc_$mod=$dir"
		eval "loc_$mod=\$dir"
		dosubs=true
		;;
	esac
    done
    $dosubs && set `echo $dir/*/. '' | sed 's,/\. , ,g'` "$@"
done

echo
echo $module_list | sed 's/^/module_list="/;s/$/"/'

exit 0
