/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include "shell.h"
#include "cmds.h"
#include <pwd.h>

/* this ought to be put in a header file */
struct command cmds[] = {
  {"alias",CMD_ALIAS},
  {"assign",CMD_ASSIGN},
  {"bg",CMD_BG},
  {"break",CMD_BREAK},
  {"cd",CMD_CD},
  {"continue",CMD_CONTINUE},
  {"dec",CMD_DEC},
  {"else",CMD_ELSE},
  {"endfor",CMD_ENDFOR},
  {"endif",CMD_ENDIF},
  {"endsw",CMD_ENDSW},
  {"eval",CMD_EVAL},
  {"exec",CMD_EXEC},
  {"exit",CMD_EXIT},
  {"fg",CMD_FG},
  {"for",CMD_FOR},
  {"foreach",CMD_FOREACH},
  {"goto",CMD_GOTO},
  {"history",CMD_HISTORY},
  {"if",CMD_IF},
  {"inc",CMD_INC},
  {"input",CMD_INPUT},
  {"intr",CMD_INTR},
  {"jobs",CMD_JOBS},
  {"key",CMD_KEY},
  {"label",CMD_LABEL},
  {"limit",CMD_LIMIT},
  {"login",CMD_LOGIN},
  {"logout",CMD_LOGOUT},
  {"next",CMD_NEXT},
  {"nset",CMD_SET},
  {"protect",CMD_PROTECT},
  {"repeat",CMD_REPEAT},
  {"sclose",CMD_SCLOSE},
  {"secho",CMD_SECHO},
  {"set",CMD_SET},
  {"setenv",CMD_SETENV},
  {"shift",CMD_SHIFT},
  {"sopen",CMD_SOPEN},
  {"source",CMD_SOURCE},
  {"sread",CMD_SREAD},
  {"sseek",CMD_SSEEK},
  {"stop",CMD_STOP},
  {"switch",CMD_SWITCH},
  {"swrite",CMD_SWRITE},
  {"term",CMD_TERM},
  {"umask",CMD_UMASK},
  {"unalias",CMD_UNALIAS},
  {"unassign",CMD_UNASSIGN},
  {"unkey",CMD_UNKEY},
  {"unlimit",CMD_UNLIMIT},
  {"unset",CMD_UNSET},
  {"unsetenv",CMD_UNSETENV},
  {"until",CMD_UNTIL},
  {"usage",CMD_USAGE},
  {"version",CMD_VERSION},
  {"wend",CMD_WEND},
  {"while",CMD_WHILE}
};
char *getword(), **evalwrd(), **exe(), *malloc(), *strcpy();
extern int _maxhist, curhist, _status, _pgrp, max_ent;
extern char **history, str[256], _loginshell, _inpipe;
extern struct proc_tab *proc;
extern struct set_vars **set;
extern char buf[1025],path[1025];

char flg;

add_history(str)
char *str;
{
  int i;

  if ((strlen(str) == 0) || (curhist > 0 && !strcmp(str,history[curhist-1]))) return;
  if (curhist == _maxhist) {
    free(history[0]);
    for(i=0;i<_maxhist-1;i++) history[i] = history[i+1];
    curhist--;
  }
  history[curhist++] = strcpy(malloc(strlen(str)+1),str);
}

/*
 *  Parse out our line to break it up into itty-bitty words we can deal with.
 */

char ***split_line(str)
char *str;
{
  char ***tmp = NULL,*stmp=str, **t;
  int i,x = 0, y = 0, max;

  flg = 0;
  tmp = (char ***)malloc(sizeof(char **) * 2);	/* # of sentences */
  tmp[0] = (char **)calloc(max = 3, sizeof(char *));	/* # of words in sentence */

  buf[0] = 0;
  do {
    stmp = getword(buf,stmp);
    if (!*buf) continue;
    if (!strcmp("(",buf)) flg++;
    if (!strcmp(")",buf) && flg) flg--;
    if (buf[0] == '`') {
      if (!(t = (char **)exe(buf))) continue;
      for(i=0;t[i];i++);
      if (y+i >= (max-1)) tmp[x] = (char **)realloc(tmp[x],sizeof(char *) * (max=y+i+4));
      for (i=0;t[i];i++) tmp[x][y++] = t[i];
      free(t);
      continue;
    }
    if (!strcmp(";",buf) && !flg) {
      if (y == 0) continue;
      tmp[x++][y] = NULL;
      tmp = (char ***)realloc(tmp,sizeof(char **) * (x+2));
      y = 0;
      tmp[x] = (char **)malloc(sizeof(char *) * (max = 3));
    } else {
      if (y == (max-1)) tmp[x] = (char **)realloc(tmp[x],sizeof(char *) * (max+=4));
      tmp[x][y] = (char *)malloc(strlen(buf)+1);
      strcpy(tmp[x][y++],buf);
      if (buf[0] == '&' && (!buf[1] || buf[1] == '!') && !flg) {
        tmp[x++][y] = NULL;
	tmp = (char ***)realloc(tmp,sizeof(char **) * (x+2));
	y = 0;
	tmp[x] = (char **)malloc(sizeof(char *) * (max = 3));
      }
    }
  } while (*stmp);
  tmp[x++][y] = NULL;
  tmp[x] = NULL;
  return tmp;
}

char *getword(wrd,s)
char *wrd,*s;
{
  char t=0;

  while(*s == ' ' || *s == '\t') s++;
  switch (*wrd++ = *s++) {
    case ';':
    case '(':
    case ')':
      *wrd = 0;
      return s;
    case 0:
      return --s;
    case '&':
      if (*s == '!' || *s == '&' || *s == '=') *wrd++ = *s++;
      *wrd = 0;
      return s;
    case '|':
      if (*s == '!' || *s == '&' || *s == '|' || *s == '=') *wrd++ = *s++;
      *wrd = 0;
      return s;
    case '>':
      t = FALSE;
      if (*s != '=') {
        if (*s == '%') {
	  *wrd++ = *s++;
	  *wrd = 0;
	  return s;
	}
	if (*s == '>') *wrd++ = *s++;
	if (*s == '!' || *s == '&' || *s == '=') *wrd++ = *s++;
	if (*s == '%') *wrd++ = *s++;
      } else *wrd++ = *s++;
      *wrd = 0;
      return s;
    case '"':
    case '`':
    case '\'':
      t = *(s-1);
      while(*wrd = *s++) {
	if (*wrd == '\\') {
	  if (t != '`') {
	    switch(*s++) {
	      case 'e':
		*wrd = '\033';
		break;
	      case 'n':
		*wrd = '\n';
		break;
	      case 'r':
		*wrd = '\r';
		break;
	      case 't':
		*wrd = '\t';
		break;
	      case 'b':
		*wrd = '\b';
		break;
	      case 'a':
		*wrd = '\007';
		break;
	      case 'f':
		*wrd = '\014';
		break;
	      case '0':
		*wrd = 0;
		while (*s >= '0' && *s <= '7') {
		  *wrd <<= 3;
		  *wrd |= *s++ - '0';
		}
		if (!*wrd) --wrd;
		break;
	      case '$':
		if (t == '"') *wrd++ = '\\';
		*wrd = '$';
		break;
	      default:
		*wrd = *(s-1);
		break;
	    }
	  } else *wrd = *(s-1);
	}
	else if(*wrd == t) {
	  *++wrd = 0;
	  return s;
	}
	if (!*wrd) break;
	wrd++;
      }
      *wrd++ = t;
      *wrd = 0;
      return --s;
    case '<':
      if (*s == '<') *wrd++ = *s++;
      if (*s == '%') {
	*wrd++ = *s++;
	*wrd = 0;
	return s;
      }
    case '=':
      if (*s == '=') *wrd++ = *s++;
      *wrd = 0;
      return s;
    case '$':
      if (*s == '<') *wrd++ = *s++;
      break;
    case '#':
      if (!flg) {
	*--wrd = 0;
	*s = 0;
	return s;
      }
      break;
    case '!':
      if (*s == '=') {
        *wrd++ = *s++;
	*wrd = 0;
	return s;
      }
      break;
    case '\\':
      *wrd--;
      *wrd++ = *s++;
      break;
  }
  while(*wrd = *s++){
    switch(*wrd) {
      case ';':
      case '&':
      case '|':
      case '<':
      case '>':
      case ' ':
      case '(':
      case ')':
      case '\t':
	*wrd = 0;
	return --s;
      case '\\':
	*wrd = *s++;
	break;
      default:
	break;
    }
    wrd++;
  }
  return --s;
}

/*
 * check for builtin commands here...
 */

parse_arg(cmd,in,inf,out,outf,outa,err,errf,erra,bg)
char **cmd, *inf, *outf, *errf, outa, erra, bg;
int in, out, err;
{
  int i,pid,ent;
  int start=0,end=MAX_CMD,mid=MAX_CMD/2,found=FALSE;

  while(start<=end) {
    if (!(i = strcmp(cmd[0],cmds[mid].cmd))) {
      found = TRUE;
      break;
    }
    if (i<0) end = mid-1;
    else start = mid+1;
    mid = (start+end)/2;
  }

  if (!found) return NORMAL_COMMAND;

  pid = execute(cmds[mid].val,cmd,in,inf,out,outf,outa,err,errf,erra,bg);
  if (pid > 0) {
    ent = get_proc_ent(pid,TRUE);
    proc[ent].cmd = (char *)malloc(strlen(cmd[0])+1);
    strcpy(proc[ent].cmd,cmd[0]);
    printf(" [%d] (%d) %s\n",ent,pid,cmd[0]);
  }
  return SHELL_COMMAND;
}

free_arg(arg)
char ***arg;
{
  int i,j;
  if (!arg) return;
  for(i=0;arg[i];i++) {
    for(j=0;arg[i][j];j++) free(arg[i][j]);
    free(arg[i]);
  }
  free(arg);
}

free_list(lst)
char **lst;
{
  int i;
  for(i=0;lst[i];i++) free(lst[i]);
  free(lst);
}

/*
 * This is bad... needs to be replaced to use to the shells run2() command
 * somehow...  probably by using shell level pipes eh?
 */
char **exe(cmd)
char *cmd;
{
  char *c, *s, **t;
  int n,i,j,p[2];
  union wait status;

  pipe(p);
  if ((i = fork()) < 0) return NULL;
  if (i) {
    close(p[1]);
    s = (char *)malloc(1025);
    i = 0;
    while((n = read(p[0],buf,1024)) > 0) {
      buf[n] = 0;
      for(j=0;j<n;j++) if (buf[j] == '\n') buf[j] = ' ';
      if (i) s = (char *)realloc(s,i+n+1);
      strcpy(s+i,buf);
      i += n;
    }
    s[i] = 0;
    close(p[0]);
    c = s;
    t = (char **)calloc(n=5,sizeof(char *));
    i = 0;
    flg = 1;
    do {
      s = getword(buf,s);
      if (!*buf) continue;
      if (i == n) t = (char **)realloc(t,sizeof(char *) * (n += 5));
      t[i++] = (char *)strcpy((char *)malloc(strlen(buf)+1),buf);
    } while (*s);
    if (i == n) t = (char **)realloc(t,sizeof(char *) * (++n));
    t[i] = NULL;
    free(c);
    wait(&status);
    return t;
  } else {
    _inpipe = TRUE;
    _pgrp = getpgrp(0);
    _loginshell = FALSE;
    for(i=0;i<max_ent;i++)
      if (proc[i].pid) {
	if (proc[i].cmd) free(proc[i].cmd);
	proc[i].pid = 0;
      }
    close(1);
    close(2);
    dup(p[1]);
    dup(p[1]);
    close(p[1]);
    c = (char *)strcpy((char *)malloc(strlen(cmd)),cmd+1);
    c[strlen(c)-1] = 0;
    run2(c);
    close(1);
    close(2);
    exit(_status);
  }
}
