/* Copyright 1992 by Simmule R. Turner

   Permission is granted to make and distribute VERBATIM copies
   of this software provided the above copyright notice and this
   permission notice are preserved in all copies.

   ALL other rights are reserved.

   NO WARRANTY is provided with this software. */


#ifndef SIZE_T
#define SIZE_T unsigned
#endif

#ifndef CONST
#ifdef __STDC__
#define CONST const
#else
#define CONST
#endif
#endif


#ifdef __STDC__
# define P(s) s
#else
# define P(s) ()
#endif

/* editline.c */
extern char *readline P((char *prompt ));

/* complete.c */
extern char *complete P((char *pathname , int *unique ));
extern int list_possible P((char *pathname , char ***argp ));

/* history.c */
extern void add_history P((char *line ));
extern char *next_history P((void ));
extern char *previous_history P((void ));
extern char *newest_history P((void ));
extern char *oldest_history P((void ));
extern char *search_history P((char *search_for , int direction ));

#ifdef memmove
/* memmove.c */
extern void *memmove P((void *, CONST void *, SIZE_T ));
#endif
#undef P
