/* Copyright 1992 by Simmule R. Turner

   Permission is granted to make and distribute VERBATIM copies
   of this software provided the above copyright notice and this
   permission notice are preserved in all copies.

   ALL other rights are reserved.

   NO WARRANTY is provided with this software. */


#include "readline.h"
#include "history.h"


void add_history(line)
char *line;
{   h_position = (-1);
#ifdef XXX
    if (h_number && !strcmp(line, h_lines[xposition(-1, -1)]))
        return;
#endif

    if (h_lines[h_next])
        free(h_lines[h_next]);

    if ((h_lines[h_next] = xstrsave(line)) != NULL)
    {   h_next = (h_next + 1) % HIST_SIZE;
        ++h_number;
    }
}

char *next_history()
{   if (h_position >= 0)
    {   if (h_lines[h_position = xposition(h_position, 1)])
            return (h_lines[h_position]);
    }
    return (NULL);
}

char *previous_history()
{   int old_position = h_position;


    if (h_lines[h_position = xposition(h_position, -1)])
        return (h_lines[h_position]);
    h_position = old_position;
    return (NULL);
}

char *newest_history()
{   h_position = (-1);
    return (h_lines[xposition(-1, -1)]);
}

char *oldest_history()
{   h_position = (-1);
    return (h_lines[xposition(-1, 1)]);
}

static int xposition(next, direction)
int next;
int direction;
{
/* BUG: */ 
    return ((next == (-1)) ?
            ((direction < 0) ?
                 (h_next + HIST_SIZE - 1) % HIST_SIZE :
                 (h_number > HIST_SIZE) ? (h_next % HIST_SIZE) : 0) :
            ((h_number > HIST_SIZE) ?
                 ((direction < 0) ?
                      (next + HIST_SIZE - 1) % HIST_SIZE :
                      (next + 1) % HIST_SIZE) :
                 ((direction < 0) ?
                      (next + h_number - 1) % h_number :
                      (next + 1) % h_number)));
}

char *search_history(search_for, direction)
char *search_for;
int direction;
{   static char *old_search_string = NULL;
    static int next;
    static int old_direction;
    int entries;


    if (search_for && *search_for)
        next = xposition(-1, direction);
    else
    {   if (old_search_string && *old_search_string)
            search_for = old_search_string;
        else
            return (NULL);
        if (direction > 0)
            direction = -old_direction;
        next = xposition(next, direction);
    }
    old_direction = direction;

    entries = (h_number > HIST_SIZE) ? HIST_SIZE: h_number;
    for (; entries > 0; --entries)
    {   if ((*search_for == '^') ?
            !strncmp(h_lines[next], search_for+1, strlen(search_for+1)):
            xstrstr(h_lines[next], search_for))
        {   if (search_for != old_search_string)
            {   if (old_search_string)
                    free(old_search_string);
                old_search_string = xstrsave(search_for);
            }
            return (h_lines[next]);
        }
        next = xposition(next, direction);
    }
    return (NULL);
}

static char *xstrsave(line)
char *line;
{   SIZE_T len = strlen(line) + 1;
    char *p = malloc(len);


    if (p)
        (void) memmove(p, line, len);

    return (p);
}

static int xstrstr(sch, pat)
char *sch;
char *pat;
{   char *p;
    SIZE_T len;
    int f;


    if ((f = *pat) == '\0')
        return (sch != '\0');
    len = strlen(pat);
    for (p = sch; *p; p++)
        if ((f == *p) && (strncmp(p, pat, len) == 0))
            return (1);
    return (0);
}
