/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PackedImageData;
import javax.media.jai.UnpackedImageData;

public final class PixelAccessor {
    public static final int TYPE_BIT = -1;
    public final SampleModel sampleModel;
    public final ColorModel colorModel;
    public final boolean isComponentSM;
    public final boolean isMultiPixelPackedSM;
    public final boolean isSinglePixelPackedSM;
    public final int sampleType;
    public final int bufferType;
    public final int transferType;
    public final int numBands;
    public final int[] sampleSize;
    public final boolean isPacked;
    public final boolean hasCompatibleCM;
    public final boolean isComponentCM;
    public final boolean isIndexCM;
    public final boolean isPackedCM;
    public final int componentType;
    public final int numComponents;
    public final int[] componentSize;

    private static SampleModel getSampleModel(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return renderedImage.getSampleModel();
    }

    public PixelAccessor(RenderedImage renderedImage) {
        this(PixelAccessor.getSampleModel(renderedImage), renderedImage.getColorModel());
    }

    public PixelAccessor(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.sampleModel = sampleModel;
        this.colorModel = colorModel;
        this.isComponentSM = this.sampleModel instanceof ComponentSampleModel;
        this.isMultiPixelPackedSM = this.sampleModel instanceof MultiPixelPackedSampleModel;
        this.isSinglePixelPackedSM = this.sampleModel instanceof SinglePixelPackedSampleModel;
        this.bufferType = this.sampleModel.getDataType();
        this.transferType = this.sampleModel.getTransferType();
        this.numBands = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
        this.sampleType = this.isComponentSM ? this.bufferType : PixelAccessor.getType(this.sampleSize);
        this.isPacked = this.sampleType == -1 && this.numBands == 1;
        boolean bl = this.hasCompatibleCM = this.colorModel != null && JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel);
        if (this.hasCompatibleCM) {
            this.isComponentCM = this.colorModel instanceof ComponentColorModel;
            this.isIndexCM = this.colorModel instanceof IndexColorModel;
            this.isPackedCM = this.colorModel instanceof PackedColorModel;
            this.numComponents = this.colorModel.getNumComponents();
            this.componentSize = this.colorModel.getComponentSize();
            int n = PixelAccessor.getType(this.componentSize);
            this.componentType = n == -1 ? 0 : n;
        } else {
            this.isComponentCM = false;
            this.isIndexCM = false;
            this.isPackedCM = false;
            this.numComponents = this.numBands;
            this.componentSize = this.sampleSize;
            this.componentType = this.sampleType;
        }
    }

    private static int getType(int[] nArray) {
        int n = nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            n = Math.max(n, nArray[n2]);
            ++n2;
        }
        int n3 = n < 1 ? 32 : (n == 1 ? -1 : (n <= 8 ? 0 : (n <= 16 ? 1 : (n <= 32 ? 3 : (n <= 64 ? 5 : 32)))));
        return n3;
    }

    public static int getPixelType(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel ? sampleModel.getDataType() : PixelAccessor.getType(sampleModel.getSampleSize());
    }

    public static int getDestPixelType(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = 32;
        int n2 = vector.size();
        if (n2 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            n = PixelAccessor.getPixelType(sampleModel);
            int n3 = 1;
            while (n3 < n2) {
                renderedImage = (RenderedImage)vector.get(n3);
                sampleModel = renderedImage.getSampleModel();
                int n4 = PixelAccessor.getPixelType(sampleModel);
                n = n == 1 && n4 == 2 || n == 2 && n4 == 1 ? 3 : Math.max(n, n4);
                ++n3;
            }
        }
        return n;
    }

    public static int getDestNumBands(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = 0;
        int n2 = vector.size();
        if (n2 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            n = sampleModel.getNumBands();
            int n3 = 1;
            while (n3 < n2) {
                renderedImage = (RenderedImage)vector.get(n3);
                sampleModel = renderedImage.getSampleModel();
                int n4 = sampleModel.getNumBands();
                n = n == 1 || n4 == 1 ? Math.max(n, n4) : Math.min(n, n4);
                ++n3;
            }
        }
        return n;
    }

    public static boolean isPackedOperation(PixelAccessor[] pixelAccessorArray, PixelAccessor pixelAccessor) {
        boolean bl = pixelAccessor.isPacked;
        if (bl && pixelAccessorArray != null) {
            int n = 0;
            while (n < pixelAccessorArray.length) {
                boolean bl2 = bl = bl && pixelAccessorArray[n].isPacked;
                if (!bl) break;
                ++n;
            }
        }
        return bl;
    }

    public static boolean isPackedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2) {
        return pixelAccessor.isPacked && pixelAccessor2.isPacked;
    }

    public static boolean isPackedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2, PixelAccessor pixelAccessor3) {
        return pixelAccessor.isPacked && pixelAccessor2.isPacked && pixelAccessor3.isPacked;
    }

    public UnpackedImageData getPixels(Raster raster, Rectangle rectangle, int n, boolean bl) {
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if (n < this.sampleType || this.sampleType == 1 && n == 2) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor2"));
        }
        if (this.isComponentSM) {
            return this.getPixelsCSM(raster, rectangle, n, bl);
        }
        int n2 = rectangle.width * rectangle.height * this.numBands;
        Object object = null;
        switch (n) {
            case 0: {
                byte[] byArray;
                if (bl) {
                    byArray = new byte[n2];
                } else if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    byArray = (byte[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                } else {
                    byArray = new byte[n2];
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray[n3] = (byte)(nArray[n3] & 0xFF);
                        ++n3;
                    }
                }
                object = this.repeatBand(byArray, this.numBands);
                break;
            }
            case 1: {
                short[] sArray;
                if (bl) {
                    sArray = new short[n2];
                } else if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    sArray = (short[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                } else {
                    sArray = new short[n2];
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    int n4 = 0;
                    while (n4 < n2) {
                        sArray[n4] = (short)(nArray[n4] & 0xFFFF);
                        ++n4;
                    }
                }
                object = this.repeatBand(sArray, this.numBands);
                break;
            }
            case 2: {
                short[] sArray = new short[n2];
                if (!bl) {
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    int n5 = 0;
                    while (n5 < n2) {
                        sArray[n5] = (short)nArray[n5];
                        ++n5;
                    }
                }
                object = this.repeatBand(sArray, this.numBands);
                break;
            }
            case 3: {
                return this.getPixelsInt(raster, rectangle, bl);
            }
            case 4: {
                return this.getPixelsFloat(raster, rectangle, bl);
            }
            case 5: {
                return this.getPixelsDouble(raster, rectangle, bl);
            }
        }
        return new UnpackedImageData(raster, rectangle, n, object, this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsCSM(Raster raster, Rectangle rectangle, int n, boolean bl) {
        boolean bl2;
        int[] nArray;
        int n2;
        int n3;
        Object object = null;
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        if (n == this.sampleType) {
            DataBuffer dataBuffer = raster.getDataBuffer();
            int[] nArray2 = componentSampleModel.getBankIndices();
            switch (this.sampleType) {
                case 0: {
                    byte[][] byArray = ((DataBufferByte)dataBuffer).getBankData();
                    byte[][] byArrayArray = new byte[this.numBands][];
                    int n4 = 0;
                    while (n4 < this.numBands) {
                        byArrayArray[n4] = byArray[nArray2[n4]];
                        ++n4;
                    }
                    object = byArrayArray;
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = this.sampleType == 1 ? ((DataBufferUShort)dataBuffer).getBankData() : ((DataBufferShort)dataBuffer).getBankData();
                    short[][] sArrayArray = new short[this.numBands][];
                    int n5 = 0;
                    while (n5 < this.numBands) {
                        sArrayArray[n5] = sArray[nArray2[n5]];
                        ++n5;
                    }
                    object = sArrayArray;
                    break;
                }
                case 3: {
                    int[][] nArray3 = ((DataBufferInt)dataBuffer).getBankData();
                    int[][] nArrayArray = new int[this.numBands][];
                    int n6 = 0;
                    while (n6 < this.numBands) {
                        nArrayArray[n6] = nArray3[nArray2[n6]];
                        ++n6;
                    }
                    object = nArrayArray;
                    break;
                }
                case 4: {
                    float[][] fArray = DataBufferUtils.getBankDataFloat(dataBuffer);
                    float[][] fArrayArray = new float[this.numBands][];
                    int n7 = 0;
                    while (n7 < this.numBands) {
                        fArrayArray[n7] = fArray[nArray2[n7]];
                        ++n7;
                    }
                    object = fArrayArray;
                    break;
                }
                case 5: {
                    double[][] dArray = DataBufferUtils.getBankDataDouble(dataBuffer);
                    double[][] dArrayArray = new double[this.numBands][];
                    int n8 = 0;
                    while (n8 < this.numBands) {
                        dArrayArray[n8] = dArray[nArray2[n8]];
                        ++n8;
                    }
                    object = dArrayArray;
                }
            }
            n3 = componentSampleModel.getPixelStride();
            n2 = componentSampleModel.getScanlineStride();
            int[] nArray4 = dataBuffer.getOffsets();
            int n9 = rectangle.x - raster.getSampleModelTranslateX();
            int n10 = rectangle.y - raster.getSampleModelTranslateY();
            nArray = new int[this.numBands];
            int n11 = 0;
            while (n11 < this.numBands) {
                nArray[n11] = componentSampleModel.getOffset(n9, n10, n11) + nArray4[nArray2[n11]];
                ++n11;
            }
            bl2 = false;
        } else {
            switch (n) {
                case 3: {
                    return this.getPixelsInt(raster, rectangle, bl);
                }
                case 4: {
                    return this.getPixelsFloat(raster, rectangle, bl);
                }
                case 5: {
                    return this.getPixelsDouble(raster, rectangle, bl);
                }
            }
            int n12 = rectangle.width * rectangle.height * this.numBands;
            short[] sArray = new short[n12];
            if (!bl) {
                UnpackedImageData unpackedImageData = this.getPixelsCSM(raster, rectangle, this.sampleType, bl);
                byte[][] byArray = unpackedImageData.getByteData();
                int n13 = 0;
                while (n13 < this.numBands) {
                    byte[] byArray2 = byArray[n13];
                    int n14 = unpackedImageData.getOffset(n13);
                    int n15 = n13;
                    int n16 = 0;
                    while (n16 < rectangle.height) {
                        int n17 = n14;
                        n14 += unpackedImageData.lineStride;
                        int n18 = 0;
                        while (n18 < rectangle.width) {
                            sArray[n15] = (short)(byArray2[n17] & 0xFF);
                            n17 += unpackedImageData.pixelStride;
                            n15 += this.numBands;
                            ++n18;
                        }
                        ++n16;
                    }
                    ++n13;
                }
            }
            object = this.repeatBand(sArray, this.numBands);
            n3 = this.numBands;
            n2 = n3 * rectangle.width;
            nArray = this.getInterleavedOffsets(this.numBands);
            bl2 = bl & raster instanceof WritableRaster;
        }
        return new UnpackedImageData(raster, rectangle, n, object, n3, n2, nArray, bl2);
    }

    private UnpackedImageData getPixelsInt(Raster raster, Rectangle rectangle, boolean bl) {
        int n = rectangle.width * rectangle.height * this.numBands;
        int[] nArray = bl ? new int[n] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
        return new UnpackedImageData(raster, rectangle, 3, this.repeatBand(nArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsFloat(Raster raster, Rectangle rectangle, boolean bl) {
        int n = rectangle.width * rectangle.height * this.numBands;
        float[] fArray = bl ? new float[n] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float[])null);
        return new UnpackedImageData(raster, rectangle, 4, this.repeatBand(fArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsDouble(Raster raster, Rectangle rectangle, boolean bl) {
        int n = rectangle.width * rectangle.height * this.numBands;
        double[] dArray = bl ? new double[n] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (double[])null);
        return new UnpackedImageData(raster, rectangle, 5, this.repeatBand(dArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl & raster instanceof WritableRaster);
    }

    private byte[][] repeatBand(byte[] byArray, int n) {
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byArrayArray[n2] = byArray;
            ++n2;
        }
        return byArrayArray;
    }

    private short[][] repeatBand(short[] sArray, int n) {
        short[][] sArrayArray = new short[n][];
        int n2 = 0;
        while (n2 < n) {
            sArrayArray[n2] = sArray;
            ++n2;
        }
        return sArrayArray;
    }

    private int[][] repeatBand(int[] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            nArrayArray[n2] = nArray;
            ++n2;
        }
        return nArrayArray;
    }

    private float[][] repeatBand(float[] fArray, int n) {
        float[][] fArrayArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArrayArray[n2] = fArray;
            ++n2;
        }
        return fArrayArray;
    }

    private double[][] repeatBand(double[] dArray, int n) {
        double[][] dArrayArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            dArrayArray[n2] = dArray;
            ++n2;
        }
        return dArrayArray;
    }

    private int[] getInterleavedOffsets(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return nArray;
    }

    public void setPixels(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.setPixels(unpackedImageData, true);
    }

    public void setPixels(UnpackedImageData unpackedImageData, boolean bl) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        if (bl) {
            switch (this.sampleType) {
                case 0: {
                    this.clampByte(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 1: {
                    this.clampUShort(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 2: {
                    this.clampShort(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 3: {
                    this.clampInt(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 4: {
                    this.clampFloat(unpackedImageData.data, unpackedImageData.type);
                }
            }
        }
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n = unpackedImageData.type;
        switch (n) {
            case 0: {
                byte[] byArray = unpackedImageData.getByteData(0);
                if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, byArray);
                    break;
                }
                int n2 = byArray.length;
                int[] nArray = new int[n2];
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = byArray[n3] & 0xFF;
                    ++n3;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = unpackedImageData.getShortData(0);
                if (this.isComponentSM) {
                    UnpackedImageData unpackedImageData2 = this.getPixelsCSM(writableRaster, rectangle, 0, true);
                    byte[][] byArray = unpackedImageData2.getByteData();
                    int n4 = 0;
                    while (n4 < this.numBands) {
                        byte[] byArray2 = byArray[n4];
                        int n5 = unpackedImageData2.getOffset(n4);
                        int n6 = n4;
                        int n7 = 0;
                        while (n7 < rectangle.height) {
                            int n8 = n5;
                            n5 += unpackedImageData2.lineStride;
                            int n9 = 0;
                            while (n9 < rectangle.width) {
                                byArray2[n8] = (byte)sArray[n6];
                                n8 += unpackedImageData2.pixelStride;
                                n6 += this.numBands;
                                ++n9;
                            }
                            ++n7;
                        }
                        ++n4;
                    }
                    break;
                }
                if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, sArray);
                    break;
                }
                int n10 = sArray.length;
                int[] nArray = new int[n10];
                if (n == 1) {
                    int n11 = 0;
                    while (n11 < n10) {
                        nArray[n11] = sArray[n11] & 0xFFFF;
                        ++n11;
                    }
                } else {
                    int n12 = 0;
                    while (n12 < n10) {
                        nArray[n12] = sArray[n12];
                        ++n12;
                    }
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 3: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getIntData(0));
                break;
            }
            case 4: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getFloatData(0));
                break;
            }
            case 5: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getDoubleData(0));
            }
        }
    }

    private void clampByte(Object object, int n) {
        switch (n) {
            case 1: {
                short[][] sArray = (short[][])object;
                int n2 = sArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    short[] sArray2 = sArray[n3];
                    int n4 = sArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = sArray2[n5] & 0xFFFF;
                        sArray2[n5] = (short)(n6 > 255 ? 255 : (short)n6);
                        ++n5;
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                short[][] sArray = (short[][])object;
                int n7 = sArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    short[] sArray3 = sArray[n8];
                    int n9 = sArray3.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        short s = sArray3[n10];
                        sArray3[n10] = (short)(s > 255 ? 255 : (short)(s < 0 ? 0 : (short)s));
                        ++n10;
                    }
                    ++n8;
                }
                break;
            }
            case 3: {
                int[][] nArray = (int[][])object;
                int n11 = nArray.length;
                int n12 = 0;
                while (n12 < n11) {
                    int[] nArray2 = nArray[n12];
                    int n13 = nArray2.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        int n15 = nArray2[n14];
                        nArray2[n14] = n15 > 255 ? 255 : (n15 < 0 ? 0 : n15);
                        ++n14;
                    }
                    ++n12;
                }
                break;
            }
            case 4: {
                float[][] fArray = (float[][])object;
                int n16 = fArray.length;
                int n17 = 0;
                while (n17 < n16) {
                    float[] fArray2 = fArray[n17];
                    int n18 = fArray2.length;
                    int n19 = 0;
                    while (n19 < n18) {
                        float f = fArray2[n19];
                        fArray2[n19] = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                        ++n19;
                    }
                    ++n17;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n20 = dArray.length;
                int n21 = 0;
                while (n21 < n20) {
                    double[] dArray2 = dArray[n21];
                    int n22 = dArray2.length;
                    int n23 = 0;
                    while (n23 < n22) {
                        double d = dArray2[n23];
                        dArray2[n23] = d > 255.0 ? 255.0 : (d < 0.0 ? 0.0 : d);
                        ++n23;
                    }
                    ++n21;
                }
                break;
            }
        }
    }

    private void clampUShort(Object object, int n) {
        switch (n) {
            case 3: {
                int[][] nArray = (int[][])object;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int[] nArray2 = nArray[n3];
                    int n4 = nArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = nArray2[n5];
                        nArray2[n5] = n6 > 65535 ? 65535 : (n6 < 0 ? 0 : n6);
                        ++n5;
                    }
                    ++n3;
                }
                break;
            }
            case 4: {
                float[][] fArray = (float[][])object;
                int n7 = fArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    float[] fArray2 = fArray[n8];
                    int n9 = fArray2.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        float f = fArray2[n10];
                        fArray2[n10] = f > 65535.0f ? 65535.0f : (f < 0.0f ? 0.0f : f);
                        ++n10;
                    }
                    ++n8;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n11 = dArray.length;
                int n12 = 0;
                while (n12 < n11) {
                    double[] dArray2 = dArray[n12];
                    int n13 = dArray2.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        double d = dArray2[n14];
                        dArray2[n14] = d > 65535.0 ? 65535.0 : (d < 0.0 ? 0.0 : d);
                        ++n14;
                    }
                    ++n12;
                }
                break;
            }
        }
    }

    private void clampShort(Object object, int n) {
        switch (n) {
            case 3: {
                int[][] nArray = (int[][])object;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int[] nArray2 = nArray[n3];
                    int n4 = nArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = nArray2[n5];
                        nArray2[n5] = n6 > Short.MAX_VALUE ? Short.MAX_VALUE : (n6 < Short.MIN_VALUE ? Short.MIN_VALUE : n6);
                        ++n5;
                    }
                    ++n3;
                }
                break;
            }
            case 4: {
                float[][] fArray = (float[][])object;
                int n7 = fArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    float[] fArray2 = fArray[n8];
                    int n9 = fArray2.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        float f = fArray2[n10];
                        fArray2[n10] = f > 32767.0f ? 32767.0f : (f < -32768.0f ? -32768.0f : f);
                        ++n10;
                    }
                    ++n8;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n11 = dArray.length;
                int n12 = 0;
                while (n12 < n11) {
                    double[] dArray2 = dArray[n12];
                    int n13 = dArray2.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        double d = dArray2[n14];
                        dArray2[n14] = d > 32767.0 ? 32767.0 : (d < -32768.0 ? -32768.0 : d);
                        ++n14;
                    }
                    ++n12;
                }
                break;
            }
        }
    }

    private void clampInt(Object object, int n) {
        switch (n) {
            case 4: {
                float[][] fArray = (float[][])object;
                int n2 = fArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    float[] fArray2 = fArray[n3];
                    int n4 = fArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        float f = fArray2[n5];
                        fArray2[n5] = f > 2.1474836E9f ? 2.1474836E9f : (f < -2.1474836E9f ? -2.1474836E9f : f);
                        ++n5;
                    }
                    ++n3;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n6 = dArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    double[] dArray2 = dArray[n7];
                    int n8 = dArray2.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        double d = dArray2[n9];
                        dArray2[n9] = d > 2.147483647E9 ? 2.147483647E9 : (d < -2.147483648E9 ? -2.147483648E9 : d);
                        ++n9;
                    }
                    ++n7;
                }
                break;
            }
        }
    }

    private void clampFloat(Object object, int n) {
        switch (n) {
            case 5: {
                double[][] dArray = (double[][])object;
                int n2 = dArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    double[] dArray2 = dArray[n3];
                    int n4 = dArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        double d = dArray2[n5];
                        dArray2[n5] = d > 3.4028234663852886E38 ? 3.4028234663852886E38 : (d < -3.4028234663852886E38 ? -3.4028234663852886E38 : d);
                        ++n5;
                    }
                    ++n3;
                }
                break;
            }
        }
    }

    public PackedImageData getPackedPixels(Raster raster, Rectangle rectangle, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        boolean bl3;
        block16: {
            block14: {
                block15: {
                    if (!this.isPacked) {
                        throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor3"));
                    }
                    if (!raster.getBounds().contains(rectangle)) {
                        throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
                    }
                    if (!this.isMultiPixelPackedSM) break block14;
                    bl3 = bl;
                    if (!bl2) break block15;
                    byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
                    n3 = (rectangle.width + 7) / 8;
                    n2 = 0;
                    n = 0;
                    break block16;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n4 = dataBuffer.getOffset();
                int n5 = rectangle.x - raster.getSampleModelTranslateX();
                int n6 = rectangle.y - raster.getSampleModelTranslateY();
                int n7 = multiPixelPackedSampleModel.getScanlineStride();
                int n8 = multiPixelPackedSampleModel.getOffset(n5, n6) + n4;
                int n9 = multiPixelPackedSampleModel.getOffset(n5 + rectangle.width - 1, n6) + n4;
                int n10 = n9 - n8 + 1;
                int n11 = multiPixelPackedSampleModel.getBitOffset(n5);
                switch (this.bufferType) {
                    case 0: {
                        byArray = ((DataBufferByte)dataBuffer).getData();
                        n3 = n7;
                        n = n8;
                        n2 = n11;
                        bl3 = false;
                        break block16;
                    }
                    case 1: {
                        n3 = n10 * 2;
                        n = n11 / 8;
                        n2 = n11 % 8;
                        byArray = new byte[n3 * rectangle.height];
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n12 = 0;
                        int n13 = 0;
                        while (n13 < rectangle.height) {
                            int n14 = n8;
                            while (n14 <= n9) {
                                short s = sArray[n14];
                                byArray[n12++] = (byte)(s >>> 8 & 0xFF);
                                byArray[n12++] = (byte)(s & 0xFF);
                                ++n14;
                            }
                            n8 += n7;
                            n9 += n7;
                            ++n13;
                        }
                        break block16;
                    }
                    case 3: {
                        n3 = n10 * 4;
                        n = n11 / 8;
                        n2 = n11 % 8;
                        byArray = new byte[n3 * rectangle.height];
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n15 = 0;
                        int n16 = 0;
                        while (n16 < rectangle.height) {
                            int n17 = n8;
                            while (n17 <= n9) {
                                int n18 = nArray[n17];
                                byArray[n15++] = (byte)(n18 >>> 24 & 0xFF);
                                byArray[n15++] = (byte)(n18 >>> 16 & 0xFF);
                                byArray[n15++] = (byte)(n18 >>> 8 & 0xFF);
                                byArray[n15++] = (byte)(n18 & 0xFF);
                                ++n17;
                            }
                            n8 += n7;
                            n9 += n7;
                            ++n16;
                        }
                        break block16;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            n3 = (rectangle.width + 7) / 8;
            n = 0;
            n2 = 0;
            bl3 = bl & raster instanceof WritableRaster;
            byArray = new byte[n3 * rectangle.height];
            if (!bl) {
                int n19 = n3 * 8;
                int[] nArray = new int[n19];
                int n20 = 0;
                int n21 = 0;
                while (n21 < rectangle.height) {
                    nArray = raster.getPixels(rectangle.x, rectangle.y + n21, rectangle.width, 1, nArray);
                    int n22 = 0;
                    while (n22 < n19) {
                        byArray[n20++] = (byte)(nArray[n22] << 7 | nArray[n22 + 1] << 6 | nArray[n22 + 2] << 5 | nArray[n22 + 3] << 4 | nArray[n22 + 4] << 3 | nArray[n22 + 5] << 2 | nArray[n22 + 6] << 1 | nArray[n22 + 7]);
                        n22 += 8;
                    }
                    ++n21;
                }
            }
        }
        return new PackedImageData(raster, rectangle, byArray, n3, n, n2, bl2, bl3);
    }

    public void setPackedPixels(PackedImageData packedImageData) {
        block14: {
            byte[] byArray;
            Rectangle rectangle;
            Raster raster;
            block12: {
                block13: {
                    if (packedImageData == null) {
                        throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
                    }
                    if (!packedImageData.convertToDest) {
                        return;
                    }
                    raster = packedImageData.raster;
                    rectangle = packedImageData.rect;
                    byArray = packedImageData.data;
                    if (!this.isMultiPixelPackedSM) break block12;
                    if (!packedImageData.coercedZeroOffset) break block13;
                    ImageUtil.setPackedBinaryData(byArray, (WritableRaster)raster, rectangle);
                    break block14;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n = dataBuffer.getOffset();
                int n2 = rectangle.x - raster.getSampleModelTranslateX();
                int n3 = rectangle.y - raster.getSampleModelTranslateY();
                int n4 = multiPixelPackedSampleModel.getScanlineStride();
                int n5 = multiPixelPackedSampleModel.getOffset(n2, n3) + n;
                int n6 = multiPixelPackedSampleModel.getOffset(n2 + rectangle.width - 1, n3) + n;
                switch (this.bufferType) {
                    case 1: {
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n7 = 0;
                        int n8 = 0;
                        while (n8 < rectangle.height) {
                            int n9 = n5;
                            while (n9 <= n6) {
                                sArray[n9] = (short)(byArray[n7++] << 8 | byArray[n7++]);
                                ++n9;
                            }
                            n5 += n4;
                            n6 += n4;
                            ++n8;
                        }
                        break block14;
                    }
                    case 3: {
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n10 = 0;
                        int n11 = 0;
                        while (n11 < rectangle.height) {
                            int n12 = n5;
                            while (n12 <= n6) {
                                nArray[n12] = byArray[n10++] << 24 | byArray[n10++] << 16 | byArray[n10++] << 8 | byArray[n10++];
                                ++n12;
                            }
                            n5 += n4;
                            n6 += n4;
                            ++n11;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            WritableRaster writableRaster = (WritableRaster)raster;
            int n = packedImageData.lineStride * 8;
            int[] nArray = new int[n];
            int n13 = 0;
            int n14 = 0;
            while (n14 < rectangle.height) {
                int n15 = 0;
                while (n15 < n) {
                    nArray[n15] = byArray[n13] >>> 7 & 1;
                    nArray[n15 + 1] = byArray[n13] >>> 6 & 1;
                    nArray[n15 + 2] = byArray[n13] >>> 5 & 1;
                    nArray[n15 + 3] = byArray[n13] >>> 4 & 1;
                    nArray[n15 + 4] = byArray[n13] >>> 3 & 1;
                    nArray[n15 + 5] = byArray[n13] >>> 2 & 1;
                    nArray[n15 + 6] = byArray[n13] >>> 1 & 1;
                    nArray[n15 + 7] = byArray[n13] & 1;
                    ++n13;
                    n15 += 8;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y + n14, rectangle.width, 1, nArray);
                ++n14;
            }
        }
    }

    public UnpackedImageData getComponents(Raster raster, Rectangle rectangle, int n) {
        Object object;
        if (!this.hasCompatibleCM) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if (n < this.componentType || this.componentType == 1 && n == 2) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor4"));
        }
        int n2 = rectangle.width * rectangle.height * this.numComponents;
        int[] nArray = new int[n2];
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = 0;
        int n6 = rectangle.y;
        while (n6 < n4) {
            int n7 = rectangle.x;
            while (n7 < n3) {
                object = raster.getDataElements(n7, n6, null);
                this.colorModel.getComponents(object, nArray, n5);
                n5 += this.numComponents;
                ++n7;
            }
            ++n6;
        }
        Object object2 = null;
        switch (n) {
            case 0: {
                object = new byte[n2];
                int n8 = 0;
                while (n8 < n2) {
                    object[n8] = (byte)(nArray[n8] & 0xFF);
                    ++n8;
                }
                object2 = this.repeatBand((byte[])object, this.numComponents);
                break;
            }
            case 1: {
                short[] sArray = new short[n2];
                int n9 = 0;
                while (n9 < n2) {
                    sArray[n9] = (short)(nArray[n9] & 0xFFFF);
                    ++n9;
                }
                object2 = this.repeatBand(sArray, this.numComponents);
                break;
            }
            case 2: {
                short[] sArray = new short[n2];
                int n10 = 0;
                while (n10 < n2) {
                    sArray[n10] = (short)nArray[n10];
                    ++n10;
                }
                object2 = this.repeatBand(sArray, this.numComponents);
                break;
            }
            case 3: {
                object2 = this.repeatBand(nArray, this.numComponents);
                break;
            }
            case 4: {
                float[] fArray = new float[n2];
                int n11 = 0;
                while (n11 < n2) {
                    fArray[n11] = nArray[n11];
                    ++n11;
                }
                object2 = this.repeatBand(fArray, this.numComponents);
                break;
            }
            case 5: {
                double[] dArray = new double[n2];
                int n12 = 0;
                while (n12 < n2) {
                    dArray[n12] = nArray[n12];
                    ++n12;
                }
                object2 = this.repeatBand(dArray, this.numComponents);
            }
        }
        return new UnpackedImageData(raster, rectangle, n, object2, this.numComponents, this.numComponents * rectangle.width, this.getInterleavedOffsets(this.numComponents), raster instanceof WritableRaster);
    }

    public void setComponents(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n = unpackedImageData.type;
        int n2 = rectangle.width * rectangle.height * this.numComponents;
        int[] nArray = null;
        switch (n) {
            case 0: {
                byte[] byArray = unpackedImageData.getByteData(0);
                nArray = new int[n2];
                int n3 = 0;
                while (n3 < n2) {
                    nArray[n3] = byArray[n3] & 0xFF;
                    ++n3;
                }
                break;
            }
            case 1: {
                short[] sArray = unpackedImageData.getShortData(0);
                nArray = new int[n2];
                int n4 = 0;
                while (n4 < n2) {
                    nArray[n4] = sArray[n4] & 0xFFFF;
                    ++n4;
                }
                break;
            }
            case 2: {
                short[] sArray = unpackedImageData.getShortData(0);
                nArray = new int[n2];
                int n5 = 0;
                while (n5 < n2) {
                    nArray[n5] = sArray[n5];
                    ++n5;
                }
                break;
            }
            case 3: {
                nArray = unpackedImageData.getIntData(0);
                break;
            }
            case 4: {
                float[] fArray = unpackedImageData.getFloatData(0);
                nArray = new int[n2];
                int n6 = 0;
                while (n6 < n2) {
                    nArray[n6] = (int)fArray[n6];
                    ++n6;
                }
                break;
            }
            case 5: {
                double[] dArray = unpackedImageData.getDoubleData(0);
                nArray = new int[n2];
                int n7 = 0;
                while (n7 < n2) {
                    nArray[n7] = (int)dArray[n7];
                    ++n7;
                }
                break;
            }
        }
        int n8 = rectangle.x + rectangle.width;
        int n9 = rectangle.y + rectangle.height;
        int n10 = 0;
        int n11 = rectangle.y;
        while (n11 < n9) {
            int n12 = rectangle.x;
            while (n12 < n8) {
                Object object = this.colorModel.getDataElements(nArray, n10, (Object)null);
                writableRaster.setDataElements(n12, n11, object);
                n10 += this.numComponents;
                ++n12;
            }
            ++n11;
        }
    }

    public UnpackedImageData getComponentsRGB(Raster raster, Rectangle rectangle) {
        if (!this.hasCompatibleCM) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        int n = rectangle.width * rectangle.height;
        byte[][] byArray = new byte[4][n];
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        byte[] byArray5 = byArray[3];
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        if (this.isIndexCM) {
            IndexColorModel indexColorModel = (IndexColorModel)this.colorModel;
            int n4 = indexColorModel.getMapSize();
            byte[] byArray6 = new byte[n4];
            indexColorModel.getReds(byArray6);
            byte[] byArray7 = new byte[n4];
            indexColorModel.getGreens(byArray7);
            byte[] byArray8 = new byte[n4];
            indexColorModel.getBlues(byArray8);
            byte[] byArray9 = null;
            if (indexColorModel.hasAlpha()) {
                byArray9 = new byte[n4];
                indexColorModel.getAlphas(byArray9);
            }
            int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
            if (byArray9 == null) {
                int n5 = 0;
                int n6 = rectangle.y;
                while (n6 < n3) {
                    int n7 = rectangle.x;
                    while (n7 < n2) {
                        int n8 = nArray[n5];
                        byArray2[n5] = byArray6[n8];
                        byArray3[n5] = byArray7[n8];
                        byArray4[n5] = byArray8[n8];
                        ++n5;
                        ++n7;
                    }
                    ++n6;
                }
            } else {
                int n9 = 0;
                int n10 = rectangle.y;
                while (n10 < n3) {
                    int n11 = rectangle.x;
                    while (n11 < n2) {
                        int n12 = nArray[n9];
                        byArray2[n9] = byArray6[n12];
                        byArray3[n9] = byArray7[n12];
                        byArray4[n9] = byArray8[n12];
                        byArray5[n9] = byArray9[n12];
                        ++n9;
                        ++n11;
                    }
                    ++n10;
                }
            }
        } else {
            int n13 = 0;
            int n14 = rectangle.y;
            while (n14 < n3) {
                int n15 = rectangle.x;
                while (n15 < n2) {
                    Object object = raster.getDataElements(n15, n14, null);
                    byArray2[n13] = (byte)this.colorModel.getRed(object);
                    byArray3[n13] = (byte)this.colorModel.getGreen(object);
                    byArray4[n13] = (byte)this.colorModel.getBlue(object);
                    byArray5[n13] = (byte)this.colorModel.getAlpha(object);
                    ++n13;
                    ++n15;
                }
                ++n14;
            }
        }
        return new UnpackedImageData(raster, rectangle, 0, byArray, 1, rectangle.width, new int[4], raster instanceof WritableRaster);
    }

    public void setComponentsRGB(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        byte[][] byArray = unpackedImageData.getByteData();
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        byte[] byArray5 = byArray[3];
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        int n3 = 0;
        int n4 = rectangle.y;
        while (n4 < n2) {
            int n5 = rectangle.x;
            while (n5 < n) {
                int n6 = byArray5[n3] << 24 | byArray4[n3] << 16 | byArray3[n3] << 8 | byArray2[n3];
                Object object = this.colorModel.getDataElements(n6, null);
                writableRaster.setDataElements(n5, n4, object);
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }
}

