'\"
'\" Copyright (c) 1995-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: filename.n,v 1.1.2.1 1998/09/24 23:58:31 stanton Exp $
'\" 
.so man.macros
.TH filename n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
filename \- File name conventions supported by Tcl commands
.BE
.SH INTRODUCTION
.PP
All Tcl commands and C procedures that take file names as arguments
expect the file names to be in one of three forms, depending on the
current platform.  On each platform, Tcl supports file names in the
standard forms(s) for that platform.  In addition, on all platforms,
Tcl supports a Unix-like syntax intended to provide a convenient way
of constructing simple file names.  However, scripts that are intended
to be portable should not assume a particular form for file names.
Instead, portable scripts must use the \fBfile split\fR and \fBfile
join\fR commands to manipulate file names (see the \fBfile\fR manual
entry for more details).

.SH PATH TYPES
.PP
File names are grouped into three general types based on the starting point
for the path used to specify the file: absolute, relative, and
volume-relative.  Absolute names are completely qualified, giving a path to
the file relative to a particular volume and the root directory on that
volume.  Relative names are unqualified, giving a path to the file relative 
to the current working directory.  Volume-relative names are partially
qualified, either giving the path relative to the root directory on the
current volume, or relative to the current directory of the specified
volume.  The \fBfile pathtype\fR command can be used to determine the
type of a given path.

.SH PATH SYNTAX
.PP
The rules for native names depend on the value reported in the Tcl
array element \fBtcl_platform(platform)\fR:
.TP 10
\fBmac\fR
On Apple Macintosh systems, Tcl supports two forms of path names.  The
normal Mac style names use colons as path separators.  Paths may be
relative or absolute, and file names may contain any character other
than colon.  A leading colon causes the rest of the path to be
interpreted relative to the current directory.  If a path contains a
colon that is not at the beginning, then the path is interpreted as an
absolute path.  Sequences of two or more colons anywhere in the path
are used to construct relative paths where \fB::\fR refers to the
parent of the current directory, \fB:::\fR refers to the parent of the
parent, and so forth.
.RS
.PP
In addition to Macintosh style names, Tcl also supports a subset of
Unix-like names.  If a path contains no colons, then it is interpreted
like a Unix path.  Slash is used as the path separator.  The file name
\fB\&.\fR refers to the current directory, and \fB\&..\fR refers to the
parent of the current directory.  However, some names like \fB/\fR or
\fB/..\fR have no mapping, and are interpreted as Macintosh names.  In
general, commands that generate file names will return Macintosh style
names, but commands that accept file names will take both Macintosh
and Unix-style names.
.PP
The following examples illustrate various forms of path names:
.TP 15
\fB:\fR
Relative path to the current folder.
.TP 15
\fBMyFile\fR
Relative path to a file named \fBMyFile\fR in the current folder.
.TP 15
\fBMyDisk:MyFile\fR
Absolute path to a file named \fBMyFile\fR on the device named \fBMyDisk\fR.
.TP 15
\fB:MyDir:MyFile\fR
Relative path to a file name \fBMyFile\fR in a folder named
\fBMyDir\fR in the current folder.
.TP 15
\fB::MyFile\fR
Relative path to a file named \fBMyFile\fR in the folder above the
current folder.
.TP 15
\fB:::MyFile\fR
Relative path to a file named \fBMyFile\fR in the folder two levels above the
current folder. 
.TP 15
\fB/MyDisk/MyFile\fR
Absolute path to a file named \fBMyFile\fR on the device named
\fBMyDisk\fR.
.TP 15
\fB\&../MyFile\fR
Relative path to a file named \fBMyFile\fR in the folder above the
current folder.
.RE
.TP
\fBunix\fR
On Unix platforms, Tcl uses path names where the components are
separated by slashes.  Path names may be relative or absolute, and
file names may contain any character other than slash.  The file names
\fB\&.\fR and \fB\&..\fR are special and refer to the current directory
and the parent of the current directory respectively.  Multiple
adjacent slash characters are interpreted as a single separator.
The following examples illustrate various forms of path names:
.RS
.TP 15
\fB/\fR
Absolute path to the root directory.
.TP 15
\fB/etc/passwd\fR
Absolute path to the file named \fBpasswd\fR in the directory
\fBetc\fR in the root directory.
.TP 15
\fB\&.\fR
Relative path to the current directory.
.TP 15
\fBfoo\fR
Relative path to the file \fBfoo\fR in the current directory.
.TP 15
\fBfoo/bar\fR
Relative path to the file \fBbar\fR in the directory \fBfoo\fR in the
current directory.
.TP 15
\fB\&../foo\fR
Relative path to the file \fBfoo\fR in the directory above the current
directory. 
.RE
.TP
\fBwindows\fR
On Microsoft Windows platforms, Tcl supports both drive-relative and UNC
style names.  Both \fB/\fR and \fB\e\fR may be used as directory separators
in either type of name.  Drive-relative names consist of an optional drive
specifier followed by an absolute or relative path.  UNC paths follow the
general form \fB\e\eservername\esharename\epath\efile\fR.  In both forms,
the file names \fB.\fR and \fB..\fR are special and refer to the current
directory and the parent of the current directory respectively.  The
following examples illustrate various forms of path names:
.RS
.TP 15
\fB\&\e\eHost\eshare/file\fR
Absolute UNC path to a file called \fBfile\fR in the root directory of
the export point \fBshare\fR on the host \fBHost\fR.
.TP 15
\fBc:foo\fR
Volume-relative path to a file \fBfoo\fR in the current directory on drive
\fBc\fR.
.TP 15
\fBc:/foo\fR
Absolute path to a file \fBfoo\fR in the root directory of drive
\fBc\fR.
.TP 15
\fBfoo\ebar\fR
Relative path to a file \fBbar\fR in the \fBfoo\fR directory in the current
directory on the current volume.
.TP 15
\fB\&\efoo\fR
Volume-relative path to a file \fBfoo\fR in the root directory of the current
volume.
.RE

.SH TILDE SUBSTITUTION
.PP
In addition to the file name rules described above, Tcl also supports
\fIcsh\fR-style tilde substitution.  If a file name starts with a
tilde, then the file name will be interpreted as if the first element
is replaced with the location of the home directory for the given
user.  If the tilde is followed immediately by a separator, then the
\fB$HOME\fR environment variable is substituted.  Otherwise the
characters between the tilde and the next separator are taken as a
user name, which is used to retrieve the user's home directory for
substitution.
.PP
The Macintosh and Windows platforms do not support tilde substitution
when a user name follows the tilde.  On these platforms, attempts to
use a tilde followed by a user name will generate an error.  File
names that have a tilde without a user name will be substituted using
the \fB$HOME\fR environment variable, just like for Unix.

.SH PORTABILITY ISSUES
.PP
Not all file systems are case sensitive, so scripts should avoid code
that depends on the case of characters in a file name.  In addition,
the character sets allowed on different devices may differ, so scripts
should choose file names that do not contain special characters like:
\fB<>:"/\e|\fR.  The safest approach is to use names consisting of
alphanumeric characters only.  Also Windows 3.1 only supports file
names with a root of no more than 8 characters and an extension of no
more than 3 characters.

.SH KEYWORDS
current directory, absolute file name, relative file name,
volume-relative file name, portability
