/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclObject;

class SocketCmd
implements Command {
    private static final String[] validCmds = new String[]{"-async", "-myaddr", "-myport", "-server"};

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        boolean server = false;
        boolean async = false;
        String channelId = "";
        String myaddr = "";
        String script = "";
        String host = "";
        boolean myport = false;
        int i = 1;
        while (i < argv.length) {
            if (argv[i].toString().length() <= 0 || argv[i].toString().charAt(0) != '-') break;
            int index = TclIndex.get((Interp)interp, (TclObject)argv[i], (String[])validCmds, (String)"option", (int)0);
            switch (index) {
                case 0: {
                    if (server) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    async = true;
                    break;
                }
                case 1: {
                    if (++i >= argv.length) {
                        throw new TclException(interp, "no argument given for -myaddr option");
                    }
                    myaddr = argv[i].toString();
                    break;
                }
                case 2: {
                    if (++i < argv.length) break;
                    throw new TclException(interp, "no argument given for -myport option");
                }
                case 3: {
                    if (async) {
                        throw new TclException(interp, "cannot set -async option for server sockets");
                    }
                    server = true;
                    if (++i >= argv.length) {
                        throw new TclException(interp, "no argument given for -server option");
                    }
                    script = argv[i].toString();
                    break;
                }
                default: {
                    throw new TclException(interp, "bad option \"" + argv[i] + "\", must be -async, -myaddr, -myport," + " or -server");
                }
            }
            ++i;
        }
        if (server) {
            host = myaddr;
            if (myport) {
                throw new TclException(interp, "Option -myport is not valid for servers");
            }
        } else if (i < argv.length) {
            host = argv[i].toString();
            ++i;
        } else {
            SocketCmd.errorWrongNumArgs(interp, argv[0].toString());
        }
        if (i != argv.length - 1) {
            SocketCmd.errorWrongNumArgs(interp, argv[0].toString());
        }
        throw new TclException(interp, "socket command not implemented yet");
    }

    private static void errorWrongNumArgs(Interp interp, String cmdName) throws TclException {
        throw new TclException(interp, "wrong # args: should be either:\n" + cmdName + " ?-myaddr addr? ?-myport myport? ?-async? host port\n" + cmdName + " -server command ?-myaddr addr? port");
    }

    SocketCmd() {
    }
}

