/*
 * A Motif program to send and receive messages to and from a Tk program
 * The Tk program is tkSend, and this one is called xmSend
 */

#include <Xm/PushB.h>
#include "../tclXtSend.h"

void
SendTo(w, clientData, callData)
    Widget w;
    XtPointer clientData;
    XtPointer callData;
{
    Tcl_Interp *interp = (Tcl_Interp *) clientData;
    char sendCommand[1024];

    strcpy(sendCommand,
		"send tkSend {.button configure -text \"Hello from Motif\"}");
    if (Tcl_Eval(interp, sendCommand) != TCL_OK)
	fprintf(stderr, "send failed\n");
}

char incrementLabelCmd[] = "\
  proc incrementLabel {} { \n\
    getLabel value \n\
    incr value \n\
    setLabel $value \n\
  } \
";

int
SetLabel(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    XmString xmstr;
    Widget w = (Widget) clientData;

    if (argc < 2) {
	Tcl_SetResult(interp, "setLabel label", TCL_STATIC);
	return TCL_ERROR;
    }

    xmstr = XmStringCreateLocalized(argv[1]);
    XtVaSetValues(w, XmNlabelString, xmstr, NULL);
    XmStringFree(xmstr);

    return TCL_OK;
}

int
GetLabel(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    XmString xmstr;
    String str;
    Widget w = (Widget) clientData;

    if (argc < 2) {
	Tcl_SetResult(interp, "getLabel \"label\"", TCL_STATIC);
	return TCL_ERROR;
    }

    XtVaGetValues(w, XmNlabelString, &xmstr, NULL);
    XmStringGetLtoR(xmstr, XmFONTLIST_DEFAULT_TAG, &str);
    Tcl_SetVar(interp, argv[1], str, 0);

    XtFree(str);
    XmStringFree(xmstr);

    return TCL_OK;
}

int
main(argc, argv)
    int argc;
    char **argv;
{
    Widget toplevel;
    Widget button;
    Tcl_Interp *interp;
    XtAppContext app;

    toplevel = XtAppInitialize(&app, "XmSend", NULL, 0, &argc, argv,
				NULL, NULL, 0);

    button = XmCreatePushButton(toplevel, "1", NULL, 0);
    XtManageChild(button);

    XtRealizeWidget(toplevel);

    interp = Tcl_CreateInterp();

    if (TclXtSend_RegisterInterp(interp, argv[0], toplevel) == TCL_ERROR)
	fprintf(stderr, "couldn't register interpreter %s\n", argv[0]);

    /*
     * Create tcl commands based in C, and then load a procedure
     */
    Tcl_CreateCommand(interp, "setLabel", SetLabel, (ClientData *) button,
		(Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand(interp, "getLabel", GetLabel, (ClientData *) button,
		(Tcl_CmdDeleteProc *) NULL);
    Tcl_Eval(interp, incrementLabelCmd);

    XtAddCallback(button, XmNactivateCallback, SendTo, (XtPointer) interp);

    XtAppMainLoop(app);
}
