/*
 * A Motif program to send and receive messages to and from a Tk program
 * The Tk program is tkSend, and this one is called xmSend
 */

#include <Xm/PushB.h>
#include "../tclXtSend.h"

void
SendTo(w, clientData, callData)
    Widget w;
    XtPointer clientData;
    XtPointer callData;
{
    Tcl_Interp *interp = (Tcl_Interp *) clientData;
    char sendCommand[1024];

    strcpy(sendCommand,
		"send tkSend {.button configure -text \"Hello from Motif\"}");
    if ( Tcl_Eval(interp, sendCommand))
	fprintf(stderr, "send failed: %s", interp->result);
}

int
SetLabel(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    XmString xmstr;
    Widget w = (Widget) clientData;

    if (argc < 2) {
	Tcl_SetResult(interp, "setLabel label", TCL_STATIC);
	return TCL_ERROR;
    }

    xmstr = XmStringCreateLocalized(argv[1]);
    XtVaSetValues(w, XmNlabelString, xmstr, NULL);
    XmStringFree(xmstr);

    return TCL_OK;
}


int
main(argc, argv)
    int argc;
    char **argv;
{
    Widget toplevel;
    Widget button;
    Tcl_Interp *interp;
    XtAppContext app;

    toplevel = XtAppInitialize(&app, "XmSend", NULL, 0, &argc, argv,
				NULL, NULL, 0);

    button = XmCreatePushButton(toplevel, "I'm an Xm button", NULL, 0);
    XtManageChild(button);

    XtRealizeWidget(toplevel);

    interp = Tcl_CreateInterp();

    if (TclXtSend_RegisterInterp(interp, argv[0], toplevel) == TCL_ERROR)
	fprintf(stderr, "couldn't register interpreter %s\n", argv[0]);

    Tcl_CreateCommand(interp, "setLabel", SetLabel, (ClientData *) button,
		(Tcl_CmdDeleteProc *) NULL);
    XtAddCallback(button, XmNactivateCallback, SendTo, (XtPointer) interp);

    XtAppMainLoop(app);
}
