'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: puts.n,v 1.4 2000/09/07 14:27:50 poenitz Exp $
'\" 
.so man.macros
.TH puts n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
puts \- Write to a channel
.SH SYNOPSIS
\fBputs \fR?\fB\-nonewline\fR? ?\fIchannelId\fR? \fIstring\fR
.BE

.SH DESCRIPTION
.PP
Writes the characters given by \fIstring\fR to the channel given
by \fIchannelId\fR.
\fIChannelId\fR must be a channel identifier such as returned from a
previous invocation of \fBopen\fR or \fBsocket\fR. It must have been opened
for output. If no \fIchannelId\fR is specified then it defaults to
\fBstdout\fR. \fBPuts\fR normally outputs a newline character after
\fIstring\fR, but this feature may be suppressed by specifying the
\fB\-nonewline\fR switch.
.PP
Newline characters in the output are translated by \fBputs\fR to
platform-specific end-of-line sequences according to the current
value of the \fB\-translation\fR option for the channel (for example,
on PCs newlines are normally replaced with carriage-return-linefeed
sequences;  on Macintoshes newlines are normally replaced with
carriage-returns).
See the \fBfconfigure\fR manual entry for a discussion on ways in
which \fBfconfigure\fR will alter output.
.PP
Tcl buffers output internally, so characters written with \fBputs\fR
may not appear immediately on the output file or device;  Tcl will
normally delay output until the buffer is full or the channel is
closed.
You can force output to appear immediately with the \fBflush\fR
command.
.PP
When the output buffer fills up, the \fBputs\fR command will normally
block until all the buffered data has been accepted for output by the
operating system.
If \fIchannelId\fR is in nonblocking mode then the \fBputs\fR command
will not block even if the operating system cannot accept the data.
Instead, Tcl continues to buffer the data and writes it in the
background as fast as the underlying file or device can accept it.
The application must use the Tcl event loop for nonblocking output
to work;  otherwise Tcl never finds out that the file or device is
ready for more output data.
It is possible for an arbitrarily large amount of data to be
buffered for a channel in nonblocking mode, which could consume a
large amount of memory.
To avoid wasting memory, nonblocking I/O should normally
be used in an event-driven fashion with the \fBfileevent\fR command
(don't invoke \fBputs\fR unless you have recently been notified
via a file event that the channel is ready for more output data).

.SH "SEE ALSO"
file(n), fileevent(n)

.SH KEYWORDS
channel, newline, output, write
