'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: read.n,v 1.2 1998/09/14 18:39:54 stanton Exp $
'\" 
.so man.macros
.TH read n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
read \- Read from a channel
.SH SYNOPSIS
\fBread \fR?\fB\-nonewline\fR? \fIchannelId\fR
.sp
\fBread \fIchannelId numBytes\fR
.BE

.SH DESCRIPTION
.PP
In the first form, the \fBread\fR command reads all of the data from
\fIchannelId\fR up to the end of the file.
If the \fB\-nonewline\fR switch is specified then the last character
of the file is discarded if it is a newline.
In the second form, the extra argument specifies how many bytes to
read.  Exactly that many bytes will be read and returned, unless
there are fewer than \fInumBytes\fR left in the file;  in this case
all the remaining bytes are returned.
.PP
If \fIchannelId\fR is in nonblocking mode, the command may not read
as many bytes as requested:  once all available input has been read,
the command will return the data that is available rather than blocking
for more input.
The \fB\-nonewline\fR switch is ignored if the command returns
before reaching the end of the file.
.PP
\fBRead\fR translates end-of-line sequences in the input into
newline characters according to the \fB\-translation\fR option
for the channel.
See the manual entry for \fBfconfigure\fR for details on the
\fB\-translation\fR option.

.SH "SEE ALSO"
eof(n), fblocked(n), fconfigure(n)

.SH KEYWORDS
blocking, channel, end of line, end of file, nonblocking, read, translation
