/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.AbsFunction;
import tcl.lang.AcosFunction;
import tcl.lang.AsinFunction;
import tcl.lang.Atan2Function;
import tcl.lang.AtanFunction;
import tcl.lang.CeilFunction;
import tcl.lang.CosFunction;
import tcl.lang.CoshFunction;
import tcl.lang.DoubleFunction;
import tcl.lang.ExpFunction;
import tcl.lang.ExprValue;
import tcl.lang.FloorFunction;
import tcl.lang.FmodFunction;
import tcl.lang.HypotFunction;
import tcl.lang.IntFunction;
import tcl.lang.Interp;
import tcl.lang.Log10Function;
import tcl.lang.LogFunction;
import tcl.lang.MathFunction;
import tcl.lang.ParseAdaptor;
import tcl.lang.ParseResult;
import tcl.lang.PowFunction;
import tcl.lang.RandFunction;
import tcl.lang.RoundFunction;
import tcl.lang.SinFunction;
import tcl.lang.SinhFunction;
import tcl.lang.SqrtFunction;
import tcl.lang.SrandFunction;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TanFunction;
import tcl.lang.TanhFunction;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;

class Expression {
    static final int VALUE = 0;
    static final int OPEN_PAREN = 1;
    static final int CLOSE_PAREN = 2;
    static final int COMMA = 3;
    static final int END = 4;
    static final int UNKNOWN = 5;
    static final int MULT = 8;
    static final int DIVIDE = 9;
    static final int MOD = 10;
    static final int PLUS = 11;
    static final int MINUS = 12;
    static final int LEFT_SHIFT = 13;
    static final int RIGHT_SHIFT = 14;
    static final int LESS = 15;
    static final int GREATER = 16;
    static final int LEQ = 17;
    static final int GEQ = 18;
    static final int EQUAL = 19;
    static final int NEQ = 20;
    static final int BIT_AND = 21;
    static final int BIT_XOR = 22;
    static final int BIT_OR = 23;
    static final int AND = 24;
    static final int OR = 25;
    static final int QUESTY = 26;
    static final int COLON = 27;
    static final int UNARY_MINUS = 28;
    static final int UNARY_PLUS = 29;
    static final int NOT = 30;
    static final int BIT_NOT = 31;
    static int[] precTable;
    static String[] operatorStrings;
    Hashtable mathFuncTable = new Hashtable();
    private String m_expr;
    private int m_len;
    int m_token;
    private int m_ind;

    TclObject eval(Interp interp, String string) throws TclException {
        ExprValue value = this.ExprTopLevel(interp, string);
        switch (value.type) {
            case 1: {
                return TclInteger.newInstance((int)((int)value.intValue));
            }
            case 2: {
                return TclDouble.newInstance((double)value.doubleValue);
            }
            case 3: {
                return TclString.newInstance((String)value.stringValue);
            }
        }
        throw new TclRuntimeError("internal error: expression, unknown");
    }

    boolean evalBoolean(Interp interp, String string) throws TclException {
        ExprValue value = this.ExprTopLevel(interp, string);
        switch (value.type) {
            case 1: {
                return value.intValue != 0L;
            }
            case 2: {
                return value.doubleValue != 0.0;
            }
            case 3: {
                return Util.getBoolean(interp, value.stringValue);
            }
        }
        throw new TclRuntimeError("internal error: expression, unknown");
    }

    Expression() {
        this.mathFuncTable.put("atan2", new Atan2Function());
        this.mathFuncTable.put("pow", new PowFunction());
        this.mathFuncTable.put("acos", new AcosFunction());
        this.mathFuncTable.put("asin", new AsinFunction());
        this.mathFuncTable.put("atan", new AtanFunction());
        this.mathFuncTable.put("ceil", new CeilFunction());
        this.mathFuncTable.put("cos", new CosFunction());
        this.mathFuncTable.put("cosh", new CoshFunction());
        this.mathFuncTable.put("exp", new ExpFunction());
        this.mathFuncTable.put("floor", new FloorFunction());
        this.mathFuncTable.put("fmod", new FmodFunction());
        this.mathFuncTable.put("hypot", new HypotFunction());
        this.mathFuncTable.put("log", new LogFunction());
        this.mathFuncTable.put("log10", new Log10Function());
        this.mathFuncTable.put("rand", new RandFunction());
        this.mathFuncTable.put("sin", new SinFunction());
        this.mathFuncTable.put("sinh", new SinhFunction());
        this.mathFuncTable.put("sqrt", new SqrtFunction());
        this.mathFuncTable.put("srand", new SrandFunction());
        this.mathFuncTable.put("tan", new TanFunction());
        this.mathFuncTable.put("tanh", new TanhFunction());
        this.mathFuncTable.put("abs", new AbsFunction());
        this.mathFuncTable.put("double", new DoubleFunction());
        this.mathFuncTable.put("int", new IntFunction());
        this.mathFuncTable.put("round", new RoundFunction());
        this.m_expr = null;
        this.m_ind = 0;
        this.m_len = 0;
        this.m_token = 5;
    }

    private final ExprValue ExprTopLevel(Interp interp, String string) throws TclException {
        String m_expr_saved = this.m_expr;
        int m_len_saved = this.m_len;
        int m_token_saved = this.m_token;
        int m_ind_saved = this.m_ind;
        try {
            this.m_expr = string;
            this.m_ind = 0;
            this.m_len = string.length();
            this.m_token = 5;
            ExprValue val = this.ExprGetValue(interp, -1);
            if (this.m_token != 4) {
                this.SyntaxError(interp);
            }
            ExprValue exprValue = val;
            Object var9_9 = null;
            this.m_expr = m_expr_saved;
            this.m_len = m_len_saved;
            this.m_token = m_token_saved;
            this.m_ind = m_ind_saved;
            return exprValue;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.m_expr = m_expr_saved;
            this.m_len = m_len_saved;
            this.m_token = m_token_saved;
            this.m_ind = m_ind_saved;
            throw throwable;
        }
    }

    static void IllegalType(Interp interp, int badType, int operator) throws TclException {
        throw new TclException(interp, "can't use " + (badType == 2 ? "floating-point value" : "non-numeric string") + " as operand of \"" + operatorStrings[operator] + "\"");
    }

    void SyntaxError(Interp interp) throws TclException {
        throw new TclException(interp, "syntax error in expression \"" + this.m_expr + "\"");
    }

    static void DivideByZero(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance((String)"ARITH DIVZERO {divide by zero}"));
        throw new TclException(interp, "divide by zero");
    }

    static void IntegerTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance((String)"ARITH IOVERFLOW {integer value too large to represent}"));
        throw new TclException(interp, "integer value too large to represent");
    }

    static void DoubleTooLarge(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance((String)"ARITH OVERFLOW {floating-point value too large to represent}"));
        throw new TclException(interp, "floating-point value too large to represent");
    }

    static void DomainError(Interp interp) throws TclException {
        interp.setErrorCode(TclString.newInstance((String)"ARITH DOMAIN {domain error: argument not in valid range}"));
        throw new TclException(interp, "domain error: argument not in valid range");
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExprValue ExprParseString(Interp interp, String s) throws TclException {
        len = s.length();
        if (!Expression.ExprLooksLikeInt(s, len, 0)) ** GOTO lbl18
        i = 0;
        while (Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (s.charAt(i) == '-') {
            res = Util.strtoul(s, ++i, 0);
            res.value = -res.value;
        } else {
            res = s.charAt(i) == '+' ? Util.strtoul(s, ++i, 0) : Util.strtoul(s, i, 0);
        }
        if (res.index != len) return new ExprValue(s);
        if (res.errno == -2) {
            Expression.IntegerTooLarge(interp);
            return new ExprValue(s);
        } else {
            this.m_token = 0;
            return new ExprValue(res.value);
lbl18:
            // 1 sources

            res = Util.strtod(s, 0);
            if (res.index != len) return new ExprValue(s);
            if (res.errno == -4) {
                Expression.DoubleTooLarge(interp);
                return new ExprValue(s);
            } else {
                this.m_token = 0;
                return new ExprValue(res.value);
            }
        }
    }

    private ExprValue ExprGetValue(Interp interp, int prec) throws TclException {
        int operator;
        boolean gotOp = false;
        ExprValue value = this.ExprLex(interp);
        if (this.m_token == 1) {
            value = this.ExprGetValue(interp, -1);
            if (this.m_token != 2) {
                throw new TclException(interp, "unmatched parentheses in expression \"" + this.m_expr + "\"");
            }
        } else {
            if (this.m_token == 12) {
                this.m_token = 28;
            }
            if (this.m_token == 11) {
                this.m_token = 29;
            }
            if (this.m_token >= 28) {
                operator = this.m_token;
                value = this.ExprGetValue(interp, precTable[this.m_token]);
                if (interp.noEval == 0) {
                    switch (operator) {
                        case 28: {
                            if (value.type == 1) {
                                value.intValue = -value.intValue;
                                break;
                            }
                            if (value.type == 2) {
                                value.doubleValue = -value.doubleValue;
                                break;
                            }
                            Expression.IllegalType(interp, value.type, operator);
                            break;
                        }
                        case 29: {
                            if (value.type == 1 || value.type == 2) break;
                            Expression.IllegalType(interp, value.type, operator);
                            break;
                        }
                        case 30: {
                            if (value.type == 1) {
                                if (value.intValue != 0L) {
                                    value.intValue = 0L;
                                    break;
                                }
                                value.intValue = 1L;
                                break;
                            }
                            if (value.type == 2) {
                                value.intValue = value.doubleValue == 0.0 ? 1L : 0L;
                                value.type = 1;
                                break;
                            }
                            Expression.IllegalType(interp, value.type, operator);
                            break;
                        }
                        case 31: {
                            if (value.type == 1) {
                                value.intValue ^= 0xFFFFFFFFFFFFFFFFL;
                                break;
                            }
                            Expression.IllegalType(interp, value.type, operator);
                            break;
                        }
                    }
                }
                gotOp = true;
            } else if (this.m_token != 0) {
                this.SyntaxError(interp);
            }
        }
        if (value == null) {
            this.SyntaxError(interp);
        }
        if (!gotOp) {
            ExprValue exprValue = this.ExprLex(interp);
        }
        block42: while (true) {
            ExprValue value2;
            if ((operator = this.m_token) < 8 || operator >= 28) {
                if (operator == 4 || operator == 2 || operator == 3) {
                    return value;
                }
                this.SyntaxError(interp);
            }
            if (precTable[operator] <= prec) {
                return value;
            }
            if (operator == 24 || operator == 25 || operator == 26) {
                Object var8_11;
                if (value.type == 2) {
                    value.intValue = value.doubleValue != 0.0 ? 1 : 0;
                    value.type = 1;
                } else if (value.type == 3) {
                    if (interp.noEval == 0) {
                        Expression.IllegalType(interp, 3, operator);
                    }
                    value.intValue = 0L;
                }
                if (operator == 24 && value.intValue == 0L || operator == 25 && value.intValue != 0L) {
                    ++interp.noEval;
                    try {
                        value2 = this.ExprGetValue(interp, precTable[operator]);
                    }
                    finally {
                        var8_11 = null;
                        --interp.noEval;
                    }
                    if (operator != 25) continue;
                    value.intValue = 1L;
                    continue;
                }
                if (operator == 26) {
                    if (value.intValue != 0L) {
                        value = this.ExprGetValue(interp, precTable[26] - 1);
                        if (this.m_token != 27) {
                            this.SyntaxError(interp);
                        }
                        ++interp.noEval;
                        try {
                            value2 = this.ExprGetValue(interp, precTable[26] - 1);
                        }
                        finally {
                            var8_11 = null;
                            --interp.noEval;
                        }
                        continue;
                    }
                    ++interp.noEval;
                    try {
                        value2 = this.ExprGetValue(interp, precTable[26] - 1);
                    }
                    finally {
                        var8_11 = null;
                        --interp.noEval;
                    }
                    if (this.m_token != 27) {
                        this.SyntaxError(interp);
                    }
                    value = this.ExprGetValue(interp, precTable[26] - 1);
                    continue;
                }
                value2 = this.ExprGetValue(interp, precTable[operator]);
            } else {
                value2 = this.ExprGetValue(interp, precTable[operator]);
            }
            if (this.m_token < 8 && this.m_token != 0 && this.m_token != 4 && this.m_token != 3 && this.m_token != 2) {
                this.SyntaxError(interp);
            }
            if (interp.noEval != 0) continue;
            switch (operator) {
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    if (value.type == 3 || value2.type == 3) {
                        Expression.IllegalType(interp, 3, operator);
                    }
                    if (value.type == 2) {
                        if (value2.type != 1) break;
                        value2.doubleValue = value2.intValue;
                        value2.type = 2;
                        break;
                    }
                    if (value2.type != 2 || value.type != 1) break;
                    value.doubleValue = value.intValue;
                    value.type = 2;
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 23: {
                    if (value.type != 1) {
                        Expression.IllegalType(interp, value.type, operator);
                        break;
                    }
                    if (value2.type == 1) break;
                    Expression.IllegalType(interp, value2.type, operator);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    if (value.type == 3) {
                        if (value2.type == 3) break;
                        Expression.ExprMakeString(interp, value2);
                        break;
                    }
                    if (value2.type == 3) {
                        if (value.type == 3) break;
                        Expression.ExprMakeString(interp, value);
                        break;
                    }
                    if (value.type == 2) {
                        if (value2.type != 1) break;
                        value2.doubleValue = value2.intValue;
                        value2.type = 2;
                        break;
                    }
                    if (value2.type != 2 || value.type != 1) break;
                    value.doubleValue = value.intValue;
                    value.type = 2;
                    break;
                }
                case 24: 
                case 25: {
                    if (value.type == 3) {
                        Expression.IllegalType(interp, value.type, operator);
                    }
                    if (value2.type != 3) break;
                    Expression.IllegalType(interp, value.type, operator);
                    break;
                }
                default: {
                    throw new TclException(interp, "unknown operator in expression");
                }
                case 26: 
                case 27: 
            }
            switch (operator) {
                default: {
                    continue block42;
                }
                case 8: {
                    if (value.type == 1) {
                        value.intValue *= value2.intValue;
                        continue block42;
                    }
                    value.doubleValue *= value2.doubleValue;
                    continue block42;
                }
                case 9: 
                case 10: {
                    if (value.type == 1) {
                        if (value2.intValue == 0L) {
                            Expression.DivideByZero(interp);
                        }
                        long divisor = value2.intValue;
                        boolean negative = false;
                        if (divisor < 0L) {
                            divisor = -divisor;
                            value.intValue = -value.intValue;
                            negative = true;
                        }
                        long quot = value.intValue / divisor;
                        long rem = value.intValue % divisor;
                        if (rem < 0L) {
                            rem += divisor;
                            --quot;
                        }
                        if (negative) {
                            rem = -rem;
                        }
                        value.intValue = operator == 9 ? quot : rem;
                        continue block42;
                    }
                    if (value2.doubleValue == 0.0) {
                        Expression.DivideByZero(interp);
                    }
                    value.doubleValue /= value2.doubleValue;
                    continue block42;
                }
                case 11: {
                    if (value.type == 1) {
                        value.intValue += value2.intValue;
                        continue block42;
                    }
                    value.doubleValue += value2.doubleValue;
                    continue block42;
                }
                case 12: {
                    if (value.type == 1) {
                        value.intValue -= value2.intValue;
                        continue block42;
                    }
                    value.doubleValue -= value2.doubleValue;
                    continue block42;
                }
                case 13: {
                    value.intValue <<= (int)value2.intValue;
                    continue block42;
                }
                case 14: {
                    if (value.intValue < 0L) {
                        value.intValue = (value.intValue ^ 0xFFFFFFFFFFFFFFFFL) >> (int)value2.intValue ^ 0xFFFFFFFFFFFFFFFFL;
                        continue block42;
                    }
                    value.intValue >>= (int)value2.intValue;
                    continue block42;
                }
                case 15: {
                    value.intValue = value.type == 1 ? (long)(value.intValue < value2.intValue ? 1 : 0) : (value.type == 2 ? (long)(value.doubleValue < value2.doubleValue ? 1 : 0) : (long)(value.stringValue.compareTo(value2.stringValue) < 0 ? 1 : 0));
                    value.type = 1;
                    continue block42;
                }
                case 16: {
                    value.intValue = value.type == 1 ? (long)(value.intValue > value2.intValue ? 1 : 0) : (value.type == 2 ? (long)(value.doubleValue > value2.doubleValue ? 1 : 0) : (long)(value.stringValue.compareTo(value2.stringValue) > 0 ? 1 : 0));
                    value.type = 1;
                    continue block42;
                }
                case 17: {
                    value.intValue = value.type == 1 ? (long)(value.intValue <= value2.intValue ? 1 : 0) : (value.type == 2 ? (long)(value.doubleValue <= value2.doubleValue ? 1 : 0) : (long)(value.stringValue.compareTo(value2.stringValue) <= 0 ? 1 : 0));
                    value.type = 1;
                    continue block42;
                }
                case 18: {
                    value.intValue = value.type == 1 ? (long)(value.intValue >= value2.intValue ? 1 : 0) : (value.type == 2 ? (long)(value.doubleValue >= value2.doubleValue ? 1 : 0) : (long)(value.stringValue.compareTo(value2.stringValue) >= 0 ? 1 : 0));
                    value.type = 1;
                    continue block42;
                }
                case 19: {
                    value.intValue = value.type == 1 ? (long)(value.intValue == value2.intValue ? 1 : 0) : (value.type == 2 ? (long)(value.doubleValue == value2.doubleValue ? 1 : 0) : (long)(value.stringValue.compareTo(value2.stringValue) == 0 ? 1 : 0));
                    value.type = 1;
                    continue block42;
                }
                case 20: {
                    value.intValue = value.type == 1 ? (long)(value.intValue != value2.intValue ? 1 : 0) : (value.type == 2 ? (long)(value.doubleValue != value2.doubleValue ? 1 : 0) : (long)(value.stringValue.compareTo(value2.stringValue) != 0 ? 1 : 0));
                    value.type = 1;
                    continue block42;
                }
                case 21: {
                    value.intValue &= value2.intValue;
                    continue block42;
                }
                case 22: {
                    value.intValue ^= value2.intValue;
                    continue block42;
                }
                case 23: {
                    value.intValue |= value2.intValue;
                    continue block42;
                }
                case 24: {
                    if (value2.type == 2) {
                        value2.intValue = value2.doubleValue != 0.0 ? 1 : 0;
                        value2.type = 1;
                    }
                    value.intValue = value.intValue != 0L && value2.intValue != 0L ? 1 : 0;
                    continue block42;
                }
                case 25: {
                    if (value2.type == 2) {
                        value2.intValue = value2.doubleValue != 0.0 ? 1 : 0;
                        value2.type = 1;
                    }
                    value.intValue = value.intValue != 0L || value2.intValue != 0L ? 1 : 0;
                    continue block42;
                }
                case 27: 
            }
            break;
        }
        throw new TclException(interp, "can't have : operator without ? first");
    }

    private ExprValue ExprLex(Interp interp) throws TclException {
        while (this.m_ind < this.m_len && Character.isWhitespace(this.m_expr.charAt(this.m_ind))) {
            ++this.m_ind;
        }
        if (this.m_ind >= this.m_len) {
            this.m_token = 4;
            return null;
        }
        char c = this.m_expr.charAt(this.m_ind);
        char c2 = this.m_ind < this.m_len - 1 ? this.m_expr.charAt(this.m_ind + 1) : (char)'\u0000';
        if (c != '+' && c != '-') {
            if (Expression.ExprLooksLikeInt(this.m_expr, this.m_len, this.m_ind)) {
                StrtoulResult res = Util.strtoul(this.m_expr, this.m_ind, 0);
                if (res.errno == 0) {
                    this.m_ind = res.index;
                    this.m_token = 0;
                    return new ExprValue(res.value);
                }
                if (res.errno == -2) {
                    Expression.IntegerTooLarge(interp);
                }
            } else {
                StrtodResult res = Util.strtod(this.m_expr, this.m_ind);
                if (res.errno == 0) {
                    this.m_ind = res.index;
                    this.m_token = 0;
                    return new ExprValue(res.value);
                }
                if (res.errno == -4) {
                    Expression.DoubleTooLarge(interp);
                }
            }
        }
        ++this.m_ind;
        switch (c) {
            case '$': {
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseVar(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                return this.ExprParseString(interp, pres.value.toString());
            }
            case '[': {
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseNestedCmd(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                String str = pres.value.toString();
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                return this.ExprParseString(interp, str);
            }
            case '\"': {
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseQuotes(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                return this.ExprParseString(interp, pres.value.toString());
            }
            case '{': {
                this.m_token = 0;
                ParseResult pres = ParseAdaptor.parseBraces(interp, this.m_expr, this.m_ind, this.m_len);
                this.m_ind = pres.nextIndex;
                if (interp.noEval != 0) {
                    return new ExprValue(0L);
                }
                return this.ExprParseString(interp, pres.value.toString());
            }
            case '(': {
                this.m_token = 1;
                return null;
            }
            case ')': {
                this.m_token = 2;
                return null;
            }
            case ',': {
                this.m_token = 3;
                return null;
            }
            case '*': {
                this.m_token = 8;
                return null;
            }
            case '/': {
                this.m_token = 9;
                return null;
            }
            case '%': {
                this.m_token = 10;
                return null;
            }
            case '+': {
                this.m_token = 11;
                return null;
            }
            case '-': {
                this.m_token = 12;
                return null;
            }
            case '?': {
                this.m_token = 26;
                return null;
            }
            case ':': {
                this.m_token = 27;
                return null;
            }
            case '<': {
                switch (c2) {
                    case '<': {
                        ++this.m_ind;
                        this.m_token = 13;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 17;
                        break;
                    }
                    default: {
                        this.m_token = 15;
                    }
                }
                return null;
            }
            case '>': {
                switch (c2) {
                    case '>': {
                        ++this.m_ind;
                        this.m_token = 14;
                        break;
                    }
                    case '=': {
                        ++this.m_ind;
                        this.m_token = 18;
                        break;
                    }
                    default: {
                        this.m_token = 16;
                    }
                }
                return null;
            }
            case '=': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 19;
                } else {
                    this.m_token = 5;
                }
                return null;
            }
            case '!': {
                if (c2 == '=') {
                    ++this.m_ind;
                    this.m_token = 20;
                } else {
                    this.m_token = 30;
                }
                return null;
            }
            case '&': {
                if (c2 == '&') {
                    ++this.m_ind;
                    this.m_token = 24;
                } else {
                    this.m_token = 21;
                }
                return null;
            }
            case '^': {
                this.m_token = 22;
                return null;
            }
            case '|': {
                if (c2 == '|') {
                    ++this.m_ind;
                    this.m_token = 25;
                } else {
                    this.m_token = 23;
                }
                return null;
            }
            case '~': {
                this.m_token = 31;
                return null;
            }
        }
        if (Character.isLetter(c)) {
            --this.m_ind;
            return this.mathFunction(interp);
        }
        this.m_token = 5;
        return null;
    }

    ExprValue mathFunction(Interp interp) throws TclException {
        MathFunction mathFunc;
        int startIdx = this.m_ind;
        TclObject[] argv = null;
        while (this.m_ind < this.m_len) {
            if (!Util.isLetterOrDigit(this.m_expr.charAt(this.m_ind)) && this.m_expr.charAt(this.m_ind) != '_') break;
            ++this.m_ind;
        }
        String funcName = this.m_expr.substring(startIdx, this.m_ind);
        this.ExprLex(interp);
        if (this.m_token != 1) {
            this.SyntaxError(interp);
        }
        if ((mathFunc = (MathFunction)this.mathFuncTable.get(funcName)) == null) {
            throw new TclException(interp, "unknown math function \"" + funcName + "\"");
        }
        int numArgs = mathFunc.argTypes.length;
        if (numArgs == 0) {
            this.ExprLex(interp);
            if (this.m_token != 2) {
                this.SyntaxError(interp);
            }
        } else {
            argv = new TclObject[numArgs];
            int i = 0;
            while (true) {
                ExprValue value = this.ExprGetValue(interp, -1);
                if (value.type == 3) {
                    throw new TclException(interp, "argument to math function didn't have numeric value");
                }
                argv[i] = value.type == 1 ? (mathFunc.argTypes[i] == 1 ? TclDouble.newInstance((double)((int)value.intValue)) : TclInteger.newInstance((int)((int)value.intValue))) : (mathFunc.argTypes[i] == 0 ? TclInteger.newInstance((int)((int)value.doubleValue)) : TclDouble.newInstance((double)value.doubleValue));
                if (i == numArgs - 1) {
                    if (this.m_token == 2) break;
                    if (this.m_token == 3) {
                        throw new TclException(interp, "too many arguments for math function");
                    }
                    this.SyntaxError(interp);
                }
                if (this.m_token != 3) {
                    if (this.m_token == 2) {
                        throw new TclException(interp, "too few arguments for math function");
                    }
                    this.SyntaxError(interp);
                }
                ++i;
            }
        }
        this.m_token = 0;
        if (interp.noEval != 0) {
            return new ExprValue(0L);
        }
        return mathFunc.apply(interp, argv);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean ExprLooksLikeInt(String s, int len, int i) {
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        c = s.charAt(i);
        if (c == '+' || c == '-') {
            if (++i >= len) {
                return false;
            }
            c = s.charAt(i);
        }
        if (Character.isDigit(c)) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            ++i;
lbl14:
            // 2 sources

            ** while (i < len && Character.isDigit((char)s.charAt((int)i)))
        }
lbl15:
        // 1 sources

        return i >= len || (c = s.charAt(i)) != '.' && c != 'e' && c != 'E';
    }

    static void ExprMakeString(Interp interp, ExprValue value) {
        if (value.type == 1) {
            value.stringValue = Long.toString(value.intValue);
        } else if (value.type == 2) {
            value.stringValue = Double.toString(value.doubleValue);
        }
        value.type = 3;
    }

    static void checkIntegerRange(Interp interp, double d) throws TclException {
        if (d < 0.0) {
            if (d < -2.147483648E9) {
                Expression.IntegerTooLarge(interp);
            }
        } else if (d > 2.147483647E9) {
            Expression.IntegerTooLarge(interp);
        }
    }

    static void checkDoubleRange(Interp interp, double d) throws TclException {
        if (d == Double.NaN || d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            Expression.DoubleTooLarge(interp);
        }
    }

    static {
        int[] nArray = new int[32];
        nArray[8] = 12;
        nArray[9] = 12;
        nArray[10] = 12;
        nArray[11] = 11;
        nArray[12] = 11;
        nArray[13] = 10;
        nArray[14] = 10;
        nArray[15] = 9;
        nArray[16] = 9;
        nArray[17] = 9;
        nArray[18] = 9;
        nArray[19] = 8;
        nArray[20] = 8;
        nArray[21] = 7;
        nArray[22] = 6;
        nArray[23] = 5;
        nArray[24] = 4;
        nArray[25] = 3;
        nArray[26] = 2;
        nArray[27] = 1;
        nArray[28] = 13;
        nArray[29] = 13;
        nArray[30] = 13;
        nArray[31] = 13;
        precTable = nArray;
        operatorStrings = new String[]{"VALUE", "(", ")", ",", "END", "UNKNOWN", "6", "7", "*", "/", "%", "+", "-", "<<", ">>", "<", ">", "<=", ">=", "==", "!=", "&", "^", "|", "&&", "||", "?", ":", "-", "+", "!", "~"};
    }
}

