/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import tcl.lang.Channel;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclRuntimeError;

class StdChannel
extends Channel {
    private static BufferedReader in = null;
    private int stdType;
    static final int STDIN = 0;
    static final int STDOUT = 1;
    static final int STDERR = 2;
    private static final int BUF_SIZE = 1024;

    StdChannel() {
        in = null;
        this.stdType = -1;
    }

    StdChannel(String string) {
        if (string.equals("stdin")) {
            this.open(0);
            return;
        }
        if (string.equals("stdout")) {
            this.open(1);
            return;
        }
        if (string.equals("stderr")) {
            this.open(2);
            return;
        }
        throw new TclRuntimeError("Error: unexpected type for StdChannel");
    }

    StdChannel(int n) {
        this.open(n);
    }

    String open(int n) {
        switch (n) {
            case 0: {
                this.mode = 1;
                if (in != null) break;
                in = new BufferedReader(new InputStreamReader(System.in));
                break;
            }
            case 1: {
                this.mode = 2;
                break;
            }
            case 2: {
                this.mode = 2;
            }
        }
        this.stdType = n;
        this.setChanName("file" + n);
        return this.getChanName();
    }

    String read(Interp interp, int n, int n2) throws IOException, TclException {
        if (this.stdType != 0) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for reading");
        }
        switch (n) {
            case 1: {
                char[] cArray = new char[1024];
                StringBuffer stringBuffer = new StringBuffer();
                while (in.read(cArray, 0, 1024) != -1) {
                    stringBuffer.append(cArray);
                }
                return stringBuffer.toString();
            }
            case 2: {
                return in.readLine();
            }
            case 3: {
                char[] cArray = new char[n2];
                in.read(cArray, 0, n2);
                return new String(cArray);
            }
        }
        throw new TclRuntimeError("StdChannel.read: Incorrect read mode.");
    }

    void write(Interp interp, String string) throws IOException, TclException {
        if (this.stdType != 1 && this.stdType != 2) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
        if (this.stdType == 1) {
            System.out.print(string);
            return;
        }
        System.err.print(string);
    }

    void close() throws IOException {
        switch (this.stdType) {
            case 0: {
                if (in == null) break;
                in.close();
                in = null;
                return;
            }
            case 1: {
                System.out.close();
                return;
            }
            case 2: {
                System.err.close();
                return;
            }
            default: {
                throw new TclRuntimeError("Error: unexpected stdType for StdChannel");
            }
        }
    }

    void flush(Interp interp) throws IOException, TclException {
        switch (this.stdType) {
            case 0: {
                throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
            }
            case 1: {
                System.out.flush();
                return;
            }
            case 2: {
                System.err.flush();
                return;
            }
        }
        throw new TclRuntimeError("Error: unexpected stdType for StdChannel");
    }

    void seek(long l, int n) throws IOException {
        switch (n) {
            default: 
        }
    }

    long tell() throws IOException {
        return -1L;
    }

    boolean eof() {
        return false;
    }
}

