.TH sha1 n 4.1 "Tcl-Extensions"
.HS sha1 tcl
.BS
.SH NAME
sha1 \- manipulate sha1 message digests
.SH SYNOPSIS
\fBsha1\fI ?-log2base log2base? -string string\fR
.br
or
.br
\fBsha1\fI ?-log2base log2base? ?-copychan chanID? -chan chanID\fR
.br
or
.br
\fBsha1\fI -init\fR (returns descriptor)
.br
\fBsha1\fI -update descriptor ?-maxbytes n? ?-copychan chanID? -chan chanID\fR
.br
\fBsha1\fI ?-log2base log2base? -final descriptor\fR
.SH DESCRIPTION
SHA1 is NIST's Secure Hashing Algorithm (also known as Secure Hashing
Standard) with the minor modification that they proposed on 7/11/94.
.PP
Switches can be in any order.
.PP
Returns a sha1 digest in base 2 ** log2base ascii representation.
log2base defaults to 4, i.e. hex representation.
.PP
.nf
       log2base   length   chars 
         1          160      01            (binary)
         2           80      0..3
         3           54      0...7         (octal)
         4           40      0..9a..f      (hex)
         5           32      0..9a..v      
         6           27      0..9a..zA..Z_, 
.fo
.PP
(The characters in the digest string have been chosen to be usable in 
filenames so that the sha1 command can be used, for example, 
to digest URLs into shorter strings for filenames in a cache.)
.PP
In the -string version, returns sha1 digest alone of string.
.PP
In the -chan version, returns list of 2 items: length of data
in chanID followed by sha1 digest of all data in chanID.  ChanID is
identifier returned from "open" for example.  If -copychan is supplied,
will also copy all data from chanID to copychanID.
.PP
In the third form, -init returns a descriptor, -update can be called
any number of times with that descriptor and returns the number of
bytes read, and -final returns the result in the same form as the
standalone -chan.
