/*  $Header: token_in.c,v 3.0 88/04/13 16:31:06 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "token_in.h"

typedef struct TokenStream_struct {
    Token   *tokens;
    int     *values;
    int      index;
    int      size;
} TokenStream;

/*
 *  functions for token input.
 */
static TokenStream *current_t;

TokenStream*  new_token_stream(tokens, values)
Token  *tokens;
int    *values;
{
    TokenStream *tt;
    int          len, i;

    tt = (TokenStream*)MALLOC( (unsigned)( sizeof(TokenStream) ) );

    for(len=0; tokens[len] != 0; len++);
    len++;

    tt->tokens = (int*)MALLOC(len*sizeof(int));
    for(i=0; i<len; i++){
	tt->tokens[i] = tokens[i];
    }

    if( values != 0 ){
	tt->values  = (int*)MALLOC(len*sizeof(int));
	for(i=0; i<len; i++){
	    tt->values[i] = values[i];
	}
    } else {
	tt->values = 0;
    }

    tt->size    = len*sizeof(int);
    tt->index   = -1;
    return tt;
}

void delete_token_stream(tt)
TokenStream *tt;
{
    if( tt->values != 0 ){
	FREE(tt->values, tt->size);
    }
    FREE(tt->tokens, tt->size);
    FREE(tt, sizeof(TokenStream));
}

void token_stream(tt)
TokenStream *tt;
{
    current_t = tt;
}

int token_current_ch()
{
    return current_t->tokens[current_t->index];
}

int token_next_ch()
{
    int answer;

    current_t->index++;
    answer = current_t->tokens[current_t->index];
    return answer;
}

int token_current_ch_value()
{
    return (current_t->values ? current_t->values[current_t->index] : 0);
}

void token_pushback_ch(l)
int l;
{
    current_t->index -= l;
    if( current_t->index < -1 ){ current_t->index = -1; }
}
