/*  $Header: tags.c,v 3.0 88/04/13 16:32:16 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "Lpars.h"
#include "tags.h"

#ifdef VMS
typedef struct map_struct {
    String    name;
    String    sh_refs[NR_SH_REFS];
    P_Set     first_chars;
} Map;

struct attdef_struct {
	String  name;
	int     decl_val;
	String *range;
	int     def_type;
	String  def_val;
	String  cur_val;
};
#endif

typedef struct parsertable_struct {
	String              name;
	int                 starttag;
	int                 endtag;
	P_Attdeflist        attlist;
	int                *incl;
	int                *excl;
	P_Map               map;
	P_Replace           start_rep;
	P_Replace           end_rep;
} Parsertable[];

#include "tags.i"

int document_start()
{
    return doc_start;
}

String info_name(info)
Parserinfo info;
{
	return( (info?info->name:(String) 0) );
}

int info_starttag(info)
Parserinfo info;
{
	return( (info?info->starttag:0) );
}

int info_endtag(info)
Parserinfo info;
{
	return( (info?info->endtag:0) );
}

P_Attdeflist info_attlist(info)
Parserinfo info;
{
	return( (info?info->attlist:(P_Attdeflist) 0) );
}

int* info_incl(info)
Parserinfo info;
{
	return( (info?info->incl:(int *) 0) );
}

int* info_excl(info)
Parserinfo info;
{
	return( (info?info->excl:(int *) 0) );
}

P_Map info_map(info)
Parserinfo info;
{
	return( (info?info->map:(P_Map) 0) );
}

Parserinfo string_info(name)
String name;
{
	int i;

	if( NAMECASE_GENERAL ){ to_upper(name); }
	for (i = 0; parserinfo[i].name != ILL_STRING; i++)
	    if (strcmp(parserinfo[i].name, name) == 0)
		return(&(parserinfo[i]));
	return( (Parserinfo) 0);
}

Parserinfo endtag_info(endtag)
int endtag;
{
	int i;

	for (i = 0; parserinfo[i].name != ILL_STRING; i++)
	    if (parserinfo[i].endtag == endtag) 
		return(&(parserinfo[i]));
	return( (Parserinfo) 0);
}

Parserinfo starttag_info(starttag)
int starttag;
{
	int i;

	for (i = 0; parserinfo[i].name != ILL_STRING; i++)
	    if (parserinfo[i].starttag == starttag) 
		return(&(parserinfo[i]));
	return( (Parserinfo) 0);
}

P_Replace info_start_rep(info)
Parserinfo   info;
{
    return( (info?info->start_rep:(P_Replace) 0) );
}

P_Replace info_end_rep(info)
Parserinfo   info;
{
    return( (info?info->end_rep:(P_Replace) 0) );
}

void info_set_start_rep(info, rep)
Parserinfo   info;
P_Replace      rep;
{
    info->start_rep = rep;
}

void info_set_end_rep(info, rep)
Parserinfo   info;
P_Replace      rep;
{
    info->end_rep = rep;
}

String endtag_to_string(endtag)
int endtag;
{
	Parserinfo info;

	info = endtag_info(endtag);
	return(info_name(info));
}

String starttag_to_string(starttag)
int starttag;
{
	Parserinfo info;

	info = starttag_info(starttag);
	return(info_name(info));
}

Delimiter starttag_keyword(name)
String  name;
{
    Parserinfo info;

    info = string_info(name);
    return ( (info==0) ? TOK_NOD : info->starttag );
}

Delimiter endtag_keyword(name)
String  name;
{
    Parserinfo info;

    info = string_info(name);
    return ( (info==0) ? TOK_NOD : info->endtag );
}

P_Attdeflist string_to_attrs(name)
String name;
{
	Parserinfo info;

	info = string_info(name);
	return(info_attlist(info));
}
