/*  $Header: str_in.c,v 3.0 88/04/13 16:27:48 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "str_in.h"

typedef struct StringStream_struct {
    String   string;
    int      index;
} StringStream;

/*
 *  functions for string input.
 */
static StringStream *s;

StringStream*  new_string_stream(string)
String string;
{
    StringStream *ss;

    ss = (StringStream*)MALLOC( (unsigned)( sizeof(StringStream) ) );
    ss->string  = string;
    ss->index   = -1;
    return ss;
}

void delete_string_stream(ss)
StringStream *ss;
{
    FREE(ss, sizeof(StringStream));
}

void string_stream(ss)
StringStream *ss;
{
    s = ss;
}

int string_current_ch()
{
    return s->string[s->index];
}

int string_next_ch()
{
    char ch;

    s->index++;
    ch = s->string[s->index];
    return ch;
}

void string_pushback_ch(l)
int l;
{
    s->index -= l;
    if( s->index < -1 ){ s->index = -1; }
}
