/* $Header: sgmlproc.c,v 3.1 89/09/25 09:26:12 sylvia Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "sgmlproc.h"

typedef struct nm_val {
	String nm;
	String val;
} cap_type, gen_delim_type, quant_type;

static cap_type capacity[] = {
	{ "TOTALCAP",	"35000" },
	{ "ENTCAP",	"35000" },
	{ "ENTCHCAP",	"35000" },
	{ "ELEMCAP",	"35000" },
	{ "GRPCAP",	"35000" },
	{ "EXGRPCAP",	"35000" },
	{ "EXNMCAP",	"35000" },
	{ "ATTCAP",	"35000" },
	{ "ATTCHCAP",	"35000" },
	{ "AVGRPCAP",	"35000" },
	{ "NOTCAP",	"35000" },
	{ "NOTCHCAP",	"35000" },
	{ "IDCAP",	"35000" },
	{ "IDREFCAP",	"35000" },
	{ "MAPCAP",	"35000" },
	{ "LKSETCAP",	"35000" },
	{ "LKNMCAP",	"35000" },
	{ 0,		0 }
	};

void capacity_ok(str, val)
String str, val;
{
	int i = 0;

	to_upper(str);
	while ((capacity[i].nm != 0) and
	       (strcmp(str, capacity[i].nm) != 0)) i++;
	if (!capacity[i].nm) {
	    report(CAP_NAME, FATAL, 0, 0, str);
	}
	else if (strcmp(val, capacity[i].val) != 0) {
	    report(SGML_WRONG_VAL, FATAL, 0, 0, str, val, 
		   capacity[i].val);
	}
}

static Bool shun_char[33];

void shun_char_ok(nr)
String nr;
{
	int n = atoi(nr);

	if (n == 127) n = 32;
	if (n == 255) n = 33;
	if ((n >= 0) and (n <= 33))
	    if (shun_char[n]) report(SHUN_TWO, NOTFATAL, 0, 0, nr);
	    else shun_char[n] = TRUE;
	else {
	    report(SHUN_NOT_ACC, FATAL, 0, 0, nr);
	}
}

void shun_char_empty()
{
	int i;

	for (i = 0; i <= 33; i++) shun_char[i] = FALSE;
}

void shun_char_been()
{
	int i;

	for (i = 0; i <= 33; i++)
	    if (!shun_char[i]) {
		report(SHUN_UNDEF, FATAL, 0, 0, (i==32?127:(i==33?255:i)));
	}
}

static gen_delim_type gen_delim[] = {
	{ "AND",	"&" },
	{ "COM",	"--" },
	{ "CRO",	"&#" },
	{ "DSC",	"]" },
	{ "DSO",	"[" },
	{ "DTGC",	"]" },
	{ "DTGO",	"[" },
	{ "ERO",	"&" },
	{ "ETAGO",	"</" },
	{ "GRPC",	")" },
	{ "GRPO",	"(" },
	{ "LIT",	"\"" },
	{ "LITA",	"'" },
	{ "MDC",	">" },
	{ "MDO",	"<!" },
	{ "MINUS",	"-" },
	{ "MSC",	"]]" },
	{ "NET",	"/" },
	{ "OPT",	"?" },
	{ "OR",		"|" },
	{ "PERO",	"%" },
	{ "PIC",	">" },
	{ "PIO",	"<?" },
	{ "PLUS",	"+" },
	{ "REFC",	";" },
	{ "REP",	"*" },
	{ "RNI",	"#" },
	{ "SEQ",	"," },
	{ "STAGO",	"<" },
	{ "TAGC",	">" },
	{ "VI",		"=" },
	{ 0,		0 }
	};

void gen_delim_ok(str, val)
String str, val;
{
	int i = 0;

	to_upper(str);
	while ((gen_delim[i].nm != 0) and
	       (strcmp(str, gen_delim[i].nm) != 0)) i++;
	if (!gen_delim[i].nm) {
	    report(DELIM_UNKNOWN, FATAL, 0, 0, str, "general");
	}
	else if (strcmp(val, gen_delim[i].val) != 0) {
	    report(SGML_WRONG_VAL, FATAL, 0, 0, str, val,
		   gen_delim[i].val);
	}
}

static struct short_delim_type {
	String nm;
	Bool   been;
} short_delim[] = {
	{ "	",	FALSE },
	{ "\r",		FALSE },
	{ "\n",		FALSE },
	{ "\nB",	FALSE },
	{ "\n\r",	FALSE },
	{ "\nB\r",	FALSE },
	{ "B\r",	FALSE },
	{ " ",		FALSE },
	{ "BB",		FALSE },
	{ "\"",		FALSE },
	{ "#",		FALSE },
	{ "%",		FALSE },
	{ "'",		FALSE },
	{ "(",		FALSE },
	{ ")",		FALSE },
	{ "*",		FALSE },
	{ "-",		FALSE },
	{ "--",		FALSE },
	{ ":",		FALSE },
	{ ";",		FALSE },
	{ "=",		FALSE },
	{ "@",		FALSE },
	{ "[",		FALSE },
	{ "]",		FALSE },
	{ "^",		FALSE },
	{ "_",		FALSE },
	{ "{",		FALSE },
	{ "|",		FALSE },
	{ "}",		FALSE },
	{ "~",		FALSE },
	{ 0,		FALSE }
	};

void short_delim_ok(str)
String str;
{
	int i = 0;

	while ((short_delim[i].nm != 0) and
	       (strcmp(str, short_delim[i].nm) != 0)) i++;
	if (!short_delim[i].nm) {
	    report(DELIM_UNKNOWN, FATAL, 0, 0, str, "short reference");
	}
	else short_delim[i].been = TRUE;
}

void short_delim_been()
{
	int i = 0;

	while (short_delim[i].nm != 0) {
	    if (!short_delim[i].been) {
		report(DELIM_UNDEF, FATAL, 0, 0, short_delim[i].nm);
	    }
	    short_delim[i].been = FALSE;
	    i++;
	}
}

static quant_type quantity[] = {
	{ "ATTCNT",	 "40" },
	{ "ATTSPLEN",	"960" },
	{ "BSEQLEN",	"960" },
	{ "DTAGLEN",	 "16" },
	{ "DTEMPLEN",	 "16" },
	{ "ENTLVL",	 "16" },
	{ "GRPCNT",	 "32" },
	{ "GRPGTCNT",	 "96" },
	{ "GRPLVL",	 "16" },
	{ "LITLEN",	"240" },
	{ "NAMELEN",	  "8" },
	{ "NORMSEP",	  "2" },
	{ "PILEN",	"240" },
	{ "TAGLEN",	"960" },
	{ "TAGLVL",	 "24" },
	{ 0,		0 }
	};

void quantity_ok(str, val)
String str, val;
{
	int i = 0;

	to_upper(str);
	while ((quantity[i].nm != 0) and
	       (strcmp(str, quantity[i].nm) != 0)) i++;
	if (!quantity[i].nm) {
	    report(QUANT_NAME, FATAL, 0, 0, str);
	}
	else if (strcmp(val, quantity[i].val) != 0) {
	    report(SGML_WRONG_VAL, FATAL, 0, 0, str, val,
		   quantity[i].val);
	}
}
