/* $Header: replace.c,v 3.0 88/04/13 16:09:38 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "group.h"
#include "replace.h"

/*
 *  First replace's are defined
 */
typedef struct replace_struct {
    Bool      start_newline;
    Bool      end_newline;
    P_Group   chunk_group;
} Replace;

P_Replace   new_replace(start, end, group)
Bool     start;
Bool     end;
P_Group  group;
{
    P_Replace rep      = (P_Replace)MALLOC( sizeof(Replace) );

    rep->start_newline = start;
    rep->end_newline   = end;
    rep->chunk_group   = group;

    return rep;
}

Bool replace_start_newline(rep)
P_Replace   rep;
{
    return rep->start_newline;
}

Bool replace_end_newline(rep)
P_Replace   rep;
{
    return rep->end_newline;
}

P_Group replace_chunk_group(rep)
P_Replace  rep;
{
    return rep->chunk_group;
}

/*
 *  Second chunks are defined
 */
typedef struct chunk_struct {
    int       type;
    String    string;
} Chunk;

P_Chunk new_chunk(type, string)
int      type;
String   string;
{
    P_Chunk chunk = (P_Chunk)MALLOC( sizeof(Chunk) );

    chunk->type   = type;
    chunk->string = strsave(string);

    return chunk;
}

int chunk_type(chunk)
P_Chunk  chunk;
{
    return chunk->type;
}

String  chunk_string(chunk)
P_Chunk  chunk;
{
    assert(chunk->type == CHUNK_STRING);
    return chunk->string;
}

String  chunk_attname(chunk)
P_Chunk  chunk;
{
    assert( chunk->type == CHUNK_ATTNAME);
    return chunk->string;
}
