/*  $Header: keywords.c,v 3.0 88/04/13 15:56:19 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "Lpars.h"
#include "keywords.h"
#include "symtable.h"

static  Delimiter markup_tokens[] = { UNDEFINED,
				      MDO_ENTITY,
				      MDO_DOCTYPE,
				      MDO_ELEMENT,
				      MDO_ATTLIST,
				      MDO_NOTATION,
				      MDO_SHORTREF,
				      MDO_USEMAP,
				      MDO_LINKTYPE,
				      MDO_LINK,
                                      MDO_SGML,
				      MDO_USELINK  };

static SymbolTable key_words = { 	   /* used in rule */
   { "UNDEFINED",	UNDEFINED	},
   { "ENTITY",		ENTITY		},
   { "DOCTYPE",		DOCTYPE		},
   { "ELEMENT",		ELEMENT		},
   { "ATTLIST",		ATTLIST 	},
   { "NOTATION",	NOTATION	},
   { "SHORTREF",	SHORTREF	},
   { "USEMAP",		USEMAP		},
   { "LINKTYPE",	LINKTYPE	},
   { "LINK",		LINK		},
   { "SGML",		SGML		},
   { "USELINK",		USELINK		},
   { "RS",		RS		}, /* 63		*/
   { "RE",		RE		}, /* 63		*/
   { "SPACE",		SPACE		}, /* 63		*/
   { "SYSTEM",		SYSTEM		}, /* 73		*/
   { "PUBLIC",		PUBLIC		}, /* 73		*/
   { "TEMP",		TEMP		}, /* 97		*/
   { "CDATA",		CDATA		}, /* 100,106,125*/
   { "IGNORE",		IGNORE		}, /* 100		*/
   { "INCLUDE",		INCLUDE		}, /* 100		*/
   { "RCDATA",		RCDATA		}, /* 100,125	*/
   { "DEFAULT",		DEFAULT		}, /* 103		*/
   { "SDATA",		SDATA		}, /* 106		*/
   { "PI",		PI		}, /* 106,107	*/
   { "STARTTAG",	STARTTAG	}, /* 107		*/
   { "ENDTAG",		ENDTAG		}, /* 107		*/
   { "MS",		MS		}, /* 107		*/
   { "MD",		MD		}, /* 107		*/
   { "SUBDOC",		SUBDOC		}, /* 109		*/
   { "NDATA",		NDATA		}, /* 109		*/
   { "EMPTY",		EMPTY		}, /* 125,153,170*/
   { "ANY",		ANY		}, /* 126          */
   { "PCDATA",		PCDATA		}, /* 129          */
   { "ID",		ID		}, /* 145          */
   { "IDREF",		IDREF		}, /* 145          */
   { "IDREFS",		IDREFS		}, /* 145          */
   { "NAME",		NAME		}, /* 145          */
   { "NAMES",		NAMES		}, /* 145          */
   { "NMTOKEN",		NMTOKEN		}, /* 145          */
   { "NMTOKENS",	NMTOKENS	}, /* 145          */
   { "NUMBER",		NUMBER		}, /* 145          */
   { "NUMBERS",		NUMBERS		}, /* 145          */
   { "NUTOKEN",		NUTOKEN		}, /* 145		*/
   { "NUTOKENS",	NUTOKENS	}, /* 145		*/
   { "FIXED",		FIXED		}, /* 147		*/
   { "REQUIRED",	REQUIRED	}, /* 147		*/
   { "CURRENT",		CURRENT		}, /* 147		*/
   { "CONREF",		CONREF		}, /* 147		*/
   { "IMPLIED",		IMPLIED		}, /* 147. 156, 157, 167 */
   { "SIMPLE",		SIMPLE		}, /* 156		*/
   { "ENUMERATE",	ENUMERATE	}, /* 156 NOT A REAL KEYWORD */
   { "XPCDATA ",	XPCDATA		}, /* ADDED KEYWORD */
   { "FUNCHAR",		FUNCHAR		}, /* 188 */
   { "MSOCHAR",		MSOCHAR		}, /* 188 */
   { "MSICHAR",		MSICHAR		}, /* 188 */
   { "MSSCHAR",		MSSCHAR		}, /* 188 */
   { "SEPCHAR",		SEPCHAR		}, /* 188 */
   { ILL_STRING,	ILL_SYMBOL	}
};

#ifdef GENERATOR

static SymbolTable sgml_key_words = { 	   /* used in rule */
   { "BASESET",		SGML_BASESET	}, /* SGML declaration */
   { "CAPACITY",	SGML_CAPACITY	}, /* SGML declaration */
   { "CHARSET",		SGML_CHARSET	}, /* SGML declaration */
   { "DESCSET",		SGML_DESCSET	}, /* SGML declaration */
   { "DOCUMENT",	SGML_DOCUMENT	}, /* SGML declaration */
   { "INSTANCE",	SGML_INSTANCE	}, /* SGML declaration */
   { "PUBLIC",		SGML_PUBLIC	}, /* SGML declaration */
   { "SGMLREF",	 	SGML_SGMLREF	}, /* SGML declaration */
   { "SCOPE",		SGML_SCOPE	}, /* SGML declaration */
   { "UNUSED",		SGML_UNUSED	}, /* SGML declaration */
   { "SWITCHES",	SGML_SWITCHES	}, /* SGML declaration */
   { "SHUNCHAR",	SGML_SHUNCHAR	}, /* SGML declaration */
   { "NONE",		SGML_NONE	}, /* SGML declaration */
   { "CONTROLS",	SGML_CONTROLS	}, /* SGML declaration */
   { "FUNCTION",	SGML_FUNCTION	}, /* SGML declaration */
   { "RE",		SGML_RE		}, /* SGML declaration */
   { "RS",		SGML_RS		}, /* SGML declaration */
   { "SPACE",		SGML_SPACE	}, /* SGML declaration */
   { "NAMING",		SGML_NAMING	}, /* SGML declaration */
   { "LCNMSTRT",	SGML_LCNMSTRT	}, /* SGML declaration */
   { "UCNMSTRT",	SGML_UCNMSTRT	}, /* SGML declaration */
   { "LCNMCHAR",	SGML_LCNMCHAR	}, /* SGML declaration */
   { "UCNMCHAR",	SGML_UCNMCHAR	}, /* SGML declaration */
   { "NAMECASE",	SGML_NAMECASE	}, /* SGML declaration */
   { "GENERAL",		SGML_GENERAL	}, /* SGML declaration */
   { "ENTITY",		SGML_ENTITY	}, /* SGML declaration */
   { "NO",		SGML_NO		}, /* SGML declaration */
   { "YES",		SGML_YES	}, /* SGML declaration */
   { "DELIM",		SGML_DELIM	}, /* SGML declaration */
   { "SHORTREF",	SGML_SHORTREF	}, /* SGML declaration */
   { "NAMES",		SGML_NAMES	}, /* SGML declaration */
   { "QUANTITY",	SGML_QUANTITY	}, /* SGML declaration */
   { "FEATURES",	SGML_FEATURES	}, /* SGML declaration */
   { "MINIMIZE",	SGML_MINIMIZE	}, /* SGML declaration */
   { "DATATAG",		SGML_DATATAG	}, /* SGML declaration */
   { "OMITTAG",		SGML_OMITTAG	}, /* SGML declaration */
   { "RANK",		SGML_RANK	}, /* SGML declaration */
   { "SHORTTAG",	SGML_SHORTTAG	}, /* SGML declaration */
   { "LINK",		SGML_LINK	}, /* SGML declaration */
   { "SIMPLE",		SGML_SIMPLE	}, /* SGML declaration */
   { "IMPLICIT",	SGML_IMPLICIT	}, /* SGML declaration */
   { "EXPLICIT",	SGML_EXPLICIT	}, /* SGML declaration */
   { "OTHER",		SGML_OTHER	}, /* SGML declaration */
   { "CONCUR",		SGML_CONCUR	}, /* SGML declaration */
   { "SUBDOC",		SGML_SUBDOC	}, /* SGML declaration */
   { "APPINFO",		SGML_APPINFO	}, /* SGML declaration */
   { "SYNTAX",		SGML_SYNTAX	}, /* SGML declaration */
   { "FORMAL",		SGML_FORMAL	}, /* SGML declaration */

   { ILL_STRING,	ILL_SYMBOL	}
};
#endif

int  string_to_key(str)
String  str;
{
    int symbol;

    to_upper(str);
    symbol = string_symbol(key_words, str);
    return ( (symbol==ILL_SYMBOL) ? TOK_NOD : symbol );
}

#ifdef GENERATOR
int  sgml_string_to_key(str)
String  str;
{
    int symbol;

    to_upper(str);
    symbol = string_symbol(sgml_key_words, str);
    return ( (symbol==ILL_SYMBOL) ? TOK_NOD : symbol );
}
#endif

String  key_str(key)
int   key;
{
    String string;

    string = symbol_string(key_words, key);
    return ( (string==ILL_STRING) ? key_words[0].string : string );
}

Delimiter mdo_keyword(word)
String  word;
{
    int    i;
    String key;

    to_upper(word);
    for(i=0; i<=10 ; i++){
        key = key_words[i].string;
	if( streq(key, word) ){
	    return markup_tokens[i];
	}
    }
    return TOK_NOD;
}

int   priority(k1, k2)
int k1;
int k2;
{
    if( (k1==IGNORE   ) or (k2==IGNORE   ) ){ return IGNORE; }
    if( (k1==CDATA    ) or (k2==CDATA    ) ){ return CDATA ; }
    if( (k1==RCDATA   ) or (k2==RCDATA   ) ){ return RCDATA; }
    if( (k1==INCLUDE  ) or (k2==INCLUDE  ) ){ return INCLUDE; }
    if( (k1==TEMP     ) or (k2==TEMP     ) ){ return TEMP   ; }
    if( (k1==UNDEFINED) or (k2==UNDEFINED) ){ return UNDEFINED; }
}
