/* $Header: group.h,v 3.0 88/04/14 09:16:17 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
/*
 *  definition of module group:
 *  A group is a list of 'elements', which are most often character strings.
 *  First the functions for building groups,
 *  then the functions for accessing them.
 *  Typical loop:
 *
 *  P_Iterator  it;
 *  P_Group     g;
 *
 *  it = group_iterator(g);
 *  while( elem = iterator_next(it) ){
 *      process_element(elem);
 *  }
 *  iterator_delete(it);
 */

#ifndef GROUP_H
#define GROUP_H

typedef void  (*func )(PAR  void*  RAP);

#define Elem void*		/* the generic element type of the group */
extern void       group_del_previous(PAR  P_Group, P_Iterator*, func  RAP);
extern void       group_del_next   (PAR  P_Group, P_Iterator*, func RAP);
#define group_delete_next(g, i, f)     group_del_next(g, &i, f)
#define group_delete_previous(g, i, f) group_del_previous(g, &i, f)

extern P_Group    group_create     ();
extern void       delete_group     (PAR  P_Group, func  RAP);
extern void       group_add        (PAR  P_Group, Elem  RAP);
extern void       group_insert     (PAR  P_Group, Elem  RAP);
extern Bool       group_add_unique (PAR  P_Group,Elem,IntFunctionVoidVoid  RAP);
/* initialize iterator */
extern P_Iterator group_iterator   (PAR  P_Group  RAP);
extern void       group_print      (PAR  FILE*, P_Group  RAP);

/* give next element */
extern Elem       iter_next        (PAR  P_Iterator*  RAP);
extern Elem       iter_previous    (PAR  P_Iterator*  RAP);

/* give current elem */
extern Elem       iterator_elem    (PAR  P_Iterator  RAP);

#define    iterator_delete(i)  {i=0;}

#endif
