/*  $Header: gen_tags.c,v 3.0 88/04/13 15:34:21 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "att_gen.h"
#include "element.h"
#include "gen_tags.h"
#include "group.h"
#include "shortref.h"

void gen_ex_in(file, str, group, nr)
FILE   *file;
String  str;
P_Group group;
int    *nr;
{
	P_Iterator it;
	String     name;

	it = group_iterator(group);
	if (it != 0) {
	    fprintf(file, "int %s%d[] = {", str, *nr);
	    while (name = next_name(it)) 
		fprintf(file, "ST_%s, ", cname(name));
	    fprintf(file, "0 };\n");
	    (*nr)++;
	}
}

void var_ex_in(file)
FILE *file;
{
	P_Iterator elem_it;
	P_Element  elem;
	int        incl = 1;
	int        excl = 1;

	elem_it = element_iterator();
	while (elem = next_element(elem_it)) {
	    gen_ex_in(file, "incl", inclusions(elem), &incl);
	    gen_ex_in(file, "excl", exclusions(elem), &excl);
	}
}

void generate_tags(file_name)
String  file_name;
{
    P_Iterator  it, nmgroup;
    P_Element   elem;
    FILE       *file;
    String      name;
    char        incl[10], excl[10];
    int         in = 1;
    int         ex = 1;

    file = fopen(file_name, "w");
    if (file == 0) {
	report(FILE_OPEN, FATAL, 0, 0, file_name);
    }

    /*  Generate start tags table
     */
    fprintf(file, "#include \"att_par.ext\"\n\n");
    fprintf(file, "#include \"map.ext\"\n\n");
    fprintf(file, "int doc_start = ST_%s;\n\n", cname(document_name()));
    var_ex_in(file);
    fprintf(file,"static Parsertable parserinfo = {\n");
    it = element_iterator();
    while( elem = next_element(it) ){
	nmgroup = group_iterator(name_group(elem));
	if (inclusions(elem)) { sprintf(incl, "incl%d", in); in++; }
	else sprintf(incl, "0");
	if (exclusions(elem)) { sprintf(excl, "excl%d", ex); ex++; }
	else sprintf(excl, "0");
	while (name = next_name(nmgroup))
	    if (strcmp(name, DOCUMENT) != 0){
                fprintf(file, "{\"%s\", ST_%s, ", name, cname(name));
		fprintf(file, "END_%s, ", cname(name));
		fprintf(file, "%s, %s, %s, %s, 0, 0 },\n", attr_var_name(name),
			       incl, excl, cname(element_map_var(name)));
	    }
    }
    fprintf(file, "{ILL_STRING, ILL_SYMBOL, ILL_SYMBOL, ILL_ATTR, ILL_EXCEP, ILL_EXCEP, ILL_MAP} };\n");
    fclose(file);
}
