/* $Header: gen_code.c,v 3.3 88/07/19 06:45:39 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "att_gen.h"
#include "context.h"
#include "element.h"
#include "gen_code.h"
#include "gen_incl.h"
#include "node.h"
#include "omitstrt.h"

#define MAX_GRAMMAR_RULES	20

static FILE    *fp;
static char	seperator[5];
static int	save_ind   = 0;
static int	count_ands = 1;

static struct {
    P_Node node;
    int    count;
    int    nr_ands;
} save_node[GRPGTCNT];

static P_Group	subset_group;
static int	N;

void subset(start, nr, answer)
int    start;
int    nr;
P_Set  answer;
{
    int new_start;
    int i;

    if( nr == 0 ){
	group_add(subset_group, set_copy(answer));
	return;
    }
    new_start = start;

   /* generate all subsets with nr elements from the range
       start..N elements
     */
    for(i=start; i<=(N-nr+1); i++){
	set_add(answer, i);
	new_start++;
	subset(new_start, nr-1, answer);
	set_delete(answer, i);
    }
}

void find_subsets(max)
int max;
{
    P_Set  answer;
    int    nr;

    N            = max;
    answer       = new_set(N+1);
    subset_group = group_create();
    for(nr=2; nr<=max; nr++){
	subset(1, nr, answer);
    }
}

int count_nr_ands(node)
P_Node node;
{
	P_Iterator group;
	P_Node     nd;
	int        count = 0;

	group = group_iterator(node_group(node));
	while (nd = next_node(group)) count++;
	return(count);
}

Bool node_gi_startopt(node)
P_Node node;
/* return whether the starttag of the gi is optional, ie. whether the
   first child of node is optional
 */
{
	P_Iterator group;
	P_Node     nd;
	Bool       value;

	group = group_iterator(node_group(node));
	if (nd = next_node(group)) {
	    value = (node_occ(nd) == OCC_OPT?TRUE:FALSE);
	}
	iterator_delete(group);
	return(value);
}

void set_flags(node, flag, context)
P_Node node;
int   *flag;
Bool  *context;
/* if a node is marked context required, the code generated must
   contain a way to detect if an previous element is already been.
   This is done with flags.
 */
{
	P_Iterator group;
	P_Node     par;
	P_Node     nd;
	Bool       cont = TRUE;
	int        flagin;

	par = node_parent(node);
	if (par) flagin = node_flagin(par);
	else flagin = NOTUSED;
	switch (node_status(node)) {
	  case ALWAYS_REQUIRED :
		node_set_flagin(node, NOTUSED);
		node_set_flagout(node, NOTUSED);
		break;
	  case CONTEXT_REQUIRED :
		if ((node_type(node) == CONN_SEQ) or 
		    (node_type(node) == GI))
		    node_set_flagin(node, flagin);
		else node_set_flagin(node, NOTUSED);
		node_set_flagout(node, NOTUSED);
		*context = TRUE;
		break;
	  case UNDEFINED:
	  case INHERENTLY_OPT :
		if (node_type(node) == CONN_SEQ) {
	            group = group_iterator(node_group(node));
	            nd = (P_Node)iterator_next(group);
		    if (node_status(nd) == INHERENTLY_OPT) {
			 node_set_flagin(node, (*flag)++);
			 cont = FALSE;
		    }
		    else node_set_flagin(node, NOTUSED);
		    iterator_delete(group);
		}
		else node_set_flagin(node, *context?NOTUSED:flagin);
		node_set_flagout(node, *context?NOTUSED:flagin);
		break;
	  default :
		report(NO_LABEL, FATAL, 0, 0, node_status(node), 
		       "set_flags");
		break;
	}
	if ((node_type(node) == KEY) and
	    ((node_key(node) == PCDATA) or
	     (node_key(node) == XPCDATA) or
	     (node_key(node) == ANY)))
	    strcpy(seperator, "sep1");
	if ((node_type(node) != KEY) and (node_type(node) != GI)) {
	    group = group_iterator(node_group(node));
	    while (nd = next_node(group)) set_flags(nd, flag, &cont);
	}
}

void code_gi(node)
P_Node node;
{
	String name;
	char   conref[40];
	int    nr;

	name = cname(node_gi(node));
	if (attr_conref(node_gi(node)))
	    sprintf(conref, "{ pars_conref(ST_%s); } ", name);
	else conref[0] = '\0';
	switch (node_status(node)) {
	  case ALWAYS_REQUIRED : 
		if (node_gi_startopt(node))
		    fprintf(fp, "[ST_%s %s]? ", name, conref);
		else fprintf(fp, "[ST_%s %s] ", name, conref);
		break;
	  case CONTEXT_REQUIRED : 
		nr = node_flagin(node);
		if (node_gi_startopt(node))
		    fprintf(fp, "[%%if (flag%d) [ST_%s %s]? | [ST_%s %s]] ",
			    nr, name, conref, name, conref);
		else fprintf(fp, "[ST_%s %s] ", name, conref);
	    	fprintf(fp, "{ flag%d = TRUE; } ", nr);
		break;
	  case UNDEFINED : 
	  case INHERENTLY_OPT :
		fprintf(fp, "[ST_%s %s] ", name, conref);
		if ((nr = node_flagin(node)) != NOTUSED)
	    	     fprintf(fp, "{ flag%d = TRUE; } ", nr);
		break;
	  default :
		report(NO_LABEL, FATAL, 0, 0, node_status(node), 
		       "code_gi");
		break;
	}
	if (attr_conref(node_gi(node))) {
	    fprintf(fp, " [ %s | TOK_CONREF ] ", name);
	}
	else fprintf(fp, "%s ", name);
}

void code_any()
{
	P_Iterator it;
	P_Iterator nmgroup;
	P_Element  elem;
	String     name;

	it = element_iterator();
	while (elem = next_element(it)) {
	    nmgroup = group_iterator(name_group(elem));
	    while (name = next_name(nmgroup)) {
		name = cname(name);
	        if (strcmp(name, DOCUMENT) != 0) {
		    if (attr_conref(name)) {
	              fprintf(fp, "[[ST_%s { pars_conref(ST_%s); } ] ",
				  name, name);
		      fprintf(fp, "[ %s | TOK_CONREF ] ]|\n", name); 
		    }
		    else fprintf(fp, "[[ST_%s] %s ]|\n", name, name); 
		}
	    }
	}
	fprintf(fp, "[pcdata(string, DATALEN, TRUE, &error)] ");
}

void code_key(key)
int key;
{
	switch (key) {
	  case CDATA  :
	      fprintf(fp, "{ enter_mode(MODE_CDATA); }\n\t");
	      fprintf(fp, "cdata(string, DATALEN, TRUE, &error)\n\t"); 
	      fprintf(fp, "{ leave_mode(); }");
	      return;
	  case RCDATA :
	      fprintf(fp, "{ enter_mode(MODE_RCDATA); }\n\t");
	      fprintf(fp, "rcdata(string, DATALEN, TRUE, &error)\n\t");
	      fprintf(fp, "{ leave_mode(); }");
	      return;
	  case PCDATA : fprintf(fp, "pcdata(string, DATALEN, TRUE, &error)"); 
			return;
	  case XPCDATA: fprintf(fp, "xpcdata(string, DATALEN, TRUE, &error)"); 
			return;
	  case EMPTY  : return;
	  case ANY    : code_any(); return;
	  default     : report(NO_LABEL, FATAL, 0, 0, key, "code_key");
	}
}

void code_startbracket(nd, null, in_and)
P_Node nd;
Bool   null;            /* indicate that an or-group starts with
                           an empty production
                         */
Bool   in_and;
{
	if (null) fprintf(fp, "%%prefer ");
	if (node_occ(nd) == OCC_REP) fprintf(fp, "[%%while(1) [");
	else if ((node_occ(nd) == OCC_OPT) and 
                 (in_and or node_type(nd) == CONN_SEQ)) {
             fprintf(fp, "[%%while(1) [");
	}
	else fprintf(fp, "[");
}

void code_endbracket(nd, in_and)
P_Node nd;
Bool   in_and;
{
	int nr1, nr2;

	if (node_type(nd) != KEY and node_type(nd) != GI)
	    if ((nr1 = node_flagout(nd)) != NOTUSED)
		if ((nr2 = node_flagin(nd)) != NOTUSED)
	            fprintf(fp, " { flag%d = flag%d; } ", nr1, nr2);
		else fprintf(fp, " { flag%d = TRUE; } ", nr1);
	if (node_occ(nd) == OCC_REP) fprintf(fp, " ] %s ]*", seperator);
	else if (node_occ(nd) == OCC_OPT) {
	    if (in_and or (node_type(nd) == CONN_SEQ)) fprintf(fp, "]");
	    fprintf(fp, "]?");
	}
	else fprintf(fp, "]");
}

void code_var(nr_var)
int nr_var;
{
	int i;

	if (nr_var == 1) return;
	for (i = 1; i < nr_var; i++) {
	    if (i == 1) fprintf(fp, "{ int ");
	    else fprintf(fp, ", ");
	    fprintf(fp, "flag%d = FALSE", i);
	}
	fprintf(fp, "; }");
}

void code_and(node, in_and)
P_Node node;
int    in_and;
/* the code for an and-group is generated later.
   So the node is stored
 */
{
	int nr_ands, i;

	nr_ands = count_nr_ands(node);
	if (!in_and and node_occ(node) == OCC_OPT)
	    fprintf(fp, "%%while(1) ");
	fprintf(fp, "and%d", count_ands);
	for (i = 1; i <= nr_ands; i++) fprintf(fp, "_%d", i);
	save_node[save_ind].node    = node;
	save_node[save_ind].count   = count_ands++;
	save_node[save_ind].nr_ands = nr_ands;
	save_ind++;
}

void dummy(node) P_Node node; { }

Bool change_or(node)
P_Node node;
{
	P_Iterator it;
	P_Node     nd;

	it = group_iterator(node_group(node));
	while (nd = next_node(it)) {
	    if (node_nullable(nd) == Yes) {
		group_delete_previous(node_group(node), it, dummy);
		group_insert(node_group(node), nd);
		return(TRUE);
	    }
	}
	return(FALSE);
}

void code_content(node, in_and)
P_Node node;
Bool  in_and;
{
	Bool       first = TRUE;
	P_Iterator group;
	P_Node     nd;
	TYPE       type;
	char       delim[4];
	Bool	   null = FALSE;

	type = node_type(node);
	switch (type) {
	  case CONN_SEQ : strcpy(delim, "\n\t"); break;
	  case CONN_OR  : strcpy(delim, "|\n\t"); 
			  null = change_or(node);
			  break;
	  case CONN_AND : code_and(node, in_and); return;
	  case GI       : code_gi(node); return;
	  case KEY      : code_key(node_key(node)); return;
	  default	: report(NO_LABEL, FATAL, 0, 0, type, "code_content");
	}
	group = group_iterator(node_group(node));

        /* every group is surrouded by brackets */
	while (nd = next_node(group)) {
	    if (!first) {
		if (type == CONN_SEQ) fprintf(fp, "%s %s", seperator, delim);
		else fprintf(fp, "%s", delim);
		null = FALSE;
	    }
	    else first = FALSE;
	    code_startbracket(nd, null, in_and);
	    code_content(nd, in_and);
	    code_endbracket(nd, in_and);
	}
}

void make_and(set, count, nr_ands)
P_Set set;
int   count;
int   nr_ands;
/* generate rules of the form:
   [%if(f_and1_1) [and1_1 sep2 and1_2] | [and1_2 sep2 and1_1] ]
 */
{
	int i, j; 
	int nr = 0;
	int last;

	fprintf(fp, "and%d", count);
	for (i = 1; i <= nr_ands; i++) 
	    if (set_member(set, i)) { 
		fprintf(fp, "_%d", i);
		last = i;
	    }
	fprintf(fp, " :\n\t");
	for (i = 1; i < last; i++) {
	    if (set_member(set, i)) {
		nr++;
		fprintf(fp, "[%%if (f_and%d_%d(LLsymb)) ", count, i);
		fprintf(fp, "[ and%d_%d %s and%d", count, i, seperator,
			count);
		for (j = 1; j <= last; j++)
		    if ((j != i) and set_member(set, j))
			fprintf(fp, "_%d", j);
		fprintf(fp, " ]|\n\t");
	    }
	}
	fprintf(fp, "[ and%d_%d %s and%d", count, last, seperator, count);
	for (i = 1; i < last; i++)
	    if (set_member(set, i)) fprintf(fp, "_%d", i);
	for (i = 0; i <= nr; i++) fprintf(fp, "]");
	fprintf(fp, "\n\t;\n");
}

void code_and_content(nr_var)
int nr_var;
/* generates code for the stored and-group and also for the members
   itself.
 */
{
	P_Iterator it;
	P_Iterator group;
	P_Node     node;
	P_Node     nd;
	P_Set      set;
	int        count;
	int        nr, nr_ands;

	while (save_ind) {
	    node    = save_node[--save_ind].node;
	    count   = save_node[save_ind].count;
	    nr_ands = save_node[save_ind].nr_ands;
	    find_subsets(nr_ands);
	    it = group_iterator(subset_group);
	    while (set = (P_Set) iterator_next(it)) 
		make_and(set, count, nr_ands);
	    group = group_iterator(node_group(node));
	    nr = 1;
	    while (nd = next_node(group)) {
	        fprintf(fp, "and%d_%d  ", count, nr);
		code_var(nr_var);
		fprintf(fp, " :\n\t");
	        code_startbracket(nd, FALSE, TRUE);
	        code_content(nd, TRUE);
	        code_endbracket(nd, TRUE);
	        fprintf(fp, "\n\t;\n%%first f_and%d_%d, and%d_%d;\n",
		        count, nr, count, nr);
	        nr++;
	    }
	}
}

void code_header()
{
	fprintf(fp, "{\n#include \"types.h\"\n");
	fprintf(fp, "#include \"lexical.h\"\n");
	fprintf(fp, "#include \"modes.h\"\n");
	fprintf(fp, "#include \"startend.h\"\n");
	fprintf(fp, "\nstatic Bool error = FALSE;\n");
	fprintf(fp, "static char string[DATALEN + 1];\n}\n");
}

void code_start()
{
	P_Iterator it;
	P_Iterator nmgroup;
	P_Element  elem;
	String     name;

	code_header();
	fprintf(fp, "%%onerror myerror;\n\n");
	it = element_iterator();
	while (elem = next_element(it)) {
	    nmgroup = group_iterator(name_group(elem));
	    while (name = next_name(nmgroup)) {
		name = cname(name);
	        if (strcmp(name, DOCUMENT) != 0)
	            fprintf(fp, "%%token ST_%s, END_%s;\n", name, name);
	    }
	}
}

int number_of_names(elem)
P_Element elem;
{
	int        nr = 0;
	P_Iterator nmgroup;

	nmgroup = group_iterator(name_group(elem));
	while (next_name(nmgroup)) nr++;
	return(nr);
}

void empty_content(elem)
P_Element elem;
{
	P_Iterator nmgroup;
	String     name;

	nmgroup = group_iterator(name_group(elem));
	while (name = next_name(nmgroup)) {
	    name = cname(name);
	    fprintf(fp, "%s:\n\t{ pars_empty(ST_%s); }\n\t;\n",
		    name, name);
	}
}

void generate_code(elem)
P_Element elem;
/* generate code for all the content models. */
{
	static int unique = 1;
	int        nr_var = 1;
	int        names;
	Bool       cont = TRUE;
	String     name;
	P_Iterator nmgroup;

	if (declared_content(elem) and
	    (node_key(content(elem)) == EMPTY)) {
	     empty_content(elem);
	     return;
	}
	strcpy(seperator, "sep2");
	set_flags(content(elem), &nr_var, &cont);
	names = number_of_names(elem);
	nmgroup = group_iterator(name_group(elem));

	if (names == 1) {
	    name = next_name(nmgroup);
	    fprintf(fp, "%s ", cname(name));
	}
	else fprintf(fp, "unique_%d ", unique);
	code_var(nr_var);
	if (names == 1 and strcmp(name, DOCUMENT) != 0) 
	    fprintf(fp, ":\n\t{ pars_start(ST_%s); }\n\t", cname(name));
	else fprintf(fp, ":\n\t");
	if (!declared_content(elem)) fprintf(fp, "%s ", seperator);
	code_startbracket(content(elem), FALSE, FALSE);
	code_content(content(elem), FALSE);
	code_endbracket(content(elem), FALSE);
	if (!declared_content(elem)) fprintf(fp, " %s\n\t", seperator);
	else fprintf(fp, "\n\t");
	if (names == 1 and strcmp(name, DOCUMENT) != 0) {
	    fprintf(fp, "END_%s\n\t{ pars_end(", cname(name));
	    fprintf(fp, "END_%s); }\n\t;\n", cname(name));
	}
	else if (names != 1) fprintf(fp, ";\n");
	else fprintf(fp, "{ pars_document(); }\n\t;\n");
	if (names != 1) {
	    while (name = next_name(nmgroup)) {
		name = cname(name);
		fprintf(fp, "%s :\n\t{ pars_start(ST_%s); }\n\t", name, name);
		fprintf(fp, "unique_%d\n\tEND_%s\n\t", unique, name);
		fprintf(fp, "{ pars_end(END_%s); }\n\t;\n", name);
	    }
	    unique++;
	}
	if (save_ind) code_and_content(nr_var);
}

void generate(filename)
String filename;
/* generate code for all the content models and variables. */
{
	P_Iterator it;
	P_Element  elem;
	int        nr = 1, nr_elems = 1;
	String     name;

	elem_traverse_post(starttag);

	name = (String) CALLOC( (unsigned) (strlen(filename) + 4), 
		                (unsigned) (sizeof(char)) );
	sprintf(name, "%s%d.g", filename, nr); nr++;
	fp = fopen(name, "w");
	if (fp == 0) report(FILE_OPEN, FATAL, 0, 0, name);
	code_start();
	generate_incl(fp, DOC_inclext, DOC_incli);
	it = element_iterator();
	while (elem = next_element(it)) {
	    if (nr_elems > MAX_GRAMMAR_RULES) {
		nr_elems = 1;
		sprintf(name, "%s%d.g", filename, nr); nr++;
		fclose(fp);
		fp = fopen(name, "w");
		if (fp == 0) report(FILE_OPEN, FATAL, 0, 0, name);
		code_header();
	    }
	    generate_code(elem);
	    nr_elems++;
	}
	fclose(fp);
	CFREE(name);
}
