/*  $Header: doc.g,v 3.0 88/04/13 16:34:53 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "assert.h"
#include "entity.h"
#include "group.h"
#include "keywords.h"
#include "lexical.h"
#include "modes.h"
#include "out.h"
#include "shortref.h"

#define MAX_KEYLEN  80   /* maximum length for a keyword. */

#ifdef DEBUG
static Bool debug = FALSE;

void debug_doc(b)
Bool b;
{
	debug = b;
}
#endif
}

%start rcdata, rcdata;
%start  cdata,  cdata;

s                    : [ TOK_SPACE | TOK_RE | TOK_RS | TOK_SEPCHAR ];

processing_instr { char str[PILEN + 1]; Bool error = FALSE; } :
		      [ TOK_PIO		{ enter_mode(MODE_PI); }
			cdata(str, PILEN, FALSE, &error)
					    /* was : system_data(str) */
			    { if (error)
			       report(WAR_PILEN, NOTFATAL, 0, 0, PILEN);
#ifdef DOC_PARSER
			      out_pi(str);
#else
			      report(WAR_PI, NOTFATAL, 0, 0);
#endif
			    }
			TOK_PIC		{ leave_mode(); }
		      ] ;

rcdata(String str; int length; Bool echo; Bool *error;)
{
    int  i=0;
    char ch;
} :
	[[  data_char(&ch)
		{ if (!(*error)) { str[i] = ch; i++; } }
	  | char_ref
	  | TOK_SHORTREF
	        { switch_to_gen_entity(current_mapping(current_value())); }
	  | general_ent_ref
	  | TOK_EE
	 ]	{ if (!(*error) and (i > length)) {
#ifdef DOC_PARSER
		     if (echo) {
			 ch = str[i-1];
			 str[i-1] = '\0';
			 out_string(str);
			 str[0] = ch;
			 i = 1;
		     }
		     else { 
#else
                     assert(echo == FALSE);
#endif
			 str[i-1] = '\0';
			 *error = TRUE;
#ifdef DOC_PARSER
		     }
#endif
		  }
		}
	]*
	      { if (!(*error)) str[i] = '\0';
#ifdef DOC_PARSER
	        if( echo ){
		    out_string(str);
		    str[0] = '\0';
		}
#endif
	      }
	;

cdata(String str; int length; Bool echo; Bool *error;)
{
    char ch;
    int  i=0;

}:
        [%while(1) data_char(&ch)
	    { if (!(*error) and (i >= length)) {
#ifdef DOC_PARSER
		if (echo) {
		    str[i] = '\0';
		    out_string(str);
		    str[0] = ch;
		    i = 1;
		}
		else { 
#else
assert(echo == FALSE);
#endif
		    str[i] = '\0';
		    *error = TRUE;
#ifdef DOC_PARSER
		}
#endif
	      }
	      else { if (!(*error)) { str[i] = ch; i++; } }
	    }
        ]*
	      { if (!(*error)) str[i] = '\0';
#ifdef DOC_PARSER
	        if( echo ){
		    out_string(str);
		    str[0] = '\0';
		}
#endif
	      }
	;

data_char(char *ch;) :
	  TOK_SPECIAL
	      { *ch = current_value(); }
	| SGML_char(ch)
	;

SGML_char(char *ch;) :
	[
	    markup_char(ch)
	  | [ TOK_DATACHAR
		  { *ch = current_value(); }
	    ]
	] ;

markup_char(char *ch;): [   name_char(ch)
		          | function_char(ch)
		          | TOK_DELMCHAR
				{ *ch = current_value(); }
			] ;

name_char(char *ch;) : [ name_start_char(ch)
		       | TOK_DIGIT
		           { *ch = current_value(); }
		       | TOK_NMCHAR
		           { *ch = current_value(); }
		       ];

name_start_char(char *ch;): [ TOK_LETTER | TOK_NMSTRT ]
		                 { *ch = current_value(); } ;

function_char(char *ch;):
	[ TOK_RE | TOK_RS | TOK_SPACE | TOK_SEPCHAR |
	  TOK_MSOCHAR | TOK_MSICHAR | TOK_MSSCHAR | TOK_FUNCHAR ]
			       { *ch = current_value(); } ;

general_ent_ref
{
    char ent_name[NAMELEN + 1];
} :
        [ TOK_ERO
	      { param_name(ent_name);
	        DEB1("general ent ref `%s'\n", ent_name);
	        switch_to_gen_entity(ent_name); 
	      }
        ] ;

/*
ref_end              : [ [ %while(1) RE | TOK_REFC ]?            { leave_mode(); }
		       ];
*/

char_ref : [ TOK_CRO
                { char_ref(); }
	   ] ;

name_token(String str; Bool upper_case_subst;)
{
    char ch;
    int  i;
    Bool error = FALSE;
} :
        [ name_char(&ch)
	      { str[0]= ch; i=1; }
	  [%while(1) name_char(&ch)
	      { if (!error)
		  if (i >= NAMELEN) {
		    str[i] = '\0';
		    report(WAR_NAMELEN, NOTFATAL, 0, 0, str, NAMELEN);
		    error = TRUE;
		  }
		  else { str[i]= ch; i++; }
	      }
	  ]*
	      { str[i]='\0';
		if( upper_case_subst ){ to_upper(str); }
	      }
        ] ;

keyword(int *key; String *key_string;)
{
    char        ch;
    static char str[MAX_KEYLEN];
    int         i;
} :
	[ name_start_char(&ch)
	      { str[0]= ch; i=1; }
          [%while(1) name_start_char(&ch)
	      { if(i<MAX_KEYLEN){
		    str[i]= ch; i++;
		}
	      }
          ]*
	      {
		  str[i]='\0';
		  *key = string_to_key(str);
		  *key_string = str;
	      }
        ] ;

param_ent_ref
{
    char ent_name[NAMELEN + 1];
}  :
        [ TOK_PERO
              { param_name(ent_name); 
		if (strlen(ent_name) > NAMELEN - 1) {
		    report(WAR_PAR_NAME, NOTFATAL, 0, 0, ent_name,
			   NAMELEN - 1);
		    ent_name[NAMELEN - 1] = '\0';
		}
                switch_to_par_entity(ent_name); 
	      }
        ] ;
 
param_literal(String str;) :
        [
          TOK_LIT                         { enter_mode(MODE_LIT_PERO); }
	      rep_param_data(str)
          TOK_LIT                                     { leave_mode(); }
        ]
      | [ TOK_LITA                        { enter_mode(MODE_LITA_PERO);}
	      rep_param_data (str)
          TOK_LITA                                    { leave_mode(); }
        ] ;
 
rep_param_data(String str;)
{
    int  i = 0;
    char ch;
    Bool error = FALSE;
} :
        [[   data_char(&ch)
                { if (!error) { str[i] = ch; i++; } }
          | char_ref
          | param_ent_ref
          | TOK_EE
	 ]	{ if ((i > LITLEN) and !error) {
		     str[i-1] = '\0';
		     error = TRUE;
		     report(WAR_LITLEN, NOTFATAL, 0, 0, 
			    "parameter literal length", LITLEN);
		  }
		}
        ]*
            { if (!error) str[i] = '\0'; }
        ;

name(String str; Bool upper_case_subst;)
{
    char ch;
} :
        [ name_start_char(&ch)
            {
		str[0] = ch;
                name_tail(str);
	        if( upper_case_subst ){ to_upper(str); }
	    }
        ] ;

name_group(P_Group g; Bool upper_case_subst;)
{
    int   conn, first_con=TOK_NOD;
    char  string[NAMELEN + 1];
    int   grpcnt;
    Bool  error = FALSE;
} :
        [ TOK_GRPO                            { enter_mode(MODE_GRP); }
	  ts_star name(string, upper_case_subst)
              {  
                  group_add(g, strsave(string));
		  grpcnt = 1;
              }  
          ts_star
          [ connector(&conn) ts_star
            name(string, upper_case_subst)     ts_star
                {
		  grpcnt++;
		  if ((grpcnt > GRPCNT) and !error) {
		      report(WAR_GRPCNT, NOTFATAL, 0, 0, GRPCNT);
		      error = TRUE;
		  }
                  if( first_con == TOK_NOD ){
                      first_con = conn;
                      group_add(g, strsave(string));
                  } else {
                      group_add(g, strsave(string));
                  }
                }  
          ]*
          TOK_GRPC                                     { leave_mode(); }
        ] ;

assoc_elem_type(P_Group g;)
{
    char  string[NAMELEN + 1];
} :
        [   name(string, NAMECASE_GENERAL)       /* was : gen_ident() */
	    {  
		group_add(g, strsave(string));
	    }  
          | name_group(g, NAMECASE_GENERAL)
        ] ;

connector(int *conn;) :
        [ TOK_AND { *conn = CONN_AND; }
        | TOK_OR  { *conn = CONN_OR ; }
        | TOK_SEQ { *conn = CONN_SEQ; }
        ]
        ;

ps                   : [%default s | TOK_EE | param_ent_ref | comment ] ;

ps_plus              : [ ps ]*;

ps_star              : [ ps ]*;

ts : [%default s | TOK_EE | param_ent_ref ] ;   

ts_star              : [ ts ]* ;
