/* $Header: att_chk.c,v 3.0 88/04/13 15:38:41 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "att_chk.h"
#include "charclas.h"
#include "conc_syn.h"
#include "entity.h"

typedef int  (*CheckListFunction)(PAR  String string, int *i, Bool list  RAP);

#ifdef DEBUG
static Bool debug = FALSE;
#endif

void Skip_s(str, i)
String  str;
int    *i  ;
{
    while( is_s(str[*i]) ){
	(*i)++;
    }
}      

void do_check(str, i, first_ok, tail_ok)
String           str;
int             *i ;
IntFunctionInt   first_ok;
IntFunctionInt   tail_ok;
{
    char ch;

    if( not (*first_ok)(str[*i]) ){
	return;
    }
    while( ch=str[*i] ){
	if( not (*tail_ok)(ch) ){
	    return;
	}
	(*i)++;
    }
}

void check_name(s,i, list)
String   s;
int     *i;
Bool     list;
{
    int count = *i;

    do_check(s, i, is_name_start_character, is_name_character);
    if( list and (s[*i] != '\0') ){
	report(ATTR_NON_NAME, FATAL, 0, 0, s, *i + 1);
    }
    else if (list and (*i - count > NAMELEN)) {
	report(WAR_NAMELEN, NOTFATAL, 0, 0, s, NAMELEN);
	s[NAMELEN] = '\0';
    }
}

void check_number(s,i, list)
String   s;
int     *i ;
Bool     list;
{
    int count = *i;

    do_check(s, i, is_DIGIT, is_DIGIT);
    if( list and (s[*i] != '\0') ){
	report(ATTR_NON_NUMBER, FATAL, 0 ,0, s, *i + 1);
    }
    else if (list and (*i - count > NAMELEN)) {
	report(WAR_NAMELEN, NOTFATAL, 0, 0, s, NAMELEN);
	s[NAMELEN] = '\0';
    }
}

void check_name_token(s,i, list)
String  s;
int    *i ;
Bool    list;
{
    int count = *i;

    do_check(s, i, is_name_character, is_name_character);
    if( list and (s[*i] != '\0') ){
	report(ATTR_NON_NTOK, FATAL, 0, 0, s, *i + 1);
    }
    else if (list and (*i - count > NAMELEN)) {
	report(WAR_NAMELEN, NOTFATAL, 0, 0, s, NAMELEN);
	s[NAMELEN] = '\0';
    }
}

void check_enumerate(s,i, list, range)
String  s;
int    *i ;
Bool    list;
String *range;
{
    String value;

    check_name_token(s, i, list);
    while( value=(*range) ){
	range++;
	if( streq(value, s) ){ return; }
    }
    report(ATTR_NOT_KNOWN, FATAL, 0, 0, s, "enumerate type");
}

void check_notation(s, i, list, range)
String  s;
int    *i ;
Bool    list;
String *range;
{
    String value;

    check_name(s, i, list);
    while( value=(*range) ){
	range++;
	if( streq(value, s) ){ return; }
    }
    report(ATTR_NOT_KNOWN, FATAL, 0, 0, s, "notation");
}

void check_number_token(s,i, list)
String  s;
int    *i ;
Bool    list;
{
    int count = *i;

    do_check(s, i, is_DIGIT, is_name_character);
    if( list and (s[*i] != '\0') ){
	report(ATTR_NON_NRTOK, FATAL, 0, 0, s, *i + 1);
    }
    else if (list and (*i - count > NAMELEN)) {
	report(WAR_NAMELEN, NOTFATAL, 0, 0, s, NAMELEN);
	s[NAMELEN] = '\0';
    }
}

void check_cdata(s, i, list)
String  s;
int    *i;
Bool    list;
{
    do_check(s, i, is_data_character, is_data_character);
    if( list and (s[*i] != '\0') ){
	report(ATTR_NON_CDATA, FATAL, 0, 0, s, *i + 1);
    }
}

void check_list(str, check_string, nm_tokens, error_nr)
String                str;
CheckListFunction     check_string;
int                  *nm_tokens;
int                   error_nr;
{
    int  i     = 0;
    int  count = 0;
    int  j;
    char tmp[LITLEN + 1];

    *nm_tokens = 0;
    while( str[i] ){
	Skip_s(str, &i);
	count = i;
	(*nm_tokens)++;
	(*check_string)(str, &i, FALSE);
	if( (str[i] != '\0') and not is_s(str[i]) ) {
	    strcpy(tmp, &(str[count]));
	    count = j = i - count;
	    while ((str[i] != '\0') and not is_s(str[i]))
		tmp[j++] = str[i++];
	    tmp[j] = '\0';
	    report(error_nr, FATAL, 0, 0, tmp, count + 1);
	}
        else if (i - count > NAMELEN) {
	    strcpy(tmp, &(str[i]));
	    str[count + NAMELEN] = '\0';
	    report(WAR_NAMELEN, NOTFATAL, 0, 0, &(str[count]), NAMELEN);
	    strcat(str, tmp);
        }
    }
}

void check_name_list(str, nm_tokens)
String  str;
int    *nm_tokens;
{
    check_list(str, check_name, nm_tokens, ATTR_NON_NAME);
}

void check_number_list(str, nm_tokens)
String  str;
int    *nm_tokens;
{
    check_list(str, check_number, nm_tokens, ATTR_NON_NUMBER);
}

void check_name_token_list(str, nm_tokens)
String  str;
int    *nm_tokens;
{
    check_list(str, check_name_token, nm_tokens, ATTR_NON_NTOK);
}

void check_number_token_list(str, nm_tokens)
String  str;
int    *nm_tokens;
{
    check_list(str, check_number_token, nm_tokens, ATTR_NON_NRTOK);
}

/*  checks the attribute against it's declared value 
 *  and returns the correct attribute.
 */
void check_attr(att_name, value, declared_value, range, nm_tokens)
String  att_name;
String  value;
int     declared_value;
String *range;
int    *nm_tokens;
{
    int    i = 0;
    
    DEB2("check_att: %s, %s\n", att_name, value);
    if( value[0] == '\0' ) {
	if( declared_value != CDATA ){
	    report(ATTR_EMPTY_LIT, FATAL, 0, 0, att_name);
	}
	return;
    }

    *nm_tokens = 1;
    switch( declared_value ){
	case NOTATION : if(NAMECASE_GENERAL){ to_upper(value); }
			check_notation(value, &i, TRUE, range);
			break;
	case ENTITY   : if(NAMECASE_ENTITY){ to_upper(value); }
	                check_name(value, &i, TRUE);
                        break;
	case ID       :
        case IDREF    :
	case NAME     : if(NAMECASE_GENERAL){ to_upper(value); }
			check_name(value, &i, TRUE);
                        break;
	case CDATA    : check_cdata(value, &i, TRUE);
                        break;
	case NAMES    :
	case IDREFS   : if(NAMECASE_GENERAL){ to_upper(value); }
			check_name_list(value, nm_tokens);
                        break;
        case ENUMERATE: if(NAMECASE_GENERAL){ to_upper(value); }
			check_enumerate(value, &i, TRUE, range);
                        break;
	case NMTOKEN  : if(NAMECASE_GENERAL){ to_upper(value); }
			check_name_token(value, &i, TRUE);
                        break;
	case NMTOKENS : if(NAMECASE_GENERAL){ to_upper(value); }
			check_name_token_list(value, nm_tokens);
                        break;
	case NUMBER   : check_number(value, &i, TRUE);
                        break;
	case NUMBERS  : check_number_list(value, nm_tokens);
                        break;
	case NUTOKEN  : if(NAMECASE_GENERAL){ to_upper(value); }
			check_number_token(value, &i, TRUE);
                        break;
	case NUTOKENS : if(NAMECASE_GENERAL){ to_upper(value); }
			check_number_token_list(value, nm_tokens);
                        break;
	default       : report(NO_LABEL, FATAL, 0, 0, declared_value,
			       "check_attr");
                        break;
    }
}

int norm_val_length(str, decl_val)
String str;
int    decl_val;
{
        int i     = 0;
	int value = 0;

	value += NORMSEP;
        switch( decl_val ){
	  case ENTITY   :
		if ((entity_type(str) == CDATA) or
		    (entity_type(str) == SDATA))
		    value += NORMSEP;
		value += strlen(str);
		break;
	  case NOTATION :
	  case ID       :
          case IDREF    :
	  case NAME     :
	  case CDATA    :
          case ENUMERATE:
	  case NMTOKEN  :
	  case NUMBER   :
	  case NUTOKEN  :
	       value += strlen(str);
               break;
	  case IDREFS   : 
	  case NAMES    :
	  case NMTOKENS :
	  case NUMBERS  :
	  case NUTOKENS :
        	while (str[i] != '\0')
              	    if (is_s(str[i])) { 
		       value += NORMSEP;
		       Skip_s(str, &i);
	            }
	            else { value++; i++; }
                value += NORMSEP;
		break;
	  default       : 
		report(NO_LABEL, FATAL, 0, 0, decl_val, "norm_val_length");
                break;
        }
        return(value);
}

void att_change_s(string)
String string;
{
	int  i, j = 0;
	char ch;

	for (i = 0; i < strlen(string); i++) {
	    ch = string[i];
	    if (is_RE(ch) or is_SEPCHAR(ch))
	        string[j++] = function_char("SPACE");
	    else if (!is_RS(ch)) string[j++] = ch;
	}
	string[j] = '\0';
}

#ifdef DEBUG
void debug_attchk(b)
Bool b;
{
	debug = b;
}
#endif
