/* LLgen generated code from source tokens.g */
/* $Header: incl,v 2.2 87/02/16 21:35:40 ceriel Exp $ */
#ifdef LL_DEBUG
#define LL_assert(x) if(!(x)) LL_badassertion("x",__FILE__,__LINE__)
#else
#define LL_assert(x)	/* nothing */
#endif

extern int LLsymb;
extern char LLsets[];

#define LL_SAFE(x)	/* Nothing */
#define LL_SSCANDONE(x)	if (LLsymb != x) LLerror(x); else
#define LL_SCANDONE(x)	if (LLsymb != x) LLerror(x); else
#define LL_T_NOSCANDONE(x)	LLscan(x)

# include "Lpars.h"

extern unsigned int LLscnt[];
extern unsigned int LLtcnt[];
extern int LLcsymb;
extern int LL_symb;

#define LLsdecr(d)	{LL_assert(LLscnt[d] > 0); LLscnt[d]--;}
#define LLtdecr(d)	{LL_assert(LLtcnt[d] > 0); LLtcnt[d]--;}
#define LLsincr(d)	LLscnt[d]++
#define LLtincr(d)	LLtcnt[d]++

# line 21 "tokens.g"

# include "types.h"
# include "io.h"
# include "extern.h"
# include "assert.h"
# include "cclass.h"

# ifndef NORCSID
static string	rcsidc = "$Header: tokens.g,v 2.7 87/06/03 19:05:14 ceriel Exp $";
# endif


extern int	scanner();
extern 		LLmessage();
extern int	input();
extern		unput();
extern		skipcomment();
# ifdef LINE_DIRECTIVE
STATIC		linedirective();
# endif
STATIC string	cpy();
STATIC string	vallookup();
# line 66 "tokens.g"






typedef struct keyword {
	string	w_word;
	int	w_value;
} t_keyw, *p_keyw;






static t_keyw resword[] = {
	{ "token",	C_TOKEN	},
	{ "avoid",	C_AVOID	},
	{ "prefer",	C_PREFER	},
	{ "persistent", C_PERSISTENT	},
	{ "default",	C_DEFAULT	},
	{ "if",		C_IF	},
	{ "while",	C_WHILE	},
	{ "first",	C_FIRST	},
	{ "start",	C_START	},
	{ "lexical",	C_LEXICAL	},
	{ "onerror",	C_ONERROR	},
	{ 0,		0	}
};

static t_token	savedtok;	
# ifdef LINE_DIRECTIVE
static  int	nostartline;	
# endif

scanner() {
	


	register int	ch;		
	register char *p = ltext;
	int		reserved = 0;	
	char		*max = &ltext[LTEXTSZ - 1];

	if (savedtok.t_tokno) {
				


		lextoken = savedtok;
		savedtok.t_tokno = 0;
		return lextoken.t_tokno;
	}
	for (;;) {
		ch = input();
		if (ch == EOF) return ch;
# ifdef LINE_DIRECTIVE
		if (ch == '#' && !nostartline) {
			linedirective();
			continue;
		}
# endif
		switch(c_class[ch]) {
		  case ISLIT :
			for (;;) {
				ch = input();
				if (ch == '\n' || ch == EOF) {
					error(linecount,"Missing '");
					break;
				}
				if (ch == '\'') break;
				if (ch == '\\') {
					*p++ = ch;
					ch = input();
				}
				*p++ = ch;
				if (p > max) p--;
			}
			*p = '\0';
			lextoken.t_string = ltext;
			return C_LITERAL;
		  case ISCOM :
			skipcomment(0);
			
		  case ISSPA :
			continue;
		  case ISDIG : {
			register i = 0;
			do {
				i = 10 * i + (ch - '0');
				ch= input();
			} while (c_class[ch] == ISDIG);
			lextoken.t_num = i;
			unput(ch);
			return C_NUMBER; }
		  default:
			return ch;
		  case ISKEY :
			reserved = 1;
			ch = input();
			
		  case ISLET :
			do {
				if (reserved && ch >= 'A' && ch <= 'Z') {
					ch += 'a' - 'A';
				}
				*p++ = ch;
				if (p > max) p--;
				ch = input();
			} while (c_class[ch] == ISDIG || c_class[ch] == ISLET);
			unput(ch);
			*p = '\0';
			if (reserved) {	


				register p_keyw w;

				w = resword;
				while (w->w_word) {
					if (! strcmp(ltext,w->w_word)) {
						


						return w->w_value;
					}
					w++;
				}
				error(linecount,"Illegal reserved word");
			}
			lextoken.t_string = ltext;
			return C_IDENT;
		}
	}
}

static int	backupc;	
static int	nonline;	

input() {
	


	register	c;

        if (c = backupc) {
			

		backupc = 0;
                return c;
	}
	if ((c = getc(finput)) == EOF) return c;
# ifdef LINE_DIRECTIVE
	nostartline = 1;
# endif
	if (!nonline) {
		linecount++;
# ifdef LINE_DIRECTIVE
		nostartline = 0;
# endif
		nonline = 1;
	}
	if (c == '\n') nonline = 0;
	return c;
}

unput(c) {
	


	backupc = c;
}

skipcomment(flag) {
	




	register int	ch;
	int		saved;	

	saved = linecount;
	if (input() != '*') error(linecount,"Illegal comment");
	do {
		ch = input();
		while (ch == '*') {
			if ((ch = input()) == '/') return;
		}
		if (flag && ch == '\n') putc(ch,fact);
	} while (ch != EOF);
	error(saved,"Comment does not terminate");
}

# ifdef LINE_DIRECTIVE
STATIC
linedirective() {
	


	register int	ch;
	register int	i;
	string		s_error = "Illegal line directive";
	string		store();
	register string	c;

	do {	



		ch = input();
	} while (ch != '\n' && c_class[ch] != ISDIG);
	if (ch == '\n') {
		error(linecount,s_error);
		return;
	}
	i = 0;
	do  {
		i = i*10 + (ch - '0');
		ch = input();
	} while (c_class[ch] == ISDIG);
	while (ch != '\n' && ch != '"') ch = input();
	if (ch == '"') {
		c = ltext;
		do {
			*c++ = ch = input();
		} while (ch != '"' && ch != '\n');
		if (ch == '\n') {
			error(linecount,s_error);
			return;
		}
		*--c = '\0';
		do {
			ch = input();
		} while (ch != '\n');
		


		if (strcmp(f_input,ltext)) f_input = store(ltext);
	}
	linecount = i;
}
# endif

STATIC string
vallookup(s) {
	


	register p_keyw p = resword;

	while (p->w_value) {
		if (p->w_value == s) return p->w_word;
		p++;
	}
	return 0;
}

STATIC string
cpy(s,p,inserted) register string p; {
	




	register string t = 0;

	switch(s) {
	  case C_IDENT : 	
		if (!inserted) t = lextoken.t_string;
		else t = "identifier";
		break;
	  case C_NUMBER :
		t = "number";
		break;
	  case C_LITERAL :
		if (!inserted) {
			*p++ = '\'';
			t = lextoken.t_string;
			break;
		}
		t = "literal";
		break;
	  case EOFILE :
		t = "endoffile";
		break;
	}
	if (!t && (t = vallookup(s))) {
		*p++ = '%';
	}
	if (t) {	


		while (*t) *p++ = *t++;
		if (s == C_LITERAL && !inserted) {
			*p++ = '\'';
		}
		return p;
	}
	


	*p++ = '\'';
	if (s >= 040 && s <= 0176) *p++ = s;
	else {
	    *p++ = '\\';
	    switch(s) {
	      case '\b' : *p++ = 'b'; break;
	      case '\f' : *p++ = 'f'; break;
	      case '\n' : *p++ = 'n'; break;
	      case '\r' : *p++ = 'r'; break;
	      case '\t' : *p++ = 't'; break;
	      default : *p++='0'+((s&0377)>>6); *p++='0'+((s>>3)&07);
		        *p++='0'+(s&07);
	    }
	}
	*p++ = '\'';
	return p;
}

LLmessage(d) {
	




	register string	s,t;
	char		buf[128];

	nerrors++;
	s = buf;
	if (d == 0) {
		s = cpy(LLsymb,s,0);
		t = " deleted";
		do *s++ = *t; while (*t++);
	} else {
		s = cpy(d,s,1);
		t = " inserted in front of ";
		do *s++ = *t++; while (*t);
		s = cpy(LLsymb,s,0);
		*s = '\0';
	}
	error(linecount, "%s", buf);
			



	if (d) {	



		savedtok = lextoken;
		savedtok.t_tokno = LLsymb;
		if (d == C_IDENT) lextoken.t_string = "dummy_identifier";
		else if (d == C_LITERAL) lextoken.t_string = "dummy_literal";
		else if (d == C_NUMBER) lextoken.t_num = 1;
	}
}

