; Wb-tree File Based Associative String Data Base System.
; Copyright (c) 1991, 1992, 1993 Holland Mark Martin
;
;Permission to use, copy, modify, and distribute this software and its
;documentation for educational, research, and non-profit purposes and
;without fee is hereby granted, provided that the above copyright
;notice appear in all copies and that both that copyright notice and
;this permission notice appear in supporting documentation, and that
;the name of Holland Mark Martin not be used in advertising or
;publicity pertaining to distribution of the software without specific,
;written prior consent in each case.  Permission to incorporate this
;software into commercial products can be obtained from Jonathan
;Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
;01803-4467, USA.  Holland Mark Martin makes no representations about
;the suitability or correctness of this software for any purpose.  It
;is provided "as is" without express or implied warranty.  Holland Mark
;Martin is under no obligation to provide any services, by way of
;maintenance, update, or otherwise.

(require (in-vicinity (program-vicinity) "sys"))

(define defer-block-deletes #f)

;; fixes:
;; 1. 1/22 blk-delete should not be called if END-OF-CHAIN
;; 2.      IND-REM-V&K needed to return B-POS
;; 3.      CHAIN-KEY-REM also neede to check for being already at root level
;; 4. 1/23 fixed BLK-DELETE? to set access to #f while calling PREV-BLK-ENT!
;; 5.      fixed CHAIN-KEY-REM to give error message if key not found in index

(define (blk-empty? blk)
  (= (BLK-END blk) (next-field blk (+ 1 BLK-DATA-START))))

;; BLK-DELETE assumes caller has ACCWRITE to blk and will
;; release if after blk-delete returns

;; sorry, waiting on parent-update is losing since
;; deletes that  lock the entire path to the root will almost certainly
;; NEVER succeed!

(define (blk-delete ent)
  (define blk (ENT-BLK ent))
  (define win? (not defer-block-deletes))
;;;  (fprintf diagout "BLK-DELETE called, blk=%d:%ld\\n" (ENT-SEG ent) (ENT-ID ent))
  (cond
   (win?
					; 1. get and lock PREV
    (ent-update-access ent ACCWRITE #f)	; KLUGE!!
    (let ((prent (prev-blk-ent ent (BLK-LEVEL blk))))
      (set! win? (ent-update-access ent #f ACCWRITE)) ;need to back out if #f
      (and win? prent			; if no PRENT, no prev to unlink
	   (set! win? (ent-update-access prent ACCREAD ACCWRITE)))
					; TBD: double-check that PRENT is still
					;PREV of ENT; if not, retry PREV-BLK
      (set! win? (and win? (= 1 (ENT-REF ent)))) ; dont delete blk w/pending parent-update
      (cond
       (win?				; 2. lock parent
	(if (not (at-root-level? (ENT-SEG ent) blk)) ; no parents to fix!
	    (let ((skey-pos (split-key-pos blk)))
	      (and
 	       skey-pos
	       (let* ((top-num (BLK-TOP-ID blk))
		      (seg (ENT-SEG ent))
		      (level (BLK-LEVEL blk))
		      (key-str (make-string 256))
		      (k-len (recon-this-key blk skey-pos key-str 0 256)))
					; 2: fix parent
		 (set! win?
		       (parent-delete-update seg top-num level (ENT-ID ent)
					     key-str k-len))))))
					; if all goes ok, we can make the mods
	(set! win? (and win? (= 1 (ENT-REF ent))))
	(cond
	 (win?				; 3-4:  unlink block from chain
	  (if prent (begin (BLK-SET-NXT-ID! (ENT-BLK prent) (BLK-NXT-ID blk))
			   (ENT-SET-DTY! prent #t)
			   (ent-write prent)))
	  (set! win? (blk-free ent))
	  (if (not win?)		; 5 reclaim block
	      (fprintf diagout ">>>>ERROR<<<<delete-blk: could not free %d:%ld\\n"
		       (ENT-SEG ent) (ENT-ID ent)))))))
      (if prent (release-ent! prent (ENT-ACC prent))))))
  (cond (win? (set! block-deletes (+ block-deletes 1)))
	(else (set! deferred-deletes (+ 1 deferred-deletes))
	      (fprintf diagout "Can't delete block %d\\n" (ENT-ID ent))))
  win?)

;;; return #t if operation was succsessful; #f if not
;;; Note the deletion of blk OLD-ID by removing its KEY+ID from parent.
;;; Note this routine does not check if the key has already been
;;; (perhaps by another process) deleted from the parent.

(define (parent-delete-update seg top-id level old-id key-str k-len)
  (define pkt (make-vector PKT-SIZE))
  (define ans -1)
  (define ans-str (make-string 4))	;this is for index blocks only.
;;;  (fprintf diagout "PARENT-DEL-UPD called, blk=%d:%ld, level=%d, key=%.*s\\n"
;;;	   seg old-id level k-len key-str)
  (let ((ent (find-ent (get-ent seg top-id #f) (+ 1 level) -1 key-str k-len)))
    (cond ((not ent) #f)
	  ((ent-update-access ent ACCREAD ACCWRITE)
	   (set! ent (chain-find ent ACCWRITE key-str k-len pkt)))
	  (else (release-ent! ent ACCREAD)
		(set! ent #f)))
    (cond (ent (set! ans (chain-rem ent key-str k-len ans-str pkt WCB-SAR))
	       (if (>= ans 0)
		   (if (not (= old-id (str2long ans-str 0)))
		       (fprintf diagout ">>>>ERROR<<<< parent-delete-update: bad value %ld in deleted down pointer %ld told\\n"
				(str2long ans-str 0) old-id)))
	       (release-ent! ent ACCWRITE)))
    (cond ((and ent (>= ans 0)))
	  (else
	   (fprintf diagout "WARNING: parent-delete-update  blk=%d:%ld, level=%d, key=%.*s\\n"
		    seg old-id level k-len key-str)
	   #f))))

;; called with ACCREAD on ENT, releases ent before returning
;;; CHAIN-REM can call BLK-DELETE
;;;   BLK-DELETE calls BLK-FREE
;;;     BLK-FREE calls AMNESIA-ENT! which sets the segment number to -1
;;; CHAIN-REM calls RELEASE-ENT!
;;;; Chad Gadya!

(define (chain-rem ent key-str k-len ans-str pkt wcb)
;;;  (fprintf diagout "CHAIN-REM called, blk=%d:%ld, key=%.*s\\n"
;;;	   (ENT-SEG ent) (ENT-ID ent) k-len key-str)
  (cond ((eq? (MATCH-TYPE pkt) MATCH)
	 (let ((alen SUCCESS))
	   (if ans-str (set! alen (get-this-val (ENT-BLK ent) (MATCH-POS pkt) ans-str)))
	   (blk-remove-key-and-val (ENT-BLK ent)
				   (MATCH-POS pkt)
				   (SEG-BSIZ (ENT-SEG ent)))
	   (ENT-SET-DTY! ent #t)
	   (if (and (blk-empty? (ENT-BLK ent))
		    (not (END-OF-CHAIN? (ENT-BLK ent))))
	       (blk-delete ent)
	       (let ()
;;;		 (fprintf diagout "CHAIN-REM: blk=%d nonleaf=%d SAR=%d\\n"
;;;			  (BLK-ID (ENT-BLK ent)) (> (BLK-LEVEL (ENT-BLK ent)) LEAF)
;;;			  (WCB-SAR? wcb))
		 (if (or (WCB-SAR? wcb) (> (BLK-LEVEL (ENT-BLK ent)) LEAF))
		     (ent-write ent))))
	   alen))
	(else
;;;	      (fprintf diagout "CHAIN-REM: key %.*s not found in blk %d\\n"
;;;		       k-len key-str (ENT-ID ent))
	 NOTPRES)))









