;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; See Template.scm in the Scheme Library for how to set up
;;; vicinities and require.

(define jacal-vicinity (program-vicinity))
;;	Save our vicinity for later dynamic loads.
(load (in-vicinity (program-vicinity) "scl" (scheme-file-suffix)))
;;	Common Lisp/Scheme compatability definitions.
(load (in-vicinity (program-vicinity) "toploads" (scheme-file-suffix)))
;;	Initialize modes to something reasonable.
(load (in-vicinity (program-vicinity) "modeinit" (scheme-file-suffix)))

;;; this should move into SLIB
;(define (output-port-height . arg) 23)

;;;; error and interrupt response for SCM.
;;; Put appropriate handlers for other systems here.

(define (impl:error str)
  (force-output)
  (newline-diag)
  (perror (tran:translate 'ERROR))
  (set-errno 0)
  (display-diag str)
  (display-diag (tran:translate 'Last-expression-lost))
  (newline-diag)
  (force-output)
  (math:exit #f))			;return to math top level.

;;;; These are error handlers for SCM.
(define out-of-storage #f)
(define could-not-open #f)
(define arithmetic-error #f)
(define user-interrupt #f)
(define end-of-program #f)
;(define hang-up end-of-program)		;automatic

(define (set-handlers!)
;;  (set! out-of-storage (lambda () (impl:error "Out of storage")))
  (set! could-not-open (lambda () (impl:error "File not found")))
  (set! arithmetic-error (lambda () (impl:error "Arithmetic Error")))
;;  (set! user-interrupt (lambda () (impl:error "User Interrupt")))
  (set! end-of-program (lambda () (math:exit #t))))

(define (cleanup-handlers!)
  (set! out-of-storage #f)
  (set! could-not-open #f)
  (set! arithmetic-error #f)
  (set! user-interrupt #f)
  (set! end-of-program #f))
